/* Copyright (c) 1993 NOVELL			*/
/* All Rights Reserved.				*/
/* create, open, insert and get sample program 	*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

extern unsigned int NWErrno;  /*cs 9/8/93 */

/*#pragma pack (1)*/    /* must do this, one byte boundary alignment */

/*#define int short*/   /* must do this, define int to be two bytes */

#define BIN 0x0004

#ifndef USHORT
typedef unsigned short USHORT;
#endif
#ifndef PSZ
typedef unsigned char *PSZ;
#endif
#ifndef PUSHORT
typedef unsigned short *PUSHORT;
#endif
#ifndef UCHAR
typedef unsigned char UCHAR;
#endif
#ifndef CHAR
typedef char CHAR;
#endif

typedef struct {
   short nKeyPos;
   short nKeyLen;
   short nKeyFlag;
   char notUsed1[4];
   char KeyType;
   char reserve1[5];
}  KEYSPEC;

typedef struct {
   short nRecLen;
   short nPageSize;
   short nIndexCount;
   char notUsed2[4];
   short nFileFlags;
   char reserve2[2];
   short nPreAlloc;
   KEYSPEC KeySpecBuf[1];
} FILESPEC;

typedef struct {
   char Last_Name[20];
   char First_Name[30];
   short ID;
   char Social_Sec[12];
} EMPLOY_REC;

FILESPEC FileSpecBuf;
/*char szFileName[] = "AUSCSHAWHP\\SYS:\\PATIENT2\\btrcoig.dat";*/
char szFileName[128];
char sPosBlk[128];
unsigned short nBufLen;

EMPLOY_REC Employ;
char sKeyBuf[128];

main (argc, argv)
int argc;
char *argv[];
{
   int i;
   int iStatus;


   if (argc != 2)
   {
     printf("\nUsage: btrcoig <Server\\\\vol:\\\\dir\\\\file>\n");
     return;
   }
 
   strcpy(szFileName, argv[1]);
   printf ("\n**** Test creating btrcoig.dat file ****\n");

/* create files */
   memset(&FileSpecBuf, 0, sizeof(FILESPEC));
   FileSpecBuf.nRecLen = 64;
   FileSpecBuf.nPageSize = 2048;  
   FileSpecBuf.nFileFlags = 0;
   FileSpecBuf.nIndexCount = 1;
   FileSpecBuf.KeySpecBuf[0].nKeyPos = 51;
   FileSpecBuf.KeySpecBuf[0].nKeyLen = 2;
   FileSpecBuf.KeySpecBuf[0].nKeyFlag = BIN;
   FileSpecBuf.KeySpecBuf[0].KeyType = 1;

   nBufLen = sizeof(FILESPEC);

   iStatus = BTRV(14, sPosBlk, &FileSpecBuf, &nBufLen, szFileName, 0);
   if (iStatus)
   {
      printf("create file failed\n");
      printf("iStatus = %d\n", iStatus); 
      printf("\n NWErrno=%lx \n", NWErrno);
   }
/* end create file */

   printf("Test opening btrcoig.dat file\n");
   nBufLen = sizeof(EMPLOY_REC);
   iStatus = BTRV(0, sPosBlk, &Employ, &nBufLen, szFileName , 0);
   if (iStatus)
   {
      printf("open file failed\n");
      printf("iStatus = %d\n", iStatus);
      printf("\n NWErrno=%lx \n", NWErrno);
   }
/*end open file*/

   printf("Test inserting Employ record\n");
   strcpy(Employ.Last_Name,"Shaw");
   strcpy(Employ.First_Name,"Charles");
   Employ.ID = 1;
   strcpy(Employ.Social_Sec, "123-45-6789");

   printf("Employ.Last_Name=%s\n",Employ.Last_Name);
   printf("Employ.First_Name=%s\n",Employ.First_Name);
   printf("EmPloy.ID=%d\n",Employ.ID);
   printf("Employ.Social_Sec=%s\n",Employ.Social_Sec);

   nBufLen = sizeof(EMPLOY_REC);
   iStatus = BTRV(2, sPosBlk, &Employ, &nBufLen, sKeyBuf, 0);
   if (iStatus)
   {
      printf("Insert Employ record failed\n");
      printf("iStatus = %d\n", iStatus);
      printf("\n NWErrno=%lx \n", NWErrno);
   }
/*end insert Employ record */

   printf("Test getting Employ record\n");
   Employ.Last_Name[0]='\0';
   Employ.First_Name[0]='\0';
   Employ.ID = 0;
   Employ.Social_Sec[0]='\0';

   *((short *)&sKeyBuf[0]) = 1;
   nBufLen = sizeof(EMPLOY_REC);
   iStatus = BTRV(5, sPosBlk, &Employ, &nBufLen, sKeyBuf, 0);
   if (iStatus)
   {
      printf("Get Employ record failed\n");
      printf("iStatus = %d\n", iStatus);
      printf("\n NWErrno=%lx \n", NWErrno);
   }

   printf("Employ.Last_Name=%s\n",Employ.Last_Name);
   printf("Employ.First_Name=%s\n",Employ.First_Name);
   printf("EmPloy.ID=%d\n",Employ.ID);
   printf("Employ.Social_Sec=%s\n",Employ.Social_Sec);
/*end get Employ record */

   printf("Testing close opened file\n");
   iStatus = BTRV(1, sPosBlk, &Employ, &nBufLen, sKeyBuf, 0);
   if (iStatus)
   {
      printf("Closing file failed\n");
      printf("iStatus = %d\n", iStatus);
      printf("\n NWErrno=%lx \n", NWErrno);
   }
/*end close opened file */   

}
