/*
 * Bullet/2 Demonstration Program
 * 31-Aug-1995 - Cornel Huth
 * Calls blt2cx0?.c where ?=1 to 7
 * (compiled with WATCOM 10a, stack size set to 32KB)
 */

#define INCL_DOS        // for threads

#include <os2.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>

#include "bullet2.h"

int cx01();
int cx02();
int cx03();
int cx04();
int cx05();
int cx06();
int cx07();
int cx08();
int cx09();

int main() {

#pragma pack(1)

EXITPACK EP;
INITPACK IP;

#pragma pack()

int rez;

CHAR tmpStr[1024];
CHAR op1[] = "Import/Add/REINDEX, with import data generated on-the-fly to DBF.";
CHAR op2[] = "Key I/O on non-Bullet data file (only index file is maintained).";
CHAR op3[] = "Atomic INSERT (transaction-list of up to 512 files).";
CHAR op4[] = "Atomic UPDATE (transaction-list of up to 512 files).";
CHAR op5[] = "Two-table joined view of EMPLOYEE and DEPARTMENT tables.";
CHAR op6[] = "Memo support for text/BLOB data to DBT.";
CHAR op7[] = "Files blowout -- many files opened simultaneously.";
CHAR op8[] = "Lock file, region, & record; exclusive/shared relock.";
CHAR op9[] = "Import/Add/REINDEX (as #1) using Custom sortFunction (float key).";

setbuf(stdout,NULL);

IP.func = INIT_XB;
IP.JFTsize = 1030;        // allow at least 1024 files to be opened
rez = BULLET(&IP);
if (rez) {
   printf("Failed Bullet initialization.  Err: %li\n",rez);
   goto ExitNow;
}

while (1) {
   printf("\x1B[2J\x1B[1;32mBullet/2 Demo.\x1B[0;37m  NLS IX3/DBF/DBT/external [31-Aug-1995]\n\n");
   printf("Take your pick (each has selectable run options):\n");
   printf("\n 0. Exit demo\n");
   printf(" 1. %s\n",op1);
   printf(" 2. %s\n",op2);
   printf(" 3. %s\n",op3);
   printf(" 4. %s\n",op4);
   printf(" 5. %s\n",op5);
   printf(" 6. %s\n",op6);
   printf(" 7. %s\n",op7);
   printf(" 8. %s\n",op8);
   printf(" 9. %s\n",op9);
   printf("\nSelection: ");

   gets(tmpStr);
   switch(*tmpStr) {
   case '1':
      printf("\n\x1B[1;32m%s\x1B[0;37m\n",op1);
      rez = cx01();
      break;
   case '2':
      printf("\n\x1B[1;32m%s\x1B[0;37m\n",op2);
      rez = cx02();
      break;
   case '3':
      printf("\n\x1B[1;32m%s\x1B[0;37m\n",op3);
      rez = cx03();
      break;
   case '4':
      printf("\n\x1B[1;32m%s\x1B[0;37m\n",op4);
      rez = cx04();
      break;
   case '5':
      printf("\n\x1B[1;32m%s\x1B[0;37m\n",op5);
      rez = cx05();
      break;
   case '6':
      printf("\n\x1B[1;32m%s\x1B[0;37m\n",op6);
      rez = cx06();
      break;
   case '7':
      printf("\n\x1B[1;32m%s\x1B[0;37m\n",op7);
      rez = cx07();
      break;
   case '8':
      printf("\n\x1B[1;32m%s\x1B[0;37m\n",op8);
      rez = cx08();
      break;
   case '9':
      printf("\n\x1B[1;32m%s\x1B[0;37m\n",op9);
      rez = cx09();
      break;
   case '0':
      break;
   }
   if ((*tmpStr=='0') | (rez))
      break;

   printf("\nPress ENTER for select menu...");
   getchar();
}
EP.func = EXIT_XB;
rez = BULLET(&EP);

ExitNow:
return(rez);
}

