/*
      BuildList REXX program by Dmitry Dyakonov, 2:5030/207.35@fidonet
                           * for T-Fix & Ttick *
*/

call RxFuncAdd 'SysFileDelete', 'RexxUtil', 'SysFileDelete'
call RxFuncAdd 'SysFileTree', 'RexxUtil', 'SysFileTree'
call RxFuncAdd 'SysOS2Ver', 'RexxUtil', 'SysOS2Ver'

NameList=''     /*   䠩                        */
Header=''       /*  䠩                     */
Footer=''       /* ᮪  䠩                     */
TFixTbl=''      /*  ᠭ ⥩  T-Fix'a       */
TtickCfg=''     /*  ᠭ ⥩  Ttick'a       */
areapath.0=0    /*   䠩                          */
areatag.0=0     /* ⠣                                  */
areadesc.0=0    /* ᠭ 䠩                        */
areafiles.0=0   /* ⢮ 䠫  䠩              */
areabytes.0=0   /* 騩 pp 䠩                    */
incpath.0=0     /*   ⥫쭮            */
incdesc.0=0     /* ᠭ ⥫쭮          */
IncludePos=''   /* ⮯ ⥫ ⥩  */
exclarea.0=0    /* ⠣ ᪫砥  䠩  */
Version='0.2b'  /* p  .cmd ;)                  */
OfflineDesc='-- archived --'
say center("",79,"")
say center("BuildList ver" Version "by Dmitry Dyakonov, 2:5030/207.35@fidonet",79)
say center("",79,"")
If stream('buildlst.ctl','c','open read') \= 'READY:' Then 
  call EndProgram "Can't open buildlst.ctl"
Say 'Reading control file ...'
Call ReadCtl
Call SysFileDelete NameList
parse value DATE('U') with CurMonth '/' CurDay '/' CurYear
Say 'Adding header file:' '"'Header'"'
Call AddHeader
if incpath.0 \= 0  &  IncludePos='Top' then
  Call IncludingArea
if TFixTbl \= '' then
  do
    say 'Reading T-Fix table ...'
    Call ReadTbl
  end
else
  do
    if TtickCfg \= '' then
      do
        say 'Reading Ttick config ...'
        Call ReadCfg
      end
    else call EndProgram 'Program aborted: TFixTbl or TtickCfg not defined.'
  end
if incpath.0 \= 0  &  IncludePos='Bottom' then
  Call IncludingArea
Call ProcessArea
Say 'Building summary table'
Call BuildSummary
Say 'Adding footer file:' '"'Footer'"'
Call AddFooter
Call AddProgramFooter
Call Stream NameList,'c','close'
say ; call EndProgram 'Thanks for using this program.'
exit

ReadCtl:
i=0 ; lineno=0;
  do while lines("buildlst.ctl")
    lineno=lineno+1
    str=strip(linein("buildlst.ctl"))
    if substr(str,1,1)=';' then iterate
    if str = '' then iterate
    parse var str word value rest
    parse upper var word word
    select 
       when word = "NAMELIST"    then NameList    = strip(value)
       when word = "HEADER"      then Header      = strip(value)
       when word = "FOOTER"      then Footer      = strip(value)
       when word = "TTICKCFG"    then TtickCfg    = strip(value)
       when word = "TFIXTBL"     then TFixTbl     = strip(value)
       when word = "OFFLINEDESC" then OfflineDesc = strip(value' 'rest,Both,'"')
       when word = "INCLUDEAREA" then 
           do
             incpath.0=incpath.0+1; incdesc.0=incdesc.0+1
             i=incpath.0
             incpath.i = strip(value)
             rest = strip(rest)
             incdesc.i = strip(rest,Both,'"')
           end
       when word = "INCLUDEPOS"   then IncludePos = strip(value)
       when word = "EXCLUDEAREA" then
           do
              exclarea.0=exclarea.0+1
              i=exclarea.0
              exclarea.i = strip(value)
           end
       otherwise
        say 'Unknown word "'word'" in control file in line #'lineno 'skipped.'
    end
  end
  call stream 'buildlst.ctl','c','close'
return

AddHeader:
 do while lines(Header)
   call lineout NameList, linein(Header)
 end
 call stream Header,'c','close'
return

IncludingArea:
 do i=1 to incpath.0
  areatag.0=areatag.0+1; areapath.0=areapath.0+1; areadesc.0=areadesc.0+1
  j=areatag.0; areatag.j='Included area #'j
  areapath.j=incpath.i; areadesc.j=incdesc.i
 end
return

ReadTbl:
  do while lines(TFixTbl)
     str=strip(linein(TFixTbl))
     if str = "" then iterate
     parse var str word value rest
     parse upper var word word
     select 
       when word = "PATH"  then
          do
              areapath.0=areapath.0+1
              i=areapath.0; str=strip(value)
              areapath.i = left(str,lastpos('\',str),' ')
          end    
       when word = "AREA"  then
          do
              areatag.0=areatag.0+1
              i=areatag.0
              areatag.i = strip(value)
          end
       when word = "COMMENT"  then
          do
              areadesc.0=areadesc.0+1
              i=areadesc.0
              if strip(value)='' then
                areadesc.i = areatag.i
              else
                areadesc.i = value' 'rest
              do j=1 to exclarea.0
                if areatag.i=exclarea.j then
                  do
                     say 'Area' exclarea.j 'excluded.'
                     areatag.0=areatag.0-1; areapath.0=areapath.0-1
                     areadesc.0=areadesc.0-1
                     leave
                  end
              end
          end
       otherwise
     end
  end
  call stream TFixTbl,'c','close'
return

ReadCfg:
  do while lines(TtickCfg)
     str=strip(linein(TtickCfg))
     if str = "" | substr(str,1,1) = ";" then iterate
     parse var str word str
     parse upper var word word
     select 
       when word = "AREA"  then
          do
              areatag.0=areatag.0+1; areapath.0=areapath.0+1; areadesc.0=areadesc.0+1
              i=areatag.0
              parse var str areatag.i areapath.i str
              do j=1 to exclarea.0
                if areatag.i=exclarea.j then
                  do
                     say 'Area' exclarea.j 'excluded.'
                     areatag.0=areatag.0-1; areapath.0=areapath.0-1; areadesc.0=areadesc.0-1
                     leave
                  end
              end
              str=strip(str)
              do while substr(str,1,1) = '-'
                 str=subword(str,2)
              end
              areadesc.i=strip(str)
          end
       otherwise
     end
  end
  call stream TtickCfg,'c','close'
return

ProcessArea:
   palka.1='|'; palka.2='/'; palka.3=''; palka.4='\'; pidx=1
   do i=1 to areatag.0
     areafiles.0=areafiles.0+1; areabytes.0=areabytes.0+1;
     j=0; out.0=0; areafiles.i=0; areabytes.i=0; size=0; date=''; flag=' '
     do while lines(areapath.i''files.bbs)
         j=j+1; out.0=out.0+1; str=''; desc='';
         temp=strip(linein(areapath.i''files.bbs))
         call charout ,left('Processing area' i '"'areadesc.i'"'  palka.pidx,79,' ')''d2c(13)
         pidx=pidx+1
         if pidx > 4 then pidx=1
         if substr(temp,1,1)='' | substr(temp,1,1)='-' then
           out.j=temp
         else
           do
              Call ProcessFile
              if date=-1 then SizeDate=left(xsize,15)
              else SizeDate=right(xsize,5,' ')' 'right(date,8,' ')flag
              out.j=left(fname,12,' ')' 'SizeDate' 'desc
           end
         Call LongDesc
     end
     Call stream areapath.i''files.bbs,'c','close'
     Call BuildArea
   end
   say left('Successfully processed:' i-1 'areas.',79,' ')
return

ProcessFile:
  parse var temp fname desc
  call SysFileTree areapath.i''fname, 'file', 'F'
  if file.0 \= 0 then
    do
       size=subword(file.1,3,1)
       date=subword(file.1,1,1)
       areafiles.i=areafiles.i+1
       xsize=format(size/1024,,0)
       areabytes.i=areabytes.i+xsize
       xsize=xsize'K'
    end
  else 
    do
      xsize=OfflineDesc
      date=-1
    end
  Call SetDateFlag
  desc=strip(desc)
  if length(desc)>50 then
    do
       k=1;
       str=strip(desc)
       do while length(str)-length(subword(str,k)) < 48
         if length(str)-length(subword(str,k))+wordlength(str,k) >48 then leave
         k=k+1
       end
       desc=subword(str,1,k-1)
       str=subword(str,k)
    end
return

SetDateFlag:
  parse value date with FMonth '/' FDay '/' FYear
  if FYear=CurYear then
    select
       when FMonth=CurMonth then
           do
              flag='+'
              if (CurDay-FDay) <= 7 then flag='*'
           end
       when (CurMonth-FMonth)=1 then
           do
              if CurDay <= FDay then
                if (CurDay+30-FDay) <= 30 then
                  do
                     flag='+'
                     if (CurDay+30-FDay) <= 7 then flag='*'
                  end
              else
                if (CurDay-FDay) <= 30 then
                  do
                     flag='+'
                     if (CurDay-FDay) <= 7 then flag='*'
                  end
           end
       otherwise
           flag=' '     
    end
  else flag=' '
return

LongDesc:
 if length(str) > 0 then
   do
      do while length(str) > 50
         out.0=out.0+1; k=1; j=j+1
         do while length(str)-length(subword(str,k)) < 48
          if length(str)-length(subword(str,k))+wordlength(str,k) >48 then leave
          k=k+1
         end
         out.j='                             'subword(str,1,k-1)
         str=subword(str,k)
      end
      out.0=out.0+1; j=j+1
      out.j='                             'str
      str=''
   end
return

BuildArea:
 call lineout NameList,'͸'
 call lineout NameList,' #'right(i,3,'0')'  'left(areadesc.i,69,' ')''
 call lineout NameList,'Ĵ'
 call lineout NameList,'  ' right(areabytes.i,8,' ')' KBytes in' right(areafiles.i,4,' ')' Files  ۲ '
 call lineout NameList,';'
 do n=1 to out.0
   call lineout NameList, out.n
 end
 call lineout NameList, ''
return

BuildSummary:
 totalfiles=0; totalbytes=0
 call lineout NameList, ""
 call lineout NameList, center("",79,"")
 call lineout NameList, center("S u m m a r y     T a b l e",79)
 call lineout NameList, ''
 call lineout NameList, ' Area   Description                                     Files   Bytes       '
 call lineout NameList, ''
 do i=1 to areatag.0
   str=' 'left(i,6)'' left(areadesc.i,46,'.') '' right(areafiles.i,6) '' right(areabytes.i,10)'K'
   call lineout NameList, str
 end
 call lineout NameList, ''
 do i=1 to areatag.0
  totalfiles=totalfiles+areafiles.i
  totalbytes=totalbytes+areabytes.i
 end
 call lineout NameList, right('Total:',56)'' right(totalfiles,6) '' right(totalbytes,10)'K'
 call lineout NameList, ''
 call lineout NameList, ''
return

AddFooter:
 do while lines(Footer)
   call lineout NameList, linein(Footer)
 end
 call stream Footer,'c','close'
return

AddProgramFooter:
call lineout NameList, ""
call lineout NameList, center("",79,"")
call lineout NameList, center("This list was created with BuildList" Version "(REXX Program) by Dmitry Dyakonov",79)
call lineout NameList, center('on' DATE("W") DATE("L") TIME("C") 'under OS/2' SysOS2Ver(),79)
call lineout NameList, center("",79,"")
return

EndProgram:
say Arg(1)
exit
return
