/******************************************************************************
*******************************************************************************
**
**  BT_CALLS.CMD
**  Copyright (c) Bob Swift, 1997.  All rights reserved.
**
**  Analyzes a BinkleyTerm log file and generates an output file showing the
**  percentage of outgoing connections for each node called.  The program
**  takes two arguements on the command line as follows:
**
**          BT_CALLS inputfile [outputfile]
**
**  If outputfile is missing, the output will go to BT_CALLS.LOG in the
**  current directory.
**
**  If the program is called with no arguements, a brief help screen will
**  be displayed.
**
**  This program is free for use.  There is no warranty expressed or implied.
**  Please direct all comments to:
**
**      Bob Swift
**      1:342/5@fidonet
**      [bswift@connect.ab.ca]
**
*******************************************************************************
******************************************************************************/

version = '1.00'                        /* Current Version Number */
sysname = 'The Power Station'           /* Put your system name here */

'@echo off'
parse upper arg infile, outfile, void
say ''
say ''
say 'BT_CALLS (v'version')'
say 'Copyright (c) Bob Swift, 1997.  All rights reserved.'
say ''
if outfile = "" then outfile = 'BT_CALLS.LOG'
if infile = "" then signal help
if \exist(infile) then signal missing
say 'Input File: ' infile
say 'Output File:' outfile
say ''
say ''
cr = '0d'x
drop nodes.
drop calls.
drop connect.
nodes.0 = 0
calls.0 = 0
connect.0 = 0
timetop = ""
timeend = ""
node = ""
conn = 0
callc = 0
count = 0
do while lines(infile) > 0
  count = count + 1
  void = charout(,cr'Lines:'right(count,6)'      Calls:'right(callc,5)'      Nodes:'right(nodes.0,4))
  temp = linein(infile)
  parse var temp a b c d e f g h void
  if (timetop = "" & d \= "") then timetop = b c d
  if (d \= "") then timeend = b c d
  conn = 0
  flag = 0
  if (a = '*' & f = 'Processing') then node = h
  if (a = '#' & f = 'No') then do
    conn = 0
    flag = 1
  end
  if (a = '#' & f = 'Connect') then do
    conn = 1
    flag = 1
  end
  if (flag = 1 & node \= "") then do
    callc = callc + 1
    g = 0
    do while g < nodes.0
      g = g + 1
      if nodes.g = node then do
        calls.g = calls.g + 1
        connect.g = connect.g + conn
        g = nodes.0
        node = ""
      end
    end
    if node \= "" then do
      g = nodes.0 + 1
      nodes.0 = g
      calls.0 = g
      connect.0 = g
      nodes.g = node
      calls.g = 1
      connect.g = conn
      node = ""
    end
  end
end
void = stream(infile,'c','close')

say ''
say 'Sorting list of nodes...'

/*  Use bubble sort because list is generally quite small.  */
d = 1
do while d < nodes.0
  a = d
  b = d
  d = d + 1
  do while b < nodes.0
   b = b + 1
   azone = right(left(nodes.a,pos(':',nodes.a)-1),7,'0')
   bzone = right(left(nodes.b,pos(':',nodes.b)-1),7,'0')
   c = substr(nodes.a,pos(':',nodes.a)+1)
   anet = right(left(c,pos('/',c)-1),7,'0')
   c = substr(nodes.b,pos(':',nodes.b)+1)
   bnet = right(left(c,pos('/',c)-1),7,'0')
   c = substr(nodes.a,pos('/',nodes.a)+1)
   anode = right(c,7,'0')
   apoint = right('0',7,'0')
   if pos('.',c) > 0 then do
     anode = right(left(c,pos('.',c)-1),7,'0')
     apoint = right(substr(c,pos('.',c)+1),7,'0')
   end
   c = substr(nodes.b,pos('/',nodes.b)+1)
   bnode = right(c,7,'0')
   bpoint = right('0',7,'0')
   if pos('.',c) > 0 then do
     bnode = right(left(c,pos('.',c)-1),7,'0')
     bpoint = right(substr(c,pos('.',c)+1),7,'0')
   end
   if (azone > bzone) | ((azone = bzone) & (anet > bnet)) | ((azone = bzone) & (anet = bnet) & (anode > bnode)) | ((azone = bzone) & (anet = bnet) & (anode = bnode) & (apoint > bpoint)) then do
     c = nodes.a
     nodes.a = nodes.b
     nodes.b = c
     c = calls.a
     calls.a = calls.b
     calls.b = c
     c = connect.a
     connect.a = connect.b
     connect.b = c
   end
  end
end

g = infile || right('BT_CALLS v'version,78-length(infile))
void = lineout(outfile,g)
g = strip(centre(sysname,78),'T')
void = lineout(outfile,g)
g = strip(centre('BinkleyTerm Log Statistics for the Period',78),'T')
void = lineout(outfile,g)
g = strip(centre(timetop || '  to  ' || timeend,78),'T')
void = lineout(outfile,g)
g = strip(centre('' || left('',61,'') || '',78),'T')
void = lineout(outfile,g)
g = strip(centre('' || centre('Percentage of Outgoing Call Connections',61) || '',78),'T')
void = lineout(outfile,g)
g = strip(centre('' || left('',61,'') || '',78),'T')
void = lineout(outfile,g)
g = strip(centre(' Node                 |  Calls Out  |  Connect  |  Connect % ',78),'T')
void = lineout(outfile,g)
g = strip(centre('' || left('',61,'') || '',78),'T')
void = lineout(outfile,g)
a = 0
b = 0
c = 0
do while a < nodes.0
  a = a + 1
  b = b + calls.a
  c = c + connect.a
  g = strip(centre(' ' || left(nodes.a,21) || right(calls.a,10) || right(connect.a,12) || right(trunc(100*connect.a/calls.a,1),14) || '   ',78),'T')
  void = lineout(outfile,g)
end
g = strip(centre('' || left('',61,'') || '',78),'T')
void = lineout(outfile,g)
g = strip(centre('   ' || left('TOTAL',19) || right(b,10) || right(c,12) || right(trunc(100*c/b,1),14) || '   ',78),'T')
void = lineout(outfile,g)
g = strip(centre('' || left('',61,'') || '',78),'T')
void = lineout(outfile,g)
void = stream(outfile,'c','close')
say ''
say ''
return 0

/*****************************************************************************/

missing:
say 'Unable to open input file,' infile '(RC = 2).'
say ''
say ''
return 2

/*****************************************************************************/

help:
say 'Analyzes a BinkleyTerm log file and generates an output file showing the'
say 'percentage of outgoing connections for each node called.  The program'
say 'takes two arguements on the command line as follows:'
say ''
say '        BT_CALLS inputfile [outputfile]'
say ''
say 'If outputfile is missing, the output will go to BT_CALLS.LOG in the'
say 'current directory.'
say ''
say ''
return 1

/*****************************************************************************/
