Program BtrieveErrors;

uses
  Btv, BtvConst,
  WinDos, WinTypes, WinProcs,
  OWindows, ODialogs, OStdDlgs,
  Strings, Validate;

{$R- X+ D+ L+}
{$R BTRVMSG.RES}
{$I BTRVMSG.INC}

const
  id_ErrorNumber = 101;
  id_ErrorName   = 102;
  id_ErrorText   = 103;
  id_SaveBtn     = 104;
  id_ClearBtn    = 105;
  id_NextBtn     = 106;
  id_PrevBtn     = 107;
  id_LoadBtn     = 108;
  id_DeleteBtn   = 109;
  id_SaveAsBtn   = 110;
  id_GroupBox    = 111;
  id_RButton1    = 112;
  id_RButton2    = 112;


type
  PBtrvMsgRec = ^TBtrvMsgRec;
  TBtrvMsgRec = record
    ID   : Integer;
    Code : Integer;
    Name : Array[0..80] of Char;
    Text : Array[0..900] of Char;
  end;


  TBtrvApp = object(TApplication)
    procedure InitMainWindow; virtual;
  end;


  PMultiEdit	= ^TMultiEdit;
  TMultiEdit = object(TEdit)
    procedure WMKeyDown(var Msg: TMessage);
      virtual  wm_First + wm_KeyDown;
  end;


  PError  = ^TError;
  TError  = Object(ErrorDisplay)
    Function    Display(Error     : Integer;
                        ErrorMsg  : String;
                        OpCode    : Integer;
                        OpCodeMsg : String;
                        FileName  : PathStr
                        ): ErrorAction;             Virtual;
  end;


  PBtrvWindow = ^TBtrvWindow;
  TBtrvWindow = object(TWindow)
    ErrorNumber : PEdit;
    ErrorName   : PEdit;
    ErrorText   : PEdit;
    GroupBox    : PGroupBox;
    RadioBtn1   : PRadioButton;
    RadioBtn2   : PRadioButton;
    FileName    : array[0..fsPathName] of Char;
    FileOpen    : Boolean;
    F           : PBtrieveFile;
    ErrDisplay  : PError;
    ErrHandler  : PErrorHandler;
    Data        : PBtrvMsgRec;
    NewRecord   : Boolean;

    constructor Init(AParent: PWindowsObject; ATitle: PChar);
    destructor Done; virtual;
    function CanClose: Boolean; virtual;
    function HasChanged: Boolean;
    procedure SaveRecord;

    { button methods }
    procedure IDLoadBtn(var Msg : TMessage);
      virtual id_First + id_LoadBtn;
    procedure IDNextBtn(var Msg : TMessage);
      virtual id_First + id_NextBtn;
    procedure IDPrevBtn(var Msg : TMessage);
      virtual id_First + id_PrevBtn;
    procedure IDSaveBtn(var Msg : TMessage);
      virtual id_First + id_SaveBtn;
    procedure IDClearBtn(var Msg : TMessage);
      virtual id_First + id_ClearBtn;
    procedure IDDeleteBtn(var Msg : TMessage);
      virtual id_First + id_DeleteBtn;
    procedure IDSaveAsBtn(var Msg : TMessage);
      virtual id_First + id_SaveAsBtn;

    { menu methods }
    procedure CMFileNew(var Msg: TMessage);
      virtual cm_First + cm_FileNew;
    procedure CMFileOpen(var Msg: TMessage);
      virtual cm_First + cm_FileOpen;
    procedure CMFileClose(var Msg: TMessage);
      virtual cm_First + cm_FileClose;
  end;


var
  BtrvApp: TBtrvApp;


procedure TBtrvApp.InitMainWindow;
  begin
    MainWindow := New(PBtrvWindow, Init(nil, 'Btrieve Message Editor'));
  end;


function TError.Display(Error     : Integer;
                        ErrorMsg  : String;
                        OpCode    : Integer;
                        OpCodeMsg : String;
                        FileName  : PathStr
                        ): ErrorAction;

  var
    Temp : Array[0..512] of Char;
    Op   : String[10];
    Err  : String[10];
    Reply: Integer;

  begin
    Str(Error, Err);
    Str(OpCode, Op);
    StrPCopy(Temp, 'Btrieve Error # ' + Err + ' - ' + ErrorMsg + #13#10 +
                   'Btrieve Opcode # ' + Op + ' - ' + OpCodeMsg + #13#10);
    Reply := MessageBox(BtrvApp.MainWindow^.HWindow, Temp, 'BTRIEVE IO ERROR',
                        mb_AbortRetryIgnore or mb_IconQuestion);

    Case Reply of
      id_Abort : Display := erAbort;
      id_Retry : Display := erRetry;
      id_Ignore: Display := erDone;
    end;
  end;


procedure TMultiEdit.WMKeyDown(var Msg: TMessage);

  var
    nKeyState : Integer;

  begin
    if (Msg.WParam = vk_Tab) then
    begin
      nKeyState := GetAsyncKeyState(vk_Shift);

      if ($FF00 and nKeyState <> 0) then
        SetFocus(Previous^.HWindow)
      else
        SetFocus(Next^.HWindow);
    end

    else
      Inherited WmKeyDown(Msg);
  end;


constructor TBtrvWindow.Init(AParent: PWindowsObject; ATitle: PChar);

  var
    AStat: PStatic;
    ABtn : PButton;

  begin
     inherited Init(AParent, ATitle);
    Attr.Menu := LoadMenu(HInstance, MakeIntResource(Main_Menu));
    Attr.X    := 10;
    Attr.y    := 10;
    Attr.W    := 655;
    Attr.H    := 575;
    ErrorNumber := New(PEdit, Init(@Self, id_ErrorNumber, '0', 130, 10, 70, 30, 6, False));
    ErrorNumber^.Validator := New(PRangeValidator, Init(0,65000));
    GroupBox    := New(PGroupBox, Init(@Self, id_GroupBox, 'Message Type', 130, 45, 140, 90));
    RadioBtn1   := New(PRadioButton, Init(@Self, id_RButton1, 'Error', 145, 70, 100, 30, GroupBox));
    RadioBtn2   := New(PRadioButton, Init(@Self, id_RButton1, 'Status', 145, 100, 100, 30, GroupBox));
    ErrorName   := New(PEdit, Init(@Self, id_ErrorName, '', 130, 150, 500, 30, 81, False));
    ErrorText   := New(PMultiEdit, Init(@Self, id_ErrorText, '', 130, 190, 500, 240, 901, True));
    ABtn  := New(PButton, Init(@Self, id_SaveBtn, '&Save', 35, 465, 60, 30, False));
    ABtn  := New(PButton, Init(@Self, id_LoadBtn, '&Load', 115, 465, 60, 30, False));
    ABtn  := New(PButton, Init(@Self, id_ClearBtn,'&Clear',195, 465, 60, 30, False));
    ABtn  := New(PButton, Init(@Self, id_NextBtn, '&Next', 275, 465, 60, 30, False));
    ABtn  := New(PButton, Init(@Self, id_PrevBtn, '&Prev', 355, 465, 60, 30, False));
    ABtn  := New(PButton, Init(@Self, id_DeleteBtn, '&Delete', 435, 465, 70, 30, False));
    ABtn  := New(PButton, Init(@Self, id_SaveAsBtn, 'Save &As', 525, 465, 80, 30, False));
    AStat := New(PStatic, Init(@Self, 200, 'Code:', 10, 10, 110, 24, 0));
    AStat := New(PStatic, Init(@Self, 201, 'Decsription:', 10, 150, 110, 24, 0));
    AStat := New(PStatic, Init(@Self, 202, 'Text:', 10, 190, 110, 24, 0));

    ErrorText^.Attr.Style := ErrorText^.Attr.Style and not ws_HScroll and not es_AutoHScroll;
    EnableKBHandler;
    FileOpen := False;
    FileName[0] := #0;
    F := nil;
    ErrDisplay := New(PError, Init);
    ErrHandler := New(PDefErrorHandler, Init(ErrDisplay));
    ErrHandler^.AddErrors([bEOF]);
    New(Data);
    NewRecord := True;
  end;

destructor TBtrvWindow.Done;
  begin
    if FileOpen then
    begin
      F^.Close;
      Dispose(F, Done);
    end;

    Dispose(ErrDisplay, Done);
    Dispose(ErrHandler, Done);
    inherited Done;
  end;

procedure TBtrvWindow.IDLoadBtn(var Msg : TMessage);

  var
    Temp : Array[0..80] of Char;
    Num  : Integer;
    ID   : Integer;
    Err  : Integer;

  begin
    if not FileOpen then
    begin
      MessageBox(HWindow, 'Please open a file first.', 'Information',
                 mb_OK or mb_IconExclamation);
      EXIT;
    end;

    ErrorNumber^.GetText(Temp, 6);
    Val(Temp, Num, Err);

    if (Err = 0) then
    begin
      ID := 0;

      if (RadioBtn2^.GetCheck = bf_Checked) then
         ID := 1;

      F^.MakeKey(@ID, @Num, nil,nil,nil,nil);
      F^.ClearBuffer;
      F^.Get(bGetEqual, bNoLock);

      if (F^.bResult = bOkay) then
      begin
        if (Data^.ID = 1) then
        begin
          RadioBtn1^.UnCheck;
          RadioBtn2^.Check;
        end
        else
        begin
          RadioBtn2^.UnCheck;
          RadioBtn1^.Check;
        end;

        Str(Data^.Code, Temp);
        ErrorNumber^.SetText(Temp);
        ErrorName^.SetText(Data^.Name);
        ErrorText^.Transfer(@Data^.Text, tf_SetData);
        NewRecord := False;
      end;
    end;
  end;

procedure TBtrvWindow.IDSaveBtn(var Msg : TMessage);
  begin
    SaveRecord;
  end;

procedure TBtrvWindow.SaveRecord;

  var
    Temp : Array[0..1024] of Char;
    Num  : Integer;
    ID   : Integer;
    Err  : Integer;
    i,x  : Integer;
    Len  : Integer;

  begin
    if not FileOpen then
    begin
      MessageBox(HWindow, 'Please open a file first.', 'Information',
                 mb_OK or mb_IconExclamation);
      EXIT;
    end;

    ErrorNumber^.GetText(Temp, 6);
    Val(Temp, Num, Err);

    if (Err <> 0) then
       EXIT;

    ID := 0;

    if (RadioBtn2^.GetCheck = bf_Checked) then
       ID := 1;

    if NewRecord then
    begin
      F^.ErrorsOnOff(False);
      F^.MakeKey(@ID, @Num, nil,nil,nil,nil);
      F^.Get(bGetEqual + bGetKey, bNoLock);
      F^.ErrorsOnOff(True);

      if (F^.bResult = bOkay) then
      begin
        Num := MessageBox(HWindow, 'Do you want to overwrite?', 'Record Already Exists',
                          mb_YesNo or mb_IconQuestion);

        if (Num = id_Yes) then
        begin
          NewRecord := False;
          F^.Get(bGetEqual, bNoLock);
        end

        else
          EXIT;
      end;
    end;

    F^.ClearBuffer;
    Data^.Code := Num;
    Data^.ID   := ID;
    ErrorName^.GetText(Data^.Name, 81);
    Len := ErrorText^.GetTextLen;
    ErrorText^.GetText(Temp, Len + 1);
    x := 0;

    for i := 0 to Len - 1 do
      Case Temp[i] of
        #13 :;
        #10 :
        begin
          Data^.Text[x] := ' ';
          Inc(x);
        end

        else
        begin
          Data^.Text[x] := Temp[i];
          Inc(x);
        end;
      end;

    F^.SetOutputSize(x + 85);

    if NewRecord then
      F^.Insert
    else
      F^.Update;

    ErrorNumber^.SetText('0');
    RadioBtn2^.UnCheck;
    RadioBtn1^.Check;
    ErrorName^.SetText('');
    ErrorText^.SetText('');
    NewRecord := True;
    SetFocus(ErrorNumber^.HWindow);
    ErrorNumber^.SetSelection(0,1);
  end;

procedure TBtrvWindow.IDPrevBtn(var Msg : TMessage);

  var
    Temp : Array[0..80] of Char;

  begin
    if CanClose and FileOpen and not NewRecord then
    begin
      F^.ClearBuffer;
      F^.Get(bGetPrev, bNoLock);

      if (F^.bResult = bOkay) then
      begin
        if (Data^.ID = 1) then
        begin
          RadioBtn1^.UnCheck;
          RadioBtn2^.Check;
        end
        else
        begin
          RadioBtn2^.UnCheck;
          RadioBtn1^.Check;
        end;

        Str(Data^.Code, Temp);
        ErrorNumber^.SetText(Temp);
        ErrorName^.SetText(Data^.Name);
        ErrorText^.SetText(Data^.Text);
        NewRecord := False;
      end;
    end;
  end;

procedure TBtrvWindow.IDNextBtn(var Msg : TMessage);

  var
    Temp : Array[0..80] of Char;

  begin
    if CanClose and FileOpen and not NewRecord then
    begin
      F^.ClearBuffer;
      F^.Get(bGetNext, bNoLock);

      if (F^.bResult = bOkay) then
      begin
        if (Data^.ID = 1) then
        begin
          RadioBtn1^.UnCheck;
          RadioBtn2^.Check;
        end
        else
        begin
          RadioBtn2^.UnCheck;
          RadioBtn1^.Check;
        end;

        Str(Data^.Code, Temp);
        ErrorNumber^.SetText(Temp);
        ErrorName^.SetText(Data^.Name);
        ErrorText^.SetText(Data^.Text);
        NewRecord := False;
      end;
    end;
  end;

procedure TBtrvWindow.IDClearBtn(var Msg : TMessage);
  begin
    if not FileOpen or CanClose then
    begin
      ErrorNumber^.SetText('0');
      ErrorName^.SetText('');
      ErrorText^.SetText('');
      RadioBtn2^.UnCheck;
      RadioBtn1^.Check;
      NewRecord := True;
      SetFocus(ErrorNumber^.HWindow);
      ErrorNumber^.SetSelection(0,1);
    end;
  end;

procedure TBtrvWindow.IDSaveAsBtn(var Msg : TMessage);
  begin
    NewRecord := True;
    SaveRecord;
  end;

procedure TBtrvWindow.IDDeleteBtn(var Msg : TMessage);

  var
    Ret : Integer;

  begin
    if not NewRecord then
    begin
      Ret := MessageBox(HWindow, 'Are you sure?', 'Delete Record',
                        mb_YesNo or mb_IconQuestion);

      if (Ret = id_Yes) then
        F^.Delete;

      ErrorNumber^.SetText('0');
      ErrorName^.SetText('');
      ErrorText^.SetText('');
      RadioBtn2^.UnCheck;
      RadioBtn1^.Check;
      NewRecord := True;
      SetFocus(ErrorNumber^.HWindow);
      ErrorNumber^.SetSelection(0,1);
    end;
  end;

procedure TBtrvWindow.CMFileOpen(var Msg: TMessage);

  var
    FD : PFileDialog;

  begin
    if CanClose then
      if not FileOpen then
      begin
        FD := New(PFileDialog, Init(@Self, MakeIntResource(sd_FileOpen), FileName));
        StrCopy(FileName, '*.ERR');

        if Application^.ExecDialog(FD) = id_OK then
        begin
          F := New(PBtrieveFile, Init(StrPas(FileName), ErrHandler, Data, SizeOf(TBtrvMsgRec)));
          F^.Open(bNormal, '');
          FileOpen := (F^.bResult = bOkay);
        end
      end

      else
      begin
        MessageBox(HWindow, 'Please close the current file.', 'Information',
                   mb_OK or mb_IconExclamation);
      end;
  end;

function TBtrvWindow.CanClose: Boolean;

  var
    Reply: Integer;

  begin
    CanClose := True;

    if HasChanged then
    begin
      Reply := MessageBox(HWindow, 'Do you want to save?', 'Current Record has Changed',
                          mb_YesNo or mb_IconQuestion);

      if (Reply = id_Yes) then
         CanClose := False;
    end;
  end;

procedure TBtrvWindow.CMFileNew(var Msg: TMessage);

  var
    FD : PFileDialog;

  begin
    if FileOpen then
    begin
      MessageBox(HWindow, 'Please close the current file.', 'Information',
                 mb_OK or mb_IconExclamation);
      EXIT;
    end;

    FD := New(PFileDialog,Init(@Self, MakeIntResource(sd_FileOpen), FileName));
    FD^.Caption := 'File New';
    StrCopy(FileName, 'BTRIEVE.ERR');

    if (Application^.ExecDialog(FD) = id_OK) then
    begin
      F := New(PBtrieveFile, Init(StrPas(FileName), ErrHandler, Data, SizeOf(TBtrvMsgRec)));
      F^.AddKeySegment(1, 2, bExtended + bSegmented, bInteger, 0, bNoJustify);
      F^.AddKeySegment(3, 2, bExtended, bInteger, 0, bNoJustify);
      F^.Create(bVariableLen, 85, 512, 0, bNormal);

      if (F^.bResult = bOkay) then
        F^.Open(bNormal, '');

      FileOpen := (F^.bResult = bOkay);
    end;
  end;

procedure TBtrvWindow.CMFileClose(var Msg: TMessage);
  begin
    F^.Close;
    FileOpen := not (F^.bResult = bOkay);

    if not FileOpen then
      Dispose(F, Done);
  end;

function TBtrvWindow.HasChanged: Boolean;
  begin
    HasChanged := ErrorNumber^.IsModified or ErrorName^.IsModified or ErrorText^.IsModified;
  end;


begin
  BtrvApp.Init('BTRVMSG');
  BtrvApp.Run;
  BtrvApp.Done;
end.
