#include <string.h>

#ifndef BOOL
   #define BOOL short
#endif
#ifndef TRUE
        #define TRUE 1
#endif                

#ifndef FALSE
        #define FALSE 0
#endif                


#include "bcalls.h"

#define SAVEBT          memcpy(&savebtstr,&btstr,sizeof(BT_STRUCT))
#define RESTOREBT       memcpy(&btstr,&savebtstr,sizeof(BT_STRUCT))
#define RESTORE         RESTOREBT
#define LONGTYPE        1
#define SHORTTYPE       2
#define DOUBLETYPE      3
#define CHARTYPE        11
#define CHECKALLCHLOR   if (!this->ALLCHLOR) return


#define BTRCL   this->btrvsyscall
#define CHECKERR()      this->error(__FILE__,__LINE__)
#define SETOP(OP)          this->btstr.OPCode=OP
#define SETKB(buf)      memcpy(this->btstr.Keybuffer,buf,MAXKEYLENGTH);
#define SETKN(num)      this->btstr.Keynumber = num
#define SETDB(buf)      memcpy(this->btstr.Databuffer,buf,MAXRECORDLENGTH)
#define SETDBL(num)     this->btstr.Databufferlength = num
#define KILLEXTENSION(filename) sprintf(Filename+strlen(Filename)-4,"%c",0)


typedef struct KEYS {
                short keypos;
                short keylength;
                short keyflags; // DUP etc
                long nokeys;
                char extendet;    // STRING etc
                char nullvalue;
                long reserved;
                   }KEYS;

typedef struct Filestruct {
                short Recordlength;
                short PageSize;
                short Indices;
                long Records;
                short fileflags;
                short reserved;
                short unused;
                struct KEYS key[MAXKEYS];
                }FILESTRUCT;



typedef struct 
{
 char        netAddress[ 12 ];
 short        MyId;
 short        ClientID;
}USER;

struct Userstruct;



extern "C" short int btrvID (
                       short int,
                       void   *,
                       void   *,
                       short int *,
                       void   *,
                       short int,
                       struct Userstruct * );






class Databasefile {

        private:
        struct BT_STRUCT savebtstr;             // defined in bt.h
        struct BT_STRUCT updatebuffer;          // defined in bt.h
        short reclength;
        BOOL Fileopen;

                  char Databasename[100];


                  public: // Functions
                                         BOOL hasRecords;
                                         struct Filestruct file;
                                         struct BT_STRUCT btstr;         // defined in bt.h
                                         BOOL ALLCHLOR;

                Databasefile(char *Filename, BOOL RO_Mode = TRUE,short Index = 0);
                virtual ~Databasefile(void);
                virtual BOOL DoDataExchange(char direction='>');

                BOOL Databasefile::operator++();
                BOOL Databasefile::operator--();

                BOOL Databasefile::operator<(char *value);
                BOOL Databasefile::operator<=(char *value);
                BOOL Databasefile::operator==(char *value);
                BOOL Databasefile::operator>(char *value);
                BOOL Databasefile::operator>=(char *value);
                BOOL Databasefile::operator+=(char *value);
                BOOL Databasefile::operator-=(char *value);

                BOOL Databasefile::operator<(long value);
                BOOL Databasefile::operator<=(long value);
                BOOL Databasefile::operator==(long value);
                BOOL Databasefile::operator>(long value);
                BOOL Databasefile::operator>=(long value);
                BOOL Databasefile::operator+=(long value);
                BOOL Databasefile::operator-=(long value);

                BOOL Databasefile::operator<(short value);
                BOOL Databasefile::operator<=(short value);
                BOOL Databasefile::operator==(short value);
                BOOL Databasefile::operator>(short value);
                BOOL Databasefile::operator>=(short value);
                BOOL Databasefile::operator+=(short value);
                BOOL Databasefile::operator-=(short value);

                BOOL Databasefile::operator<(double value);
                BOOL Databasefile::operator<=(double value);
                BOOL Databasefile::operator==(double value);
                BOOL Databasefile::operator>(double value);
                BOOL Databasefile::operator>=(double value);
                BOOL Databasefile::operator+=(double value);
                BOOL Databasefile::operator-=(double value);

                BOOL Databasefile::btrvsyscall();
                void Databasefile::bytesumme(long *summe,void *array,short size);


                BOOL GetLast();
                BOOL GetFirst();
                BOOL GetNext();
                BOOL GetPrevious();

                BOOL GetFirstFilter(char op[3],char *searchvalue);
                BOOL GetNextFilter(char op[3],char *searchvalue);
                BOOL GetPreviousFilter(char op[3],char *searchvalue);

                BOOL GetFirstFilter(char op[3],long searchvalue);
                BOOL GetNextFilter(char op[3],long searchvalue);
                BOOL GetPreviousFilter(char op[3],long searchvalue);

                BOOL GetFirstFilter(char op[3],short searchvalue);
                BOOL GetNextFilter(char op[3],short searchvalue);
                BOOL GetPreviousFilter(char op[3],short searchvalue);

                BOOL GetFirstFilter(char op[3],double searchvalue);
                BOOL GetNextFilter(char op[3],double searchvalue);
                BOOL GetPreviousFilter(char op[3],double searchvalue);


                // Search Operation
                BOOL Find(char op[3],char *value);
                BOOL Find(char op[3],short);
                BOOL Find(char op[3],long);
                BOOL Find(char op[3],double);



                // Modify OP
                BOOL Insert();
                BOOL Delete();
                BOOL DeleteAll();
                BOOL Deletewhere(char op[3],char *value);
                BOOL Deletewhere(char op[3],short value);
                BOOL Deletewhere(char op[3],long value);
                BOOL Deletewhere(char op[3],double value);
                BOOL Update();

                // Transactions()
                BOOL BeginTransaction();
                BOOL AbortTransaction();
                BOOL EndTransaction();

                // Locks
                BOOL LockRecord();
                BOOL LockFile();
                BOOL Unlock();

                // Misc
                BOOL GetRecno(long *recno);
                BOOL SetRecno(long recno);
                BOOL RecCount(long *reccount);
                long RecCount(void);

                BOOL Stat();

                BOOL Reclength(short *reclength);
                BOOL SetIndex(short);
                short GetIndex();
                virtual BOOL error(char *,short);

};





