//**************************************************************************
//**************************************************************************
//***                                                                    ***
//***             NOVEL-BTREE-FUNKTIONEN                                 ***
//***                                                                    ***
//**************************************************************************
//**************************************************************************

#include "BCALLS.H"
#ifndef __WATCOMC__
        #include <dos.H>
#endif
static int _Status ;
static int _Length ;
static char _Key[256] ;

static int TTSActiveFlag = 0 ;

#ifdef __WATCOMC__
        #ifndef FP_OFF
                #define FP_OFF( fp )( (unsigned )( fp ))
        #endif
#else
        #define FP_OFF( fp )( (unsigned )( fp ))
#endif
/*
// ProcId is used for communicating with the Multi Tasking Version of
// Btrieve. It contains the process id returned from BMulti and should
// not be changed once it has been set
*/


int BTRV(int OP,void far *POS_BLK,void far *DATA_BUF,int far *DATA_LEN,void far *KEY_BUF,int KEY_NUM )
   {
   static unsigned ProcId = 0 ; // initialize to no process id
   static char multi      = 0 ; // flag set to true if MultiUser
   static char VSet       = 0 ; // flag set to true if checked version
   struct REGVAL
      {
      int AX, BX, CX, DX, SI, DI, CY , xx ;
      } REGS ;
   struct SEGREG
      {
      short ES, CS, SS, DS ;
      } SREGS ;
   struct BTRIEVE_PARMS     // structure to Btrieve Record Manager
      {
      char *BUF_OFFSET  ;        // callers data buffer offset
      int   BUF_LEN     ;        // length of data buffer
      char *CUR_OFFSET  ;        // user position block offset
      char *FCB_OFFSET  ;        // offset of disk FCB
      int   FUNCTION    ;        // requested function
      char *KEY_OFFSET  ;        // offset of user's key buffer
      char  KEY_LENGTH  ;        // length of user's key buffer
      char  KEY_NUMBER  ;        // key of reference for request
      int  *STAT_OFFSET ;   // offset of status word
      int   XFACE_ID    ;   // language identifier
      } XDATA ;
   int STAT = 0 ;                           // status of Btrieve call

   if ( ! VSet ) // Check for Btrieve Manager started
      {
      VSet = 1 ;
      REGS.AX = 0x3000 ;
      int86x(0x21,&REGS,&REGS,&SREGS) ;
      if ( (REGS.AX & 0x00FF) >= 3 )
         {
         REGS.AX = _2FCODE ;
         int86x (BTR2_INT,(union REGS *)&REGS,&REGS,&SREGS) ;
         multi = ((REGS.AX & 0xFF) == 'M') ;
         }
      }

   if ( ! multi )
      {
      REGS.AX = 0x3500 + BTR_INT ;
      int86x(0x21,&REGS,&REGS,&SREGS) ;
      if ( REGS.BX != BTR_OFFSET )  return(BTR_ERR) ;
      }

   segread(&SREGS) ;                             // Read SREGS for Users DATE-Segmenet
   XDATA.FUNCTION    =  OP                     ; // Move user Parter to XDATA
   XDATA.STAT_OFFSET = &STAT                   ;
   XDATA.FCB_OFFSET  =  (char *)(POS_BLK)      ;
   XDATA.CUR_OFFSET  =  (char *)(POS_BLK) + 38 ;
   XDATA.BUF_OFFSET  =  (char *)(DATA_BUF)     ;
   XDATA.BUF_LEN           = *DATA_LEN               ;
   XDATA.KEY_OFFSET  =  (char *)(KEY_BUF)      ;
   XDATA.KEY_LENGTH  =  255                    ; // use max since we don't know
   XDATA.KEY_NUMBER  =  KEY_NUM                ;
   XDATA.XFACE_ID          =  VARIABLE_ID            ;
   REGS.DX = FP_OFF(&XDATA)                    ; // parameter block to DX
   SREGS.DS = SREGS.SS ;

   if ( ! multi )
      {
      int86x(BTR_INT,&REGS,&REGS,&SREGS) ;
      }
   else
      {
      while ( 1 )
         {
         REGS.AX = 1 ;
         if ( (REGS.BX = ProcId) != 0 ) REGS.AX = 2 ;
         REGS.AX += _2FCODE ;
         int86x(BTR2_INT,&REGS,&REGS,&SREGS) ;
         if ( (REGS.AX & 0x00FF) == 0 ) break ;
         REGS.AX = 0x0200 ;
         int86x(0x7F,&REGS,&REGS,&SREGS) ;
         }
      if ( ProcId == 0 ) ProcId = REGS.BX ;
      }
   *DATA_LEN = XDATA.BUF_LEN;
   return(STAT) ;
   }






