/*
  This file is an example program of how to use Don Cameau's (70451,2312) 
  radio buttons GET system.  In this program the user is allowed to choose
  files from the current directory with a checkbox style interface.  
  
  Whats so great about this?  Well, have you ever wanted the user to choose
  several files to be printed all at once.  With aCHOICE() or most other
  array/choice type functions only one selection is returned at a time.
  With this the user can select as many selections as he or she wishes. Then
  all you have to do is search the array to see which items were selected.

  This program was written in very simple, easy to understand syntax on purpose
  for anyone who is new to clipper or the radio buttons GET system by Don 
  Cameau.

  The radio buttons GET systems OBJ file is packages along with this and must be
  linked into this program for it to work.  I have altered the way the COLORS
  work with this GET system, so you may want a copy of the original radio 
  buttons GET system. It can be found at GO CLIPPER, which is probably where you
  got this.

  This program was written by Troy Morton
*/

#include "radiobtn.ch"  && This header file is required.
#include "box.ch"       && Same as with CLIPPER 5.2d
#include "inkey.ch"     && Same as with CLIPPER 5.2d

LOCAL TROY1 := {}                       && Array to hold results of GET
LOCAL getlist := {}                     && The CLIPPER 5.2d GET array
LOCAL aFILELIST := DIRECTORY("*.*")     && An array of files in current dir
LOCAL aNEWLIST := ARRAY(LEN(aFILELIST)) && New array with only file names
LOCAL aSELECTED := {}                   && Array to hold names of selected
LOCAL X, TEMP                           && files. And two temp vars.

DO WHILE LASTKEY() != K_ESC
   SET SCOREBOARD OFF
   SET COLOR TO W/B
   SCROLL()                && Same as CLS or CLEAR SCREEN
   SET COLOR TO N/W,W+/W

************************************************************
*** Move only file names from DIRECTORY() to a new array ***
************************************************************
   FOR X = 1 TO LEN(aFILELIST)
      aNEWLIST[X] := REPLICATE(aFILELIST[X][1],1)
   NEXT X

************************************************************
*** Create an array to hold selections (1 yes, 0 no) and ***
*** fill it with 0's. If it isn't filled with 0's an     ***
*** argument error will occur.                           ***
************************************************************
   TROY1 := ARRAY(LEN(aNEWLIST))
   AFILL(TROY1,0)

************************************************************
*** Display and READ the GETs                            ***
************************************************************
   DISPBOX(4,33,5+LEN(ANEWLIST),53,B_SINGLE+" ","N/W")
   FOR X = 1 TO LEN(aNEWLIST)              && Notice the {} around aNEWLIST[X]
      @4+X,35 GET TROY1[X];                && The GET reader expects an array
      VIA CHECKBOX {aNEWLIST[X]};          && so we fool it into thinking it's a
      NOBOX                                && one element array.
   NEXT X                                                    
   READ                                                      

************************************************************
*** Copy the selected items to a new array               ***
************************************************************
   FOR X = 1 TO LEN(TROY1)
      IF TROY1[X] = 1   
         AADD(aSELECTED,REPLICATE(aNEWLIST[X],1))
      ENDIF
   NEXT X

************************************************************
*** Use aChoice() to show which items were selected      ***
************************************************************
   
   IF LEN(aSELECTED) > 0    && Make sure that something was selected
      
      DISPBOX(4,5,5+LEN(aSELECTED),20,B_SINGLE+" ","N/W")
      @4,6 SAY " Chosen Files "
      TEMP := ACHOICE(5,6,5+LEN(aSELECTED),19,aSELECTED)
      
      IF TEMP > 0           && Make sure that the aCHOICE() wasn't aborted
         
         ALERT("File Chosen is; "+aSELECTED[TEMP])
         aSELECTED := {}
      
      ENDIF

   ENDIF

ENDDO
