/*
  Radio Buttons and Check Boxes for Clipper 5.2d

  For a demonstration, run the batch file MAKEDEMO.BAT to make an EXE or use
  the command:

            rmake radiobtn /dTEST

  To this radio button and check box GET Reader in an application, recompile
  RADIOBTN.PRG without the /dTEST preprocessor directive.

  Check out RADIOBTN.CH for the syntax.  Note that you must put the options
  in same order as defined in RADIOBTN.CH or else it won't work.

  Ŀ
   The functions contained herein are the original work of Dan Comeau 
   and others and are placed in the public domain.                    
  

  Modifications:

  Version     Changes
       
    2.0b       Handle array elements for GET variables.
 (Dec '94)
    2.0a       Comments and TXT file changed. No code changes.
 (Nov '94)
    2.0        Added checkbox option. If array contains only 1 element
 (Nov '94)      then a checkbox appears. Thanks to the person who sent me
                the heart of this new code -- I've misplaced his/her name.
                The new alternate syntax is VIA CHECKBOX to show that it
                is a checkbox.  Note, however, that this is only cosmetic
                since the radiobutton reader decides whether to display
                radiobuttons or a checkbox depending on the length of the
                array. Checkboxes return 1 when on and 0 when off.
               Value no longer set to zero if the WHEN condition is false.
                Thanks to another forgotten person who showed me the light
                on this and gave me some code modifications. If this breaks
                your code, have a look below and uncomment the two affected
                sections.  Search for the work "uncomment."
               The same person also included some code that moves the cursor
                to the last button of a GET if you moved to it with the UP
                key.
               Added new option to set marker for Yes and No conditions.
                For radiobuttons, the default Yes marker is a dot.  For
                checkboxes, the default Yes marker is a check mark.  The
                default No marker is a blank. You can change these defaults
                by changing the DEFINE statements below.

    1.2        Horizontal spacing option, HSPACING, added.  Thanks to
 (Apr '93)      Rich Miller [70632,734] for this modification.
               New syntax: VIA RADIOBUTTONS. The previous syntax of
                WITH RADIOBUTTONS is still supported. You don't need to
                change your code because of this change.
               Made several minor internal changes to optimize display.

    1.1        VALID clause now supported.

    1.0b       New parameter for drawing shadow around box.  See
                RADIOBTN.CH for syntax.  Thanks (again) to John Forsberg
                [75170,641] for this modification.  Check out the
                DrawBoxShadow() function he wrote to draw a shadow around a
                box using pure Clipper code.

    1.0a       Disabled GET variables now return 0; ie., when the WHEN
                expression is false.  Thanks to John Forsberg [75170,641]
                for this modification.  Note that if the user ends the READ
                with Esc, PgUp, or PgDn, the disabled GET value may not
                be 0.

    1.0        Original release.


  I'd like to hear about any enhancements you make to these functions.  In
  fact, with your permission, I'd like to add your enhancements and make a
  new version.  Send revised source code or questions to my CompuServe
  account [70451,2312], Internet 70451.2312@compuserve.com, or my mailing
  address, as of December, 1994:

            Dan Comeau
            702-1025 Grenon Ave.
            Ottawa, Ontario
            K2B 8S5, CANADA

  By the way, Clipper 5.3 will have radiobuttons and checkboxes.
  Therefore, I do not plan to enhance this code once 5.3 is available.

  If you end up using all or parts of this code in a commercial or
  shareware library, I'd appreciate it if you let me know.

*/
// Function/Procedure Prototype Table  -  Last Update: 12-10-94 @ 02:49:29pm
// 
// Return Value         Function/Arguments
//   
// nil                  static function DrawBoxShadow( nTop, nLeft, nBottom, nRight )
// nil                  static function DrawRadioButtons( nRow, nCol, aChoices, nChoice, nCursor, ;
// valid                static function GetPostValidate( get )
// when                 static function GetPreValidate( get )
// nil                  function RBCB_Kill()
// Void                 function RBCB_New( oGet, bWhen, ;
// nil                  function RBCB_Reader( oGet, lNoBox, lHoriz, cTitle, cYesMarker, cNoMarker )
// Void                 function test()


#include "radiobtn.ch"

#include "box.ch"          // as shipped with Clipper 5.2d
#include "getexit.ch"      // ''   ''     ''     ''
#include "inkey.ch"        // ''   ''     ''     ''
#include "common.ch"       // ''   ''     ''     ''

#define HBRACKETSPACING  4    // space (ie.,"( ) ") between 1st bracket & text of horizontal choices
#ifndef K_SPACE               // this was finally defined in Clipper 5.2
  #define K_SPACE       32
#endif

static aAllButtons := {}   // for all the get radio buttons and check boxes


/*
 
  Test function for the radio buttons.

  To make the test version, use:  rmake radiobtn /dTEST
 
*/
#ifdef TEST

  #define SCREEN_COLOR    "GR+/B"    // regular screen color
  #define SHADOWBOX_COLOR "GR+/R"    // for box with a shadow around it
  #define GREYED_COLOR    "W/R"      // color of disabled GET

  // To demo use of arrays for GET variables:
  #define CITIES      1              // 1st element of aMyGets[]
  #define PLACES      2              // 2nd element of aMyGets[]

  function test()

    local aGet1     := { "1 Choice1", "2 Disable Buttons #3", "3 Choice1" }
    local cGet1     := "Get 1"
    local cGet2     := "Get 2"
    local GetList   := {}
    local nChoice1  := 2          // initial choices for radio buttons
    local nChoice2  := 1
    local nChoice3  := 1
    local nChoice3b := 1          // Checkbox choice
    local nChoice3c := 1          // Checkbox choice
    local nChoice4  := 2
    local nChoice5  := 2
    // To demo use of arrays for GET variables:
    local aMyGets   := { 3, 2 }
    local aCities   := {"Sao Paulo", "Curitiba", "Rio de Janeiro"}
    local aPlaces   := {"Here", "There", "Anywhere"}

    set scoreboard off

    // demonstrate set key ability within a radio button GET
    setkey( K_F1, { |s,r,c| s:=savescreen(), ;
			    r:=row(),;
			    c:=col(),;
			    scroll(), ;
			    setpos(5,5), ;
			    dispout("You pressed F1.  Press any key to continue . . ."), ;
			    inkey(0), ;
			    restscreen(,,,,s),;
			    setpos(r,c) } )

    setcolor( SCREEN_COLOR )
    clear screen

    @ 2, 5 say "Use the Tab, Shift-Tab, arrow, space bar, and Enter keys to move around."
    @ 3, 5 say "Press F1 to show use of setkey within GETs."

    @ 5, 5 say "Normal Get #1:" ;
	   get cGet1

    @ 6, 5 say "Buttons #1" ;
	   get nChoice1 ;
	   color SCREEN_COLOR ;
	   via radiobuttons aGet1

    @ 6,40 get nChoice2 ;
	   color SCREEN_COLOR ;
	   via radiobuttons { "1 Choice2","2 Choice2","3 Choice2","4 Choice2" } ;
	   nobox

    @ 7,60 say "Buttons #3" ;
	   get nChoice3 ;
	   color SHADOWBOX_COLOR+","+GREYED_COLOR ;
	   when nChoice1 != 2 ;
	   via radiobuttons { "1 Choice3","2 Choice3","3 Choice3","4 Choice3","5 Choice3" } ;
	   shadow

    @11, 5 get nChoice3b ;                       // Uses MARKER
	   color SCREEN_COLOR ;
	   via checkbox { "Checkbox 1" } ;
	   nobox ;
	   yesmarker "X" ;
	   nomarker  "-"

    @12, 5 get nChoice3c ;
	   color SCREEN_COLOR ;
	   via radiobuttons { "Checkbox 2" } ;
	   nobox

    @12,30 say "Normal Get #2:" ;
	   get cGet2

    @14, 5 say "Buttons #4:"
    @14,col()+1 get nChoice4 ;
		color SCREEN_COLOR ;
		via radiobuttons { "1 Choice4","2 Choice4","3 Choice4" } ;
		nobox ;
		horizontal

    @19,2 say "This is a radiobutton with a shadowed box drawn around it."
    @16,5 say"Choice 5 With Horizontal Spacing = 5 and a Long Title" ;
	  get nChoice5 ;
	  color SHADOWBOX_COLOR ;
	  via radiobuttons { "1 Choice5","2 Choice5" } ;
	  double ;
	  horizontal ;
	  hspacing 5 ;
	  shadow

    // To demo use of arrays for GET variables (aMyGets):
    @20,5 say 'Cities' ;
	  get aMyGets[ CITIES ] ;
	  color SCREEN_COLOR ;
	  via radiobuttons aCities
    @20,30 say 'Places' ;
	   get aMyGets[ PLACES ] ;
	   color SCREEN_COLOR ;
	   via radiobuttons aPlaces

    read
    RBCB_Kill()  // reduce memory requirement by setting array to NIL

    // display values
    devpos( 24, 0 )
    ? "Normal Get Values..:", cGet1, cGet2
    ? "Radio Button Values:", nChoice1, nChoice2, nChoice3, nChoice4, nChoice5
    ? "Check Box Value....:", nChoice3b, nChoice3c
    ? "City, Place Values.:", aCities[ aMyGets[ CITIES ] ] + ", " + ;
			      aPlaces[ aMyGets[ PLACES ] ]
  return nil

#endif


/*
 
  Initialization for Radio Buttons and Check Boxes.  Display title and
  choices.  Optionally draw box around choices.  Horizontal choices must
  fit on one line.
 
*/
function RBCB_New( oGet, bWhen,                      ;
		   nRow, nCol, cTitle, nChoice,      ;
		   aChoices, lNoBox, lDblBox,        ;
		   lHoriz, lShadow, nHSpacing, cYesMarker, cNoMarker )

  local cColorSpec    // color string
  local n             // temp variable
  local nWidth        // width of button box

  dispbegin()         // buffer the display output

    if cTitle == NIL
      cTitle := ""      // init to enable testing in len()
    endif

    if valtype( nHSpacing ) != "N"  // set default horizontal spacing
       nHSpacing := 2
    endif

    if (nChoice < 1) .or. (nChoice > len( aChoices ))  // make sure nChoice is in valid range
      if len( aChoices ) > 1
	nChoice := 1            //--- Only if a radio button not a check box
      endif
    endif

    // Add choices array to the aAllButtons array.
    aadd( aAllButtons, { oGet:Name, aChoices, nHSpacing, oGet:subscript } )

    // Ŀ
    //  Draw box around buttons 
    // 
    if ! lNoBox   // draw box around buttons
      if lHoriz   // draw horizontal box

	// find total width of aChoices choices
	nWidth := 0
	aeval( aChoices, { |c, n| nWidth += if( n == 1, 1, nHSpacing ) ;
					  + HBRACKETSPACING ;
					  + len( c )  } )
	nWidth := max( nWidth + 1, len( cTitle ) + 2 ) //  make sure title fits

	// draw single or double line box
	dispbox( nRow, nCol, nRow+2, nCol+nWidth+1, ;
		 if( lDblBox, B_DOUBLE, B_SINGLE )+space(1), oGet:ColorSpec )

	if lShadow // draw shadow around box
	  DrawBoxShadow( nRow, nCol, nRow+2, nCol+nWidth+1 )
	endif

      else        // draw vertical box

	// find max width of aChoices choices
	nWidth := len( aChoices[1] )
	aeval( aChoices, { |c| nWidth := max(nWidth, len(c)) } )
	nWidth := max( nWidth+5, len(cTitle)+1 )    // add 5 spaces for " ( ) "

	// draw single or double line box
	dispbox( nRow, nCol, nRow+len(aChoices)+1, nCol+nWidth+2, ;
		 if( lDblBox, B_DOUBLE, B_SINGLE )+space(1), oGet:ColorSpec )

	if lShadow // draw shadow around box
	  DrawBoxShadow( nRow, nCol, nRow+len(aChoices)+1, nCol+nWidth+2 )
	endif

      endif
    endif

    // Ŀ
    //  Put title at top left corner 
    // 
    if !empty( cTitle )
      if lNoBox   // no box around buttons
	@ nRow, nCol say cTitle && color oGet:ColorSpec
      else        // box drawn around buttons
	@ nRow, nCol+1 say " "+cTitle+" " && color oGet:ColorSpec
      endif
    endif

    // Ŀ
    //  Display radio button choices 
    // 
    // check when condition for this get; use this to set colors
    if ( bWhen == NIL ) .or. eval( bWhen, oGet )
      // normal color
      cColorSpec := setcolor() && oGet:ColorSpec
    else
      // failed pre-validation (ie., WHEN)
      // grey out the radio button box choices
      cColorSpec := if( (n:=at(",",oGet:ColorSpec)) > 0, ;       // find comma delimiter
		    substr(setcolor()/*oGet:ColorSpec*/,n+1), ; // remainder of color string
		    setcolor()/*oGet:ColorSpec*/)              // same color as regular

      // Uncomment the next lines to change data value if WHEN condition fails
      //-x- nChoice := 0   // don't show any choices for greyed out radio buttons
      //-x- // return zero for disabled button
      //-x- oGet:VarPut( nChoice )   // update get var

    endif

    // draw the buttons
    /*
      Note: 1 is subtracted from nCol when horizontal and no box or
            title. This was needed to line up the buttons with the oGet
            supplied coordinates when DrawRadioButtons() is called from
            RBCB_Reader().
    */
    DrawRadioButtons( nRow, ;
		      nCol - if( lHoriz .and. lNoBox .and. empty( cTitle ), ;
				 1, 0 ;
			       ), ;
		      aChoices, nChoice, nChoice, cColorSpec, ;
		      lNoBox, lHoriz, empty( cTitle ), nHSpacing, cYesMarker, cNoMarker ;
		    )
  dispend()

return nil


/*
* 
*  Draw Radio Buttons choices
* 
*/

// code blocks to display the buttons
#xtranslate bHORIZONTALCONTROL ;
	 => { | c, n | dispout( replicate( " ", if( n == 1, if( lNoBox, 0, 1 ), nHSpacing ) ) + ;  // space before bracket
				cLeftBracket + ;                                                  // left bracket
				( if( n == nCursor, nCursorPos := col() + ;                        // set position of selected button
								  if( n == 1, ;
								      0, ;
								      nHSpacing-if( lNoBox, 0, 1 ) ), ), ;
				  if( n == nChoice, cYesMarker, cNoMarker ) ;             // bw the brackets
				) + ;
				cRightBracket + " " + c, ;                             // right bracket + text
				cColorSpec ;
			      ) ;
	    }

#xtranslate bVERTICALCONTROL ;
	 => { | c, n | setpos( row() + 1, if( lNoBox, nCol, nCol + 2 ) ), ;
		       dispout( cLeftBracket + ( if( n == nCursor, nCursorPos := row(), ), ;
					    if( n == nChoice, cYesMarker, cNoMarker );
					  ) + ;
				cRightBracket + " " + c, ;
				cColorSpec ;
			      ) ;
	    }


static function DrawRadioButtons( nRow, nCol, aChoices, nChoice, nCursor, ;
				  cColorSpec, lNoBox, lHoriz, lNoTitle, ;
				  nHSpacing, cYesMarker, cNoMarker)

  local cLeftBracket
  local cRightBracket
  local nCursorPos := 0   // cursor position (could be either row or col)

  if len( aChoices ) == 1                        // checkbox
    DEFAULT cLeftBracket  TO CB_LEFT
    DEFAULT cRightBracket TO CB_RIGHT
    DEFAULT cYesMarker    TO CB_YES
    DEFAULT cNoMarker     TO CB_NO
  else                                           // radiobutton
    DEFAULT cLeftBracket  TO RB_LEFT
    DEFAULT cRightBracket TO RB_RIGHT
    DEFAULT cYesMarker    TO RB_YES
    DEFAULT cNoMarker     TO RB_NO
  endif

  dispbegin()

    set cursor off

    if lHoriz   // horizontal radio buttons
      if lNoBox
	setpos( nRow + if(lNoTitle,0,1), nCol )
	aeval( aChoices, bHORIZONTALCONTROL )            // show buttons
	setpos( nRow + if(lNoTitle,0,1), nCursorPos+1 )  // display cursor at this coordinate

      else   // with a box around buttons
	setpos( nRow+1, nCol+1 )
	aeval( aChoices, bHORIZONTALCONTROL )          // show buttons
	setpos( nRow+1, nCursorPos+2 )                 // display cursor at this coordinate
      endif

    else        // vertical radio buttons
      if lNoBox
	setpos( nRow-if(lNoTitle,1,0), nCol )
	aeval( aChoices, bVERTICALCONTROL )            // show buttons
	setpos( nCursorPos, nCol+1 )                   // display cursor at this coordinate
      else
	setpos( nRow, nCol )
	aeval( aChoices, bVERTICALCONTROL )            // show buttons
	setpos( nCursorPos, nCol+3 )                   // display cursor at this coordinate
      endif
    endif

    set cursor on

  dispend()

return nil


/*
 
  Radio and Check Buttons GET Reader.
  Supports WHEN and VALID.
 
*/
function RBCB_Reader( oGet, lNoBox, lHoriz, cTitle, cYesMarker, cNoMarker )

  local aChoices      // radio button choices
  local cGreyColor    // greyed out color if WHEN condition failed
  local cSavedScreen  // to save portion of screen normally showing GET value
  local n             // temp variable
  local nChoice       // button choices (1st one is name of get variable)
  local nCursor       // button cursor (may be different than nChoice)
  local nFoundChoice  // array position of this gadget in all gadgets
  local nHSpacing     // how many spaces to leave between horizontal choices
  local nKey          // key pressed
  local nMaxChoices   // max number of choices
  local nOldChoice    // to save current choice
  local nOldCursor    // to save current cursor position
  local bHotKey       // code block for a set key that is pressed

  // initialize variables
  // 1st element of aAllButtons == GET var name
  // 4th   ''    ''     ''      == array subscript if GET var was an array
  nFoundChoice := ascan( aAllButtons, { |a| a[1] == oGet:Name .and.;  // compare against name
					    if( a[4] == NIL, ;        // compare against possible array subscript
					       .t., ;                 // no array used if NIL
					       a[4] == oGet:subscript ) } )
  aChoices     := aAllButtons[ nFoundChoice, 2 ]
  nHSpacing    := aAllButtons[ nFoundChoice, 3 ]

  // read the GET if the WHEN condition is satisfied
  if ( GetPreValidate( oGet ) )  // note: see our own version of this udf below

    // initialize variables
    n           := 0
    nKey        := 0
    nMaxChoices := len( aChoices )
    if nMaxChoices > 1                           // Only if a radio button
      // make a copy of the get var value
      nChoice := if( oGet:VarGet() != 0, oGet:VarGet(), 1 )
      if LastKey() == K_UP
	nCursor := nMaxChoices                   // On an UP that changes GET objects
      else
	nCursor := nChoice                       // cursor position
      endif                                      // move to last button of the new get
    else
      nChoice := oGet:VarGet()                   // Retain prior value
      nCursor := 1                               // cursor position
    endif

    // activate the GET for reading
    dispbegin()
    // save the 1 character spot where the GET value is about to be displayed
    cSavedScreen := savescreen( oGet:row, oGet:col, oGet:row, oGet:col )
    oGet:SetFocus()
    // restore the 1 character spot where the GET displayed its value
    restscreen( oGet:row, oGet:col, oGet:row, oGet:col, cSavedScreen )
    // redraw buttons: sets cursor under choice
    DrawRadioButtons( oGet:Row, oGet:Col, aChoices, nChoice, nCursor, ;
		      setcolor()/*oGet:ColorSpec*/, lNoBox, lHoriz, empty(cTitle), ;
		      nHSpacing, cYesMarker, cNoMarker )
    dispend()

    do while ( oGet:ExitState == GE_NOEXIT )

      nOldChoice := nChoice      // save "old" choice before movement
      nOldCursor := nCursor      // save "old" cursor choice before movement
      nKey       := inkey(0)     // wait for a key to be pressed

      // see if a hot key was pressed

      if ( bHotKey := setkey( nKey ) ) != nil
	eval( bHotKey, procname(1), procline(1), readvar() )
	loop  // get next key
      endif

      // determine what key was pressed

      do case
      case nKey == K_ESC        // cancel selection
	oGet:ExitState := GE_ESCAPE

      case nKey == K_SPACE      // move to cursor or the next radio button choice
	if ! nCursor == nChoice
	  // move choice to cursor position
	  nChoice := nCursor
	else
	  if nMaxChoices == 1                    // It's a tick box
	    nChoice := 0                         // Toggle the only choice
	  else                                   // Only if a radio button
	    // move choice to next button
	    nCursor := nChoice := if( nChoice == nMaxChoices, 1, nChoice+1 )
	  endif
	endif

      case nKey == K_ENTER      // get to the next get
	oGet:ExitState := GE_ENTER

      case nKey == K_UP         // up arrow
	if lHoriz               // horizontal box: exit to previous get
	  oGet:exitstate := GE_UP
	else                    // vertical box: move cursor up
	  if nCursor == 1
	    oGET:exitstate := GE_UP  // move to previous get
	  else
	    nCursor--
	  endif
	endif

      case nKey == K_DOWN       // down arrow
	if lHoriz               // horizontal box: exit to next get
	  oGET:exitstate := GE_DOWN
	else                    // vertical box: move cursor down
	  if nCursor == nMaxChoices
	    oGET:exitstate := GE_DOWN  // move to next get
	  else
	    nCursor++
	  endif
	endif

      case nKey == K_LEFT       // left arrow
	if lHoriz               // horizontal box: move cursor to previous choice
	  if nCursor == 1
	    nCursor := nMaxChoices
	    // to move to the previous get,
	    // comment the line above and uncomment the next line
	    // oGET:exitstate := GE_UP  // move to previous get
	  else
	    nCursor--
	  endif
	else                    // vertical box
	  // uncomment this line if you want the cursor to move to previous get
	  // oGet:exitstate := GE_UP
	endif

      case nKey == K_RIGHT      // right arrow
	if lHoriz               // horizontal box: move cursor to next choice
	  if nCursor == nMaxChoices
	    nCursor := 1
	    // to move to the next get,
	    // comment the line above and uncomment the next line
	    // oGET:exitstate := GE_DOWN  // move to next get
	  else
	    nCursor++
	  endif
	else                    // vertical box
	  // uncomment this line if you want the cursor to move to next get
	  // oGET:exitstate := GE_DOWN
	endif

      case nKey == K_TAB        // tab: exit to next get
	oGET:exitstate := GE_DOWN

      case nKey == K_SH_TAB     // shift-tab: exit to previous get
	oGet:exitstate := GE_UP

      case nKey == K_PGUP       // page up
	oGET:ExitState := GE_WRITE

      case nKey == K_PGDN       // page down
	oGet:ExitState := GE_WRITE

      otherwise
	if Len(aChoices) > 1
	  // handle if user pressed a key to select the first letter
	  // 1st, continue search from current location
	  n := ascan( aChoices, ;
		      { |c| upper( left(c,1) ) == upper ( chr(nKey) ) },;
		      nChoice+1, nMaxChoices )
	  if n == 0
	    // 2nd, if another not found, restart search from the top
	    n := ascan( aChoices, ;
			{ |c| upper( left(c,1) ) == upper ( chr(nKey) ) },;
			1, nChoice - 1 )
	  endif
	  nCursor := nChoice := if( n > 0, n, nChoice )  // move cursor if a match

	elseif upper( left(aChoices[1],1) ) == upper ( chr(nKey) )
	  nChoice := if( nChoice == 0, 1, 0)  // Toggle the tick box for check box

	endif

      endcase

      // check if moved to new radio button selection
      if ! nOldChoice == nChoice .or. ! nOldCursor == nCursor
	DrawRadioButtons( oGet:Row, oGet:Col, aChoices, nChoice, nCursor, ;
			  setcolor()/*oGet:ColorSpec*/, lNoBox, lHoriz, empty(cTitle), ;
			  nHSpacing, cYesMarker, cNoMarker)
      endif

      // disallow exit if the VALID condition is not satisfied
      if ! GetPostValidate( oGet )
	oGet:ExitState := GE_NOEXIT
      end

    enddo ( oGet:ExitState == GE_NOEXIT )

    oGet:VarPut( nChoice )   // update get var

    // de-activate the GET
    dispbegin()
    // save the 1 character spot where the GET value is about to be displayed
    cSavedScreen := savescreen( oGet:row, oGet:col, oGet:row, oGet:col )
    oGet:KillFocus()
    // restore the 1 character spot where the GET displayed its value
    restscreen( oGet:row, oGet:col, oGet:row, oGet:col, cSavedScreen )
    dispend()

  else
    // failed pre-validation (ie., WHEN)
    // grey out the radio button box choices
    cGreyColor := if( (n:=at(",",oGet:ColorSpec)) > 0, ;  // find comma dilimiter
		  substr(oGet:ColorSpec,n+1), ;           // remainder of color string
		  oGet:ColorSpec )                        // same color as regular

    // Uncomment the next lines to change data value if WHEN condition fails
    //-x- // return zero for disabled button
    //-x- oGet:VarPut( 0 )   // update get var
    oGet:VarPut( nChoice )   // update get var

    DrawRadioButtons( oGet:Row, oGet:Col, aChoices, nChoice, nCursor, ;
		      cGreyColor, lNoBox, lHoriz, empty(cTitle), ;
		      nHSpacing, cYesMarker, cNoMarker)

  endif

return nil


//
// A copy from Nantucket's version with some modifications.
//
/*
 GetPreValidate()
 Test entry condition (WHEN clause) for a GET.
*/
static function GetPreValidate( get )

  local when := .t.

	if ( get:preBlock <> NIL )
    when := Eval(get:preBlock, get)
  end

  if ( !when )
    get:exitState := GE_WHEN    // indicates failure

	else
		get:exitState := GE_NOEXIT              // prepares for editing

	end

return when


//
// A copy from Nantucket's version with some modifications.
//
/*
 GetPostValidate()
 Test exit condition (VALID clause) for a GET.
*/
static function GetPostValidate( get )

  local valid := .t.

	if ( get:exitState == GE_ESCAPE )
		return (.t.)                                    // NOTE
	end

	// check VALID condition if specified
  if ( get:postBlock <> NIL )
    valid := Eval(get:postBlock, get)
  end

return (valid)


/*
 
  Draw Shadow to the right and under Box
 
*/
static function DrawBoxShadow( nTop, nLeft, nBottom, nRight )

  // save old color
  local cOldColor := set( _SET_COLOR )

  // build bottom shadow buffer array (account for screen height)
  local BottomBuf := if( nBottom < maxrow(), ;
			 { nBottom + 1, ;
			   nLeft + 1, ;
			   nBottom + 1, ;
			   if( nRight < maxcol(), ;
			       nRight + 1, ;
			       nRight ;
			     ), ;
			   savescreen( nBottom + 1, ;
				       nLeft + 1, ;
				       nBottom+1, ;
				       if( nRight < maxcol(), ;
					   nRight + 1, ;
					   nRight ;
					 ) ;
				     ) ;
			 }, ;
			 nil ;
		       )

  // build right shadow buffer array (account for screen width)
  local RightBuf := if( nRight < maxcol(), ;
			{ nTop + 1, ;
			  nRight + 1, ;
			  if( nBottom < maxrow(), ;
			      nBottom + 1, ;
			      nBottom ;
			    ), ;
			  nRight + 1, ;
			  savescreen( nTop + 1, ;
				      nRight + 1, ;
				      if( nBottom < maxrow(), ;
					  nBottom + 1, nBottom ;
					), ;
				      nRight + 1 ;
				    ) ;
			}, ;
			nil ;
		      )

  // code block to evaluate shadow buffer arrays
  local ShdwStrip := { | buf | ( restscreen( buf[1], buf[2], buf[3], buf[4], ;
				   transform( buf[5], ;
					      replicate( "X" + chr(8), ;
							 len( buf[5] ) * 0.5 ;
						       ) ;
					    ) ;
					   ) ;
			       ) ;
		     }

  // draw bottom shadow
  if ! BottomBuf == NIL
    eval( ShdwStrip, BottomBuf )
  endif

  // draw right shadow
  if ! RightBuf == NIL
    eval( ShdwStrip, RightBuf )
  endif

  // restore original color
  set( _SET_COLOR, cOldColor )

return nil


/*
 
  Clear the radio button array.  Do this after the READ to free up memory.
 
*/
function RBCB_Kill()
  aAllButtons := {}
return nil
