/* TAPE.REXX:  Sends useful control commands to tape drive via BTN handler.
     R. Rethemeyer  3/94
*/
address command
default_drive = "TAPE"

arg cmd drive .
if cmd=""   then signal helpme
if drive="" then drive=default_drive

select
   when abbrev("REWIND",cmd,3)    then edata="01"
   when abbrev("RETENSION",cmd,3) then edata="1B 00 00 00 03 00"
   when abbrev("EJECT",cmd,2)     then edata="1B 00 00 00 00 00"
   when abbrev("PREVENT",cmd,4)   then edata="1E 00 00 00 01 00"
   when abbrev("ALLOW",cmd,3)     then edata="1E 00 00 00 00 00"
   when abbrev("END",cmd,3)       then edata="11 03"
   when abbrev("WFM",cmd,3)       then edata="10 00 00 00 01"
   when abbrev("FORWARD",cmd,1)   then edata="11 01 00 00 01"
   when abbrev("BACKWARD",cmd,1)  then do
         'echo >'drive':RAWCMD "11 01 FF FF FE"'  /* 2 steps back */
         edata="11 01 00 00 01"                   /* 1 step forward */
         end
   when abbrev("ERASE",cmd,3)     then do
         say "Are you SURE you want to erase" drive "? (y/n)"
         pull huh .
         if substr(huh,1,1)~="Y" then signal byebye
         'echo >'drive':RAWCMD "01"'  /* rewind first */
         edata="19 01"
         end
   otherwise signal helpme
end

'echo >'drive':RAWCMD "'edata'"'

byebye:
exit

helpme:
   say "Syntax:   [RX] TAPE <function> [device]"
   say " function is one of:"
   say "   REWind, RETension, EJect, PREVent, ALLow (prevent/allow removal),"
   say "   ERAse, WFM, END (skip to end of data),"
   say "   FORward (skip forward 1 file), BACK (skip back 1 file)."
   say " If omitted, device defaults to" default_drive
   exit
