/*
 * SpeechQ.CMD
 *
 * This program runs in the background and waits for data to be placed in the
 * queue 'REXXSPEECH'.  When data is encountered, RSynth is used to
 * speak the text.
 *
 * The following text strings have special meanings:
 * COMMAND_END - program terminates
 * COMMAND_MUTE - discards all pending strings all future strings
 * COMMAND_UNMUTE - cancels effects of COMMAND_MUTE
 * COMMAND_DISCARD - removes all pending strings from queue
 * COMMAND_NUMQUEUED - speaks the number of messages queued
 *
 */

'echo off'
'cls'
queuename='REXXSPEECH'
synthfilename='SAY.EXE'
synth='SAY '

/* Change to executed directory */
parse source . . sourcename
speechdir = filespec('D', sourcename)||filespec('P', sourcename)
speechdir = delstr(speechdir, length(speechdir))
call directory speechdir

call rxfuncadd 'SysFileTree','RexxUtil','SysFileTree'
call SysFileTree synthfilename, file, 'FO'
if file.0 = 0 then
	do
	say synthfilename' not found!  Speech queue terminated.'
 	say '(This program should be in the same directory as 'synthfilename'.)'
	say
	say 'Press Enter to quit.'
	pull
	exit
	end

rc = rxqueue('Create', queuename)
if (rc \= queuename) then do
	rc = rxqueue('Delete', queuename)
	rc = rxqueue('Create', queuename)
	end

if (rc = queuename) then do
	rc = rxqueue('Set', queuename)
    say 'Speech enabled.'
    synth ' Speech enabled.'

	muted = 0
	paused = 0
    'if exist SPKSTART.CMD start /b /min /c SPKSTART.CMD'
    call checkqueue
	do while curspeech\='COMMAND_END'
		select
        when (curspeech='COMMAND_MUTE') then do
            if muted=1 then do
                say 'Speech is already muted.'
                synth ' Speech is already muted.'
                end
            else do
				muted=1
                say 'Speech muted.'
                synth ' Speech muted.'
				end
			end
        when (curspeech='COMMAND_UNMUTE') then do
            if muted=0 then do
                say 'Speech is not muted.'
                synth ' Speech is not muted.'
                end
            else do
			 	muted=0
                say 'Speech resumed.'
                synth ' Speech resumed.'
                end
			end
		when (curspeech='COMMAND_DISCARD') then
			do while queued()>0
				pull
				end
        when (curspeech='COMMAND_NUMQUEUED') then do
            if queued()=0 then do
                say 'No messages are queued.'
                synth ' No messages are queued.'
                end
            else do
                say 'There are 'queued()' nessage queued.'
                synth ' There are 'queued()' messages queued.'
                end
			end
		otherwise
            if muted = 0 then do
               say curspeech
               synth curspeech
            end
            else
				say 'Muted: 'curspeech
		end /* select */
		call checkqueue
    end /* do */

	rc = rxqueue('Delete', queuename)
    say 'Speech terminated.'
    synth ' Speech terminated.'
    exit
    end
else
    say 'Unable to delete pre-existing speech queue.  Aborting.'
    synth ' Unable to delete pre-existing speech queue.  Aborting.'
exit

checkqueue: procedure expose curspeech paused
	say 'Queued: 'queued()
	/* Use LINEIN() instead of PULL so we don't have to busy-wait on QUEUED() */
        curspeech = linein('QUEUE:')
	return
