/* Speech Timer - part of the BackTalk project - no it's not realtime     */

call rxfuncadd 'SysSleep','RexxUtil','SysSleep'

queuename='REXXSPEECH'
parse arg cmdline
rc = rxqueue('Set', queuename)

/* Default values */

timermins = 60      /* countdown time, minutes  */
lap = 300           /* lap between spoken time left, seconds */
message = " "       /* message pronounced after the time left */

urgminsleft = 0     /* Falls in urgent mode after urgminleft time, minutes */
urgmsg = " "        /* Urgent mode message  */
urglap = 120        /* Urgent mode lap, seconds  */

alertmsg = " "      /* Alert message when timer has stopped */

parmpos = pos('-?',cmdline)        /* Help screen */
if parmpos > 0 then do
   say 'Speech Timer - Part of the BackTalk project'
   say
   say '-t1  countdown time (minutes)'
   say '-l1  laps time (seconds)'
   say '-m1  message'
   say
   say '-t2  time remaining to switch in urgent mode (minutes)'
   say '-l2  laps time in urgent mode (seconds)'
   say '-m2  message in urgent mode'
   say
   say '-m3  alert message when timer has stopped'
   say
   say '-?   Help screen'
   say
   say 'ie.: c:\> spchtmr -t1 45 -t2 15 -m1 for your dentist rendezvous -m2 for'
   say '     your VERY VERY important dentist rendezvous -l1 300 -l2 120 -m3 Your'
   say '     dentist rendezvous!!'
   exit
end

parmpos = pos('-t1',cmdline)    /* Finds position of parameters and asks  */
if parmpos > 0 then do          /* getparm procedure to find the content. */
   parmpos = parmpos + 3
   call getparm
   if parm <> '' then timermins = parm
end

parmpos = pos('-l1',cmdline)
if parmpos > 0 then do
  parmpos = parmpos + 3
  call getparm
  if parm <> '' then lap = parm
end

parmpos = pos('-m1',cmdline)
if parmpos > 0 then do
  parmpos = parmpos + 3
  call getparm
  if parm <> '' then message = parm
end

parmpos = pos('-t2',cmdline)
if parmpos > 0 then do
  parmpos = parmpos + 3
  call getparm
  if parm <> '' then urgminsleft = parm
end

parmpos = pos('-l2',cmdline)
if parmpos > 0 then do
  parmpos = parmpos + 3
  call getparm
  if parm <> '' then urglap = parm
end

parmpos = pos('-m2',cmdline)
if parmpos > 0 then do
  parmpos = parmpos + 3
  call getparm
  if parm <> '' then urgmsg = parm
end

parmpos = pos('-m3',cmdline)
if parmpos > 0 then do
  parmpos = parmpos + 3
  call getparm
  if parm <> '' then alertmsg = parm
end

/* Give some visual information */

say 'countdown time:' timermins 'minutes.'
say 'laps time:' lap 'seconds.'
say 'message: 'message
say
say 'fall in urgent mode at 'urgminsleft 'minutes left.'
say 'laps time in urgent mode:' urglap 'seconds.'
say 'urgent message:' urgmsg
say
say 'alert message:' alertmsg

timersecs = 60*timermins      /* Converts minutes into seconds.  Specify  */
urgsecsleft = 60*urgminsleft  /* seconds here instead of minutes there if */
                              /* you find that better.                    */

queue "Starting a" timermins "minute countdown."
rc = time('E')
                                               /* This part makes the countdown until it's in urgent mode. */
do while countsecs > urgsecsleft               /* A chrono is started, and then the timer value is substracted */
   call syssleep trunc(lap)                    /* from it and then valuated in minutes and secs, then spoken. */
   parse value time('E') with countsecs '.'    /* If not enough time is left to complete another loop, because */
   countsecs = timersecs - countsecs           /* of the syssleep, another loop is called, and checks each second */
   secsleft = trunc(countsecs)                 /* which should be enough, and REXX ain't that precise anyways  */
   minsleft = 0
   if secsleft >= 60 then
      do until secsleft < 60
         minsleft = minsleft + 1
         secsleft = secsleft - 60
      end
   queue "There is" minsleft "minutes and" secsleft "seconds left" message
   if countsecs <= urglap & countsecs <= lap & countsecs > urgsecsleft then do
      do while countsecs > 0
         call syssleep 1
         parse value time('E') with countsecs '.'
         countsecs = timersecs - countsecs
      end
      queue alertmsg
   end
end

do while countsecs > 0         /* Same as above, but uses urgent mode values */
   call syssleep trunc(urglap)
   parse value time('E') with countsecs '.'
   countsecs = timersecs - countsecs
   secsleft = trunc(countsecs)
   minsleft = 0
   if secsleft >= 60 then
      do until secsleft < 60
         minsleft = minsleft + 1
         secsleft = secsleft - 60
      end
   queue "There is only" minsleft "minutes and" secsleft "seconds left" urgmsg
   if countsecs <= urglap then do
      do while countsecs > 0
         call syssleep 1
         parse value time('E') with countsecs '.'
         countsecs = timersecs - countsecs
      end
      queue alertmsg
   end
end

exit

/* Procedures */
/* ---------- */

/* Grabs the parameters in a certain variable cmdline at position parmpos */
/* and outputs the findings to parm                                       */

getparm: procedure expose parmpos parm cmdline
   parm = ''
   tmp = ''
   do until length(cmdline) - parmpos <= 0
      parmpos = parmpos + 1
      tmp = substr(cmdline,parmpos,1)
      if substr(cmdline,parmpos,2) = ' -' | tmp = '-' then return
      parm = parm||tmp
   end
return
