*  Program.....: BroColNB.PRG
*  Authors.....: Peter Volz
*  Copyright(c): 1989-1994 SmartCode Programming, All rights reserved.
*  Application.: BroPlus Professional Xbase Browse Utility & File Manager
*  Version.....: Clipper 5.01 / 5.2
*  Compile.....: clipper brocolnb /m /n /a /w [/dCLIPPER52]
*  Functions...: Bp_Colors
*
***************************************************************************
* BROCOLNB.PRG - use instead of BROCOLOR.PRG if you notice 'blinking'
*                instead of high-intensity background colors on your monitor.

// Variables:
//    aGlColor  system wide array of { color,monochrome } color string pairs,
//              initialized through:  aGlColor := Bp_Colors()
//    iGlColor == 1  ==> color      is selected
//    iGlColor == 2  ==> monochrome is selected
// The constants to the right of the // comment sign are used in the program
//     code, and #defined in BROCOLOR.CH
// The color strings can be modified in the source code below
// Be sure to save a copy of the original color strings before modifying!

function Bp_Colors  // alternate colors, no high-intensity background color

local aColors := { ;
                   ;
 ;   // COLOR1   Standard Foreground/Background Color
   { "N/W,W+/B,W"          , ""                 }, ;
 ;
 ;   // COLOR2   Yellow Foreground/Standard Background Color (Status indicators)
   { "GR/W"                , ""                 }, ;
 ;
 ;   // COLOR3   Bright White on Black Message Color (Row 3)
   { "W+/N"                , "W+/N"             }, ;
 ;
 ;   // COLOR4   Parameter Entry Window Standard Color
   { "W+/B,W+/G,,,W+/R"    , "N/W,W+/N,,,W+/N"  }, ;
 ;
 ;   // COLOR4A  Help Window Color
   { "W+/RB"               , "N/W"              }, ;
 ;
 ;   // COLOR4B  Help Window Heading Color
   { "GR+/RB"              , "N/W"              }, ;
 ;
 ;   // COLOR5   PullDown Menu: Frame/Window Color
   { "N/BG,W+/GR,,,N+/BG"  , "N/W,W+/N,,,N+/W"  }, ;
 ;
 ;   // COLOR5A  PullDown Menu: Highlighted Row
   { "W+/GR"               , "W+/W"             }, ;
 ;
 ;   // COLOR5B  PullDown Menu: Highlighted Item Speed Letter
   { "GR+/GR"              , "N/W"              }, ;
 ;
 ;   // COLOR5C  PullDown Menu: Selectable Row
   { "N/BG"                , "N/W"               }, ;
 ;
 ;   // COLOR5D  PullDown Menu: Selectable Item Speed Letter
   { "GR+/BG"              , "W+/W"              }, ;
 ;
 ;   // COLOR5E  PullDown Menu: Unselectable Row
   { "N+/BG"               , "N+/W"              }, ;
 ;
 ;   // COLOR5F  PullDown Menu: Unselectable Item Speed Letter
   { "GR/BG"               , "N+/W"              }, ;
 ;
 ;   // COLOR6A  Bottom Keystroke Help Background Color for Multi Select Screen, Bp_MsgLine Color
   { "W+/N"                , "W/N"             }, ;
 ;
 ;   // COLOR6D  Color for Selected Window Border Display
   { "W/GR"                , "N/W"             }, ;
 ;
 ;   // COLOR6E  Color for Unselected Window Border Display
   { "N+/W"                , "N+/N"             }, ;
 ;
 ;   // COLOR7   Color for Top Menu Bar (Function Key Display)
   { "W+/N,W+/R"           , "W+/N,N/W"       }, ;
 ;
 ;   // COLOR7A  Color for Help Index & Directory PickLists
   { "W+/N,N/W"            , "W+/N,N/W"       }, ;
 ;
 ;   // COLOR8   Memo Window Key Help Color
   { "W+/N"                , "N/W"              }, ;
 ;
 ;   // COLOR9   Command Options, simulated GET Color for SAYs
   { "W+/R"                , "N/W"              }, ;
 ;
 ;   // COLOR10  Bottom Keystroke Help Foreground Color for Multi Select Screen
   { "GR+/N"               , "W+/N"            }, ;
 ;
 ;   // COLOR11  Database Picklist Color
   { "W+/GR,W+/N,,,W/GR"   , "N/W,W+/N,,,N+/W"  }, ;
 ;
 ;   // COLOR11F Database Field Selection Picklist Color
   { "W+/RB,W+/N,,,W/RB"   , "N/W,W+/N,,,N+/W"  }, ;
 ;
 ;   // COLOR12  Parameter Entry Window Highlight Color
   { "GR+/B"               , "N+/W"             }, ;
 ;
 ;   // COLOR13  Password Entry Window Highlight Color
   { "N/N"                 , "N/N"              }, ;
 ;
 ;   // COLOR14  Main Database Browse Color
   { "N/W, N/BG, N/W, N/W, B/BG, B/W, W+/R, N/G, W+/B, W+/B",         ;
     "W+/N, N/W, W+/N, W+/N, N/W, N/W, W+/N, N/W, W+/N, W+/N" }, ;
 ;
 ;   // COLOR15  Modify Structure Browse Color
   { "BG+/N, N/BG, W, W+/N, B/BG, W+/B, W+/RB, N/BG",                 ;
     "N/W, W+/N, N/W, N/W, W+/N, N/W, N/W, W+/N"                   }, ;
 ;
 ;   // COLOR16  Relations Browse Color
   { "N/B, N/BG, W, GR+/B, B/W, N/N, W+/RB, N/BG",                    ;
     "N/W, W+/N, N/W, N/W, W+/N, N/W, N/W, W+/N, "                 }, ;
 ;
 ;   // COLOR17  Color for AlertBox Window, Bp_Wait function
   { "GR+/R,GR+/B"         , "N/W,W+/W"         }, ;
 ;
 ;   // COLOR17A Color for MemoField Edit Window
   { "N/G,N/R"             , "N/W,N/W"        }, ;
 ;
 ;   // COLOR18  Record Edit Screen Color, View Directory List Question, Flex Types D,N,L
   { "W+/N,N/BG,,,N/W"     , "N/W,W+/N,,,W+/N" }, ;
 ;
 ;   // COLOR18A Record Edit Window Highlight Color, FlexType Hilite, FlexArray Heading
   { "GR+/N"               , "N/W"              }, ;
 ;
 ;   // COLOR18B Main Database Selection Picklist Color
   { "W+/N,N/GR,,,N/W"     , "N/W,W+/N,,,N+/W"  }, ;
 ;
 ;   // COLOR18I Main Index File Picklist Color
   { "W+/N,N/BG,,,N/W"     , "N/W,W+/N,,,N+/W"  }, ;
 ;
 ;   // COLOR18F Main Database Field Selection Picklist Color
   { "W+/N,N/RB,,,N/W"     , "N/W,W+/N,,,N+/W"  }, ;
 ;
 ;   // COLOR18M Record Edit Window Menu Bar Color
   { "W+/N,W+/R,,,N/W"     , "N/W,W+/N,,,W/N"   }, ;
 ;
 ;   // COLOR19B Database Selection Picklist Color - selected items
   { "GR+/N,N/BG,,,N/W"    , "N/W,W+/N,,,N+/W"  }, ;
 ;
 ;   // COLOR19I Index File Picklist Color - selected items
   { "BG+/N,N/BG,,,N/W"    , "N/W,W+/N,,,N+/W"  }, ;
 ;
 ;   // COLOR19F Database Field Selection Picklist Color - selected items
   { "RB+/N,N/BG,,,N/W"    , "N/W,W+/N,,,N+/W"  }, ;
 ;
 ;   // COLOR20  Flex Data Array Browser
   { "W+/N, N/BG, W, W+/N, B/W, N/N, W+/R, N/BG",                     ;
     "N/W, W+/N, N/W, N/W, W+/N, N/W, N/W, W+/N, " },                 ;
 ;
 ;   // COLOR21A Bottombar Menu - Highlighted Item
   { "GR+/R"               , "W/N"              }, ;
 ;   // COLOR21B Bottombar Menu - Highlighted Item Speed Letter
   { "W+/R"                , "W+/N"             }, ;
 ;   // COLOR21C Bottombar Menu - Selectable Item
   { "GR+/N"               , "N/W"              }, ;
 ;   // COLOR21D Bottombar Menu - Selectable Item Speed Letter
   { "W+/N"                , "W+/W"             }, ;
 ;   // COLOR21E Bottombar Menu - Unselectable Item
   { "W/N"                 , "N+/W"             }, ;
 ;   // COLOR21F Bottombar Menu - Unselectable Item Speed Letter
   { "N+/N"                , "W+/W"              }  ;
 ;
                 }
return aColors

*============================================================================
