
; *******************************************************
; *                                                     *
; *     Turbo Pascal Runtime Library Version 7.0        *
; *     String Pos Function                             *
; *                                                     *
; *     Copyright (C) 1990-1993 Norbert Juffa           *
; *                                                     *
; *******************************************************

             TITLE   STPOS


CODE         SEGMENT BYTE PUBLIC

             ASSUME  CS:CODE

; Publics

             PUBLIC  SPos

;-------------------------------------------------------------------------------
; Pos standard function: Pos (VAR Obj, Target: STRING): BYTE
;
; Pos searches the string Target for the first occurence of a string Obj. If Obj
; is found in Target, the index at which the first character of Obj appears in
; Target is returned. If Obj is not found in Target, zero is returned. The
; routine searches the first character of Obj in the first Len(Target)-Len(Obj)
; charcters of Target. Whenever there is a match, the following characters of
; Target are compared to the characters in Obj. If all characters match, Obj has
; been succesfully found in Target.
;
; On entry:  [SP+4] Address of Target
;            [SP+8] Address of Obj
;
; On exit:   AX     index at which Obj first found in Target (0 if not found)
;-------------------------------------------------------------------------------

SPos         PROC    FAR
             CLD                       ; auto-increment for string instructions
             PUSH    DS                ; save TURBO-Pascal data segment
             PUSH    BP                ; save TURBO-Pascal's frame pointer
             MOV     BP, SP            ; make new frame pointer
             LES     DI, [BP+8]        ; address of target string
             LDS     SI, [BP+12]       ; address of object string
             MOV     AX, [SI]          ; AL=length of object, AH=1. char of obj.
             INC     SI                ; adjust
             INC     SI                ;  string pointer
             XOR     CH, CH            ; init result
             DEC     AX                ; length - 1 (changes AH only when AL=0)
             MOV     CL, ES:[DI]       ; length of target string
             SUB     CL, AL            ; targetlength <= objectlength - 1 ?
             JBE     $not_found        ; yes, object not found
             MOV     BH, CL            ; save length of target string
             INC     DI                ; first char of target string
             XCHG    AL, AH            ; AL=1. char of object, AH=length of obj.
             MOV     BP, SI            ; save offset into object
$search:     REPNZ   SCASB             ; scan target string for 1. char of obj.
             JNZ     $not_found        ; exit, if not found
             MOV     BL, CL            ; save remaining length of target string
             MOV     CL, AH            ; number of char to be compared
             MOV     DX, DI            ; save offset into target string
             REPZ    CMPSB             ; compare remaining char of target & obj.
             MOV     SI, BP            ; restore offset into object string
             MOV     DI, DX            ; restore offset into target string
             MOV     CL, BL            ; restore remaining length of target str
             JNZ     $search           ; cont. search, if not all chars matched
             SUB     BH, BL            ; Pos = targetlength - remain. targetlen.
             MOV     CH, BH            ; Pos
$not_found:  POP     BP                ; restore TURBO-Pascal's frame pointer
             POP     DS                ; restore TURBO-Pascal data segment
             MOV     AL, CH            ; Pos
             XOR     AH, AH            ; clear msb
             RET     8                 ; return and pop parameters
SPos         ENDP

             ALIGN   4

CODE         ENDS

             END
