PROGRAM ULPerr; { Copyright (c) 1993 Norbert Juffa }

{ ULPErr tests the software routines for REAL arithmetic transcendental
  functions against the coprocessors EXTENDED precision routines. }

{$N+,E-,A+}

USES FUN1_TP6, CRT;

TYPE  ExtMathFun =  FUNCTION (X: EXTENDED): EXTENDED;
      TestFunctions = (Sine, Cosine, Atan, Log, Expo);
      Bounds = ARRAY [1..2] OF EXTENDED;

VAR   Z:  EXTENDED;
      ZA: ARRAY [1..10] OF BYTE ABSOLUTE Z;
      ZW: ARRAY [1..5] OF WORD ABSOLUTE Z;
      Y:  EXTENDED;
      YA: ARRAY [1..10] OF BYTE ABSOLUTE Y;
      YW: ARRAY [1..5] OF WORD ABSOLUTE Y;
      X:  REAL;
      Step,UlpError, MinUlpErr, MaxUlpErr: EXTENDED;
      YR, ZR:REAL;
      Total, Wrong: LONGINT;
      CoproFun:     ARRAY [Sine..Expo] OF ExtMathFun;
      SoftwareFun:  ARRAY [Sine..Expo] OF RealMathFun;
      L: TestFunctions;

CONST Trials = 1000000;
      FunName:    ARRAY [Sine..Expo] OF STRING =
                  ('SIN', 'COS', 'ARCTAN', 'LN', 'EXP');
      FunIntvl:   ARRAY [Sine..Expo] OF Bounds =
                  ((-0.5*PI, 0.5*PI), (-0.5*PI, 0.5*PI), (-20.0, 20.0),
                   (0.001, 20.0), (-88.0, 88.0));

FUNCTION CoproSin (X: EXTENDED): EXTENDED; FAR;
BEGIN
   CoproSin := Sin (X);
END;

FUNCTION CoproCos (X: EXTENDED): EXTENDED; FAR;
BEGIN
   CoproCos := Cos (X);
END;

FUNCTION CoproExp (X: EXTENDED): EXTENDED; FAR;
BEGIN
   CoproExp := Exp (X);
END;

FUNCTION CoproLn (X: EXTENDED): EXTENDED; FAR;
BEGIN
   CoproLn := Ln (X);
END;

FUNCTION CoproArctan (X: EXTENDED): EXTENDED; FAR;
BEGIN
   CoproArcTan := ArcTan (X);
END;


BEGIN
   CoproFun [Sine]   := CoproSin;
   CoproFun [Cosine] := CoproCos;
   CoproFun [Atan]   := CoproArctan;
   CoproFun [Log]    := CoproLn;
   CoproFun [Expo]   := CoproExp;

   SoftwareFun [Sine]   := SW_Sin;
   SoftwareFun [Cosine] := SW_Cos;
   SoftwareFun [Atan]   := SW_Arctan;
   SoftwareFun [Log]    := SW_Ln;
   SoftwareFun [Expo]   := SW_Exp;


   WriteLn ('******** Test of REAL transcendental function using coprocessor ********');

   FOR L := Sine TO Expo DO BEGIN
      WriteLn;
      WriteLn;
      WriteLn;
      WriteLn ('Test of function ', FunName [L]:6, ' in interval (',
               FunIntvl [L, 1]:15, ' .. ', FunIntvl [L, 2]:15, ')');
      WriteLn;
      WriteLn ('       x             total     wrong       -ULPerr         + ULPerr');
      WriteLn;
      X := FunIntvl [L, 1];
      Step := (FunIntvl [L, 2] - FunIntvl [L, 1]) / (Trials);
      MinUlpErr := 0;
      MaxUlpErr := 0;
      Total := 0;
      Wrong := 0;
      WHILE X <= FunIntvl [L, 2] DO BEGIN
         Inc (Total);
         Y := SoftwareFun [L] (X);
         Z := CoproFun [L] (X);
         YR := Y;
         ZR := Z;
         IF YR <> ZR THEN
            Inc (Wrong);

         IF YW[5] > ZW[5] THEN
            UlpError := ((((((((YA[8]*256.0+YA[7])*256.0+YA[6])*256.0+YA[5])
                        *256.0+YA[4])*256.0+YA[3])*256.0+YA[2])*256.0+YA[1])*2-
                        (((((((ZA[8]*256.0+ZA[7])*256.0+ZA[6])*256.0+ZA[5])
                        *256.0+ZA[4])*256.0+ZA[3])*256.0+ZA[2])*256.0+ZA[1]))/
                        16777216.0
         ELSE IF YW[5] < ZW[5] THEN
            UlpError := ((((((((YA[8]*256.0+YA[7])*256.0+YA[6])*256.0+YA[5])
                        *256.0+YA[4])*256.0+YA[3])*256.0+YA[2])*256.0+YA[1])-
                        (((((((ZA[8]*256.0+ZA[7])*256.0+ZA[6])*256.0+ZA[5])
                        *256.0+ZA[4])*256.0+ZA[3])*256.0+ZA[2])*256.0+ZA[1])*2)/
                        16777216.0
         ELSE UlpError := ((((((((YA[8]*256.0+YA[7])*256.0+YA[6])*256.0+YA[5])
                          *256.0+YA[4])*256.0+YA[3])*256.0+YA[2])*256.0+YA[1]) -
                          (((((((ZA[8]*256.0+ZA[7])*256.0+ZA[6])*256.0+ZA[5])
                          *256.0+ZA[4])*256.0+ZA[3])*256.0+ZA[2])*256.0+ZA[1])) /
                          16777216.0;

         IF (YR <> 0) AND (ZR <> 0) THEN
            IF (UlpError < MinUlpErr) THEN
               MinUlpErr := UlpError
            ELSE IF (UlpError > MaxUlpErr) THEN
               MaxUlpErr := UlpError;

         X := X + (Step);

         IF Total AND $FFF = 0 THEN BEGIN
            GotoXY (1, WhereY);
            ClrEol;
            Write (X:16, Total:10, Wrong:10, '  ', MinUlpErr:16, '  ', MaxUlpErr:16);
         END;
      END;
      GotoXY (1, WhereY);
      ClrEol;
      WriteLn (X:16, Total:10, Wrong:10, '  ', MinUlpErr:16, '  ', MaxUlpErr:16);
   END;
END.
