/*
* This file demos some boxs with shadows that are coded with Clipper 5.2's
* GT system. If you do not pick a shadow side the function will decide on
* which side to place the shadow (depending if its an even or odd day). I
* think that this may drive some operators crazy, not knowing if they are
* seeing things when the shadow changes from day to day!
*/

#xcommand BOXIT                                         ;
          [ TOP <nTop> ]                                ;
          [ LEFT <nLeft> ]                              ;
          [ BOTTOM <nBottom> ]                          ;
          [ RIGHT <nRight> ]                            ;
          [ BOX TYPE <nBoxType> ]                       ;
          [ SHADOW SIDE <nSide> ]                       ;
          [ COLOR <cColor> ]                            ;
          =>                                            ;
          ShadBox( <nTop>,                              ;
                   <nLeft>,                             ;
                   <nBottom>,                           ;
                   <nRight>,                            ;
                   <nBoxType>,                          ;
                   <nSide>,                             ;
                   <cColor> )

#xtranslate ASSUME <p> IS <v> [IF MISSING]              ;
    => <p> := IF( <p> == NIL, <v>, <p> )

#xcommand SET <v> WITHIN <bottom> TO <top> BASE <value> ;
    => if !( <v> >= <bottom> .and. <v> <= <top> )      ;;
           <v> := <value>                              ;;
       endif

#xtranslate IS_EVEN( <foo> )                            ;
    =>                                                  ;
       ( MOD( <foo>, 2 ) == 0 )

#xtranslate IS_ODD( <foo> )                             ;
    =>                                                  ;
       ( MOD( <foo>, 2 ) == 1 )

#xtranslate MOD( <n1>, <n2> )                           ;
    =>                                                  ;
       ( IF( <n2> == 0, <n1>, ( (<n1>) % (<n2>) ) + ;
       IF( ( (<n1>) % (<n2>) ) * <n2> \< 0, <n2>, 0 ) ))


#define LEFT_SIDE   1
#define RIGHT_SIDE  2

#define DOUBLE_BOX  1
#define SINGLE_BOX  2
#define SD_BOX      3
#define DS_BOX      4

#ifdef TESTING
function test()
    local lBlink := setblink(.f.), nCursor := setcursor(0)
    dispbox(0,0,maxrow(),maxcol(),"","w+/w")
    ShadBox( 0, 0,5,maxcol() +1, DOUBLE_BOX, LEFT_SIDE )
    inkey(0)

    dispbox(0,0,maxrow(),maxcol(),"","r+/w*")
    ShadBox( 0, 0,maxrow()+3,maxcol() +1, SINGLE_BOX, RIGHT_SIDE,"n/gr*" )
    inkey(0)

    dispbox(0,0,maxrow(),maxcol(),"","w+/w")

    // simple example of UDC
    BOXIT   BOX TYPE SD_BOX

    ShadBox( 10, 10,15,40, DS_BOX, RIGHT_SIDE,"w+/r*" )
    ShadBox(3,3,6,70,,,"n/w*")
    @4,5 say "Press any key to quit this silly demo" color "n/w*"
    inkey(0)
    cls
    setblink(lBlink)
    setcursor(nCursor)
return nil
#endif

function ShadBox( nTop, nLeft, nBottom, nRight, nBoxType, nSide, cColor)
    assume nTop     is 0
    assume nLeft    is 0
    assume nBottom  is maxrow() -1
    assume nRight   is maxcol() -1
    assume nBoxType is 1
    assume nSide    is if( IS_EVEN( day(date())),LEFT_SIDE,RIGHT_SIDE)
    assume cColor   is "w+/b"

    set nSide    within 1 to 2           base 1
    set nBottom  within 3 to maxrow() -1 base maxrow() -1
    set nBoxType within 1 to 4           base 1

    if nSide == RIGHT_SIDE
        set nRight within 0 to maxcol() -1 base maxcol() -1
    else
        set nLeft  within 1 to maxcol()    base 1
        set nRight within 4 to maxcol()    base maxcol()
    endif


    box(nTop,nLeft,nBottom,nRight,nBoxType,cColor)
    shadow(nTop,nLeft,nBottom,nRight,nSide)

return nil
