/* Calculate costs with BT-XE ShortCostLog feature
 *
 * Usage:
 * calccost <costlog filename> <system 4D addr> <date start> <date end>
 *
 * This will calculate statistics for system <system 4D addr> starting at
 * <date start> (this day included) up to <date end> (this day included, too).
 *
 * If you do not use default ShortCostLog layout, then you have to adapt
 * the "parse" call below ...
 */
 
parse arg costlog system datestart dateend .

if costlog='' then
  do
    say 'CalcCost.Cmd: no parameters, going into interactive mode...'
    say
    call charout ,'Filename of ShortCostLog  ? : '; pull costlog
    call charout ,'System (4D address)       ? : '; pull system
    call charout ,'Start date (e.g. 960101)  ? : '; pull datestart
    call charout ,'End date (e.g. 961231)    ? : '; pull dateend
  end
  
sum.cost     = 0
sum.rcost    = 0
sum.seconds  = 0
sum.calls    = 0
sum.inbytes  = 0
sum.outbytes = 0

call stream costlog, 'c', 'open read'

do while lines(costlog)<>0
  parse value linein(costlog) with _date _time _taskno _system _connectrate _seconds _cost _rcost _inbytes _outbytes .
  if _system=system & _date>=datestart & _date<=dateend then
    do
      sum.seconds  = sum.seconds  + _seconds
      sum.cost     = sum.cost     + _cost
      sum.calls    = sum.calls    + 1
      sum.inbytes  = sum.inbytes  + _inbytes
      sum.outbytes = sum.outbytes + _outbytes
      sum.cost     = sum.cost     + _cost
      sum.rcost    = sum.rcost    + _rcost
    end
end

call stream costlog, 'c', 'close'

say 'Statistics for   :' system 
say 'Time interval    :' datestart '..' dateend 
say 'Calls            :' sum.calls
say 'Seconds          :' sum.seconds 
say 'Inbound traffic  :' sum.inbytes
say 'Outbound traffic :' sum.outbytes
say 'Own costs        :' sum.cost
say 'Remote costs     :' sum.rcost

exit

  
