/*++


--*/

#include <stdlib.h>
#include <stdio.h>
#include <windows.h>
#include <winioctl.h>
#include <string.h>
#include <memory.h>
#include <string.h>

BOOL
LockVolume(
    HANDLE hDisk
    )
{
    DWORD ReturnedByteCount;

    return DeviceIoControl(
                hDisk,
                FSCTL_LOCK_VOLUME,
                NULL,
                0,
                NULL,
                0,
                &ReturnedByteCount,
                NULL
                );
}

BOOL
UnlockVolume(
    HANDLE hDisk
    )
{
    DWORD ReturnedByteCount;

    return DeviceIoControl(
                hDisk,
                FSCTL_UNLOCK_VOLUME,
                NULL,
                0,
                NULL,
                0,
                &ReturnedByteCount,
                NULL
                );
}

// Partition in 
typedef struct
{
BYTE bActivate;
BYTE bHeadBegin;
WORD wCylSectBegin;

BYTE bType;  // 0=none, 5=ext
BYTE bHeadEnd;
WORD wCylSectEnd;

DWORD dwDist;
DWORD dwSize;
} PARTITION;

typedef struct
{
BYTE bDisk;
PARTITION part;
} PARTDESC;

typedef struct
{
BYTE bType;
const char *szTxt;
} TYPEPARTDESC;


/*
Boot type list, from Linux FDISK
 0  Empty            8  AIX             75  PC/IX           b7  BSDI fs
 1  DOS 12-bit FAT   9  AIX bootable    80  Old MINIX       b8  BSDI swap
 2  XENIX root       a  OS/2 Boot Manag 81  Linux/MINIX     c7  Syrinx
 3  XENIX usr       40  Venix 80286     82  Linux swap      db  CP/M
 4  DOS 16-bit <32M 51  Novell?         83  Linux native    e1  DOS access
 5  Extended        52  Microport       93  Amoeba          e3  DOS R/O
 6  DOS 16-bit >=32 63  GNU HURD        94  Amoeba BBT      f2  DOS secondary
 7  OS/2 HPFS       64  Novell          a5  BSD/386         ff  BBT
*/
const TYPEPARTDESC TypeDesc[] =
{ 
{0x1," (DOS Fat12)"} ,
{0x2," (XENIX root)"} ,
{0x3," (XENIX usr)"} ,
{0x4," (Dos Fat16)"} ,
{0x5," (Extended)"} ,
{0x6," (BIGDOS Fat16)"} ,
{0x7," (HPFS/NTFS)"} ,
{0x8," (AIX)"} ,
{0x9," (AIX bootable)"} ,
{0x0a," (OS/2 Boot Manag.)"} ,
{0x40," (Venix 80286)"} ,
{0x51," (Novell?)"} ,
{0x52," (Microport)"} ,
{0x63," (GNU HURD)"} ,
{0x64," (Novell)"} ,
{0x75," (PC/IX)"} ,
{0x80," (Old Minix)"} ,
{0x81," (Linux/Minix)"} ,
{0x82," (Linux swap)"} ,
{0x83," (Linux native)"} ,
{0x93," (Amoeba)"} ,
{0x94," (Amoeba BBT)"} ,
{0xa5," (BSD/386)"} ,
{0xb7," (BSDI fs)"} ,
{0xb8," (BSDI swap)"} ,
{0xc7," (Syrinx)"} ,
{0xdb," (CP/M !)"} ,
{0xe1," (DOS access)"} ,
{0xe3," (DOS R/O)"} ,
{0xf2," (DOS secondary)"} ,
{0xff," (BBT)"} ,
{0,""} ,
};

void AddPartition(PARTDESC PartDescone,PARTDESC PartDesc[],WORD &wNbPart)
{
const char * pszTypeText="";
int i;
  for (i=0;;i++)
    {
      if (TypeDesc[i].bType == PartDescone.part.bType)
        {
          pszTypeText = TypeDesc[i].szTxt;
          break;
        }
      if (TypeDesc[i].bType == 0)
        break;
    }
  printf("%2u : %c: type=%x%s, size = %lu KB\n",wNbPart,
                (PartDescone.bDisk&0x7f)+'C',
                PartDescone.part.bType,pszTypeText,PartDescone.part.dwSize/2);
  PartDesc[wNbPart++] = PartDescone;
}

BOOL BrowsePhysical(HANDLE hDriveReuse,WORD wPhysical,PARTDESC PartDesc[],WORD &wNbPart,DWORD dwPos)
{
HANDLE hDrive; 
BOOL b;
char szBoot[0x200];
DWORD BytesRead=0;
DWORD i;
//DWORD j;
char szOpen[80];
        wsprintf(szOpen,"\\\\.\\PhysicalDrive%c",'0'+wPhysical);
        if (hDriveReuse==NULL)
          {
           hDrive = CreateFile(
                    szOpen,
                    GENERIC_READ,
                    FILE_SHARE_READ |FILE_SHARE_WRITE	,
                    NULL,
                    OPEN_EXISTING,
                    0,
                    NULL
                    );
           if ( hDrive == INVALID_HANDLE_VALUE ) {
              return FALSE;
              }
           LockVolume(hDrive);
          }
        else hDrive = hDriveReuse;
        
        SetFilePointer(hDrive,dwPos,0,FILE_BEGIN);
        b = ReadFile(hDrive,szBoot, 0x200, &BytesRead, NULL);
        if (!b) BytesRead=0;
        if ((szBoot[0x1fe]==0x55) && (szBoot[0x1ff]==(char)0xaa))
        for (i=0;i<4;i++)
          {
          PARTDESC partDescone;
            partDescone.bDisk =(BYTE)wPhysical+0x80;
            memcpy(&partDescone.part,szBoot+0x1be+(i*0x10),sizeof(PARTITION));
            if (partDescone.part.bType != 0)
              AddPartition(partDescone,PartDesc,wNbPart);
            if (partDescone.part.bType == 5) 
              BrowsePhysical(hDrive,wPhysical,PartDesc,wNbPart,partDescone.part.dwDist*512+dwPos) ;
          }
        /*
        for (i=0;i<BytesRead;i++)
          {
            if ((i!=0) && ((i & 0xf)==0)) 
              {
                printf("  ");
                for (j=i-0xf;j<i;j++)
                  {
                    BYTE c=(BYTE)szBoot[j];
                      if (c>=' ') putchar(c); else putchar('.');
                  }
                printf("\n");
              }

            if (((BYTE)szBoot[i]) <= 0xf) printf(" ");
            printf("%X ",(DWORD)(BYTE)szBoot[i]);            
          }
        */
        if (hDriveReuse==NULL)
          {
            UnlockVolume(hDrive);
            CloseHandle(hDrive);
          }
        return TRUE;
}


BOOL BuildFile(const char* fn,const PARTDESC & PartDesc,char * pszFileName)
{
char szBoot[512];
HFILE hf;
OFSTRUCT of;
  memset(szBoot,0,512);
  * (WORD*)(szBoot)=0x3CEB;
  * (BYTE*)(szBoot+2)=0x90;
  * (WORD*)(szBoot+510)=0xAA55;
  memcpy(((char*)szBoot)+0x3E,
        "\xFA\x33" \
        "\xC0\x8E\xD0\xBC\x00\x7C\xB8\xB0\x07\x8E\xD8\x8E\xC0\xB9\x00\x01"
        "\x8B\xF1\xBF\x00\x03\xF3\xA5\xB8\xD0\x07\x50\x8E\xD8\x8E\xC0\xB8"
        "\x64\x01\x50\xCB\xFB\xBE\xB4\x01\xE8\x3A\x00\xB8\x01\x02\xB9\x01"
        "\x00\xBA\x80\x00\x33\xDB\x8E\xC3\xBB\x00\x7C\x06\x53\xCD\x13\x72"
        "\x0A\x26\x81\x3E\xFE\x7D\x55\xAA\x75\x01\xCB\xBE\x3E\x02\xE8\x14"
        "\x00\xB4\x01\xCD\x16\x74\x06\x32\xE4\xCD\x16\xEB\xF4\x32\xE4\xCD"
        "\x16\x33\xD2\xCD\x19\xFC\xAC\x0A\xC0\x74\x08\x56\xB4\x0E\xCD\x10"
        "\x5E\xEB\xF3\xC3\x44\x69\x73\x6B\x20\x66\x6F\x72\x6D\x61\x74\x74"
        "\x65\x64\x20\x77\x69\x74\x68\x20\x57\x69\x6E\x49\x6D\x61\x67\x65"
        "\x20\x32\x2E\x32\x30\x20\x28\x63\x29\x20\x31\x39\x39\x33\x2D\x39"
        "\x35\x20\x47\x69\x6C\x6C\x65\x73\x20\x56\x6F\x6C\x6C\x61\x6E\x74"
        "\x0A\x0D\x42\x6F\x6F\x74\x73\x65\x63\x74\x6F\x72\x20\x66\x72\x6F"
        "\x6D\x20\x43\x2E\x48\x2E\x20\x48\x6F\x63\x68\x73\x74\x84\x74\x74"
        "\x65\x72\x0A\x0D\x0A\x0D\x4E\x6F\x20\x53\x79\x73\x74\x65\x6D\x64"
        "\x69\x73\x6B\x2E\x20\x42\x6F\x6F\x74\x69\x6E\x67\x20\x66\x72\x6F"
        "\x6D\x20\x68\x61\x72\x64\x64\x69\x73\x6B\x2E\x0A\x0D\x00\x43\x61"
        "\x6E\x6E\x6F\x74\x20\x6C\x6F\x61\x64\x20\x66\x72\x6F\x6D\x20\x68"
        "\x61\x72\x64\x64\x69\x73\x6B\x2E\x0A\x0D\x49\x6E\x73\x65\x72\x74"
        "\x20\x53\x79\x73\x74\x65\x6D\x64\x69\x73\x6B\x20\x61\x6E\x64\x20"
        "\x70\x72\x65\x73\x73\x20\x61\x6E\x79\x20\x6B\x65\x79\x2E\x0A\x0D"
        "\x00",0x143);
                                                        // AX=0x201  for int 13
  * (BYTE*)(szBoot+0x72) = PartDesc.bDisk;              // Modify DL for int 13
  * (BYTE*)(szBoot+0x73) = PartDesc.part.bHeadBegin;    // Modify DH for int 13
  * (WORD*)(szBoot+0x6f) = PartDesc.part.wCylSectBegin; // Modify CX for int 13
  hf = OpenFile(fn,&of,OF_CREATE|OF_WRITE);
  if (hf==HFILE_ERROR)
    return FALSE;
  _lwrite(hf,szBoot,512);
  _lclose(hf);
  strcpy(pszFileName,of.szPathName);
  printf("%s writted\n",of.szPathName);
  return TRUE;
}

#define MAXBOOTINI (32768)
BOOL AddBootIni(char *szLine)
{
char szBootIni[MAXBOOTINI];
HFILE hf;
UINT uiSize;
OFSTRUCT of;
DWORD dwAttr;
  hf = OpenFile("C:\\BOOT.INI",&of,OF_READ);
  if (hf==HFILE_ERROR) 
    return FALSE;
  uiSize = _lread(hf,szBootIni,MAXBOOTINI);
  _lclose(hf);
  if ((uiSize >= MAXBOOTINI) || (uiSize<0xf))
    return FALSE;
  if (szBootIni[uiSize-1]==0x1a)
    uiSize--;

  if ((szBootIni[uiSize-2]!=0x0d) || (szBootIni[uiSize-1]!=0x0a))
    {
       uiSize+=2;
       szBootIni[uiSize-2]=0x0d;
       szBootIni[uiSize-1]=0x0a;
    }

  strcpy(szBootIni+uiSize,szLine);
  uiSize += strlen(szLine);

  if ((szBootIni[uiSize-2]!=0x0d) || (szBootIni[uiSize-1]!=0x0a))
    {
       uiSize+=2;
       szBootIni[uiSize-2]=0x0d;
       szBootIni[uiSize-1]=0x0a;
    }

  dwAttr = GetFileAttributes("C:\\BOOT.INI");

  SetFileAttributes("C:\\BOOT.INI",FILE_ATTRIBUTE_NORMAL);
  hf = OpenFile("C:\\BOOT.INI",&of,OF_CREATE);
  _lwrite(hf,szBootIni,uiSize);
  _lclose(hf);
  SetFileAttributes("C:\\BOOT.INI",dwAttr);
  printf("C:\\BOOT.INI updated\n");
 return TRUE;
}


void help()
{
  printf("\n" \
       "Usage : BOOTPART\n" \
       "            List all partition, with number\n" \
       "        BOOTPART <part_number> <filename> [<name_of_system>]\n" \
       "            where : part_number : a number of a partition (or A: for floppy)\n"
       "                    filename : the file name of the bootfile to create\n" \
       "                    name_of_system : the name to be added in the BOOT.INI\n" \
       "                Create a boot file for the partition, and if name_of_system\n" \
       "                  is specified, register it in the BOOT.INI\n" \
       "\n");
}

#define MAXPART 256
WORD main(int argc,char *argv[])
{
WORD wDisk=0;
PARTDESC PartDesc[MAXPART];
WORD wNbPart=0;

  printf("Boot Partition 1.0 for Windows NT-1995 G. Vollant (100144.2636@compuserve.com)\n" \
         "Add partition in the Windows NT Multi-boot loader\n" \
         "Run \"%s /?\" for more information\n\n",argv[0]);
  if (argc > 1)
    if ((strncmp(argv[1],"HELP",4) == 0) || (strncmp(argv[1],"/?",2) == 0) ||
      (strncmp(argv[1],"?",1) == 0))
        {
          help();
          return 0 ;
        }

  while (BrowsePhysical(NULL,wDisk,PartDesc,wNbPart,0))
   wDisk++;
  

  if (argc >= 3)
    {
    WORD wPart ;
    BOOL fDone=FALSE;
    char szName[128];
    char szLine[256];
    char szFileName[256];
    int i;
    char * arg1 = argv[1];
    BOOL fGoodFile=FALSE;
      if ((((*arg1)>='a') && ((*arg1)<='z')) || (((*arg1)>='A') && ((*arg1)<='Z')) )
        if (*(arg1+1)==':')
          {
          PARTDESC PartDescOne;

            PartDescOne.bDisk = (((*arg1) & 0x1f)-1);
            PartDescOne.part.bHeadBegin=0;
            PartDescOne.part.wCylSectBegin=1;
            fDone=TRUE;
            fGoodFile=BuildFile(argv[2],PartDescOne,szFileName);
          }

      
      
      wPart = (WORD)atoi(argv[1]);
      if ((wPart < wNbPart) && (!fDone))
        fGoodFile=BuildFile(argv[2],PartDesc[wPart],szFileName);

      if ((fGoodFile) && (argc > 3))
        {
          for (i=3;i<argc;i++)
            {
              if (i==3)
                szName[0]='\0';
              else
                strcat(szName," ");
              strcat(szName,argv[i]);
            }
          sprintf(szLine,"%s=\"%s\"",szFileName,szName);
          //printf("%s",szLine);
          AddBootIni(szLine);
        }
    }
  return 0;
}

/*
;;For information, this is the file FDBOOT.ASM
;; FDBOOT comes with FDFORMAT from C.H. Hochsttter
;; for complete FDFormat package, download :
;; ftp://ftp.coast.net/SimTel/msdos/diskutil/fdform18.zip (or in SimTel mirror,
;;   like ftp://oak.oakland.edu/SimTel/msdos/diskutil/fdform18.zip
;;   or FDFORM.ZIP in the PCHW compuserve forum
;; begin of FDBOOT.ASM

             page      66,128
cseg         segment   para public 'CODE'
             assume    cs:cseg

             org       100h                     ;Allow Boot-Sector as COM-File
begin:       jmp       short start              ;Jump
             nop
bpb          db        3FH DUP (0)              ;Reserve enough space for BPB

start        proc      far
             cli                                ;Clear Interrupts, while modifying stack
             xor       ax,ax                    ;Zero AX
             mov       ss,ax                    ;Set SS...
             mov       sp,7c00h                 ;..and SP below Code
             mov       ax,7b0h                  ;Set Segment-Registers that Offset is 100H
             push      ax                       ;Push Segment twice
             push      ax
             pop       ds                       ;Get Segment in DS
             pop       es                       ;and also in ES
             mov       si,100h                  ;Set Source to 100H
             mov       di,300h                  ;Set Destination to 300H
             mov       cx,100h                  ;Set Count to 512 Bytes (1 Sector)
             rep       movsw                    ;Move Code
             mov       ax,7d0h                  ;New Segment at 7d0h (+20H)
             push      ax                       ;Push Segment three times
             push      ax
             push      ax
             pop       ds                       ;Get new segment in DS
             pop       es                       ;and also in ES
             mov       ax,offset entry          ;Offset of next instruction
             push      ax                       ;Push to stack
             ret                                ;and pop it to CS:IP
start        endp

entry        proc      far
             sti                                ;Start Interrupts again
             mov       si,offset text1          ;Move SI to text
             call      output                   ;display to screen
             mov       ax,201h                  ;AH=2 (read sector), AL=1 (count)
             mov       cx,1                     ;CH=0 (Track), CL=1 (Sector)
             mov       dx,128                   ;DH=0 (Head), DL=128 (Fixed Disk C)
             xor       bx,bx                    ;Segment of Transfer buffer
             push      bx                       ;Push to Stack
             pop       es                       ;Get Segment in ES
             mov       bx,7c00h                 ;Offset of Transfer buffer
             push      es                       ;Push Segment...
             push      bx                       ;And Offset to stack
             int       13h                      ;Read from Harddisk
             jc        error                    ;Jump if error
             cmp       word ptr es:7dfeh,0aa55h ;Valid Boot Secotor?
             jnz       error                    ;No, error
             ret                                ;Continue with Boot-Sector of C:

error:       mov       si,offset text2          ;Move SI to text
             call      output                   ;display to screen
loop1:       mov       ah,1                     ;Get Status of...
             int       16h                      ;...Keyboard buffer
             jz        boot_new                 ;if keypressed, reboot
             xor       ah,ah                    ;flush....
             int       16h                      ;...Keyboard Buffer
             jmp       loop1                    ;And try again
boot_new:    xor       ah,ah                    ;flush...
             int       16h                      ;...Keyboard buffer
             xor       dx,dx                    ;Zero DX
             int       19h                      ;Reboot
entry        endp

output       proc      near
             cld
loop_o:      lodsb                              ;Get one character
             or        al,al                    ;Is it zero?
             jnz       weiter                   ;No, continue
             ret                                ;else return
weiter:      push      si                       ;Save SI
             mov       ah,0eh                   ;Output character...
             int       10h                      ;...in AL to screen
             pop       si                       ;restore SI
             jmp       short loop_o             ;repeat loop
output       endp

             IF        LANGUAGE EQ 1
text1        db        'FDBOOT Version 1.8',10,13
             db        'No Systemdisk. Booting from harddisk.',10,13,0
text2        db        'Cannot load from harddisk.',10,13
             db        'Insert Systemdisk and press any key.',10,13,0
             ENDIF

             IF        LANGUAGE EQ 49
text1        db        'FDBOOT Version 1.8',10,13
             db        'Keine Systemdiskette. Starten von Festplatte.',10,13,0
text2        db        'Kann nicht von der Festplatte starten.',10,13
             db        'System-Diskette in Laufwerk A: einlegen',10,13
             db        'Anschlieend eine Taste drcken',10,13,0
             ENDIF

             org       2feh
             db        55h,0aah

cseg         ends
             end       begin
;; end of FDBOOT.ASM
*/
