{$D-}  { Disable Debug Information }
{$S-}  { Disable Stack Checking }
{$V-}  { Disable String Checking }

Unit GetCmBBS;
{ Part of BBS Onliner Interface }
{ Copyright (C) 1990 Andrew J. Mead
  All Rights Reserved. }

{ Original version 7/1/90 }
{ Original release version 9/5/90 }
{ Original public release 12/15/90 }
{ history found in IOLIB.PAS }


INTERFACE

Uses
  boidecl,
  DOS;

Procedure GETCOMMAND(       { process command line parameters }
    infofile,               { name of documentation file }
    inhof,                  { default name for text hall of fame }
    logfile    : pathstr;   { name of error log }
    gamename,               { name of current game }
    version    : string;    { version of current game }
    programset : charset);  { set of program's command line switches }

IMPLEMENTATION

Uses
  iolib;

Type
  IRQtype   = array [0..15] of byte;   { array of IRQ information }
  portype   = array [0..3] of word;    { default port addressess  }

Var
  inchar    : char;                    { standard input character }
  minmax    : byte;                    { maximum time allowed }

Const
  timedone  : boolean = false; { remaining time figured }
  filedone  : boolean = false; { BBS file processed }
  hofdone   : boolean = false; { /y processed }
  lockcomm  : boolean = false; { /c processed }
  lockIRQ   : boolean = false; { /i processed }
  locklocal : boolean = false; { /l processed }
  lockname  : boolean = false; { /n processed }
  setlocal  : boolean = false; { BBS file says it is in local play }
  portarray : portype =        { default port addressess for Com1 - Com4 }
      ($3F8,$2F8,$3E8,$2E8);
  IRQarray  : IRQtype =        { interrupt vectors for IRQs 0 - 15 }
      ($08,$09,$0A,$0B,$0C,$0D,$0E,$0F,$70,$71,$72,$73,$74,$75,$76,$77);
  Initarray : IRQtype =        { 8259A IRQ enabling masks-used in Async.Pas }
      ($FE,$FD,$FB,$F7,$EF,$DF,$BF,$7F,$FB,$FB,$FB,$FB,$FB,$FB,$FB,$FB);
      { Entries 8-15 are unknown the cascade mask (for IRQ2) is used }

  IRQnum    : byte    = 4;     { default IRQ - Com1 Com3 }

Procedure GETCOMMAND;
  var
    gcf         : text;        { user information text file handle }
    gcb         : file;        { user information byte file handle }
    gbuffer     : array [1..4096] of char; { buffer for gcf-text file buffer }
    gcbuffer    : array [0..4095] of byte; { buffer for gcb-binary file buffer}
    gcstr       : string;      { current input line from gcf }
    insize      : word;        { size of gcb }
    dummy       : word;        { Val conversion error value }
    timetemp    : real;        { Second/Minute time conversion variable }
    opchs       : string [2];  { Opus-CBCS Task Designation }
    gloop       : byte;

  Procedure SHOWERROR(param : byte;passtr : string);
  { display error in command line arguments }
    var s : text;              { errorlog file handle }

    Procedure WRITEERROR(outstr : string);
      begin {* GetCommand,ShowError,WriteError *}
        write(s,'Abnormal termination of program at');
        GetTime(hour,minute,second,hunsec);
{time}  write(s,hour:1,':',minute:1,':',second:1,'  ');
        GetDate(hour,minute,second,hunsec);
{date}  writeln(s,minute:1,'/',second:1,'/',hour:1,'.');
        writeln(s,'ERROR ',param:0);
        writeln(outstr);
        writeln(s,outstr);
        writeln(s)
      end;  {* GetCommand,ShowError,WriteError *}

    begin  {* GetCommand,ShowError *}
      write(#27'[2J');
      assign(s,logfile);
      if exist(logfile) then append(s) else rewrite(s);
      writeln(gamename,' version ',version,'.');
      writeln('Copyright (C) 1990 Andrew J. Mead');
      writeln('All Rights Reserved.');
      writeln('Contact: POB 1155 Chapel Hill, NC 27514-1155');
      writeln;
      writeln('Abnormal termination of program:');
      writeln;
      writeln('ERROR ',param:0);
      case param of
           1 : WriteError('Too many command line arguments.');
           2 : WriteError('Unknown or incorrect argument on command line.');
           3 : WriteError(passtr+' file format not supported yet.');
           4 : WriteError('Unable to find '+passtr+'.  Check implementation or notify Sysop.');
           5 : WriteError('Error in '+passtr+'.  Check implementation.');
           7 : WriteError('Duplicate directives.');
           8 : WriteError('Path/Filename for Hall of Fame is not valid.');
           9 : WriteError(passtr+' is not a valid path.');
          10 : WriteError('Invalid port setting(s) in '+passtr+'.');
          11 : WriteError('Invalid or missing numeric in /X:nn.');
          12 : WriteError('Hall of Fame limit out of range, must be in 1-19.');
          13 : WriteError('Invalid or missing value in /C:n.  ''n'' should be 1-4');
          16 : WriteError('/L can not be used with either /C or /I');
          17 : WriteError('Invalid format in /I:i:nnnn.');
          18 : WriteError(passtr+' is not a valid Hexadecimal address in /I statement.');
          19 : WriteError('Invalid numeric in /A:x.');
          20 : WriteError('/A timeleft should be at least 5.');
          21 : WriteError('Error reading data file, check documentation for proper switch.')
        end;
      writeln;
      writeln('Check ',infofile,' for proper installation of this program.');
      writeln('Report error message to SysOp.');
      writeln;
      writeln('Error saved in ',logfile,'.');
      delay(5000);
      writeln('Now returning to BBS.');
      close(s);
      halt
    end;  {* GetCommand,ShowError *}

  Procedure PROCESSTEXT(      { process BBS system text file for user info }
      filestr   : pathstr;    { name of BBS system file }
      getname,                { username is in file indicator }
      getime,                 { user time remaining is in file indicator }
      getlines,               { user screen length is in file indicator }
      ismins    : boolean;    { user time remaining is in minutes indicator }
      nameline,               { line at which users name is found }
      timeline,               { line at which users time remaining is found }
      lineline,               { line at which users screen length is found }
      comline,                { line at which the comport is listed }
      combyte,                { byte in comline that determines comport }
      doextra   : byte);      { extra information for a given file - switch }

    Procedure RESTART(readline : byte);
    { places the given lines information in gcstring }
      var rloop : byte;

      begin {* GetCommand,ProcessText,Restart *}
        reset(gcf);
        {$I-}
        for rloop := 1 to readline do readln(gcf,gcstr);
        {$I+}
        if IOResult <> 0 then ShowError(5,filestr)
      end;  {* GetCommand,ProcessText,Restart *}

    Procedure DORBBS;
    { get users last name, and append it to the first name }
      begin {* GetCommand,ProcessText,DoRBBS *}
        Restart(8); { Get user's last name }
        username := username + ' ' + gcstr
      end;  {* GetCommand,ProcessText,DoRBBS *}

    Procedure DOWWIV;
    { check to see if game is being played locally or from remote }
    { get user's real name }
      begin {* GetCommand,ProcessText,DoWWIV *}
        Restart(15);
        while (gcstr[1] = ' ') and (length(gcstr) > 0) do delete(gcstr,1,1);
        if (length(gcstr) > 0) and (gcstr[1] = '0') then setlocal := true;
        Restart(3);
        usereal := true;
        realname := gcstr;
        Restart(1);
        realname := '#'+ gcstr + ' ' + realname
      end;  {* GetCommand,ProcessText,DoWWIV *}

    Procedure DOSPITFIRE;
    { get user's user number }
      begin {* GetCommand,ProcessText,DoSpitfire *}
        Restart(1);
        usereal := true;
        realname := '#' + gcstr
      end;  {* GetCommand,ProcessText,DoSpitfire *}

    Procedure DOWILDCAT;
    { check to see if game is being played locally or from remote }
      begin {* GetCommand,ProcessText,DoWildCat *}
        Restart(28);
        if Pos('LOCAL',gcstr) > 0 then setlocal := true
      end;  {* GetCommand,ProcessText,DoWildCat *}

    Procedure DO2AM;
      begin {* GetCommand,ProcessText,Do2AM *}
        Restart(6); { Get user's last name }
        username := username + ' ' + gcstr;
        Restart(3);
        usereal := true;
        realname := gcstr
      end;  {* GetCommand,ProcessText,Do2AM *}

    Procedure DOPHOENIX;
      begin {* GetCommand,ProcessText,DoPhoenix *}
        Restart(2);
        if Pos('LOCAL',gcstr) > 0 then setlocal := true
      end;  {* GetCommand,ProcessText,DoPhoenix *}

    begin {* GetCommand,ProcessText *}
      if filedone then ShowError(7,'') else filedone := true;
      if length(gcstr) > 2 then
        begin
          delete(gcstr,1,2);
          if gcstr[1] = ':' then delete(gcstr,1,1);
          if not (gcstr[length(gcstr)] in [':','\']) then gcstr := gcstr + '\';
          filestr := gcstr + filestr;
          if not Valid(filestr) then ShowError(9,gcstr)
        end;
      if not Exist(filestr) then ShowError(4,filestr);
      assign(gcf,filestr);
      SetTextBuf(gcf,gbuffer);
      if getname then              { get users name }
        begin
          Restart(nameline);
          usename := true;
          username := copy(gcstr,1,39)
        end
      else usename := false;
      if getime then               { get users time remaining }
        begin
          Restart(timeline);
          while (gcstr[1] = ' ') and (length(gcstr) > 0) do Delete(gcstr,1,1);
          while (gcstr[length(gcstr)] = ' ') and (length(gcstr) > 0) do Delete(gcstr,length(gcstr),1);
          Val(gcstr,timetemp,dummy);
          if dummy <> 0 then ShowError(5,filestr);
          if ismins then timeleft := trunc(timetemp) else timeleft := trunc(timetemp/60.0);
          if timeleft < 10 then timeleft := 8 else Dec(timeleft,2);
          usetime := true;
          if timedone then timeleft := Min(timeleft,minmax - 2);
          timeleft := Min(timeleft,50);
          GetTime(hour,minute,second,hunsec)
        end
      else usetime := false;
      if getlines then             { get users screen size }
        begin
          Restart(lineline);
          while (gcstr[1] = ' ') and (length(gcstr) > 0) do Delete(gcstr,1,1);
          while (gcstr[length(gcstr)] = ' ') and (length(gcstr) > 0) do Delete(gcstr,length(gcstr),1);
          Val(gcstr,pagelength,dummy);
          if dummy <> 0 then ShowError(5,filestr);
          if pagelength > 24 then Dec(pagelength)
        end;
      if not (lockcomm or locklocal or lockIRQ) then
        begin                      { get communications port }
          Restart(comline);
          case gcstr[combyte] of
              '0' : setlocal := true;
              '1'..'4' :
                begin
                  dolocal := false;
                  if gcstr[combyte] in ['2','4'] then IRQnum := 3;
                  portnum := ord(gcstr[combyte]) - ord('1')
                end
            end
        end;
      case doextra of
          1 : DoRBBS;
          2 : DoWWIV;
          3 : DoWildCat;
          4 : Do2AM;
          5 : DoPhoenix;
          6 : DoSpitfire
        end;
      close(gcf)
    end;  {* GetCommand,ProcessText *}

  Procedure PROCESSFILE(      { process BBS system data file for user info }
      filestr   : pathstr;    { name of BBS system file }
      getname,                { username is in file indicator }
      getime,                 { user time remaining is in file indicator }
      getlines,               { user screen length is in file indicatior }
      ismins    : boolean;    { user time remaining is in minutes indicator }
      nameoff   : word;       { username offset }
      namesize  : byte;       { username string size }
      timeoff,                { user time offset }
      lineoff,                { user screen length offset }
      commoff,                { communication port offset }
      localkey  : word;       { local mode indicator value }
      doextra   : byte);      { extra processing switch }

    Procedure DOOPUS114;
    { get user's real name }
      begin {* GetCommand,ProcessFile,DoOpus114 *}
        move(gcbuffer[0],realname[1],36);
        realname[0] := chr(36);
        if Pos(#0,realname) > 0 then realname[0] := chr(Pos(#0,realname) - 1)
        else while realname[length(realname)] = ' ' do Dec(realname[0]);
        if length(realname) > 0 then
            if (length(username) = 0) then username := realname else usereal := true
      end;  {* GetCommand,ProcessFile,DoOpus114 *}

    begin {* GetCommand,ProcessFile *}
      if filedone then ShowError(7,'') else filedone := true;
      if length(gcstr) > 2 then
        begin
          delete(gcstr,1,2);
          if gcstr[1] = ':' then delete(gcstr,1,1);
          if not (gcstr[length(gcstr)] in [':','\']) then gcstr := gcstr + '\';
          filestr := gcstr + filestr;
          if not Valid(filestr) then ShowError(9,gcstr)
        end;
      if not Exist(filestr) then ShowError(4,filestr);
      assign(gcb,filestr);
      reset(gcb,1);
      blockread(gcb,gcbuffer,filesize(gcb),insize);
      close(gcb);
      if getname and not lockname then              { get users name }
        begin
          move(gcbuffer[nameoff],username[1],namesize);
          username[0] := chr(namesize);
          if Pos(#0,username) > 0 then username[0] := chr(Pos(#0,username) - 1)
          else while username[length(username)] = ' ' do Dec(username[0]);
          usename := true
        end
      else usename := false;
      if getime then               { get users time remaining }
        begin
          if ismins then move(gcbuffer[timeoff],timeleft,sizeof(word))
          else move(gcbuffer[timeoff],timetemp,sizeof(real));
          if not ismins then timeleft := trunc(timetemp/60.0);
          if timeleft < 10 then timeleft := 8 else Dec(timeleft,2);
          usetime := true;
          if timedone then timeleft := Min(timeleft,minmax - 2);
          timeleft := Min(timeleft,50);
          GetTime(hour,minute,second,hunsec)
        end
      else usetime := false;
      if getlines then             { get users screen size }
        begin
          move(gcbuffer[lineoff],pagelength,1);
          if doextra = 1 then Inc(pagelength,2);
          if pagelength > 24 then Dec(pagelength)
        end;
      if not (lockcomm or locklocal or lockIRQ) then
        begin                      { get communications port }
          if doextra = 1 then
            begin
              if (gcbuffer[localkey] or gcbuffer[localkey]) = 0 then setlocal := true
              else
                begin
                  dolocal := false;
                  if gcbuffer[commoff] in [1,3] then IRQnum := 3;
                  portnum := gcbuffer[commoff];
                end
            end
          else case char(gcbuffer[commoff]) of
              #0,'0','L' : setlocal := true;
              '1'..'4',#1..#4 :
                begin
                  dolocal := false;
                  if char(gcbuffer[commoff]) in [#2,#4,'2','4'] then IRQnum := 3;
                  if gcbuffer[commoff] in [1..4] then portnum := gcbuffer[commoff] - 1
                  else portnum := gcbuffer[commoff] - ord('1')
                end
            end
        end;
      case doextra of
          1 : DoOpus114
        end
    end;  {* GetCommand,ProcessFile *}

  Procedure DoPCBoard12(filestr : pathstr);
  { Process drop file from PCBoard 12.x and Auntie BBS }
    var
      pctime : real;
      pcmask : array [1..6] of byte absolute pctime;

    { PC Board times are in seconds stored as 4 byte reals (QBasic I think)
      they must be converted into Turbo Pascal 6 byte reals, before being
      converted into longint. }

    begin {* GetCommand,DoPCBoard12 *}
      if filedone then ShowError(7,'') else filedone := true;
      if length(gcstr) > 2 then
        begin
          delete(gcstr,1,2);
          if gcstr[1] = ':' then delete(gcstr,1,1);
          if not (gcstr[length(gcstr)] in [':','\']) then gcstr := gcstr + '\';
          filestr := gcstr + filestr;
          if not Valid(filestr) then ShowError(9,gcstr)
        end;
      if not Exist(filestr) then ShowError(4,filestr);
      assign(gcb,filestr);
      reset(gcb,1);
      blockread(gcb,gcbuffer,filesize(gcb),insize);
      close(gcb);
      move(gcbuffer[14],username[1],25);
      username[0] := chr(25);
      if Pos(#0,username) > 1 then username[0] := chr(Pos(#0,username) - 1)
      else while username[length(username)] = ' ' do Dec(username[0]);
      usename := true;
{ convert stored real format to Turbo Pascal real format }
      pcmask[1] := gcbuffer[79];
      pcmask[2] := $00;
      pcmask[3] := $00;
      pcmask[4] := gcbuffer[76];
      pcmask[5] := gcbuffer[77];
      pcmask[6] := gcbuffer[78];

      timeleft := trunc(pctime/60.0); { covert real seconds to word minutes }
      if timeleft < 10 then timeleft := 8 else Dec(timeleft,2);
      usetime := true;
      if timedone then timeleft := Min(timeleft,minmax - 2);
      timeleft := Min(timeleft,50);
      GetTime(hour,minute,second,hunsec);
      if not (lockcomm or locklocal or lockIRQ) then
          if gcbuffer[10] = ord('L') then setlocal := true
    end;  {* GetCommand,DoPCBoard12 *}

  Procedure DOSEARCHLIGHT;
    { get path to the door directory from command line }
    var
      sldir  : dirstr;
      slname : namestr;
      slext  : extstr;

    begin {* GetCommand,DoSearchLight *}
      if filedone then ShowError(7,'') else filedone := true;
      FSplit(paramstr(0),sldir,slname,slext);
      gamepath := sldir
    end;  {* GetCommand,DoSearchLight *}

  Procedure GETCOMPORT;
  { set communications port by command line directive }
    begin {* GetCommand,GetComPort *}
      lockcomm := true;
      if locklocal then ShowError(16,'');
      dolocal := false;
      if (gcstr[length(gcstr)] in ['1'..'4']) then portnum := ord(gcstr[length(gcstr)]) - ord('1')
      else ShowError(13,'')
    end;  {* GetCommand,GetComPort *}

  Procedure GETIRQINFO;
  { set IRQ and port information by command line directive }
    var
      IRQerror : word;

    begin {* GetIRQInfo *}
      lockIRQ := true;
      if locklocal then ShowError(16,'');
      dolocal := false;
      delete(gcstr,1,1);
      if gcstr[1] = ':' then delete(gcstr,1,1);
      if upcase(gcstr[1]) in ['0'..'9','A'..'F'] then
        begin
          IRQnum  := ord(gcstr[1]) and 15;
          if upcase(gcstr[1]) in ['A'..'F'] then Inc(IRQnum,9);
          portint := IRQarray[IRQnum];
          initval := initarray[IRQnum];
          delete(gcstr,1,1);
          if gcstr[1] = ':' then delete(gcstr,1,1) else ShowError(17,'')
        end
      else ShowError(17,'');
      if length(gcstr) <> 4 then ShowError(17,'');
      Val('$'+gcstr,portadd,IRQerror);
      if IRQerror > 0 then ShowError(18,gcstr)
    end;  {* GetIRQInfo *}

  Procedure GETHOFLIM;
  { limit player Hall of Fame appearances }
    var
      error : word;

    begin {* GetCommand,GetHofLim *}
      if length(gcstr) < 3 then ShowError(2,'');
      delete(gcstr,1,2);
      if gcstr[1] = ':' then delete(gcstr,1,1);
      Val(gcstr,hoflim,error);
      if error > 0 then ShowError(11,'');
      if not (hoflim in [1..19]) then ShowError(12,'')
    end;  {* GetCommand,GetHofLim *}

  Procedure GETHOF;
  { redirect text Hall of Fame output }
    begin {* GetCommand,GetTimeLimit *}
      hofdone := true;
      if length(gcstr) < 3 then ShowError(2,'');
      delete(gcstr,1,2);
      if gcstr[1] = ':' then delete(gcstr,1,1);
      if (pos('.',gcstr) = 0) then
        begin
          if (gcstr[length(gcstr)] in [':','\']) then
              gcstr := gcstr + inhof
          else gcstr := gcstr + '\' + inhof
        end;
      if not Valid(gcstr) then ShowError(8,'')
      else texthof := gcstr
    end;  {* GetCommand,GetTimeLimit *}

  Procedure GETTIMELIMIT;
  { set maximum time limit }
    begin {* GetCommand,GetTimeLimit *}
      timedone := true;
      if length(gcstr) < 3 then ShowError(2,'');
      delete(gcstr,1,2);
      if gcstr[1] = ':' then delete(gcstr,1,1);
      val(gcstr,minmax,dummy);
      if dummy <> 0 then ShowError(8,'');
      if filedone then timeleft := Min(timeleft,minmax - 2)
      else
        begin
          usetime := true;
          timeleft := Min(minmax - 2,50);
          GetTime(hour,minute,second,hunsec)
        end
    end;  {* GetCommand,GetTimeLimit *}

  Procedure DOPORTS;
  { use default IRQ and port information for communications }
    begin {* GetCommand,DoPorts *}
      portadd := portarray[portnum];
      portint := IRQarray[irqnum];
      initval := initarray[irqnum]
    end;  {* GetCommand,DoPorts *}

  Procedure GETAGAIN;
  { get multiple play parameters }
    var
      error : word;

    begin {* GetCommand,GetAgain *}
      doagain := true;
      delete(gcstr,1,2);
      if gcstr[1] = ':' then delete(gcstr,1,1);
      If length(gcstr) > 0 then
        begin
          Val(gcstr,againtime,error);
          if error > 0 then ShowError(19,'');
          if againtime < 5 then ShowError(20,'')
        end
      else againtime := 10
    end;  {* GetCommand,GetAgain *}

  Procedure GETNAME;
    var
      gloop : byte;

    begin {* GetCommand,GetName *}
      delete(gcstr,1,2);
      if gcstr[1] = ':' then delete(gcstr,1,1);
      if length(gcstr) > 0 then
        begin
          lockname := true;
          usename := true;
          username := gcstr;
          for gloop := 1 to length(username) do if username[gloop] = '_' then
              username[gloop] := ' '
        end
    end;  {* GetCommand,GetName *}

{ slash '/' switches }
{    active switches :  12 4567 9ABCD F HI KLMNOPQRST VWXYZ }
{  reserved switches : 0  3    8       G             U      }
{ available switches :               E    J                 }
{   program switches : +-][=. }

{ dash '-' switches } { unused at this point }
{    active switches :                                      }
{  reserved switches :                                      }
{ available switches : 0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ }


  begin {* GetCommand *}
    usetime  := false;       { default - no time limit }
    usename  := false;       { default - no user name }
    usereal  := false;       { default - only know alias }
    pagelength := 24;        { default - 24 line screen }
    timexp   := false;       { set time to not expired }
    if paramcount > 7 then ShowError(1,'');
    for gloop := 1 to paramcount do
      begin
        gcstr := paramstr(gloop);
        if (gcstr[1] <> '/') or (length(gcstr) < 2) then ShowError(2,'');
        case upcase(gcstr[2]) of
{PCBoard12x}'1' : DoPCBoard12('PCBoard.Sys');
{2 A.M.}    '2' : ProcessText('Jumper.Dat',  true,true,false,true,  5, 8, 0, 9,4,4);
{Opus 1.13} '3' : ShowError(3,'Opus-CBCS 1.13 ');
{WWIV,TG}   '4' : ProcessText('Chain.Txt',   true,true,true, false, 2,16,10,21,1,2);
{RyBBS}     '5' : ProcessText('CurrUser.BBS',true,true,false,true,  1,13, 0, 6,1,0);
{Spitfire}  '6' : ProcessText('SFDoors.Dat', true,true,false,true,  2, 7, 0, 6,1,6);
{Auntie}    '7' : DoPCBoard12('Auntie.Sys');
{Sapphire}  '8' : ShowError(3,'Sapphire BBS ');
{SeachLight}'9' : DoSearchLight;
{XBBS}      '0' : ShowError(3,'XBBS ');
{DrWy,GT}   'D' : ProcessText('Door.Sys',    true,true,false,true,  1, 4, 0, 2,1,0);
{Forum}     'F' : ProcessText('UserInfo.Txt',true,true,false,false, 1, 4, 0, 5,1,0);
{Genesis}   'G' : ShowError(3,'Genesis ');
{Phoenix}   'H' : ProcessText('Info.Txt',    true,true,false,true,  1, 7, 0, 3,1,5);
{ModuleX}   'M' : ProcessText('Number.Txt',  true,true,false,false, 1, 4, 0, 5,1,0);
{PCBoard14x}'P' : ProcessFile('PCBoard.Sys', true,true,false,true ,84,25,61, 0,125,18,0);
{GAP,Force} 'S' : ProcessText('Door.Sys',    true,true,true, true, 10,19,21, 1,4,0);
{UBBS}      'U' : ShowError(3,'UBBS ');
{WildCat}   'W' : ProcessText('CallInfo.BBS',true,true,true, true,  1, 5,23,29,4,3);
{Opus 1.14} 'O' :
              begin
                if (length(gcstr) > 3) and (upcase(gcstr[3]) in ['0'..'9','A'..'F'])
                    and (upcase(gcstr[4]) in ['0'..'9','A'..'F']) then
                  begin
                    opchs := Copy(gcstr,3,2);
                    delete(gcstr,3,2);
                    ProcessFile('LastUS'+opchs+'.Dat',true,true,true,true,104,32,1030,173,1026,1024,1)
                  end
                else ProcessFile('LastUser.Dat',true,true,true,true,104,32,1030,173,1026,1024,1)
              end;
{EIS-PC}    'R' :
{FoReM}       begin  { Get node number }
{OLEcom}        if (length(gcstr) > 2) and (gcstr[3] in ['0'..'9']) then
{QuickBBS}        begin
{RBBS}              inchar := gcstr[3];
{Remote Access}     delete(gcstr,3,1);
{TAG}               ProcessText('DorInfo'+inchar+'.Def',true,true,false,true,7,12,0,4,4,1)
{TP-Board}        end
                else ProcessText('DoorInfo.Def',true,true,false,true,7,12,0,4,4,1)
              end;

{Local}     'L' : if locklocal then ShowError(7,'') else locklocal := true;
{lockcomm}  'C' : if lockcomm or lockIRQ then ShowError(7,'')
                else if not setlocal then GetComPort;
{lockIRQ}   'I' : if lockcomm or lockIRQ then ShowError(7,'')
                else if not setlocal then GetIRQInfo;

{doagain}   'A' : if doagain then ShowError(7,'') else GetAgain;
{baudlock}  'B' : if baudlock then ShowError(7,'') else baudlock := true;
{getname}   'N' : if lockname then ShowError(7,'') else GetName;
{checkcd}   'K' : if not checkcd then ShowError(7,'') else checkcd := false;
{doquiet}   'Q' : if doquiet then ShowError(7,'') else doquiet := true;
{hoflim}    'X' : if hoflim < 20 then ShowError(7,'') else GetHofLim;
{hofpath}   'Y' : if hofdone then ShowError(7,'') else GetHOF;
{timelimit} 'Z' : if timedone then ShowError(7,'') else GetTimeLimit
            else if gcstr[1] in programset then  { program defined symbols }
              begin
                case gcstr[1] of
                    '+' : if plusindex = 0 then plusindex := gloop else ShowError(7,'');
                    '-' : if minusindex = 0 then plusindex := gloop else ShowError(7,'');
                    ']' : if closeindex = 0 then plusindex := gloop else ShowError(7,'');
                    '[' : if openindex = 0 then plusindex := gloop else ShowError(7,'');
                    '=' : if equalindex = 0 then plusindex := gloop else ShowError(7,'');
                    '.' : if dotindex = 0 then plusindex := gloop else ShowError(7,'')
                  end
              end
            else ShowError(2,'')
          end
      end;
    if locklocal and (lockcomm or lockIRQ) then ShowError(16,'');
    if locklocal or setlocal then dolocal := true;
    doecho := not dolocal;
    if not (dolocal or lockIRQ) then DoPorts;
    if not hofdone then texthof := gamepath + inhof
  end;  {* GetCommand *}

end. Unit


Text Data Files
  BBS System      SynData File    type   Name  Real  Time  Line  Comm  Local
x 2 A.M. BBS         Jumper.Dat   text    5+6    3     8m  ----   9,4  ----
x DoorWay          2 Door.Sys     text      1  ----    4m  ----   2,1  ----
x EIS-PC           3 DorInfo#.Def text    7+8  ----   12m  ----   4,4  ----
x Force BBS        1 Door.Sys     text     10  ----   19m   21    1,4  ----
x FoReM            3 DorInfo#.Def text    7+8  ----   12m  ----   4,4  ----
x Forum            4 UserInfo.Txt text      1  ----    4s  ----   5,1   5,L
x GAP              1 Door.Sys     text     10  ----   19m   21    1,4  ----
  Genesis            CallInfo.BBS text      1  ----    5m   23    ???  28,L
x GT               2 Door.Sys     text      1  ----    4m  ----   2,1  ----
x ModuleX          4 Number.Txt   text      1  ----    4s  ----   5,1   5,L
x OLEcom           3 DorInfo#.Def text    7+8  ----   12m  ----   4,4  ----
x Phoenix            Info.BBS     text      1  ----    7m  ----   3,1   2,L
x Quick BBS        3 DorInfo#.Def text    7+8  ----   12m  ----   4,4  ----
x RBBS             3 DorInfo#.Def text    7+8  ----   12m  ----   4,4  ----
x Remote Acces     3 DorInfo#.Def text    7+8  ----   12m  ----   4,4  ----
x RyBBS              CurrUser.BBS text      1  ----   13m  ----   6,1  ----
x Spitfire BBS       SFDoors.Dat  text      2  ----    7m  ----   6,1  ----
x TAG              3 DorInfo#.Def text    7+8  ----   12m  ----   4,4  ----
x TP-Board         3 DorInfo#.Def text    7+8  ----   12m  ----   4,4  ----
x WildCat            CallInfo.BBS text      1  ----    5m   23   29,4  28,L
x WWIV               Chain.Txt    text      2    3    16s   10   21,1  15,0
x Telegard         x Can emulate most of the above

Binary Data Files
  BBS System      SynData File    type   Name  Real  Time  Line  Comm  Local
- Auntie BBS       5 Auntie.Sys   b128   14n25 ----   76c  ----  ----  10,L
  OPUS-CBCS 1.13     LastUser.BBS b128    0l   ----   ???  123   ????  ????
- OPUS-CBCS 1.14     LastUsXX.Dat b     104n32 0n36 1030mw 173  1026w  ----
- PCBoard 12.x     5 PCBoard.Sys  b128   14n25 ----   76c  ----  ----  10,L
x PCBoard 14.x       PCBoard.Sys  b128   84n25 ----   61mw ----  125c  18,L
  Sapphire BBS       Sapphire.Dat b545    0l   ----   ???   87   ????  ????

Command Line Driven
x Search Light BBS

Unknown Data Files
  UBBS
  XBBS

x in use
- beta stage

m minutes
s seconds

r real
i integer
w word
c char


2 A.M., Auntie BBS, DoorWay, EIS-PC, Force BBS, FoReM, Forum, GAP, GT,
ModuleX, OLEcom, Opus-CBCS 1.14, PCBoard 12.x, PCBoard 14.x, Phoenix,
Quick BBS, RBBS, Remote Access, RyBBS, SearchLight BBS, Spitfire BBS,
TAG, Telegard, TP-Board, WildCat, WWIV.
/**/
/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/
/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/
/*%                                                                       %*/
/*%                     U S E R   D A T A B A S E                         %*/
/*%                                                                       %*/
/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/
/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/
/*                                                                         */
/* The user data base consists of two files: a data file (USER.DAT) and a  */
/* matching index file (USER.IDX).  The data file is a direct access file  */
/* with fixed length, 1 kb records, one for each user.  The index contains */
/* one computed, 4-byte CRC value for each user name.                      */
/*                                                                         */
/* Access to the user database can be done sequentially on the main data   */
/* file or by keyed access by computing the special CRC value of the       */
/* desired user name, looking up that value in the index file, and then    */
/* by seeking the positionally correspondent record in the main file.      */
/*                                                                         */
/* WARNING:                                                                */
/*                                                                         */
/* Any changes made to user names or the number, or order, of user records */
/* will put the index into an unsynchronized state that may result in      */
/* undefined and potentially dangerous problems unless the index is        */
/* updated or rebuilt by the utility.  One way of doing this is to run     */
/* the oIndex program after such changes to properly rebuild the index.    */
/*                                                                         */
/* WARNING:                                                                */
/*                                                                         */
/* Any changes to a user record made by an external utility that is        */
/* operating independently in another partition or work-station while      */
/* that user is online will be overwritten when Opus updates the user      */
/* record with its own working copy of it.                                 */
/*                                                                         */
/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/
/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/


   #define MAXLREAD 0x100  /* Number of msg area pointers to maintain      */

   struct   _usr
   {
n   0  35      char name[36];       /* Caller's first and last names                */
   36  71      char city[36];       /* Caller's location                            */
   72  87      char pwd[16];        /* Password                                     */
   88 103      char usrtel[16];     /* User Tel# for ref or future callback         */
a 104 135      char alias[32];      /* User alias if ID is not it                   */
  136 137      word times;          /* Number of previous calls to this system      */
  138          byte ClassPriv;      /* User Access Privilege                        */
  139          byte help;           /* Help level (see below)                       */
  140          byte tabs;           /* 0=transmit <sp> instead of <tab>             */
  141          byte language;       /* Lang set no. (1-6) as defined in .PRM file.  */
  142 143      word nulls;          /* Number of Nulls (delays) after <cr>          */
  144 145      word msg;            /* Last message area accessed                   */
  146 147      word Bits;           /* User option flags (See Below)                */

      /* Each of the 32 bits within the following 4-byte (long) item       */
      /* represents a single user 'key'.   To have access to any Opus      */
      /* function that has any of 32 'lock' bits set for it, there has to  */
      /* be at least the matching key bits set in this item.  Having other */
      /* key bits sit does not matter.                                     */
      /*                                                                   */
      /* For maintenance and discussion, key and lock bits are referred to */
      /* by the characters A-Z and 0-5 where 'A' is bit 0 (least           */
      /* significant) and '5' refers to bit 31 (most significant).         */

  148 151      long ClassLock;      /* 32 User 'Keys'                               */
                           /* Each bit of this long object corresponds to  */
                           /* each of 32 possible user 'keys' which are    */
                           /* referred to by the character (A-Z,0-5) where */
                           /* the least significant) bit is called 'A' and */
                           /* the most significant nit is called '5'.      */

  152 155      long ludate;         /* Date of user's Last Call to system expressed */
                           /* as seconds since 01-Jan-70 in GMT/UTC time.  */

  156 157      int  time;           /* Time on-line so-far today                    */

  158 159      word flag;           /* User file management flags (see below)       */

  160 163      long upld;           /* Total kilobytes uploaded to date.            */
  164 167      long dnld;           /* Total kilobytes downloaded to date.          */
  168 171      int  dnldl;          /* Total kilobytes downloaded last/current call */
  172 173      word files;          /* Last file area accessed                      */
x 174          byte width;          /* Width of the caller's monitor                */
y 175          byte len;            /* Height of the caller's                       */
  176 177      word credit;         /* FidoNet usage credit in cents                */
  178 179      word debit;          /* FidoNet usage in cents                       */

  180 187      char spcoec[8];      /* Special OECC to show after logon             */
                           /* Good for clubs, stores, user groups          */
                           /* Eg, "Welcome to the dBase User Group"        */

  188 192      byte saccnt[5];      /* Array of 5 counters which correspond to the  */
                           /* files SPANN#.BBS which reside on the path    */
                           /* given by 'spcldir' in the .PRM file. If any  */
                           /* is > 0 than the user is shown the matching   */
                           /* announcement and is decremented.  When 0, it */
                           /* is no longer displayed.                      */

  193          byte exflag;         /* Expiration behavior flags (see below)        */

  194 197      long xdate;          /* Expiry date always rounded to (0000 hrs) and */
                           /* as secs since 01-Jan-70 in *LOCAL* time for  */
                           /* reasons of cross-zone accounting equivelnce. */

  198 202      long crmin;          /* Total minutes given to user                  */
  203 206      long dbmin;          /* Total minutes used  by user                  */

  207 238      char ulikes[32];     /* Reserved for future feature                  */
  239 242      long fudate;         /* First Call Date(secs since 01-Jan-70 UTC/GMT)*/

  243 258      byte reserved[16];   /* Filler, reserved.                            */

      /* The following item contains for each of the 256 possible areas,   */
      /* the last message number that the user read in that area.  A value */
      /* of zero means the area was not accessed by the user yet.          */

  259 260      word lastmsg[MAXLREAD];


  261 264      long OPUS_id;           /* Opus Record ID ... Must always be 'OPUS'  */


      /* The next 7 sets of 'id' and 'inf' data are for external utilities */
      /* that have been registered with OpusInfo to use for the storage    */
      /* and independent maintenance of auxiliary information.  The first  */
      /* (long) array of 7 items holds the registered ID's of utilities    */
      /* that make use of the 7 matching 32-byte data blocks that follow.  */
      /*                                                                   */
      /* Any utility may make use of any of the 7 data blocks providing    */
      /* they ensure that the desired blocks are not already used as would */
      /* be indicated by an ID in the matching ID positions.  If free,     */
      /* then the utility claims them by writing its registered ID in the  */
      /* matching ID positions.  It is up to the utility to ensure that    */
      /* enough positions are free in all of the user records that would   */
      /* potentially be accessed by it.                                    */
      /*                                                                   */
      /* Currently registered ID's ........................................*/
      /*                                                                   */
      /* 0x57555646 .. FVIEW ... File viewing utility by Doug Boone        */
      /* 0x4F4D414E .. OMAN  ... Opus system manager by Tom Kashuba        */


  265 271      long extern_id[7];      /* LONG ID number for external programs      */
                              /* Must be registered with OpusInfo          */

  272 495      byte extern_inf[7][32]; /* 7 32-byte external util data blocks       */
                           224
   };


/*-------------------------------------------------------------------------*/
/* 'Bits' -- User Option Flag Meanings                                     */
/*-------------------------------------------------------------------------*/

   #define  NO_IBMCHAR  0x0004 /* Cannot receive IBM textmode graphics     */
   #define  USE_LORE    0x0008 /* Wants LORE editor instead of OPed        */
   #define  MORE_PROMPT 0x0010 /* Wants the page break "MORE?" question    */
   #define  ANSI        0x0020 /* Can handle ANSI video                    */
   #define  CONFIG_SET  0x0040 /* OPUS logon questions answered            */
   #define  FORMFEED    0x0080 /* SET=xmit clearscreen, CLEAR=eat formfeed */
   #define  AVATAR      0x0100 /* Can handle AVATAR (aka "oANSI") video    */

   #define  USE_PHONE   0x0400 /* User Modem Tel# to Call Back    (future) */
   #define  USE_ALIAS   0x0800 /* Use ALIAS in var user functions (future) */

   #define  NO_NAME     0x1000 /* Don't List User's Name in User List      */
   #define  NO_TIME     0x2000 /* Don't List User's Last-On in User List   */
   #define  NO_CITY     0x4000 /* Don't List User's City in User List      */

   #define  CURSOR_CONTROL (ANSI|AVATAR)


/*-------------------------------------------------------------------------*/
/* 'flag' -- User file management flags                                    */
/*                                                                         */
/* These flags are used by the user file manager within oMan to control    */
/* the reuse and deletion of user records.  External utilities may use     */
/* then as long as they folow the conventions established by oMan.         */
/*                                                                         */
/*-------------------------------------------------------------------------*/

   #define REUSE       0x0001    /* Re-use rec for next new caller         */
   #define PURGE       0x0002    /* Remove record in next OMAN Pack        */
                                 /* All other bits currently reserved      */

/* The following value is used as a mask to cover all of the 8 separate    */
/* bit values in range 0x0100-0x8000.  They each represent a 'group tag'   */
/* as implemented in the Opus user manager, oMan, and are referred to by   */
/* the letters 'A' (0x0100) through 'H' (0x8000).  Group tags are benign   */
/* markers that are for the covenience of user record maintenance and are  */
/* used by the user manager only.                                          */

   #define GRPTAGS     0xFF00


/*-------------------------------------------------------------------------*/
/* 'help' -- User help levels (menu style)                                 */
/*-------------------------------------------------------------------------*/

   #define TOTMDL         4      /* Total menu detail levels               */

   #define HITECH      0x00      /* 1-line, top-of-screen, bar-style menus */
   #define EXPERT      0x02      /* No text at all, just a prompt          */
   #define REGULAR     0x04      /* Lists menu option letters only.        */
   #define NOVICE      0x06      /* Full menu command titles listed.       */

/* #define USING_FTB   0xFF */   /* Old mode.  Not supported in 1.10.      */


/*-------------------------------------------------------------------------*/
/*  'exflag' -- Flags dealing with user expiration control                 */
/*-------------------------------------------------------------------------*/
/* These definitions are the bit values of the 'exflag' flags item which   */
/* determine the type and handling of user expiration.  The values of      */
/* ExpByDate and ExpByDate set the type of expiration, if any.  The values */
/* of ExpDemote and ExpAxe determine how to handle expired users.          */
/*-------------------------------------------------------------------------*/

   #define EXPBYDATE   0x01  /* Expire user by date.  That is, consider    */
                             /* them as expired when they log on AFTER the */
                             /* date stored in 'xdate'.                    */

   #define EXPBYMINS   0x02  /* Expire user by minutes of usage.  That is, */
                             /* consider them as expired when the minutes  */
                             /* they have used thus far (crmin) exceeds    */
                             /* the minutes they were alotted (dbmin).     */

   #define EXPDEMOTE   0x10  /* If user is expired, reduce their privilege */
                             /* to TWIT or, if set, to the demote value    */
                             /* set in the PRM file.                       */

   #define EXPAXE      0x20  /* If user is expired, disconnect them.       */






/**/
/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/
/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/
/*%                                                                       %*/
/*%                  L A S T   U S E R   R E C O R D                      %*/
/*%                                                                       %*/
/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/
/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/
/*%                                                                       %*/
/*%  The "LASTUSER" record is a single record file that is written to     %*/
/*%  disk after a user logs off and just prior to every time that Opus    %*/
/*%  does an external exit.  The file contains a copy of the user's       %*/
/*%  record (in its entirety) along with an extended data block that      %*/
/*%  contains additional environmental information that is useful to      %*/
/*%  external programs.                                                   %*/
/*%                                                                       %*/
/*%  An option in the PRM file optionally allows the user record portion  %*/
/*%  of the file to read back into Opus, overlaying the live copy in      %*/
/*%  memory.  This is extremely powerful and DANGEROUS in that the user's %*/
/*%  profile can be updated (or damaged) dynamically!                     %*/
/*%                                                                       %*/
/*%  The last user file name is formatted as LASTUS##.DAT where '##'      %*/
/*%  is the task number (expressed as hexadecimal) of the running Opus.   %*/
/*%  The task number, being one of several arguments passed to the        %*/
/*%  program, allows it to properly compose the LASTUSER file name so it  %*/
/*%  can open and process it.  Once accessed, all of its data is          %*/
/*%  available for use by the program.                                    %*/
/*%                                                                       %*/
/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/
/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/

   struct _lu_file
   {
    0 495      struct _usr user;    /* Copy of user record                          */
  496 497      word   baud;         /* Current user's baud (0 == keyboard!)         */
c 498 499      word   port;         /* Current port #                               */
  500 501      word   task;         /* Active task number                           */
m 502 503      word   mins;         /* User's minutes remaining                     */
  504 505      word   msgarea;      /* Which message area user is in                */
  506 507      word   filearea;     /* Which file area user is in                   */

  508 511      long   timeoff;      /* Date/Time that caller's session must end by. */
                           /* As secs since 01-Jan-70 UTC/GMT              */

      struct tm tmoff;     /* MS-C 'tm' struct of above but as local time  */

      char   laston[25];   /* Orig Last Call Date as ASCIIZ string because */
                           /* same field in user rec is curr logon time    */
   };



alias          104..135 /0
a 104 135      char alias[32];      /* User alias if ID is not it                   */
name             0.. 35 /0
n   0  35      char name[36];       /* Caller's first and last names                */
time (minutes) 502..503 word minutes
m 502 503      word   mins;         /* User's minutes remaining                     */
lines          175      byte
y 175          byte len;            /* Height of the caller's                       */
comm           498..499 word ?????
c 498 499      word   port;         /* Current port #                               */
