{$D-}  { Debug Information Off }
{$S-}  { Stack Checking Off    }
{$V-}  { String Checking Off   }

Unit BOIDecl;
{ Part of BBS Onliner Interface }
{ Copyright (C) 1990 Andrew J. Mead
  All Rights Reserved. }

{ original version 10/20/90
  history found in IOLIB.PAS }

INTERFACE

Uses
  DOS;

Const
  InterfaceVersion = '1.20';     { Interface Version Number }

  { Implement ANSI color codes, second number is TP CRT code }

  { Foreground and background color constants }
  Black         = 30; { 0}  { ANSI background constants are 10 greater than }
  Blue          = 34; { 1}  { the foreground constants.  PortBackground adds }
  Green         = 32; { 2}  { 10 to the value passed. }
  Cyan          = 36; { 3}
  Red           = 31; { 4}
  Magenta       = 35; { 5}
  Brown         = 33; { 6}
  LightGray     = 37; { 7}

  { Foreground color constants }
  DarkGray      = 80; { 8}  { ANSI uses an intesity parameter. 50 has been }
  LightBlue     = 84; { 9}  { added to each of the constants.  TextPortColor }
  LightGreen    = 82; {10}  { strips the 50 off and also sends the intesity }
  LightCyan     = 86; {11}  { code. }
  LightRed      = 81; {12}
  LightMagenta  = 85; {13}
  Yellow        = 83; {14}
  White         = 87; {15}

  { Add-in for blinking }
  Blink         = 100; {128}

Const
  docolor    : boolean = false;            { use color indicator }
  dolocal    : boolean = true;             { local mode indicator }
  doecho     : boolean = false;            { echo info locally indicator }
  doquiet    : boolean = false;            { supress local bell ringing }
  baudlock   : boolean = false;            { modem has locked baud rate }
  doagain    : boolean = false;            { allow multiple play }
  setfunction: boolean = false;            { character input is extended code }
  checkcd    : boolean = true;             { use carrier detect routines }
  againtime  : word    = 10;               { time minimum for Again play }
  portadd    : word    = $03F8; { Com1 }   { serial port address }
  portnum    : word    = 0;     { Com1 }   { serial port number (absolute) }
  portint    : word    = $0C;   { IRQ4 }   { serial port interrupt vector }
  initval    : byte    = $EF;   { IRQ4 }   { 8259A port initialization value }

  hoflim     : byte    = 20;    { maximum entries by one player in HOF }
  gamepath   : pathstr = '';               { path to game and game files }

  plusindex  : byte    = 0;     { GetCmBBS places ParamStr index value in }
  minusindex : byte    = 0;     { the given variable.  These are the main }
  equalindex : byte    = 0;     { program definable variables.  The program }
  closeindex : byte    = 0;     { must perform any further processing on }
  openindex  : byte    = 0;     { these switches. }
  dotindex   : byte    = 0;

Type
  str39      = string [39];
  charset    = set of char;

Var
  pagelength : byte;        { size of screen in lines }
  username   : str39;       { player's name - if available }
  usename    : boolean;     { availability of users name }
  realname   : str39;       { player's real name (not alias) - if available }
  usereal    : boolean;     { availability of real name }
  timeleft   : integer;     { playing time - if available }
  usetime    : boolean;     { use playing time indicator }
  hour       : word;        { hour at initialization }
  thishour   : word;        { current hour }
  minute     : word;        { minute at initialization }
  thismin    : word;        { current minute }
  second     : word;        { time input variable - unused }
  hunsec     : word;        { time input variable - unused }
  extraword  : word;        { reserved }
  timexp     : boolean;     { time expired indicator }
  texthof    : pathstr;     { text hall of fame filename }

IMPLEMENTATION

end.  Unit
