  
' Modify brightness.
' Modify brightness of input image, for 4 & 8 bit image modify only palette.
' Use an R/G/B * f formula, it could be also R/G/B / f +off (es: red / .60 + 102)

' Input:	4-8-24 bit
' Output:	4-8-24 bit

' Author:	Andrea Benoni			 rev:	1.2


string	inpFile,outFile
DevCon	Ibmp,Obmp
RGB	pix
float  	x,y,L

L=1.4			' Icrease brightness factor
inpFile="testi.bmp"
outFile="testo.bmp"

Ibmp=LoadImage(inpFile)

if((Ibmp.BitCount=8)	|(Ibmp.BitCount=4))		' if 4 or 8 bit modify palette			
  For y=0 to 255
     pix=GetPalette(Ibmp,y)
     pix.Red=min(pix.Red*L,255) 		' modify RGB
     pix.Green=min(pix.Green*L,255)
     pix.Blue=min(pix.Blue*L,255)
     SetPalette(Ibmp,y,pix)
  Next y
  Preview(Ibmp,"Output",5,5,Ibmp.Width+10,Ibmp.Height+30)	
  SaveImage(Ibmp,outFile)
  DspMes("End")
  Return
Endif

Obmp=CreateImage(Ibmp.Width,Ibmp.Height,24)

For y=0 to Ibmp.Height-1
   For x=0 to Ibmp.Width-1
      pix=GetPixel(Ibmp,x,y)
      pix.Red=min(pix.Red*L,255) 		' modify RGB
      pix.Green=min(pix.Green*L,255)
      pix.Blue=min(pix.Blue*L,255)
      SetPixel(Obmp,x,y,pix)
   Next x
   if(y%10=0)
      Preview(Obmp,"Output",5,5,Obmp.Width+10,Obmp.Height+30)	
   endif
Next y
SaveImage(Obmp,outFile)
DspMes("End")