b  
' Lake.
' Reflect input image on a simulated lake.
' For a better result use a 24 bit output.

' Input:	4-8-24 bit
' Output:	4-8-24 bit (24 reccomended)

' Author:	Andrea Benoni			rev:	1.2


string	inpFile
DevCon	Ibmp,Obmp
RGB	pix
float  	x,y,lev,L,Px,Py

inpFile="testi.bmp"
Ibmp=LoadImage(inpFile)
Obmp=CreateImage(Ibmp.Width,Ibmp.Height*.8,Ibmp.BitCount)
					' or substitute Ibmp.BitCount with 24

if((Ibmp.BitCount=8)	|(Ibmp.BitCount=4))		' if 4 or 8 bit copy palette			
  For y=0 to 255
     pix=GetPalette(Ibmp,y)
     SetPalette(Obmp,y,pix)
  Next y
Endif

Px=3.14*12/Ibmp.Width
Py=3.14*12/Ibmp.Height
lev=5


pix.Lum=0		' Copy upper half image
For y=0 to Obmp.Height*.6
   For x=0 to Ibmp.Width
      pix=GetPixel(Ibmp,x,y)
      SetPixel(Obmp,x,y,pix)
   Next x
   if(y%10=0)
      Preview(Obmp,"Out",5,5,Obmp.Width+10,Obmp.Height+30)
   endif
Next y

For y=0 to Ibmp.Height*.5-3
   For x=0 to Ibmp.Width
      L=lev*sin(y*Py)*cos(x*Px)
      pix=GetPixel(Ibmp,x,y)
      pix.Red=pix.Red*.6
      pix.Green=pix.Green*.6
      pix.Blue=pix.Blue
      SetPixel(Obmp,x,Obmp.Height-(y*.7)-L-1,pix)
      SetPixel(Obmp,x,Obmp.Height-(y*.7)-L,pix)
   Next x
   if(y%3=0)
      Preview(Obmp,"Out",5,5,Obmp.Width+10,Obmp.Height+30)
   endif
Next y
Preview(Obmp,"Out",5,5,Obmp.Width+10,Obmp.Height+30)
DspMes("End")
