  
' Flag effect.
' Use cosin function to modify input image simulating a flag,
' using also y differential to modify brightness.
' For a better and faster result use a 24 bit output.

' Input:	4-8-24 bit
' Output:	4-8-24 bit (24 reccomended)

' Author:	Andrea Benoni			 rev:	1.2


string	inpFile,outFile
DevCon	Ibmp,Obmp
RGB	pix
float  	x,y,lev,L,OL,V,Px,Px

inpFile="testi.bmp"
outFile="testo.bmp"
lev=5
Ibmp=LoadImage(inpFile)
Obmp=CreateImage(Ibmp.Width,lev*2+Ibmp.Height,Ibmp.BitCount) 
				   ' or substitute Ibmp.BitCount with 24

if((Ibmp.BitCount=8)	|(Ibmp.BitCount=4))		' if 4 or 8 bit copy palette			
  For y=0 to 255
     pix=GetPalette(Ibmp,y)
     SetPalette(Obmp,y,pix)
  Next y
Endif

Px=3.14*6/Ibmp.Width

For y=0 to Ibmp.Height-1
   For x=0 to Ibmp.Width-1
      L=lev*cos(x*Px)			' calc y distorsion
      V=.70-(.30*(OL-L))			' calc differential
      OL=L
      pix=GetPixel(Ibmp,x,y)			' get input image pixel
      pix.Red=pix.Red*V			' modify color
      pix.Green=pix.Green*V
      pix.Blue=pix.Blue*V
      SetPixel(Obmp,x,y+L+lev,pix)		' put pixel on output
   Next x
   if(y%10=0)
      Preview(Obmp,"Output",5,5)
      DspWhile("Filtering",100/Ibmp.Height*y)
   endif
Next y
DspWhile("",0)
SaveImage(Obmp,outFile)
DspMes("End")