V  
' Pyramids.
' Blend the input image with a pattern of pyramids.
' For a better and faster result use a 24 bit output.
 
' Input:	4-8-24 bit
' Output:	24 bit

' Author:	Andrea Benoni			 rev:	1.2


string	inpFile,mskFile,outFile
DevCon	Ibmp,Mbmp,Obmp
RGB	pix
float  	x,y,L

inpFile="testi.bmp"
outFile="testo.bmp"
mskFile="triang.bmp"

Ibmp=LoadImage(inpFile)
Mbmp=LoadImage(mskFile)
Obmp=CreateImage(Ibmp.Width,Ibmp.Height,24)

For y=0 to Ibmp.Height-1
   For x=0 to Ibmp.Width-1
      pix=GetPixel(Mbmp,x,y)
      L=.50+(.50/255*pix.Lum)
      pix=GetPixel(Ibmp,x,y)
      pix.Red=pix.Red*L
      pix.Green=pix.Green*L
      pix.Blue=pix.Blue*L
      SetPixel(Obmp,x,y,pix)
   Next x
   if(y%4=0)
      Preview(Obmp,"Output",5,5,Obmp.Width+10,Obmp.Height+30)	
   endif
Next y
SaveImage(Obmp,outFile)
DspMes("Ok")
