  
' Carpet.
' Use sin and cosin function to simulate a undulatory surface.
' For a better and faster result use 24 bit output.
 
' Input:	4-8-24 bit
' Output:	8-24 bit

' Author:	Andrea Benoni			 rev:	1.2


string	inpFile
DevCon	Ibmp,Obmp
RGB	pix
float  	x,y,lev,offset,L,V,xi,yi,Px,Py

inpFile="testi.bmp"

Ibmp=LoadImage(inpFile)
Obmp=CreateImage(Ibmp.Height/2.5+Ibmp.Width,Ibmp.Height+(Ibmp.Width/4)+lev,Ibmp.BitCount)
				   ' or replace Ibmp.BitCount with 24

if((Ibmp.BitCount=8)	|(Ibmp.BitCount=4))
  For y=0 to 255
     pix=GetPalette(Ibmp,y)
     SetPalette(Obmp,y,pix)
  Next y
Endif

Px=3.14*8/Ibmp.Width
Py=3.14*8/Ibmp.Height
lev=5

For y=0 to Ibmp.Height
   offset=Ibmp.Height-y/3
   For x=0 to Ibmp.Width
      L=lev*sin(y*Py)*cos(x*Px)
      V=1-(.40/(lev*2)*(lev+L))
      pix=GetPixel(Ibmp,x,y)
      pix.Red=pix.Red*V
      pix.Green=pix.Green*V
      pix.Blue=pix.Blue*V
      xi=x+offset
      yi=y+lev+L+(x/4)
      SetPixel(Obmp,xi,yi,pix)
      SetPixel(Obmp,xi,yi+1,pix)
   Next x
   if(y%10=0)
      Preview(Obmp,"Out",5,5,Obmp.Width+10,Obmp.Height+30)
   endif
Next y
DspMes("Ok")
