' Area: F-QUICKBASIC 
'  Msg#: 283                                          Date: 06 Apr 94  23:33:01
'  From: Eric B. Ford                                 Read: Yes    Replied: No 
'    To: All                                          Mark:                     
'  Subj: 1/3 Neural Network Source Code
'
'Here's a small old Basic program to perform a simple back propagation neural
'network.  Note:  This isn't my code!  Whoever wrote it, I can't critize,
'because I never got around to writing one in Basic, but it's obviously old.

'If you start playing with this, here are a few suggestions...

'    1.  Use lots of trainging interations...  I typically use 5000 for my
'scientific work, just to see if a network is promising.  Also change the
'iteration counter to a long, so it can train alot longer.  I've removed the
'print statement for the "round", but I didn't want to post altered code, since
'it isn't mine.

'    2.  Feel free to modify it to use more hidden nodes.  I typically use
'between 10 and 100, but it depends on what your doing.


'    3.  Neural network scientists are famous for leaving computers on all
'weekend to train networks.  Once you've typed in a good bit of data and have a
'reasonable sized network (approx 25-75 hidden nodes), let it run all night.  I
'frequently do that all night. I even have Cray Y-MPs work on these for several
'hours!

'    4.  Add a feature to save a network, so you could pick up where you left
'off.  This way you could come back to promising nets. Also add something to
'load and save the training patterns, so you don't have to type them over and
'over.

'    5.  At this point email me about getting either C code or a few EXEs to
'work with.  If you've gotten this far, you may want to apply it to anything
'from handwriting recognition to stock market prediction.  NNs are currently
'being used for both and many other interesting things.

'If anyone's interested I have much more advanced C and C++ code.
'This progrma should be seen as a toy and learning tool, and not as something to
'do meaningful work with.  If you want to apply this, my C implementations are
'much more powerful and a lot faster.  I'm pretty experienced at this kind of
'stuff, so I should be able to help anyone interested in neural networks. I'm
'currently using similar techniques for:

'    1.  Long range navigation of planetary rovers in virtual reality
'    2.  Direct mail - predicting which households are likely to respond to a
'direct mail package 3.  Image processing - getting more detail of images from
'astronomical observatories
'    3.  Intel - Automating microchip manufacture.  Confidential


'As you old-timers know, I always was a Post-It advocate, but I don't know what
'the official view of Postit is now, so I'll just post the code.  Let me know if
'you have any questions!

1 DIM wout(10, 10), outa(10), win(10, 10), hidnet(10), OUTNET(10), DELTAOUT(10)
5 DIM INA(10), TARG(10), OEXAM(10, 10), IEXAM(10, 10), HIDA(10)
10 CLS
11 thrval = .4: REM default threshold value
14 PRINT "Enter # of INPUT neurons "; : GOSUB 950: nin = c
20 PRINT "Enter # of OUTPUT neurons "; : GOSUB 950: nout = c
30 PRINT "Enter # of training CASES "; : GOSUB 950: ncase = c
35 PRINT "Enter # of HIDDEN neurons "; : GOSUB 950: nhid = c
40 REM
110 GOSUB 6000
120 PRINT
130 PRINT "0. Exit"
140 PRINT "1. Set rate of learning (Default ="; : PRINT rate; : PRINT " )"
160 PRINT "2. re-enter pattern"
170 PRINT "3. Make a Prediction"
175 PRINT "4. START AGAIN"
177 PRINT "5. Train Network"
178 PRINT "6. New Threshold value (Default = "; : PRINT thrval; : PRINT " )"
180 PRINT
190 PRINT "What is your choice ";
200 GOSUB 950
211 IF c = 0 THEN 220
212 IF c = 1 THEN 270
213 IF c = 2 THEN 350
214 IF c = 3 THEN 430
215 IF c = 4 THEN 10
216 IF c = 5 THEN 360
217 IF c = 6 THEN 900
219 GOTO 120
220 PRINT
230 PRINT "Are you sure (0 to exit)  "
240 INPUT c
250 IF c = 0 THEN END ELSE 120
270 PRINT
280 PRINT "What is the new rate?"
290 INPUT rate
330 GOTO 120
350 PRINT
355 GOSUB 5000
360 PRINT "How many rounds of teaching?  "
370 INPUT c
380 FOR l = 1 TO c
385 PRINT "ROUND", l
390 GOSUB 1000
400 NEXT l
410 GOTO 120
430 GOSUB 4000
440 GOTO 120
900 INPUT "New threshold value ="; thrval: GOTO 120
950 REM keyboard input routine
960 c$ = INKEY$: IF c$ = "" THEN 960 ELSE 970
970 PRINT c$: c = VAL(c$): RETURN
1000 REM
1010 FOR I1 = 1 TO ncase
1015 FOR J1 = 1 TO nin
1020 INA(J1) = IEXAM(I1, J1)
1030 NEXT J1
1040 FOR K1 = 1 TO nout
1050 TARG(K1) = OEXAM(I1, K1)
1060 NEXT K1
1065 GOSUB 8000
1070 NEXT I1
1990 RETURN
4000 REM
4010 FOR i = 1 TO nin: PRINT "Enter value of neuron  ", i: GOSUB 950: INA(i) =_
c: NEXT i
4020 GOSUB 7000
4030 REM ouput neuron values
4050 FOR j = 1 TO nout
4060 PRINT " Output neuron  "; j; " has a value of  "; outa(j)
4070 IF outa(j) > thrval THEN PRINT "==>1<==" ELSE PRINT "==>0<=="
4090 NEXT j
4130 PRINT
4140 PRINT
4145 FOR l = 1 TO nout: FOR m = 1 TO nin
4147 PRINT "WIN"; : PRINT l; : PRINT m; : PRINT "="; : PRINT win(l, m)
4148 NEXT: NEXT
4150 PRINT "Another PREDICTION (1 = yes, 0 = Exit to main menu) ";
4160 GOSUB 950
4170 IF c <> 0 THEN GOTO 4010
4180 RETURN
5000 REM
5005 FOR K = 1 TO ncase
5010 PRINT " value of neurons: INPUT"
5012 FOR i = 1 TO nin
5015 PRINT "Neuron  "; i; "="; : GOSUB 950: INA(i) = c
5025 IEXAM(K, i) = INA(i)
5030 NEXT i
5035 PRINT " Value of neurons: OUTPUT"
5040 FOR j = 1 TO nout
5050 PRINT "Neuron  "; j; "="; : GOSUB 950: TARG(j) = c
5055 OEXAM(K, j) = TARG(j)
5060 NEXT j
5080 PRINT
5090 NEXT K
5320 RETURN
6000 REM
6010 FOR h = 1 TO nhid
6020 FOR i = 1 TO nin
6090 win(h, i) = .1 * (h - i)
6100 NEXT i
6110 NEXT h
6120 FOR j = 1 TO nout
6130 FOR h = 1 TO nhid
6140 wout(j, h) = .1 * (j - h)
6150 NEXT h
6160 NEXT j
6170 rate = .5
6180 RETURN
7000 REM  **** sigmoid output *****
7010 FOR h = 1 TO nhid
7020 hidnet(h) = 0
7030 FOR i = 1 TO nin
7040 hidnet(h) = hidnet(h) + win(h, i) * INA(i)
7050 NEXT i
7060 HIDA(h) = 1 / (1 + EXP(-hidnet(h)))
7070 NEXT h
7080 FOR j = 1 TO nout
7090 OUTNET(j) = 0
7100 FOR h = 1 TO nhid
7110 OUTNET(j) = OUTNET(j) + wout(j, h) * HIDA(h)
7120 NEXT h
7130 outa(j) = 1 / (1 + EXP(-OUTNET(j)))
7140 NEXT j
7150 RETURN
8000 REM *** sigmoid matrix update ****
8010 GOSUB 7000
8020 FOR j = 1 TO nout
8030 e = EXP(OUTNET(j))
8040 DELTAOUT(j) = (TARG(j) - outa(j)) * e / ((1 + e) ^ 2)
8050 FOR h = 1 TO nhid
8060 wout(j, h) = wout(j, h) + rate * DELTAOUT(j) * HIDA(h)
8070 NEXT h
8080 NEXT j
8090 FOR h = 1 TO nhid
8100 dum = 0
8110 FOR j = 1 TO nout
8120 dum = dum + DELTAOUT(j) * wout(j, h)
8130 NEXT j
8140 e = EXP(hidnet(h))
8150 deltahid = (e / ((1 + e) ^ 2)) * dum
8160 FOR i = 1 TO nin
8170 win(h, i) = win(h, i) + rate * deltahid * INA(i)
8180 NEXT i
8190 NEXT h
8200 RETURN
