' Area: F-QUICKBASIC 
'  Msg#: 352                                          Date: 25 Apr 94  16:53:09
'  From: Bob Perkins                                  Read: Yes    Replied: No 
'    To: Allan Fields                                 Mark:                     
'  Subj: Re: File viewing
'
'  I got a bit carried away here and created a little file lister.  This will
'work with files that are small enough to be loaded into memory.  On my system
'with 614k available DOS memory this will load over 4000 lines.  You must start
'QB with "/ah" for this to work.  Also notice that I used 128 bytes as the
'length of the string.  This gives me more memory to work with than if I'd used
'80 bytes. 
' To use as much available memory as possible use a power of 2 as the length of
'your string.  (1,2,4,8,16,32,64,128,etc)
'  Another approach you might consider for reading a text file is to just load a
'few pages at a time and read ahead/behind as necessary.

 '
 'Start QB with "/ah" for huge arrays
 '
 maxmem& = FRE(-1) - 65535
 maxlines% = CINT(maxmem& \ 128)
 '$DYNAMIC
 REDIM array(1 TO maxlines%) AS STRING * 128
 f% = FREEFILE
 OPEN COMMAND$ FOR INPUT AS #f%   'might want to add error-checking
 count% = 0
 DO WHILE NOT EOF(1)
  count% = count% + 1
  IF count% > maxlines% THEN
    PRINT "Cannot load entire file!  "; maxlines%; " lines read."
    PRINT "Press Any Key to Continue...";
    DO: LOOP UNTIL LEN(INKEY$)
    count% = maxlines%: EXIT DO
  END IF
  LINE INPUT #1, array(count%)
 LOOP
 CLOSE #f%
 COLOR 7, 1: CLS
 LOCATE 25, 1: COLOR 0, 7: PRINT SPACE$(80);
 LOCATE , 14
 PRINT "File Viewer"; SPACE$(15); CHR$(179);
 PRINT SPACE$(12); "Press ESC to exit";
 COLOR 7, 1
 top% = 1
 DO
  FOR x% = top% TO top% + 23
    LOCATE x% - top% + 1, 1: PRINT LEFT$(array(x%), 80);
  NEXT x%
  DO
    a$ = INKEY$
    IF LEN(a$) THEN
      IF LEN(a$) = 2 THEN
        test% = -ASC(RIGHT$(a$, 1))
      ELSE
        test% = ASC(a$)
      END IF
      SELECT CASE test%
        CASE 27: CLS : END
        CASE -79                                 'END
          top% = count% - 23
          EXIT DO
        CASE -71                                 'HOME
          top% = 1
          EXIT DO
        CASE -73, -72                            'PgUp/Up-Arrow
          IF test% = -73 THEN
            top% = top% - 24
          ELSE
            top% = top% - 1
          END IF
          IF top% < 1 THEN top% = 1
          EXIT DO
        CASE -81, -80                            'PgDn/Dn-Arrow
          IF test% = -81 THEN
            top% = top% + 24
          ELSE
            top% = top% + 1
          END IF
          IF top% + 23 > count% THEN top% = count% - 23
          EXIT DO
      END SELECT
    END IF
  LOOP
 LOOP
 COLOR 7, 0: CLS


