' Area: F-QUICKBASIC 
'  Msg#: 474                                          Date: 26 Apr 94  11:28:00
'  From: Mark Pruitt                                  Read: Yes    Replied: No 
'    To: Robert Fisher                                Mark:                     
'  Subj: Baud
'
'JK>RF> How come QB only accepts the speed 9600bps?  Is it possible

OPEN "COM1:300" FOR RANDOM AS #10 
BaudControl(1,1,57600,ErrCode%) 
 
'*AND* if you're in a really really good mood, open COM2 too: 
OPEN "COM2:300" FOR RANDOM AS #10 
BaudControl(1,2,115200,ErrCode%) 
 
SUB BaudControl (Func%, Port%, X.Baud&, ErrCode%) STATIC 
   'INPUT: Func%=0  -  return the current baud rate in BAUD 
   '       Func%=1  -  set the baud rate from BAUD 
   'See the Serial/Parallel Adapter TechRef for details 
 
    baud& = X.Baud& 
    ErrCode% = 0 
   'the error trapping isn't necessary for most applications. 
   'these errors should be found in the debug cycle 
    IF (Port% < 1 OR Port% > 2) THEN  'bad port params 
      ErrCode% = -1 
    ELSEIF baud& < 100 THEN 
      ErrCode% = -2 
    ELSEIF Func% < 0 OR Func% > 1 THEN  'added error code completes 
                                        'trapping 
      ErrCode% = -3 
    ELSE 
      Addr% = &H4F8 - (&H100 * Port%)    ' base address of port reg's 
      AddrLCR% = Addr% + 3               ' Line Control Register 
      AddrDivLatchLSB% = Addr% + 0       ' Divisor Latch LSB & MSB 
      AddrDivLatchMSB% = Addr% + 1       ' Divisor Latch LSB & MSB 
      ValLCR% = INP(AddrLCR%)            ' get old LCR value 
      OUT AddrLCR%, ValLCR% AND &H7F     ' Disable DLAB to get to inters 
      ValInt% = INP(AddrDivLatchMSB%)    ' Get the int enable statuses 
      OUT AddrDivLatchMSB%, 0            ' Disable all modem intertupts 
      OUT AddrLCR%, ValLCR% OR &H80      ' Enable DLAB to gain access 
      SELECT CASE Func%
 
        CASE 1  'set baud 
          Divisor% = 115200 \ baud&       'magic number for baud rate 
          MSB = Divisor% \ 256 
 
          LSB = Divisor% MOD 256 
          OUT AddrDivLatchMSB%, MSB 
          OUT AddrDivLatchLSB%, LSB      ' put out the new baud rate 
        CASE 0                           'get the current baud rate 
          MSB = INP(AddrDivLatchMSB%) 
          LSB = INP(AddrDivLatchLSB%)    'get old baud rate 
          Divisor% = MSB * 256 + LSB 
          X.Baud& = 115200 / Divisor% 
      END SELECT 
      OUT AddrLCR%, ValLCR% AND &H7F      'Disable DLAB to get to inters 
      OUT AddrDivLatchMSB%, ValInt%       'Replace orig inter values 
      OUT AddrLCR%, ValLCR%               'Replace orig LCR values 
    END IF 
END SUB 
