/* This file contains IBM PC specific functions
   for the Turbo C 2.0 compiler.

   Last changed: 1993 Jan 11 by Costas Krallis SV1XV:
		removed all non-DOS non TCC stuff.
*/

#include <stdio.h>

/* directory search utility for DOS */

#include <sys/stat.h>
#include <dos.h>
#include <conio.h>
#define ST_RDONLY	0x01	/* read only file */
#define ST_HIDDEN	0x02	/* hidden file */
#define ST_SYSTEM	0x04	/* system file */
#define ST_VLABEL	0x08	/* volume label */
#define ST_DIRECT	0x10	/* file is a sub-directory */
#define ST_ARCHIV	0x20	/* set when file has been written and closed */

#define REGFILE	(ST_HIDDEN|ST_SYSTEM|ST_DIRECT)
#define	SET_DTA		0x1a
#define	FIND_FIRST	0x4e
#define	FIND_NEXT	0x4f

struct dirent {
	char rsvd[21];
	char attr;
	short ftime;
	short fdate;
	long fsize;
	char fname[13];
};

/* wildcard filename lookup */
int filedir(char *name, int times, char *ret_str)
{
	register char *cp,*cp1;
	static struct dirent sbuf;
	union REGS regs;

	bdos(SET_DTA,(unsigned)&sbuf,0);	/* Set disk transfer address */

	regs.h.ah = (times == 0) ? FIND_FIRST : FIND_NEXT;
	regs.x.dx = (unsigned int) name;
	regs.x.cx = (unsigned int) REGFILE;
	intdos(&regs,&regs);
	if (regs.x.cflag) 
		sbuf.fname[0] = '\0';

	/* Copy result to output, forcing to lower case */
	for(cp = ret_str,cp1 = sbuf.fname; cp1 < &sbuf.fname[13] && *cp1 != '\0';)
		*cp++ = tolower(*cp1++);
	*cp = '\0';
}

/* This function should put the TTY in a mode such that signgle characters
* can be read without waiting for a complete line. Echo should be on.
*/
int setrawmode(void)
{}

/* This function should restore the TTY modes back to cooked mode */
int setcookedmode(void)
{}

/* This function return one charater form the keyboard. It will wait
* for a character to be input. This function will echo the character.
* This funtion will return after each character is typed if rawmode is set
*/
int getrch(void)
{
	return(bdos(1,0,0) & 0xff);
}


/* dummy do nothing */
int catchit(void)
{}

int setsignals(void)
{
	ctrlbrk(catchit);
}


int setvideo(char *s)
{
	if (strncmp("bios",s,4) == 0)
		directvideo = 0;
	else
		directvideo = 1;
}

/* I use my own gets to get around the DESQview raw mode bug
   which causes gets not to work right.
   It reads straight from console, not via "stdin".
*/
char *gets(char *s)
{
	register char *p;
	register int c;
	p = s;
	while ((c = getrch()) != EOF){
		if ( c == '\b' && p > s) {
			p--;
			putch(' ');
			putch('\b');
		}
		else if ( c == '\n' || c == '\r') {
			break;
		} else
			*p++ = c;
	}
	*p = '\0';
	putch('\n');
	return(s);
}
