// tedit.cpp
#include "genapp.h"

class TEditApp: public TGenApp
    {
    public:
        TEditApp();

        virtual void handleEvent(TEvent& Event);
        static TMenuBar *initMenuBar(TRect R);
        static TStatusLine *initStatusLine(TRect R);
        virtual void getClipWindow(void);
    };

TEditApp::TEditApp() :
    TProgInit(&TEditApp::initStatusLine,
              &TEditApp::initMenuBar,
              &TEditApp::initDeskTop)
    {
    TEditor::editorDialog = TEditApp::genEditDialog;
    initClipWindow();
    }


void TEditApp::handleEvent(TEvent& Event)
    {
    PathStr FileName;

    TGenApp::handleEvent(Event);
    switch(Event.what)
        {
        case evCommand:
            switch(Event.message.command)
                {
                case cmOpenFile:
                    FileName = fileOpenDialog("*.*");
                    if (FileName[0])
                        deskTop->insert(
                            validView(new TEditWindow(deskTop->getExtent(),
                            FileName,wnNoNumber)));
                    break;
                case cmNewFile:
                    deskTop->insert(validView(
                        new TEditWindow(deskTop->getExtent(),
                        NULL, wnNoNumber)));
                    break;
                }
        }
    }

TMenuBar *TEditApp::initMenuBar(TRect R)
    {
    R.b.y = R.a.y + 1;
    return new TMenuBar(R,
    TGenApp::fileMenu() +
    TGenApp::editMenu() +
    TGenApp::searchMenu() +
    TGenApp::windowsMenu());
    }

TStatusLine *TEditApp::initStatusLine(TRect R)
    {
    R.a.y = R.b.y - 1;
    return new TStatusLine(R, *new TStatusDef(0, 0x0FFFF, genStatusLine()));
    }

void TEditApp::getClipWindow()
    {
    clipWindow = new TEditWindow(TProgram::deskTop->getExtent(), '', wnNoNumber);

    if (clipWindow)
        {
        clipWindow->hide();
        TEditor::clipboard = clipWindow->editor;
        TEditor::clipboard->canUndo = (Boolean) 0;
        }
    }

void main(void)
    {
    TEditApp EditApp;
    EditApp.run();
    }


