// mfilewnd.h
// File window for use in MDIEdit application.

#ifndef __MFILEWND_H
#define __MFILEWND_H

#ifndef __WINDOBJ_H
#include <windobj.h>
#endif

#ifndef __FILEWND_H
#include <filewnd.h>
#endif

#ifndef __MENUS_H
#include "menus.h"
#endif

_CLASSDEF(TMyFileWindow)

class _EXPORT TMyFileWindow : public TFileWindow {
protected:
	LPSTR MenuName;
	int   WindowMenuPosition;
public:
	TMyFileWindow(PTWindowsObject AParent, LPSTR ATitle,
		LPSTR AFileName, LPSTR NewMenuName,
		int NewWindowMenuPosition = 0, PTModule AModule = NULL)
		: TFileWindow(AParent, ATitle, AFileName, AModule),
		MenuName(NewMenuName),
		WindowMenuPosition(NewWindowMenuPosition) {}
	virtual void GetWindowClass(WNDCLASS _FAR & AWndClass);
	virtual LPSTR GetClassName(void) {
		return "TMyFileWindow";
		}

	virtual void CMGotoLine(RTMessage Msg) = [CM_FIRST+CM_GOTOLINENUMBER];
	virtual void WMMDIActivate(RTMessage Msg) = [WM_FIRST+WM_MDIACTIVATE];
protected:
	TMyFileWindow(StreamableInit s) : TFileWindow(s) {}
	virtual void write (Ropstream os);
	virtual Pvoid read (Ripstream is);
	static PTStreamable build(void);
private:
	virtual const Pchar streamableName() const	{
		return "TMyFileWindow";
		}
	};

inline Ripstream operator >> (Ripstream is, RTMyFileWindow cl) {
	return is >> (RTStreamable)cl;
	}
inline Ripstream operator >> (Ripstream is, RPTMyFileWindow cl) {
	return is >> (RPvoid)cl;
	}

inline Ropstream operator << (Ropstream os, RTMyFileWindow cl) {
	return os << (RTStreamable)cl;
	}
inline Ropstream operator << (Ropstream os, PTMyFileWindow cl) {
	return os << (PTStreamable)cl;
	}

#endif	// ifdef  __MFILEWND_H
