// stdwin.h

#include<windows.h>
#include"winapp.h"

#if !defined(STDWIN_H)

/* STDWIN
A class derived from Window. This class creates a standard, overlapped Window
with Scroll bars.
*/
class WinAppStdWindow : public Window
    {
    public:
        WinAppStdWindow(WinApp *myApp, WinClass *wc, char *name) :
            Window(myApp,wc)
            {
                // StdWindow class settings
            AddClassStyle(CS_HREDRAW | CS_VREDRAW);

                // Window settings: OVERLAPPEDWINDOW includes
                // OVERLAPPED, CAPTION, SYSMENU, THICKFRAME,MINIMIZE_BOX,
                // and MAXIMIZE_BOX
            AddWinStyle(WS_BORDER | WS_OVERLAPPEDWINDOW | WS_VISIBLE);
            AddWinStyle(WS_HSCROLL | WS_VSCROLL);

            SetWinInstance(myApp->GetInstance());
            SetWinX(CW_USEDEFAULT);
            SetWinY(CW_USEDEFAULT);
            SetWinWidth(CW_USEDEFAULT);
            SetWinHeight(CW_USEDEFAULT);
            SetWinName(name);
            }
    };

#define STDWIN_H
#endif
