/*----------------------------------------------------------------------*/
/* This program will read in a Post Road Mailer folder file             */
/* and produce an OV VM notelog file                                    */
/*----------------------------------------------------------------------*/
/* To prepare a notelog for OV used, type in and execute                */
/* the following EXEC against the notelog file on VM                    */
/*                                                                      */
/* |...+....1....+....2....+....3....+....4....+....5....+....6....+....*/
/* /*******/                                                            */
/* parse arg fn ft fm .                                                 */
/* if      ft = 'OFSLOGFL' then do                                      */
/*   Address 'COMMAND' 'RENAME 'fn ft fm' = OFSLOGfl A0'                */
/*   ft = 'OFSLOGfl'                                                    */
/*   fm = 'A0'                                                          */
/*   Address 'COMMAND' 'COPY   'fn ft fm' = = = (REP RECFM F LRECL 80'  */
/* end                                                                  */
/* else if ft = 'OFSLOGfl' then                                         */
/*   Address 'COMMAND' 'RENAME 'fn ft fm' = OFSLOGFL = '                */
/*----------------------------------------------------------------------*/
 Signal On Syntax

 Parse Arg pcfile nlfn parms 

 parms = translate(parms)

 if strip(pcfile) = '' then do
   Say 'Syntax is: fold2log <path> <notelog file name> <options>'
   Say
   Say 'Where:'
   Say '<path> is the Post Road folder (.NLG) file'
   Say 'that is to be convert into an OV VM notelog (.OFS) file'
   Say '<notelog file name> is the file name to be used for the'
   Say 'OV VM notelog file.'
   Say '<options> include APPEND or APP.'

   ret_code = 0
 end
 else if Stream(pcfile, 'C', 'QUERY EXISTS') = '' then do
   Say 'File ('pcfile') was NOT found.'
   ret_code = -3
 end
 else do
   fn = filespec('name',pcfile)
   Parse Var fn fn'.'ext

   Parse Var nlfn nlfn'.' .
   nlfn = strip(nlfn);
   if nlfn = '' then nlfn = fn
   else              nlfn = strip(substr(nlfn,1,8))

   Say '========================================'
   Say 'Coverting file ('pcfile')'
   Say 'to OV VM notelog file --> 'fn'.ofs'
   Say '========================================'

   ret_code = CONVERT_FOLDER(pcfile,fn,nlfn,parms)
 end

/*-----------------------------------------------------------------*/
/* Exit the program.  One way in.  One way out                     */
/*-----------------------------------------------------------------*/
QUIT:
  EXIT(ret_code)

/*-----------------------------------------------------------------*/
/* Display any syntax errors on the screen                         */
/*-----------------------------------------------------------------*/
SYNTAX:
  ret = RC
 'SET CMSTYPE RT'
  Say 'Error' ret 'in line' sigl ':' errortext(ret)
  Say sigl':'sourceline(sigl) 
  pull .
  Signal QUIT
  RETURN(0)

/*-----------------------------------------------------------------*/
/* Read the post road folder and covert it to OV VM notelog format */
/*-----------------------------------------------------------------*/
CONVERT_FOLDER:Procedure
 Parse arg pcfile,fn,nlfn,parms

 call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
 call SysLoadFuncs

 logfile   = nlfn'.OFS'
 ret_code  = 0
 ncount    = 0
 append    = 0

 if pos('APP',parms) > 0 then append = 1

 if append = 0 & Stream(logfile, 'C', 'QUERY EXISTS') <> '' then do
   Say
   Say 'The file ('logfile') alreadys exists.'
   Say
   Say 'Do you wish to replace it? (y/n)'
   pull ans .
   ans = translate(ans)
   if substr(ans,1,1) = 'Y' then ret_code = 0
   else                          ret_code = 1
 end  /* Do */

 if ret_code = 0 then do
   if append = 0 then do
     if Stream(logfile,   'C', 'QUERY EXISTS') <> '' then
       Call SysFileDelete logfile
   end

   start = 'NO'
   Do While Lines(pcfile) > 0
     lin = LineIn(pcfile)

     Select
       When substr(lin,2,3) = 'MSG' then do
         lin = overlay('FE'x,lin,1)
         Call LineOut logfile,lin
         start  = 'YES'
         ncount = ncount + 1
       end
       When c2d(substr(lin,1,1)) = 254 then do
         if      c2d(substr(lin,2,1)) = 1 then type = 'R'
         else if c2d(substr(lin,2,1)) = 3 then type = 'F'
         else if c2d(substr(lin,2,1)) = 4 then type = 'A'
         else                                   type = ' '

         subject = substr(lin,3,length(lin)-2)
         lin = 'FF'x||'FF'x||'13'x||'96'x||'00'x||'0B'x
         lin = overlay(subject,        lin, 7)
         lin = overlay(copies('00'x,8),lin,72)
         lin = overlay(type,           lin,77)

         Call LineOut logfile,lin
         start = 'NO'
       end
       When start = 'YES' then do
         Call LineOut logfile,lin
       end 
       Otherwise nop
     end /* select */
   end /* do...while */
 end /* if */
       
 Say '('ncount') notes were loaded.'

 RETURN(ret_code)
