/*====================================================================
This file is part of the Blackout screen saver.       v0.91 1995-04-15
Copyright (C) 1995 by Staffan Ulfberg.    See README file for details.
====================================================================*/
#define INCL_WIN
#define INCL_DOSPROCESS
#include <stdlib.h>
#include <os2.h>
#include <graph.h>
#include <sys/hw.h>
#include "vga.h"

#define MAX_PAL_SIZE 256

extern void ErrMsg(char *s);

static char newtable[MAX_PAL_SIZE * 3], oldtable[MAX_PAL_SIZE * 3];

void setpalette(char *p) {
  _portaccess(FIRST_PORT, LAST_PORT);  
  _wait01 (IS1_R, 0x08);
  _outp8 (PEL_IW, 0);
  _outps8dac (PEL_D, p, 3 * 256);
}

void getpalette(char *p) {
   int i, j;

  _portaccess(FIRST_PORT, LAST_PORT);  
  _outp8(PEL_IR, 0);
  for(j = 0; j < 256 * 3; j++) {
    for(i = 0; i < 20; i++) ;  
    *p++ = _inp8(PEL_D);
  }
}

void grey_blank(HWND hwnd) {
  int i;

  getpalette(oldtable);
  for (i = 0; i < 256 * 3; i++) 
    newtable[i] = oldtable[i] / 2;
  setpalette(newtable);

  WinShowPointer(HWND_DESKTOP, 0);
}

void grey_blankblack(HWND hwnd) {
  int i;

  getpalette(oldtable);
  for (i = 0; i < 256 * 3; i++) 
    newtable[i] = 0;
  setpalette(newtable);
}

void grey_unblank(HWND hwnd) {

  setpalette(oldtable);
  WinShowPointer(HWND_DESKTOP, 1);
}
