/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990-1994 BecknerVision Inc - No Rights Reserved

    Written by John Wm Beckner
    BecknerVision Inc

        ** THIS FILE IS PUBLIC DOMAIN **

        ** Use of this code is at your own risk, absolutely no guarantees
        ** are made to its usefulness  - you must determine for yourself if
        ** this code is of any use to you.  If you do not agree with this, do
        ** not use this code. **
*/

#include "beckner.inc"
#include "inkey.ch"

////////////////
////////////////
//
// Purpose:
//    Browse from DOS prompt
//
// Syntax:
//    C> BROWSE <cFile>
//
// Formal Arguments: (1)
//    Name        Description
//    ___________ ____________
//    cFile       Database to browse
//
// Files:
//    (<cFile>.dbf[/t])
//
// Description:
//    Invokes fBrowse() for the specified database file.
//
// See Also:
//    fBrowse()
//
// Category:
//    Utility Program
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

FUNCTION Browse(cFile, cIndex)
   SET KEY K_F9 TO pCtrlW
   IF cFile=NIL
      Alert("You must specify the file name and optional index")
      QUIT
   ENDIF
   fShare(cFile)
   IF cIndex!=NIL
      SET INDEX TO (cIndex)
   ENDIF
   fBrowse()
   pQuit()
ENDFUNCTION
