/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990-1994 BecknerVision Inc - No Rights Reserved

    Written by John Wm Beckner
    BecknerVision Inc

        ** THIS FILE IS PUBLIC DOMAIN **

        ** Use of this code is at your own risk, absolutely no guarantees
        ** are made to its usefulness  - you must determine for yourself if
        ** this code is of any use to you.  If you do not agree with this, do
        ** not use this code. **
*/

/* produce blue bg with diamonds */


#define BLUE B
#define LIGHT_BLUE B+
#define DIAMONDS Chr(4)
#command SPRINKLE WITH <char> => Sprinkle( <char> )
#xcommand WAIT TIL SOMEONE FIGGERS OUT TO PRESS A KEY => Inkey(0)
#xcommand CLEAR [THE] SCREEN => CLS
#command ENDFUNCTION => RETURN NIL
#xcommand TURN THAT DANGED BLINKING THING OFF => SET CURSOR OFF

////////////////
////////////////
//
// Purpose:
//    Sample of creating your own commands  
//
// Syntax:
//    C> BLUEBG
//
// Formal Arguments: (0)
//
// Description:
//    Weird sample showing how to write your own commands.  To see the actual
//    effect, compile with -b-p options and run with CLD /S and single-step.
//
// Category:
//    Sample Program
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

FUNCTION BlueBG()
   TURN THAT DANGED BLINKING THING OFF
   SET COLOR TO BLUE/LIGHT_BLUE
   CLEAR THE SCREEN
   SPRINKLE WITH DIAMONDS
   WAIT TIL SOMEONE FIGGERS OUT TO PRESS A KEY
ENDFUNCTION

////////////////
////////////////
//
// Purpose:
//    "Sprinkles" characters on the screen
//
// Syntax:
//    Sprinkle(<cChar>) -> NIL
//
// Formal Arguments: (1)
//    Name        Description
//    ___________ ____________
//    cChar       Character to display
//
// Returns:
//    NIL
//
// Files:
//    none
//
// Description:
//    Displays the specified character at specific positions on the screen.
//
// Category:
//    Support Function
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

STATIC FUNCTION Sprinkle(cChar)
   LOCAL nRow, nCol
   FOR nRow := 1 to MaxRow() STEP 8
      FOR nCol := 7 to MaxCol() STEP 10
         @ nRow, nCol SAY cChar
      NEXT
   NEXT
   FOR nRow := 5 to MaxRow() STEP 8
      FOR nCol := 2 to MaxCol() STEP 10
         @ nRow, nCol SAY cChar
      NEXT
   NEXT
ENDFUNCTION
