/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990-1994 BecknerVision Inc - No Rights Reserved

    Written by John Wm Beckner
    BecknerVision Inc

        ** THIS FILE IS PUBLIC DOMAIN **

        ** Use of this code is at your own risk, absolutely no guarantees
        ** are made to its usefulness  - you must determine for yourself if
        ** this code is of any use to you.  If you do not agree with this, do
        ** not use this code. **
*/

#include "beckner.inc"
#define PMT_DATE     1
#define PMT_AMOUNT   2
#define PRINCIPAL    3
#define INTEREST     4
#define BALANCE      5

////////////////
////////////////
//
// Purpose:
//    Sample showing use of mAmort()
//
// Syntax:
//    C> AMORTIZE
//
// Formal Arguments: (0)
//
// Description:
//    Sample program to return amortization schedule using mAmort().
//
// See Also:
//    mAmort()
//
// Category:
//    Sample Program
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

FUNCTION Main()
   LOCAL cVersion := "v1.0", nNumPmts := 180, nLoan := 0.00, GetList := {}
   LOCAL nAPR := 10, dStart := dBegMonth(dSame()), nCtr, aSchedule
   LOCAL nTotalPrinc := 0.00, nTotalInt := 0.00, lPage1 := .y.
   CLS
   @ 0, 0 SAY "Beckner Amortization Schedule II"+cVersion
   @ 1, 0 SAY "Copyright (c)1993 BecknerVision Inc - All Rights Reserved"
   @ 3, 0 SAY "# of payments ............" GET nNumPmts PICTURE "999"
   @ 4, 0 SAY "Starting balance ........." GET nLoan    PICTURE "999,999.99"
   @ 5, 0 SAY "First payment due date ..." GET dStart
   @ 6, 0 SAY "APR ......................" GET nAPR     PICTURE "99.99999"
   READ

   /* THIS IS THE KEY FUNCTION - ALL ELSE IS WINDOW-DRESSING */
   aSchedule := mAmortSched(nLoan, nAPR, nNumPmts, dStart)

   CLS
   SET PRINTER ON
   SET CONSOLE OFF
   ? "  Amortization Schedule"
   ? "  Created with Beckner Library & Utilities II"
   ?
   ? "  Number of Payments .......", sMake(nNumPmts)
   ? "  Loan Amount ..............", sDollar(nLoan)
   ? "  APR ......................", sMake(nAPR)+"%"
   ?
   FOR nCtr := 1 TO nNumPmts
      IF pRow()>55 .or. lPage1
         IF lPage1
            lPage1 := .n.
         ELSE
            EJECT
         ENDIF
         ? "  ###  DUE DATE  PAYMENT AMT    PRINCIPAL     INTEREST  BALANCE DUE"
         ?
      ENDIF
      ? " ", Str(nCtr, 3), "",               /* payment number              */;
            aSchedule[nCtr, PMT_DATE],       /* payment due date            */;
            x(aSchedule[nCtr, PMT_AMOUNT]),  /* payment amount due          */;
            x(aSchedule[nCtr, PRINCIPAL]),   /* principal                   */;
            x(aSchedule[nCtr, INTEREST]),    /* interest                    */;
            x(aSchedule[nCtr, BALANCE])      /* balance due after payment   */
      nTotalPrinc += aSchedule[nCtr, PRINCIPAL]
      nTotalInt   += aSchedule[nCtr, INTEREST]
   NEXT
   ?
   ? "Total Principal Repaid ...", sDollar(nTotalPrinc)
   ? "Total Interest Repaid ....", sDollar(nTotalInt)
   SET CONSOLE ON
   SET PRINTER OFF
   EJECT
ENDFUNCTION

STATIC FUNCTION x(nAmount)
   RETURN Transform(nAmount, "9,999,999.99")
ENDFUNCTION
