    DECLARE FUNCTION ExeName$
    DECLARE FUNCTION QInstrB% (StartPos%, Source$, Search$)
    DECLARE SUB MaxStats (Record$)
    DECLARE SUB SystemName ()

    COMMON SHARED Bar$
    COMMON SHARED /Bkla201M/ Caller$
    COMMON SHARED /Bkla201M/ MaxH%
    COMMON SHARED /Bkla201M/ MaxCPS&
    COMMON SHARED /Bkla201M/ MaxFileSize&
    COMMON SHARED /Bkla201M/ MaxOutgoingFile&
    COMMON SHARED /Bkla201M/ MaxOutFTot&
    COMMON SHARED /Bkla201M/ MaxInFTot&
    COMMON SHARED /Bkla201M/ MaxSec%
    COMMON SHARED /Bkla201M/ MaxFileCount%
    COMMON SHARED /Bkla201M/ MaxSecTot%
    COMMON SHARED /Bkla201M/ MissingFileSize&
    COMMON SHARED /Bkla201M/ ExcludExt$()
    COMMON SHARED /Bkla201M/ LastF%
    COMMON SHARED /Bkla201M/ ExcludeFiles%

    CONST BinklaVersion$ = "2.02"
    CONST Copyright1$ = "Binkley Log Analyzer - BinkLA Version "
    CONST Copyright2$ = "Copyright 1991 - 94 by RJ (Bob) Ross - ALL RIGHTS RESERVED"
    CONST Copyright3$ = "SysOp - RJ's Byteline BBS - FidoNet 1:134/75"

    CONST False = 0
    CONST True = NOT False

  ' Define color constants
    CONST BLACK = 0
  ' CONST BLUE = 1
    CONST GREEN = 2
    CONST CYAN = 3
    CONST RED = 4
  ' CONST MAGENTA = 5
    CONST BROWN = 6
    CONST WHITE = 7
    CONST BRIGHT = 8
    CONST BLINK = 16
    CONST YELLOW = BROWN + BRIGHT

  ' Running out of space in the main module so had to break things up

  ' Second module for BinkLA - BKLA201M.BAS - also includes following Subs
  ' MaxStats Sub
  ' Help Sub
  ' Copyright Sub
  ' Sort Sub
  ' PrtCtrDisp Sub
  ' SystemName Sub

DEFINT A-Z
    SUB Copyright
        CLS
        COLOR YELLOW
        PRINT TAB(40 - (LEN(BinklaVersion$) + LEN(Copyright1$)) \ 2); Copyright1$; BinklaVersion$
        PRINT TAB(40 - LEN(Copyright2$) \ 2); Copyright2$
        PRINT TAB(40 - LEN(Copyright3$) \ 2); Copyright3$
      '       PRINT
        COLOR CYAN
        PRINT STRING$(79, "")
        COLOR WHITE
    END SUB

    SUB Help
        CLS

        COLOR CYAN + BRIGHT
        PRINT TAB(40 - (LEN(BinklaVersion$) + LEN(Copyright1$)) \ 2); Copyright1$; BinklaVersion$
        COLOR YELLOW
        PRINT STRING$(79, "")
        COLOR WHITE + BRIGHT
        PRINT "Use:"; SPC(3);
        COLOR GREEN
        PRINT "BINKLA [<-switches>] [LNG=langfilename] [LOG=logfilename]"
        PRINT "       [SP=External_SortProgram] [@ResponseFile]"
        PRINT
        PRINT SPC(7); "Switches, LNG=langfilename, LOG=logfile, SP=SortProgram"
        PRINT SPC(7); "and @ResponseFile are optional and may be given in any order."
        PRINT SPC(7); "The default produces BKLARpt.Txt  in the parent/home directory"
        PRINT SPC(7); "where BinkLA.Exe and Binkley.log reside."
        COLOR WHITE + BRIGHT
        PRINT "Switches:"
        COLOR GREEN
        PRINT TAB(8); "= No switch produces BKLARpt.Txt using Binkley.log and exits."
        PRINT " -BBS  = Produce a colourized BKLARpt.Bbs suitable for a BBS display."
        PRINT " -DF   = Make a data file BKLADat.nnn from Part I of the report."
        PRINT " -DN   = Use the current day number as extension for report BKLARpt."
        PRINT " -EXN  = -EXN,Zone:Net (ie -EXN,1:134). Exclude a Nets from BKLARpt.*."
        PRINT " -H    = This brief help screen."
        PRINT " -KTF  = Don't delete created temp files (.$$$, .$$S)."
        PRINT " -L    = Produce BKLARpt.Txt and list it to the screen."
        PRINT " -LL   = List the last created BKLARpt.Txt file to the screen."
        PRINT " -MAX  = Display Maximus BBS uploads/downloads."
        PRINT " -MD   = Provide mail detail in BKLARpt.*."
        PRINT " -NHA  = Don't use high ascii characters in BKLAARpt.*."
        COLOR YELLOW + BLINK
        PRINT
        PRINT " -- More --";
        DO
            a$ = INKEY$
        LOOP UNTIL LEN(a$)
        LOCATE CSRLIN - 2, 1
        COLOR GREEN
        PRINT
        PRINT " -SN   = Configure BINKLA.EXE to display your System Name on the output report."
        PRINT " -SUP  = Suppress filenames in Part II of BKLARpt.* (-SUP,.LZH,FNEWS)"
        PRINT " LNG=  = Use an alternate BinkLA language/translate file."
        PRINT " LOG=  = Log path\log filename.  Optional if Binkley.LOG in default directory."
        PRINT " SP=   = Use an external sort program.  ie: SP=QSort."
        PRINT " @     = ResponseFile<.ext>.  A text file containing command line switches."
        COLOR YELLOW
        PRINT STRING$(79, "");
        COLOR WHITE
    END SUB

DEFSNG A-Z
    SUB MaxStats (Record$)
        'for Max V2 compatability
        P% = INSTR(25, Record$, "calling (U#")
        IF P% THEN
            Caller$ = MID$(Record$, 24, P% - 24)
            P% = 0
        END IF
        'for Max V 3.00 compatability
        P% = INSTR(25, Record$, "calling")
        IF P% THEN
            Caller$ = MID$(Record$, 24, P% - 24)
            P% = 0
        END IF
        P% = INSTR(19, Record$, "MAX  End,")
        IF P% THEN
            P% = 0
            Caller$ = ""
            MaxCPS& = 0
            MaxFileSize& = 0
            MaxOutgoingFile& = 0
            MaxSec% = 0
            MaxFilename$ = ""
            EXIT SUB
        END IF
        P% = INSTR(24, Record$, "CPS: ")
        IF P% THEN
            MaxCPS& = VAL(MID$(Record$, 29))
            P% = INSTR(Record$, "(")
            IF P% THEN
                MaxFileSize& = VAL(MID$(Record$, P% + 1))
            END IF
        END IF
        P% = INSTR(19, Record$, "MAX  DL-")
        IF P% THEN
            MaxPosn% = QInstrB%(-1, Record$, "\")
        END IF
        IF MaxPosn% THEN
            MaxFilename$ = MID$(Record$, MaxPosn% + 1)
            MaxFileExtension$ = UCASE$(RIGHT$(MaxFilename$, 4))
            IF LEFT$(MaxFileExtension$, 1) <> "." THEN
                P% = INSTR(MaxFileExtension$, ".")
                IF P% THEN
                    MaxFileExtension$ = MID$(MaxFileExtension$, P%)
                END IF
            END IF
            IF ExcludeFiles% THEN
                FOR X% = 1 TO LastF%
                    IF ExcludExt$(X%) = MaxFileExtension$ THEN
                        ExcludeMaxFile% = True
                        EXIT FOR
                    END IF
                NEXT
            END IF
            IF NOT ExcludeMaxFile% THEN
              'do nothing
              '   ELSE
                MaxFileCount% = MaxFileCount% + 1
                MaxOutgoingFile& = MaxFileSize&
                MaxOutFTot& = MaxOutFTot& + MaxOutgoingFile&
                PRINT #MaxH%, Bar$; LEFT$(Caller$, 18);
                PRINT #MaxH%, TAB(21); MaxFilename$;
                PRINT #MaxH%, TAB(37);
                IF MaxOutgoingFile& = 0 THEN
                    MissingFileSize& = -1
                    PRINT #MaxH%, SPACE$(8); "***";
                ELSE
                    PRINT #MaxH%, USING "###,###,###"; MaxOutgoingFile&;
                END IF
                PRINT #MaxH%, TAB(64);
                PRINT #MaxH%, USING "#####"; MaxCPS&;
                IF MaxOutgoingFile& > 0 AND MaxCPS& > 0 THEN
                    MaxSec% = MaxOutgoingFile& \ MaxCPS&
                    MaxSecTot% = MaxSecTot% + MaxSec%
                    MaxMin! = MaxSec% / 60
                END IF
                MaxPosn% = 0
                PRINT #MaxH%, TAB(71);
                PRINT #MaxH%, USING "###.#"; MaxMin!;
                PRINT #MaxH%, Bar$
            END IF
        END IF
        P% = INSTR(19, Record$, "MAX  UL-")
        IF P% THEN
            MaxPosn% = QInstrB%(-1, Record$, "\")
        END IF

        IF MaxPosn% THEN
            MaxFilename$ = MID$(Record$, MaxPosn% + 1)
            MaxFileExtension$ = UCASE$(RIGHT$(MaxFilename$, 4))
            IF LEFT$(MaxFileExtension$, 1) <> "." THEN
                P% = INSTR(MaxFileExtension$, ".")
                IF P% THEN
                    MaxFileExtension$ = MID$(MaxFileExtension$, P%)
                END IF
            END IF
            IF ExcludeFiles% THEN
                FOR X% = 1 TO LastF%
                    IF ExcludExt$(X%) = MaxFileExtension$ THEN
                        ExcludeMaxFile% = True
                        EXIT FOR
                    END IF
                NEXT
            END IF
            IF NOT ExcludeMaxFile% THEN

                MaxFileCount% = MaxFileCount% + 1
                MaxIncomingFile& = MaxFileSize&
                MaxInFTot& = MaxInFTot& + MaxIncomingFile&
                PRINT #MaxH%, Bar$; LEFT$(Caller$, 18);
                PRINT #MaxH%, TAB(21); MaxFilename$;
                PRINT #MaxH%, TAB(51);
                IF MaxIncomingFile& = 0 THEN
                    MissingFileSize& = -1
                    PRINT #MaxH%, SPACE$(8); "***";
                ELSE
                    PRINT #MaxH%, USING "###,###,###"; MaxIncomingFile&;
                END IF
                PRINT #MaxH%, TAB(64);
                PRINT #MaxH%, USING "#####"; MaxCPS&;
                IF MaxIncomingFile& > 0 AND MaxCPS& > 0 THEN
                    MaxSec% = MaxIncomingFile& \ MaxCPS&
                    MaxSecTot% = MaxSecTot% + MaxSec%
                    MaxMin! = MaxSec% / 60
                END IF
                MaxPosn% = 0
                PRINT #MaxH%, TAB(71);
                PRINT #MaxH%, USING "###.#"; MaxMin!;
                PRINT #MaxH%, Bar$
            END IF
        END IF
    END SUB

DEFINT A-Z
    SUB PrtCtrDisp (PrtRec%, Ln%) STATIC
        SELECT CASE PrtRec%
        CASE IS = 1
            LOCATE 14
            PRINT SPC(Ln%); "Working    |"
        CASE IS = 2
            LOCATE 14
            PRINT SPC(Ln%); "Working    / "
        CASE IS = 3
            LOCATE 14
            PRINT SPC(Ln%); "Working    - "
        CASE IS = 4
            LOCATE 14
            PRINT SPC(Ln%); "Working    \ "
        CASE ELSE
            IF PrtRec% > 4 THEN PrtRec% = 1
        END SELECT

    END SUB

    SUB SORT (TMP1&(), TMP2&(), CNT%) STATIC
      '
      ' --- The Shell-Metzner Sort Subroutine --- <Fast!>
      '
        M% = CNT%
        WHILE M% > 1
            M% = INT(M% / 2)
            FOR J% = 1 TO CNT% - M%
                FOR i% = J% TO 1 STEP -M%
                    k% = i% + M%
                  'IF TMP1&(i%) >= TMP1&(k%) THEN
                    IF TMP1&(i%) <= TMP1&(k%) THEN
                        i% = 0
                    ELSE
                        SWAP TMP1&(i%), TMP1&(k%)
                        SWAP TMP2&(i%), TMP2&(k%)
                    END IF
                NEXT i%
            NEXT J%
        WEND
    END SUB

DEFSNG A-Z
    SUB SystemName
        EditColor% = 112
        NormColor% = 112
        LOCATE 8, 1
        Temp1$ = SPACE$(40)
        PRINT "This option will allow you to configure BinkLA.Exe to automatically place"
        PRINT "the name of your BBS system at the top of BinkLA output report."
        PRINT
        PRINT "You may press Esc to abort this function, if desired, and return to DOS."

        DO
            LOCATE 13, 1
            PRINT "Your System Name: ";
            CALL Editor(Temp1$, Length%, ScanCode%, 0, 0, NormColor%, EditColor%, 13, 18)
            IF ScanCode% = 27 THEN
                LOCATE 17, 1
                PRINT "Aborted - System Name not changed."
                END
            END IF
            Msg$ = "OK?  "
            YN$ = "N"
            CALL YesNo(YN$, Msg$, ScanCode%, 7, EditColor%, 15, 1)
            IF ScanCode% = 27 THEN
                LOCATE 17, 1
                PRINT "Aborted - System Name not changed."
            END IF
        LOOP UNTIL UCASE$(YN$) = "Y"
        IF UCASE$(YN$) = "Y" THEN
            Temp1$ = LTRIM$(RTRIM$(Temp1$))
            Temp1$ = Temp1$ + "@"
            LookingFor$ = "R^"
            FileName$ = ExeName$
            ' Filename$ = "BINKLA.EXE "    'to run in the QB Environment"
            FilePointer& = 1
            OurHandle% = FREEFILE
            OPEN FileName$ FOR BINARY AS #OurHandle%
            DO WHILE NOT EOF(OurHandle%)
                SEEK OurHandle%, FilePointer&
                a$ = INPUT$(4096, OurHandle%)
                Result% = INSTR(a$, LookingFor$)
                IF Result% THEN
                    FilePos& = (SEEK(OurHandle%)) - ((LEN(a$) - Result% + 1))
                    EXIT DO
                END IF
                FilePointer& = SEEK(OurHandle%) - LEN(LookingFor$)
            LOOP
            IF Result% THEN
                FilePos& = (SEEK(OurHandle%)) - ((LEN(a$) - Result% + 1))
                PUT OurHandle%, FilePos& + 2, Temp1$
                LOCATE 18, 1
                PRINT "Update completed "; FileName$; " modified."
                END
            ELSE
                LOCATE 18, 1
                PRINT "Failed to update "; FileName$
                CALL SetLevel(1)
                END
            END IF
        END IF
      ' END IF
    END SUB

