  '**************************************************************************
  '*         Program:  BinkLA                                               *
  '*         Version:  2.02                                                 *
  '*    Date Started:  December 20th, 1991                                  *
  '*  Date Completed:  May 24th, 1992  (Version 2.00)                       *
  '*                   June 12th, 1992 (Version 2.00a)                      *
  '*                   June 28th, 1992 (Version 2.00b)                      *
  '*                   July 10th, 1992 (Version 2.00c)                      *
  '*                   August 15th, 1992 (Version 2.00d)                    *
  '*                   November 26th, 1992 (Version 2.00e)                  *
  '*                   January 29th, 1993 (Version 2.00f)                   *
  '*                   February 24th, 1993 (Version 2.00g)                  *
  '*                   November 21st, 1993 (Version 2.00h)                  *
  '*                   December 24th, 1993 (Version 2.00i)                  *
  '*                   December 28th, 1993 (Version 2.00j)                  *
  '*                   April 11th, 1994 (Version 2.01)                      *
  '*                   April 20th, 1994 (Version 2.01a)                     *
  '*                   June 1st, 1994 (Version 2.01b)                       *
  '*                   Dec 10th, 1994 (Version 2.01c)                       *
  '*                   May 21st, 1995 (Version 2.01d)                       *
  '*                   Aug 21st, 1995 (Version 2.02)                        *                                                                        *
  '*      Programmer:  RJ (Bob) Ross                                        *
  '*                                                                        *
  '*        Purpose :  To parse a Binkley logfile and                       *
  '*                   produce a statistical output report of in/out calls  *
  '*                   including network mail / network files               *
  '**************************************************************************

    COMMON SHARED Bar$
    COMMON SHARED /Bkla201M/ Caller$
    COMMON SHARED /Bkla201M/ MaxH%
    COMMON SHARED /Bkla201M/ MaxCPS&
    COMMON SHARED /Bkla201M/ MaxFileSize&
    COMMON SHARED /Bkla201M/ MaxOutgoingFile&
    COMMON SHARED /Bkla201M/ MaxOutFTot&
    COMMON SHARED /Bkla201M/ MaxInFTot&
    COMMON SHARED /Bkla201M/ MaxSec%
    COMMON SHARED /Bkla201M/ MaxFileCount%
    COMMON SHARED /Bkla201M/ MaxSecTot%
    COMMON SHARED /Bkla201M/ MissingFileSize&
    COMMON SHARED /Bkla201M/ ExcludExt$()
    COMMON SHARED /Bkla201M/ LastF%
    COMMON SHARED /Bkla201M/ ExcludeFiles%
    CONST BinklaVersion$ = "2.02"  'In 2nd module also

    DEFINT A-Z
    DECLARE SUB ClearEOL (Col%)
    DECLARE SUB ClearScr (ULRow%, ULCol%, LRRow%, LRCol%, Colr%, Page%)
    DECLARE FUNCTION ComputeCRC& (X$)
    DECLARE SUB Copyright ()
    DECLARE FUNCTION Date2Num% (D$)
    DECLARE SUB Editor (Ed$, ActiveLenght%, ScanCode%, NumOnly%, CapsOn%, NormalColor%, EditColor%, Row%, Column%)
    DECLARE FUNCTION ErrorMsg$ (ErrorNum%)
    DECLARE SUB ErrorMessage (Message$)
    DECLARE FUNCTION ExeName$
    DECLARE FUNCTION Exist% (FileName$)
    DECLARE SUB FileView (FileName$, Ky, Action, FVI AS ANY, SEG Array)
    DECLARE FUNCTION FindLast% (BYVAL Address, Size)
    DECLARE SUB Help ()
    DECLARE SUB InputLine (IOCHAN%, BUFSIZE%, STATUS%, TEXT$)
    DECLARE FUNCTION ItsMail% (Work$)
    DECLARE FUNCTION LineCount% (FileName$, Buffer$)
    DECLARE SUB MaxStats (Record$)
    DECLARE FUNCTION ParseString$ (CurPos%, Work$, Delimit$)
    DECLARE SUB PrtCtrDisp (PrtRec%, Ln%)
    DECLARE FUNCTION QInstrB% (StartPos%, Source$, Search$)
    DECLARE FUNCTION QPTrim$ (Work$)
    DECLARE FUNCTION QPValI% (Value$)
    DECLARE FUNCTION QPValL& (Value$)
    DECLARE SUB SetLevel (ErrValue%)
    DECLARE SUB SORT (TMP1&(), TMP2&(), CNT%)
    DECLARE SUB SystemName ()
    DECLARE SUB Translate (X$)
    DECLARE SUB YesNo (YN$, Prompt$, ScanCode, NormalColr, EditColr, Row, Column)

    COMMON SHARED CR$, LF$, CRLF$               'required for binary read Sub InputLine

    CONST False = 0
    CONST True = NOT False
    CONST Comma = ","

    SysName$ = "R^Not Defined@^&^&^&^&^&^&^&^&^&^&^&^&^&^&^&"

  'For debugging
  'SysName$ = "P^RJ's Byteline BBS@^&^&^&^&^&^&^&^&^&^&^&^&"

    CR$ = CHR$(13)
    LF$ = CHR$(10)
    CRLF$ = CR$ + LF$

    DIM RecCount AS LONG


  ' Define color constants
    CONST BLACK = 0
  ' CONST BLUE = 1
    CONST GREEN = 2
    CONST CYAN = 3
    CONST RED = 4
  ' CONST MAGENTA = 5
    CONST BROWN = 6
    CONST WHITE = 7
    CONST BRIGHT = 8
    CONST BLINK = 16
    CONST YELLOW = BROWN + BRIGHT

    CONST Copyright1$ = "Binkley Log Analyzer - BinkLA Version "

  ' Ansi codes for BBS file
    WHTE$ = CHR$(27) + "[1;37m"
    GREN$ = CHR$(27) + "[1;32m"
    YELLO$ = CHR$(27) + "[1;33m"
    CYANB$ = CHR$(27) + "[1;36m"
    REDC$ = CHR$(27) + "[1;31m"

    ClrScreen$ = CHR$(12)
    MorePrompt$ = CHR$(5)

  'Report Variables
  '----------------
    DIM Rpt$(1 TO 82)
    DIM Session$(1 TO 11)       'to parse the Session cost record
    DIM ExcludExt$(15)          'to parse .Ext to suppress in Pt II (-SUP)
    DIM ExcludNet$(11)          'to parse Nets, zones, etc out of BKLARpt
    DIM Logfile$(14)            'to use up to 14 logfiles

  '***********************************************************
  '* Output Report BKLARpt.txt specific formatting variables
  '***********************************************************
    EndLg$ = "[** Unknown **]"
    RptTi$ = "Log Statistics for the period"
    HrsTo$ = "Hrs -- to --"
    Hours$ = "Hrs"
    StrLg$ = "[** Unknown **]"
    CreDF$ = "Created data file: "

    Rpt$(1) = "Ŀ"
    Rpt$(2) = " Part I - Message Transfers & Calls "
    Rpt$(3) = "͵"
    Rpt$(4) = "Zone:Net/Node    Telephone Calls         Message Bytes       CPS  Tran"
    Rpt$(5) = "    Number     Out  Connect  In  Outgoing     Incoming    Avg   Min"
    Rpt$(6) = "͵"

    Rpt$(7) = "Ĵ"


    Rpt$(8) = ";"

    Rpt$(9) = "Ŀ"
    Rpt$(10) = " PART II - Network File Transfers "
    Rpt$(11) = "͵"
    Rpt$(12) = "Zone:Net/Node                            File Bytes          CPS  Tran"
    Rpt$(13) = "    Number         File Names      Outgoing     Incoming   Rate   Min"
    Rpt$(14) = "͵"

    Rpt$(15) = "Ŀ"
    Rpt$(16) = " PART III - Network Session Costs "
    Rpt$(17) = "͵"
    Rpt$(18) = "Zone:Net/Node      Logged At      Session Time                        "
    Rpt$(19) = "    Number      Date    Time    Hrs  Mins  Sec   Tariff     Fee    "
    Rpt$(20) = "͵"

    Rpt$(21) = "Ŀ "
    Rpt$(22) = "  PART IV - SUMMARY  "
    Rpt$(23) = "͵"
    Rpt$(79) = " Link Rate           Network "
    Rpt$(80) = " Summary -       BBS  In Outĳ"
    Rpt$(81) = "Ĵ"

    Rpt$(24) = "No records to process for this report."

    Rpt$(25) = "Ĵ"

    Rpt$(26) = ""

    Rpt$(27) = "14400 "
    Rpt$(28) = "Message Bytes Transferred    ="
    Rpt$(29) = "9600 "
    Rpt$(30) = "File Bytes Transferred       ="
    Rpt$(31) = "2400 "
    Rpt$(32) = "TOTAL Bytes Transferred      ="
    Rpt$(33) = "1200 "
    Rpt$(34) = "Othr "
    Rpt$(35) = "Message Connect Time         ="
    Rpt$(36) = "TOTAL          "
    Rpt$(37) = "File Transfer Connect Time   ="
    Rpt$(38) = "TOTAL Connect Time (Hours)   ="
    Rpt$(39) = " Net Password Errors          ="
    Rpt$(40) = "TOTAL Network Session Fees   ="
    Rpt$(41) = "Ĵ Net Nuisance Callers         ="

    Rpt$(42) = "Ĵ Unsuccessful Connect Attempts="
    Rpt$(43) = "* Processed Logs:"
    Rpt$(44) = "* Multiple Logs"

    Rpt$(45) = "Ŀ"
    Rpt$(46) = "   - Message Transfer - Detailed -  "
    Rpt$(47) = "͵"
    Rpt$(48) = "Zone:Net/Node    Time                  Message Bytes / CPS              "
    Rpt$(49) = "    Number     Hr:Mn:Sc      Outgoing     CPS        Incoming    CPS   "
    Rpt$(50) = "͵"
    Rpt$(51) = "16800 "
    Rpt$(52) = ""
    Rpt$(53) = "28800 "
    Rpt$(54) = "21600 "
    Rpt$(55) = "19200 "
    Rpt$(56) = "                                          "

    Rpt$(57) = "Ŀ"
    Rpt$(58) = "        Incoming FAX Files        "
    Rpt$(59) = "͵"
    Rpt$(60) = " Connect With ID                         File Names          Bytes      "
    Rpt$(61) = "͵"
    Rpt$(62) = "26400 "
    Rpt$(63) = "24000 "
    Rpt$(64) = "12000 "
    Rpt$(65) = "7200 "
    Rpt$(66) = "4800 "
    Rpt$(67) = "Ĵ"

    Rpt$(68) = "Ŀ"
    Rpt$(69) = "    Maximus BBS File Transfers    "
    Rpt$(70) = "͵"
    Rpt$(71) = "                                         File Bytes          CPS  Tran"
    Rpt$(72) = "    Caller         File Names      Outgoing     Incoming   Rate   Min"
    Rpt$(73) = "͵"
    Rpt$(74) = "Total Fax File Bytes In      ="
    Rpt$(75) = "Incoming FAX Calls           ="
    Rpt$(76) = "BBS In/Out File Bytes        ="
    Rpt$(77) = "Connect  33600 "
    Rpt$(78) = "31200 "
    Rpt$(82) = "      NETWORK/FAX ACTIVITY SUMMARY        "


  '***********************************
  '*Truth Table - behaviour modifiers
  '***********************************
    BBS% = False
    BKLARptFile$ = "BKLARpt.Txt"
    BobDavis% = False
    ChopExt% = False
    DelTempFiles% = True
    DispRpt% = False            ' -L option
    DispMaxSTats% = False       ' -MAX option
    ExcludeFiles% = False
    ExNet% = False              ' -EXN option
    FaxWith$ = "Unknown"
    FaxRec% = False
    HighAscii% = True
    IntSrt% = True              'internal sort of temp files
    Log$ = "BINK"
    Logfile$(0) = "Binkley.Log"
    MailRec% = False
    MailDetail% = False
    MissingFileSize& = False     'byte size of in or out Max file
    MkDataFile% = False
    NoTot% = False
    NumRpt% = False
    ProcNode% = False
    RptPtI% = False
    RptPtII% = False
    RptPtIII% = False
    SessCost% = False
    SortFlag% = False
    UseLngFile% = False


  'Current Path and default filename for BinkLAE.LNG
  'not good from QuickBASIC environment.  Exe file required
  '--------------------------------------------------------
    Temp$ = ExeName$
    P% = QInstrB%(-1, Temp$, "\")
    IF P% THEN
        ExePath$ = LEFT$(Temp$, P%)
        LNGFile$ = ExePath$ + "BinkLAE.LNG"
    END IF
  '******************************************
  '* Command Line switches / parser / action
  '******************************************
    CmdLine$ = COMMAND$

    P% = INSTR(CmdLine$, "@")
    IF P% THEN
        RSPFile$ = MID$(CmdLine$, P% + 1)
        P% = INSTR(RSPFile$, " ")
        IF P% THEN
            RSPFile$ = LEFT$(RSPFile$, P% - 1)
        END IF
        IF Exist%(RSPFile$) THEN
            RSPF% = FREEFILE
            OPEN RSPFile$ FOR INPUT AS RSPF%
            LINE INPUT #RSPF%, CmdLine$
            CmdLine$ = UCASE$(CmdLine$)
            CLOSE RSPF%
        ELSE
            BEEP
            Message$ = ErrorMsg$(53)
            CALL ErrorMessage(Message$)
            LOCATE 18, 10
            PRINT "Unable to locate response file "; RSPFile$
            SetLevel (1)
            END
        END IF
    END IF

  'Add System Name to the Exe file   -    -SN
  '------------------------------------------
    IF INSTR(CmdLine$, "-SN") THEN
        CALL Copyright
        CALL SystemName
    END IF

  'Help Screen      -        -H
  '-----------------------------
    IF INSTR(CmdLine$, "-H") THEN
        CALL Help
        END
    END IF

  'List the last created BKLARpt.txt file     -     -LL
  '----------------------------------------------------
    IF INSTR(CmdLine$, "-LL") THEN
        IF Exist%(BKLARptFile$) THEN
            CLEAR
            BKLARptFile$ = "BKLARpt.Txt"
            GOSUB ListFile
            END
        ELSE
            BEEP
            Message$ = ErrorMsg$(53)
            CALL ErrorMessage(Message$)
            LOCATE 18, 10
            PRINT BKLARptFile$; " not found."
            SetLevel (1)
            END
        END IF
    END IF

  'Make data file BKLADat.nnn       -       -DF
  '-------------------------------------------
    IF INSTR(CmdLine$, "-DF") THEN
        MkDataFile% = True
        Num% = Date2Num%(DATE$) - Date2Num%("01-01-" + RIGHT$(DATE$, 4)) + 1
        Num$ = LTRIM$(STR$(Num%))
        BklaDatF$ = "BKLADat." + Num$
    END IF

  'Custom format of BKLARpt.Dat for Net 106   -   -N106
  '----------------------------------------------------
    IF INSTR(CmdLine$, "-N106") THEN
        BobDavis% = True
    END IF

  'Use the current day number as .ext for BKLARpt.     - DN
  '--------------------------------------------------------
    IF INSTR(CmdLine$, "-DN") THEN
      'dt$ = DATE$
        Num% = Date2Num%(DATE$) - Date2Num%("01-01-" + RIGHT$(DATE$, 4)) + 1
        Num$ = LTRIM$(STR$(Num%))
        BKLARptFile$ = "BKLARpt." + Num$
    END IF

  'List BKLARpt.Txt after it's been created   -   -L
  '------------------------------------------------
    IF INSTR(CmdLine$, "-L") THEN
        DispRpt% = True
    END IF

  'Use different Log file(s) (default Binkley.Log in current dir)  - LOG=
  '---------------------------------------------------------------------
    P% = INSTR(CmdLine$, "LOG=")
    IF P% THEN
        Temp$ = MID$(CmdLine$, P% + 4)
        P% = INSTR(Temp$, " ")
        IF P% THEN Temp$ = LEFT$(Temp$, P% - 1)
        Logfiles$ = Temp$
        LF% = 0
        Posn% = 1
        DO
            Logfile$(LF%) = ParseString$(Posn%, Logfiles$, ",")
            LF% = LF% + 1
        LOOP UNTIL Posn% = LEN(Logfiles$) OR LF% = 14
        LastLog% = FindLast%(BYVAL VARPTR(Logfile$(14)), 14)
    END IF

  'Exclude a net/nets, etc from BKLARpt.txt       -  -EXN
  '------------------------------------------------------
    P% = INSTR(CmdLine$, "-EXN")
    IF P% THEN
        AXNets$ = MID$(CmdLine$, P%)
        P% = INSTR(AXNets$, " ")
        Posn% = 5
        IF P% THEN AXNets$ = LEFT$(AXNets$, P% - 1)
        DO
            ExcludNet$(Ex%) = ParseString$(Posn%, AXNets$, ",")
            Ex% = Ex% + 1
        LOOP UNTIL Posn% = LEN(AXNets$) OR Ex% = 11
        Last% = FindLast%(BYVAL VARPTR(ExcludNet$(11)), 11)
        IF Last% THEN
            ExNet% = True
        END IF
    END IF

  'Include Mail Detail report with BKLARpt.txt/bbs
  '-----------------------------------------------
    IF INSTR(CmdLine$, "-MD") THEN
        MailDetail% = True
    END IF

  'Don't use High Ascii characters in BKLARpt.Txt   -     -NHA
  '-----------------------------------------------------------
    IF INSTR(CmdLine$, "-NHA") THEN
        HighAscii% = False
    END IF

  'Don't erase the Temp work files (.$$$, .$$S)     -    -KTF
  '----------------------------------------------------------
    IF INSTR(CmdLine$, "-KTF") THEN
        DelTempFiles% = False
    END IF

  'Display Maximum BBS download/upload files         -    -MAX
  '-----------------------------------
    IF INSTR(CmdLine$, "-MAX") THEN
        DispMaxSTats% = True
    END IF

  'Use an external sort program   -  SP=
  '----------------------------
    P% = INSTR(CmdLine$, "SP=")
    IF P% THEN
        Temp$ = MID$(CmdLine$, P% + 3)
        P% = INSTR(Temp$, " ")
        IF P% THEN Temp$ = LEFT$(Temp$, P% - 1)
        SortProgram$ = Temp$
        IntSrt% = False
    END IF

  ' *************************
  ' * Logfile variables
  ' *************************
    BBSEx$ = Log$ + " " + "Exiting to BBS"
    BBSSp$ = Log$ + " " + "Spawning BBS"
    begin$ = Log$ + " " + "begin"
    Conne$ = Log$ + " " + "Connect"
    CPSst$ = Log$ + " " + "CPS:"
    EconA$ = Log$ + " " + "End of connection attempt"
    EEMSI$ = Log$ + " " + "End of EMSI"
    EFTSt$ = Log$ + " " + "End of FTS-0001"
    EndBk$ = Log$ + " " + "end"
    EWazo$ = Log$ + " " + "End of WaZOO"
    FaxCW$ = Log$ + " " + "FAX Connect with"
    FaxFR$ = Log$ + " " + "FAX File received"
    FilRq$ = Log$ + " " + "File Request"
    InCal$ = Log$ + " " + "Incoming call, dial aborted"
    LstCr$ = Log$ + " " + "Lost Carrier"
    NoCar$ = Log$ + " " + "No Carrier"
    NoDiT$ = Log$ + " " + "No Dial Tone"
    NoDTo$ = Log$ + " " + "No Dialtone"
    NoSnd$ = Log$ + " " + "No Send - Remote Hung Up"
    NoYoH$ = Log$ + " " + "No YOOHOO/2U2"
    NuisC$ = Log$ + " " + "Disconnecting nuisance caller"
    ONodS$ = Log$ + " " + "Other node sending to"
    ProcN$ = Log$ + " " + "Processing node"
    PwdEr$ = Log$ + " " + "Password Error from"
    RecvS$ = Log$ + " " + "Received-"
    RecSn$ = Log$ + " " + "Received: 0/0 Sent: 0/0 Total: 0/0 CPS: 0"
    RecS1$ = Log$ + " " + "XReceived:"
    SCFee$ = "Fee:"
    Scnds$ = Log$ + " " + "Seconds:"
    SentS$ = Log$ + " " + "Sent"
    SessW$ = Log$ + " " + "Session with"
    SyncO$ = Log$ + " " + "Synchronizing to Offset"
    Systm$ = "System:"
    TMErr$ = Log$ + " " + "Too many errors"
    TiOut$ = Log$ + " " + "Timeout"
    TrCan$ = Log$ + " " + "Transfer cancelled"

  'Suppress printing of selected files (.Ext) in Part II   -  -SUP
  '---------------------------------------------------------------
    P% = INSTR(CmdLine$, "-SUP")
    IF P% THEN
        AXFiles$ = MID$(CmdLine$, P%)
        P% = INSTR(AXFiles$, " ")
        Posn% = 5
        IF P% THEN AXFiles$ = LEFT$(AXFiles$, P% - 1)
        DO
            ExcludExt$(ExF%) = ParseString$(Posn%, AXFiles$, ",")
            ExF% = ExF% + 1
        LOOP UNTIL Posn% = LEN(AXFiles$) OR ExF% = 16
        LastF% = FindLast%(BYVAL VARPTR(ExcludExt$(15)), 15)
        IF LastF% THEN
            ExcludeFiles% = True
        END IF
    END IF
  'Create Ansi file BKLARpt.bbs        -       -BBS
  '------------------------------------------------
    IF INSTR(CmdLine$, "-BBS") THEN
        BBS% = True
        DispRpt% = False
        BKLARptFile$ = "BKLARpt.Bbs"
    END IF
  'Use an alternate LNG file          -       LNG=
  '-----------------------------------------------
    P% = INSTR(CmdLine$, "LNG=")
    IF P% THEN
        Temp$ = MID$(CmdLine$, P% + 4)
        P% = INSTR(Temp$, " ")
        IF P% THEN Temp$ = LEFT$(Temp$, P% - 1)
        LNGFile$ = Temp$
    END IF

    CALL Copyright

  '***********************************
  '* GLOBAL ERROR TRAP
  '***********************************

   ON ERROR GOTO ErrHandler

  'Make sure we have a Logfile else end the program
  '------------------------------------------------
    IF NOT Exist%(Logfile$(0)) THEN
        BEEP
        Message$ = ErrorMsg$(53)
        CALL ErrorMessage(Message$)
        LOCATE 18, 10
        COLOR WHITE + BRIGHT
        PRINT Logfile$(0); " not found - BinkLA terminated."
        SetLevel (1)
        END
    END IF

  'Parse BinkLAE.Lng file (if required & available)
  '------------------------------------------------
    IF Exist%(LNGFile$) THEN
        Filestat% = 1
        UseLngFile% = True
        Handel% = FREEFILE
        Buffer% = 4096

        OPEN LNGFile$ FOR BINARY AS Handel%

        DO UNTIL Filestat% = -1
            CALL InputLine(Handel%, Buffer%, Filestat%, Record$)
            Record$ = LTRIM$(Record$)
            SELECT CASE UCASE$(LEFT$(Record$, 5))
            CASE IS = "ENDLG"
                EndLg$ = QPTrim$(MID$(Record$, 6))
            CASE IS = "RPTTI"
                RptTi$ = QPTrim$(MID$(Record$, 6))
            CASE IS = "HRSTO"
                HrsTo$ = QPTrim$(MID$(Record$, 6))
            CASE IS = "HOURS"
                Hours$ = QPTrim$(MID$(Record$, 6))
            CASE IS = "STRLG"
                StrLg$ = QPTrim$(MID$(Record$, 6))
            CASE IS = "CREDF"
                CreDF$ = QPTrim$(MID$(Record$, 6))
                CreDF$ = CreDF$ + " "
            CASE IS = "RPT01"
                Rpt$(1) = QPTrim$(MID$(Record$, 6))
            CASE IS = "RPT02"
                Rpt$(2) = QPTrim$(MID$(Record$, 6))
            CASE IS = "RPT03"
                Rpt$(3) = QPTrim$(MID$(Record$, 6))
            CASE IS = "RPT04"
                Rpt$(4) = QPTrim$(MID$(Record$, 6))
            CASE IS = "RPT05"
                Rpt$(5) = QPTrim$(MID$(Record$, 6))
            CASE IS = "RPT06"
                Rpt$(6) = QPTrim$(MID$(Record$, 6))
            CASE IS = "RPT07"
                Rpt$(7) = QPTrim$(MID$(Record$, 6))
            CASE IS = "RPT08"
                Rpt$(8) = QPTrim$(MID$(Record$, 6))
            CASE IS = "RPT09"
                Rpt$(9) = QPTrim$(MID$(Record$, 6))
            CASE IS = "RPT10"
                Rpt$(10) = QPTrim$(MID$(Record$, 6))
            CASE IS = "RPT11"
                Rpt$(11) = QPTrim$(MID$(Record$, 6))
            CASE IS = "RPT12"
                Rpt$(12) = QPTrim$(MID$(Record$, 6))
            CASE IS = "RPT13"
                Rpt$(13) = QPTrim$(MID$(Record$, 6))
            CASE IS = "RPT14"
                Rpt$(14) = QPTrim$(MID$(Record$, 6))
            CASE IS = "RPT15"
                Rpt$(15) = QPTrim$(MID$(Record$, 6))
            CASE IS = "RPT16"
                Rpt$(16) = QPTrim$(MID$(Record$, 6))
            CASE IS = "RPT17"
                Rpt$(17) = QPTrim$(MID$(Record$, 6))
            CASE IS = "RPT18"
                Rpt$(18) = QPTrim$(MID$(Record$, 6))
            CASE IS = "RPT19"
                Rpt$(19) = QPTrim$(MID$(Record$, 6))
            CASE IS = "RPT20"
                Rpt$(20) = QPTrim$(MID$(Record$, 6))
            CASE IS = "RPT21"
                Rpt$(21) = QPTrim$(MID$(Record$, 6))
            CASE IS = "RPT22"
                Rpt$(22) = QPTrim$(MID$(Record$, 6))
            CASE IS = "RPT23"
                Rpt$(23) = QPTrim$(MID$(Record$, 6))
            CASE IS = "RPT79"
                Rpt$(79) = QPTrim$(MID$(Record$, 6))
            CASE IS = "RPT80"
                Rpt$(80) = QPTrim$(MID$(Record$, 6))
            CASE IS = "RPT81"
                Rpt$(81) = QPTrim$(MID$(Record$, 6))
            CASE IS = "RPT24"
                Rpt$(24) = QPTrim$(MID$(Record$, 6))
            CASE IS = "RPT25"
                Rpt$(25) = QPTrim$(MID$(Record$, 6))
            CASE IS = "RPT26"
                Rpt$(26) = QPTrim$(MID$(Record$, 6))
            CASE IS = "RPT27"
                Rpt$(27) = QPTrim$(MID$(Record$, 6))
            CASE IS = "RPT28"
                Rpt$(28) = QPTrim$(MID$(Record$, 6))
            CASE IS = "RPT29"
                Rpt$(29) = QPTrim$(MID$(Record$, 6))
            CASE IS = "RPT30"
                Rpt$(30) = QPTrim$(MID$(Record$, 6))
            CASE IS = "RPT31"
                Rpt$(31) = QPTrim$(MID$(Record$, 6))
            CASE IS = "RPT32"
                Rpt$(32) = QPTrim$(MID$(Record$, 6))
            CASE IS = "RPT33"
                Rpt$(33) = QPTrim$(MID$(Record$, 6))
            CASE IS = "RPT34"
                Rpt$(34) = QPTrim$(MID$(Record$, 6))
            CASE IS = "RPT35"
                Rpt$(35) = QPTrim$(MID$(Record$, 6))
            CASE IS = "RPT36"
                Rpt$(36) = QPTrim$(MID$(Record$, 6))
            CASE IS = "RPT37"
                Rpt$(37) = QPTrim$(MID$(Record$, 6))
            CASE IS = "RPT38"
                Rpt$(38) = QPTrim$(MID$(Record$, 6))
            CASE IS = "RPT39"
                Rpt$(39) = QPTrim$(MID$(Record$, 6))
            CASE IS = "RPT40"
                Rpt$(40) = QPTrim$(MID$(Record$, 6))
            CASE IS = "RPT41"
                Rpt$(41) = QPTrim$(MID$(Record$, 6))
            CASE IS = "RPT42"
                Rpt$(42) = QPTrim$(MID$(Record$, 6))
            CASE IS = "RPT43"
                Rpt$(43) = QPTrim$(MID$(Record$, 6))
            CASE IS = "RPT44"
                Rpt$(44) = QPTrim$(MID$(Record$, 6))
            CASE IS = "RPT45"
                Rpt$(45) = QPTrim$(MID$(Record$, 6))
            CASE IS = "RPT46"
                Rpt$(46) = QPTrim$(MID$(Record$, 6))
            CASE IS = "RPT47"
                Rpt$(47) = QPTrim$(MID$(Record$, 6))
            CASE IS = "RPT48"
                Rpt$(48) = QPTrim$(MID$(Record$, 6))
            CASE IS = "RPT49"
                Rpt$(49) = QPTrim$(MID$(Record$, 6))
            CASE IS = "RPT50"
                Rpt$(50) = QPTrim$(MID$(Record$, 6))
            CASE IS = "RPT51"
                Rpt$(51) = QPTrim$(MID$(Record$, 6))
            CASE IS = "RPT52"
                Rpt$(52) = QPTrim$(MID$(Record$, 6))
            CASE IS = "RPT53"
                Rpt$(53) = QPTrim$(MID$(Record$, 6))
            CASE IS = "RPT54"
                Rpt$(54) = QPTrim$(MID$(Record$, 6))
            CASE IS = "RPT55"
                Rpt$(55) = QPTrim$(MID$(Record$, 6))
            CASE IS = "RPT56"
                Rpt$(56) = QPTrim$(MID$(Record$, 6))
            CASE IS = "RPT57"
                Rpt$(57) = QPTrim$(MID$(Record$, 6))
            CASE IS = "RPT58"
                Rpt$(58) = QPTrim$(MID$(Record$, 6))
            CASE IS = "RPT59"
                Rpt$(59) = QPTrim$(MID$(Record$, 6))
            CASE IS = "RPT60"
                Rpt$(60) = QPTrim$(MID$(Record$, 6))
            CASE IS = "RPT61"
                Rpt$(61) = QPTrim$(MID$(Record$, 6))
            CASE IS = "RPT62"
                Rpt$(62) = QPTrim$(MID$(Record$, 6))
            CASE IS = "RPT63"
                Rpt$(63) = QPTrim$(MID$(Record$, 6))
            CASE IS = "RPT64"
                Rpt$(64) = QPTrim$(MID$(Record$, 6))
            CASE IS = "RPT65"
                Rpt$(65) = QPTrim$(MID$(Record$, 6))
            CASE IS = "RPT66"
                Rpt$(66) = QPTrim$(MID$(Record$, 6))
            CASE IS = "RPT67"
                Rpt$(67) = QPTrim$(MID$(Record$, 6))
            CASE IS = "RPT68"
                Rpt$(68) = QPTrim$(MID$(Record$, 6))
            CASE IS = "RPT69"
                Rpt$(69) = QPTrim$(MID$(Record$, 6))
            CASE IS = "RPT70"
                Rpt$(70) = QPTrim$(MID$(Record$, 6))
            CASE IS = "RPT71"
                Rpt$(71) = QPTrim$(MID$(Record$, 6))
            CASE IS = "RPT72"
                Rpt$(72) = QPTrim$(MID$(Record$, 6))
            CASE IS = "RPT73"
                Rpt$(73) = QPTrim$(MID$(Record$, 6))
            CASE IS = "RPT74"
                Rpt$(74) = QPTrim$(MID$(Record$, 6))
            CASE IS = "RPT75"
                Rpt$(75) = QPTrim$(MID$(Record$, 6))
            CASE IS = "RPT76"
                Rpt$(76) = QPTrim$(MID$(Record$, 6))
            CASE IS = "RPT77"
                Rpt$(77) = QPTrim$(MID$(Record$, 6))
            CASE IS = "RPT78"
                Rpt$(78) = QPTrim$(MID$(Record$, 6))
            CASE IS = "RPT82"
                Rpt$(82) = QPTrim$(MID$(Record$, 6))
            CASE IS = "BBSEX"
                BBSEx$ = Log$ + " " + QPTrim$(MID$(Record$, 6))
            CASE IS = "BBSSP"
                BBSSp$ = Log$ + " " + QPTrim$(MID$(Record$, 6))
            CASE IS = "BEGIN"
                begin$ = Log$ + " " + QPTrim$(MID$(Record$, 6))
            CASE IS = "CONNE"
                Conne$ = Log$ + " " + QPTrim$(MID$(Record$, 6))
            CASE IS = "CPSST"
                CPSst$ = Log$ + " " + QPTrim$(MID$(Record$, 6))
            CASE IS = "ECONA"
                EconA$ = Log$ + " " + QPTrim$(MID$(Record$, 6))
            CASE IS = "EEMSI"
                EEMSI$ = Log$ + " " + QPTrim$(MID$(Record$, 6))
            CASE IS = "EFTST"
                EFTSt$ = Log$ + " " + QPTrim$(MID$(Record$, 6))
            CASE IS = "ENDBK"
                EndBk$ = Log$ + " " + QPTrim$(MID$(Record$, 6))
            CASE IS = "EWAZO"
                EWazo$ = Log$ + " " + QPTrim$(MID$(Record$, 6))
            CASE IS = "FAXCW"
                FaxCW$ = Log$ + " " + QPTrim$(MID$(Record$, 6))
            CASE IS = "FAXFR"
                FaxFR$ = Log$ + " " + QPTrim$(MID$(Record$, 6))
            CASE IS = "FILRQ"
                FilRq$ = Log$ + " " + QPTrim$(MID$(Record$, 6))
            CASE IS = "INCAL"
                InCal$ = Log$ + " " + QPTrim$(MID$(Record$, 6))
            CASE IS = "LSTCR"
                LstCr$ = Log$ + " " + QPTrim$(MID$(Record$, 6))
            CASE IS = "NODIT"
                NoDiT$ = Log$ + " " + QPTrim$(MID$(Record$, 6))
            CASE IS = "NODTO"
                NoDTo$ = Log$ + " " + QPTrim$(MID$(Record$, 6))
            CASE IS = "NOCAR"
                NoCar$ = Log$ + " " + QPTrim$(MID$(Record$, 6))
            CASE IS = "NOSND"
                NoSnd$ = Log$ + " " + QPTrim$(MID$(Record$, 6))
            CASE IS = "NOYOH"
                NoYoH$ = Log$ + " " + QPTrim$(MID$(Record$, 6))
            CASE IS = "NUISC"
                NuisC$ = Log$ + " " + QPTrim$(MID$(Record$, 6))
            CASE IS = "ONODS"
                ONodS$ = Log$ + " " + QPTrim$(MID$(Record$, 6))
            CASE IS = "PROCN"
                ProcN$ = Log$ + " " + QPTrim$(MID$(Record$, 6))
            CASE IS = "PWDER"
                PwdEr$ = Log$ + " " + QPTrim$(MID$(Record$, 6))
            CASE IS = "RECVS"
                RecvS$ = Log$ + " " + QPTrim$(MID$(Record$, 6))
            CASE IS = "RECSN"
                RecSn$ = Log$ + " " + QPTrim$(MID$(Record$, 6))
            CASE IS = "RECS1"
                RecS1$ = Log$ + " " + QPTrim$(MID$(Record$, 6))
            CASE IS = "SCFEE"
                SCFee$ = QPTrim$(MID$(Record$, 6))
            CASE IS = "SCNDS"
                Scnds$ = Log$ + " " + QPTrim$(MID$(Record$, 6))
            CASE IS = "SENTS"
                SentS$ = Log$ + " " + QPTrim$(MID$(Record$, 6))
            CASE IS = "SESSW"
                SessW$ = Log$ + " " + QPTrim$(MID$(Record$, 6))
            CASE IS = "SYNCO"
                SyncO$ = Log$ + " " + QPTrim$(MID$(Record$, 6))
            CASE IS = "SYSTM"
                Systm$ = QPTrim$(MID$(Record$, 6))
            CASE IS = "TIOUT"
                TiOut$ = Log$ + " " + QPTrim$(MID$(Record$, 6))
            CASE IS = "TMERR"
                TMErr$ = Log$ + " " + QPTrim$(MID$(Record$, 6))
            CASE IS = "TRCAN"
                TrCan$ = Log$ + " " + QPTrim$(MID$(Record$, 6))
            END SELECT
        LOOP
        CLOSE Handel%
    END IF

    IF NOT HighAscii% THEN
        FOR X% = 1 TO 82
            CALL Translate(Rpt$(X%))
        NEXT
    END IF

  'Required for InputLine Sub
  '--------------------------
    Filestat% = 1
    Handel% = FREEFILE
    Buffer% = 4096

    OPEN Logfile$(0) FOR BINARY SHARED AS Handel%

  'Logfile Start time
  '------------------
    DO UNTIL Filestat% = -1
        CALL InputLine(Handel%, Buffer%, Filestat%, Record$)
      '+ 15 Dec 12:09:32 BINK begin
        IF INSTR(19, Record$, Log$) THEN
            IF INSTR(Record$, begin$) THEN
                StrLg$ = MID$(Record$, 3, 15)
                EXIT DO
            END IF
        END IF
    LOOP
    CLOSE Handel%

  'Variables for the data files  - BKLAMTmp.$$$ Message transfers & calls
  '----------------------------------------------------------------------
    DIM MNode1 AS STRING * 15
    DIM MCallsOut1 AS INTEGER
    DIM MConnect1 AS INTEGER
    DIM MCallsIn1 AS INTEGER
    DIM MByteOut1 AS LONG
    DIM MByteIn1 AS LONG
    DIM MTimeOut1 AS INTEGER
    DIM MTimeIn1 AS INTEGER

    DIM MNode2 AS STRING * 15
    DIM MCallsOut2 AS INTEGER
    DIM MConnect2 AS INTEGER
    DIM MCallsIn2 AS INTEGER
    DIM MByteout2 AS LONG
    DIM MByteIn2 AS LONG
    DIM MTimeOut2 AS INTEGER
    DIM MTimeIn2 AS INTEGER

  'BKLAFTmp.$$$ File transfers & calls
  '-----------------------------------
    DIM FileNm AS STRING * 14
    DIM FileByteOut AS LONG
    DIM FileByteIn AS LONG
    DIM FileCPS AS INTEGER

  'Initialize
  '----------
    GOSUB InitFV

  'Border line for the report output
  '---------------------------------
    IF HighAscii% THEN
        Bar$ = ""
    ELSE
        Bar$ = "|"
    END IF
  '================================
  'Open Temp Files to receive data
  '================================
    MTmp% = FREEFILE
    OPEN "BKLAMTmp.$$$" FOR OUTPUT AS MTmp%     'Message transfers & calls
    FTmp% = FREEFILE
    OPEN "BKLAFTmp.$$$" FOR OUTPUT AS FTmp%     'File transfers & calls
    Fcst% = FREEFILE
    OPEN "BKLACTmp.$$$" FOR OUTPUT AS Fcst%     'Session cost
    IF MailDetail% THEN
        MDtl% = FREEFILE
        OPEN "BKLAMDtl.$$$" FOR OUTPUT AS MDtl% 'Mail detail demp file
    END IF
    Fax% = FREEFILE
    OPEN "BKLAFax.$$$" FOR OUTPUT AS Fax%       'Incoming Fax files

    IF DispMaxSTats% THEN
        MaxH% = FREEFILE
        OPEN "bklamax.$$$" FOR OUTPUT AS MaxH%  'Max BBS file transfer data
        FOR X% = 68 TO 73
            PRINT #MaxH%, Rpt$(X%)
        NEXT
    END IF

  'Print heading to session cost temp file
  '---------------------------------------
    FOR X% = 15 TO 20
        PRINT #Fcst%, Rpt$(X%)
    NEXT

  'Process the Logfile(s) - Main loop to create data files
  '-------------------------------------------------------
    DO UNTIL CountLogs% = LastLog% + 1
        DO UNTIL CountLogs% = LastLog% + 1
            IF NOT Exist%(Logfile$(CountLogs%)) THEN
                IF CountLogs% <= LastLog% THEN
                    Logfile$(CountLogs%) = Logfile$(CountLogs%) + " (Not Found)"
                    CountLogs% = CountLogs% + 1
                    EXIT DO
                END IF
            END IF
            RecCount = 0
            LOCATE 12, 1
            Handel% = FREEFILE
            Buffer% = 4096
            Filestat% = 1
            OPEN Logfile$(CountLogs%) FOR BINARY SHARED AS Handel%
            CountLogs% = CountLogs% + 1

          'Display record count at column
          '------------------------------
            Ln% = (50 - LEN(Logfile$(CountLogs%))) \ 2

            IF UseLngFile% THEN
                LOCATE 11: COLOR CYAN
                PRINT SPC(Ln%); "Using : "; LNGFile$
            END IF

          'Program loop to create all the data files
          '-----------------------------------------
            DO UNTIL Filestat% = -1
                DO UNTIL Filestat% = -1

                    CALL InputLine(Handel%, Buffer%, Filestat%, Record$)

                  'Display a count of all the records read
                  '------------------------------------
                    RecCount = RecCount + 1
                    LOCATE 12: COLOR GREEN
                    PRINT SPC(Ln%); "Reading "; Logfile$(CountLogs% - 1); ":";
                    COLOR WHITE + BRIGHT
                    PRINT RecCount

                  'Only look at BINK log entries
                  '-------------------------------------
                    IF INSTR(19, Record$, Log$) THEN            'It's a BINK log entry
                      '+ 15 Dec 12:09:32 BINK

                      'Get the log end time from the last entry in EndLg$
                      '---------------------------------------------------
                        IF INSTR(19, Record$, EndBk$) THEN
                          '+ 16 Dec 12:00:00 BINK end,
                            EndLg$ = MID$(Record$, 3, 15)
                            EXIT DO
                        END IF

                      'Get Connect Link Rate
                      '---------------------
                       IF INSTR(19, Record$, Conne$) THEN
                           LinkRate& = VAL(MID$(Record$, 32))
                       END IF

                      'FAX Connect with
                      '----------------
                        IF INSTR(19, Record$, FaxCW$) THEN
                            FaxCall% = FaxCall% + 1
                            P% = LEN(FaxCW$) + 20
                            IF INSTR(P%, Record$, " ") THEN
                                FaxW% = INSTR(P%, Record$, CHR$(34))
                                IF FaxW% THEN
                                    FaxWith$ = LTRIM$(MID$(Record$, FaxW% + 1))
                                    IF RIGHT$(FaxWith$, 1) = CHR$(34) THEN
                                        FaxWith$ = LEFT$(FaxWith$, LEN(FaxWith$) - 1)
                                    END IF
                                END IF
                            ELSE FaxWith$ = "Unknown"
                            END IF
                            EXIT DO
                        END IF

                      'FAX File Received
                      '-----------------
                        IF INSTR(19, Record$, FaxFR$) THEN
                            P% = QInstrB%(-1, Record$, "\")
                            IF P% THEN
                                FaxRec% = True
                                Temp$ = MID$(Record$, P% + 1)
                                P% = INSTR(Temp$, "(")
                                IF P% THEN
                                    FaxFileName$ = RTRIM$(LEFT$(Temp$, P% - 1))
                                    FaxBytes& = QPValL&(MID$(Temp$, P% + 1))
                                    GOSUB WriteFaxTmp
                                END IF
                            END IF

                        END IF

                      'A BBS caller - Exiting to BBS / Spawning BBS
                      '--------------------------------------------
                        IF INSTR(19, Record$, BBSEx$) OR INSTR(19, Record$, BBSSp$) THEN
                            IF INSTR(19, PrevRecord$, Conne$ + " 38400") THEN
                                BBS14% = BBS14% + 1
                                PrevRecord$ = "Unknown"
                                EXIT DO
                            END IF
                            IF INSTR(19, PrevRecord$, Conne$ + " 33600") THEN
                                BBS33% = BBS33% + 1
                                PrevRecord$ = "Unknown"
                                EXIT DO
                            END IF
                            IF INSTR(19, PrevRecord$, Conne$ + " 31200") THEN
                                BBS31% = BBS31% + 1
                                PrevRecord$ = "Unknown"
                                EXIT DO
                            END IF
                            IF INSTR(19, PrevRecord$, Conne$ + " 28800") THEN
                                BBS28% = BBS28% + 1
                                PrevRecord$ = "Unknown"
                                EXIT DO
                            END IF
                            IF INSTR(19, PrevRecord$, Conne$ + " 26400") THEN
                                BBS264% = BBS264% + 1
                                PrevRecord$ = "Unknown"
                                EXIT DO
                            END IF
                            IF INSTR(19, PrevRecord$, Conne$ + " 24000") THEN
                                BBS240% = BBS240% + 1
                                PrevRecord$ = "Unknown"
                                EXIT DO
                            END IF
                            IF INSTR(19, PrevRecord$, Conne$ + " 21600") THEN
                                BBS21% = BBS21% + 1
                                PrevRecord$ = "Unknown"
                                EXIT DO
                            END IF
                            IF INSTR(19, PrevRecord$, Conne$ + " 19200") THEN
                                BBS19% = BBS19% + 1
                                PrevRecord$ = "Unknown"
                                EXIT DO
                            END IF

                            IF INSTR(19, PrevRecord$, Conne$ + " 16800") THEN
                                BBS16% = BBS16% + 1
                                PrevRecord$ = "Unknown"
                                EXIT DO
                            END IF
                            IF INSTR(19, PrevRecord$, Conne$ + " 14400") THEN
                                BBS14% = BBS14% + 1
                                PrevRecord$ = "Unknown"
                                EXIT DO
                            END IF
                            IF INSTR(19, PrevRecord$, Conne$ + " 12000") THEN
                                BBS120% = BBS120% + 1
                                PrevRecord$ = "Unknown"
                                EXIT DO
                            END IF
                            IF INSTR(19, PrevRecord$, Conne$ + " 9600") THEN
                                BBS96% = BBS96% + 1
                                PrevRecord$ = "Unknown"
                                EXIT DO
                            END IF
                            IF INSTR(19, PrevRecord$, Conne$ + " 7200") THEN
                                BBS72% = BBS72% + 1
                                PrevRecord$ = "Unknown"
                                EXIT DO
                            END IF
                            IF INSTR(19, PrevRecord$, Conne$ + " 4800") THEN
                                BBS48% = BBS48% + 1
                                PrevRecord$ = "Unknown"
                                EXIT DO
                            END IF
                            IF INSTR(19, PrevRecord$, Conne$ + " 2400") THEN
                                BBS24% = BBS24% + 1
                                PrevRecord$ = "Unknown"
                                EXIT DO
                            END IF
                            IF INSTR(19, PrevRecord$, Conne$ + " 1200") THEN
                                BBS12% = BBS12% + 1
                                PrevRecord$ = "Unknown"
                                EXIT DO
                            END IF
                            IF INSTR(19, PrevRecord$, Conne$) THEN
                                BBSOther% = BBSOther% + 1
                                PrevRecord$ = "Unknown"
                                EXIT DO
                            END IF
                            IF INSTR(PrevRecord$, "Unknown") THEN
                                BBSOther% = BBSOther% + 1
                                EXIT DO
                            END IF
                        END IF

                      'Session Cost Bink 2.58 and above
                      '--------------------------------
                      ' Seconds:
                        P% = INSTR(19, Record$, Scnds$)
                        IF P% THEN

                            Seconds% = QPValI%(MID$(Record$, P% + LEN(Scnds$)))
                          ' Fee:
                            P% = INSTR(19, Record$, SCFee$)
                            IF P% THEN
                                fee% = QPValI%(MID$(Record$, P% + LEN(SCFee$)))
                                IF fee% > 0 THEN
                                    RptPtIII% = True
                                    SessionCost% = True
                                  'System:
                                    P% = INSTR(19, Record$, Systm$)
                                    IF P% THEN System$ = LTRIM$(MID$(Record$, P% + LEN(Systm$)))
                                    P% = INSTR(System$, "@")
                                    IF P% THEN
                                        System$ = LEFT$(System$, P% - 1)
                                    END IF
                                  'Exclude (-EXN switch)
                                    IF ExNet% THEN
                                        FOR X% = 1 TO Last%
                                            IF INSTR(System$, ExcludNet$(X%)) THEN
                                                ChopNet% = True
                                                EXIT FOR
                                            END IF
                                        NEXT
                                    END IF
                                    IF ChopNet% THEN
                                        ChopNet% = False
                                        EXIT DO
                                    END IF
                                  'Node Number
                                    PRINT #Fcst%, Bar$; LEFT$(System$, 15);
                                  'Date of log entry
                                    PRINT #Fcst%, TAB(18); MID$(Record$, 3, 6);
                                  'Time of log entry
                                    PRINT #Fcst%, TAB(28); MID$(Record$, 10, 5);
                                  'Calculate time of call
                                    IF Seconds% THEN
                                      'Session time
                                        Sec% = 0
                                        Min% = 0
                                        Hr% = 0
                                        Tarif% = 0
                                        IF Seconds% > 60 THEN
                                            Sec% = Seconds% MOD 60
                                            Min% = Seconds% \ 60
                                        ELSE Sec% = Seconds%
                                        END IF
                                        IF Min% > 60 THEN
                                            Temp% = Min% MOD 60
                                            Hr% = Min% \ 60
                                            Min% = Temp%
                                        END IF
                                        PRINT #Fcst%, TAB(36);
                                        PRINT #Fcst%, USING "###"; Hr%;
                                        PRINT #Fcst%, TAB(44);
                                        PRINT #Fcst%, USING "##"; Min%;
                                        PRINT #Fcst%, TAB(50);
                                        PRINT #Fcst%, USING "##"; Sec%;
                                      'Tariff
                                        P% = INSTR(19, Record$, "Tariff:")
                                        IF P% THEN
                                            Tarif% = QPValI%(MID$(Record$, P% + 8))
                                        END IF
                                        PRINT #Fcst%, TAB(58);
                                        PRINT #Fcst%, USING "####"; Tarif%;
                                      'Fee
                                        PRINT #Fcst%, TAB(68);
                                        PRINT #Fcst%, USING "#####"; fee%;
                                      'ending Bar
                                        PRINT #Fcst%, TAB(76); Bar$
                                        TotSessCost% = TotSessCost% + fee%
                                    END IF
                                END IF
                            END IF
                        END IF
                      'Can't identify Zone:Net/Node number try Session With Record
                      '-----------------------------------------------------------
                        IF INSTR(19, Record$, SessW$) THEN
                           'IF RTRIM$(MNode1) = "Unknown" THEN
                            IF QPTrim$(MNode1) = "Unknown" THEN
                                L% = LEN(Record$)
                                Temp$ = RIGHT$(Record$, 20 + LEN(SessW$))
                                L% = INSTR(Temp$, " ")
                                IF L% THEN
                                    MNode1 = LEFT$(Temp$, L%)
                                    IF MCallsIn1 > 0 THEN MCallsIn1 = MCallsIn1 - 1
                                    GOSUB WriteMTmpRec
                                    GOSUB InitFV
                                    EXIT DO
                                END IF
                            END IF
                        END IF

                      'Disconnecting nuisance caller - curmudgeon
                      '------------------------------------------
                        IF INSTR(19, Record$, NuisC$) THEN
                            NuisanceCall% = NuisanceCall% + 1
                            EXIT DO
                        END IF

                      'File Request (for failed file request)
                      '------------
                        IF INSTR(19, Record$, FilRq$) THEN
                            P% = INSTR(19, Record$, "(")
                            IF P% THEN
                                L% = LEN(Record$) - P%
                                ReqFile$ = MID$(Record$, P%)
                                EXIT DO
                            END IF
                        END IF

                      'Processing Node - outgoing call
                      '-------------------------------
                        IF INSTR(19, Record$, ProcN$) THEN
                          '* 15 Dec 12:09:51 BINK Processing node 1:134/13 -- The SuperBox
                            Temp$ = MID$(Record$, 20 + LEN(ProcN$))
                            L% = INSTR(Temp$, " ")
                            IF L% THEN Temp$ = LEFT$(Temp$, L% - 1)
                            L% = INSTR(Temp$, "@")
                            IF L% THEN Temp$ = LEFT$(Temp$, L% - 1)
                            MNode1 = Temp$
                            MCallsOut1 = 1
                            MConnect1 = 1
                            MCallsIn1 = 0
                            ProcNode% = True
                            FirstCall% = True
                            EXIT DO
                        END IF

                      'Other node sending to
                      '---------------------
                        IF INSTR(19, Record$, ONodS$) THEN
                            IF ProcNode% THEN
                                Temp$ = QPTrim$(MID$(Record$, 46))
                                Temp2$ = QPTrim$(MNode1)
                                IF Temp$ = Temp2$ THEN
                                    MConnect1 = 0
                                    GOSUB WriteMTmpRec
                                    GOSUB InitFV
                                    EXIT DO
                                END IF
                            END IF
                        END IF

                      'Too many errors
                      '---------------
                        IF INSTR(19, Record$, TMErr$) THEN
                          ' MConnect1 = 1
                          ' GOSUB WriteMTmpRec
                          ' GOSUB InitFV
                            EXIT DO
                        END IF

                      'Incoming call, dial aborted
                      '---------------------------
                        IF INSTR(19, Record$, InCal$) THEN
                            IF ProcNode% THEN
                                MConnect1 = 0
                                GOSUB WriteMTmpRec
                                GOSUB InitFV
                                EXIT DO
                            END IF
                        END IF

                      'No Dial Tone
                      '------------
                        IF INSTR(19, Record$, NoDiT$) THEN
                            MConnect1 = 0
                            GOSUB WriteMTmpRec
                            GOSUB InitFV
                            EXIT DO
                        END IF
                        IF INSTR(19, Record$, NoDTo$) THEN
                            MConnect1 = 0
                            GOSUB WriteMTmpRec
                            GOSUB InitFV
                            EXIT DO
                        END IF

                      'No Carrier
                      '----------
                        IF INSTR(19, Record$, NoCar$) THEN
                            IF FirstCall% THEN
                                MCallsOut1 = MCallsOut1 - 1
                                FirstCall% = False
                            END IF
                            MCallsOut1 = MCallsOut1 + 1
                            EXIT DO
                        END IF

                      'No YOOHOO/2U2
                      '-------------
                        IF INSTR(19, Record$, NoYoH$) THEN
                            MConnect1 = 1
                            GOSUB WriteMTmpRec
                            GOSUB InitFV
                            EXIT DO
                        END IF

                      'End of connection attempt
                      '-------------------------
                        IF INSTR(19, Record$, EconA$) THEN
                            MConnect1 = 0
                            GOSUB WriteMTmpRec
                            GOSUB InitFV
                            EXIT DO
                        END IF

                      'Password Error
                      '--------------
                        IF INSTR(19, Record$, PwdEr$) THEN
                            PasswordErr% = PasswordErr% + 1
                            EXIT DO
                        END IF

                      'BINK Connect
                      '------------
                        IF INSTR(19, Record$, Conne$ + " ") THEN
                            PrevRecord$ = Record$
                            EXIT DO
                        END IF

                      'Incoming Call
                      '-------------
                        IF NOT ProcNode% THEN
                            IF RIGHT$(Record$, 1) = ")" THEN
                                IF INSTR(19, PrevRecord$, Conne$ + " ") THEN
                                    P% = QInstrB(-1, Record$, "(")
                                    IF P% THEN
                                        Temp$ = MID$(Record$, P% + 1)
                                        L% = LEN(Temp$)
                                        Temp$ = LEFT$(Temp$, L% - 1)
                                        P% = INSTR(Temp$, "@")
                                        IF P% THEN
                                            Temp$ = LEFT$(Temp$, P% - 1)
                                        END IF
                                        MNode1 = Temp$
                                        P% = INSTR(MNode1, "/")
                                        IF P% THEN
                                          'do nothing
                                        ELSE
                                            MNode1 = "Unknown"
                                        END IF
                                        MCallsIn1 = 1
                                        MConnect1 = 1
                                        IF INSTR(19, PrevRecord$, Conne$ + " 33600") THEN
                                            Net33% = Net33% + 1
                                            PrevRecord$ = ""
                                            EXIT DO
                                        END IF

                                        IF INSTR(19, PrevRecord$, Conne$ + " 31200") THEN
                                            Net31% = Net31% + 1
                                            PrevRecord$ = ""
                                            EXIT DO
                                        END IF

                                        IF INSTR(19, PrevRecord$, Conne$ + " 28800") THEN
                                            Net28% = Net28% + 1
                                            PrevRecord$ = ""
                                            EXIT DO
                                        END IF
                                        IF INSTR(19, PrevRecord$, Conne$ + " 26400") THEN
                                            Net264% = Net264% + 1
                                            PrevRecord$ = ""
                                            EXIT DO
                                        END IF
                                        IF INSTR(19, PrevRecord$, Conne$ + " 24000") THEN
                                            Net240% = Net240% + 1
                                            PrevRecord$ = ""
                                            EXIT DO
                                        END IF
                                        IF INSTR(19, PrevRecord$, Conne$ + " 21600") THEN
                                            Net21% = Net21% + 1
                                            PrevRecord$ = ""
                                            EXIT DO
                                        END IF
                                        IF INSTR(19, PrevRecord$, Conne$ + " 19200") THEN
                                            Net19% = Net19% + 1
                                            PrevRecord$ = ""
                                            EXIT DO
                                        END IF
                                        IF INSTR(19, PrevRecord$, Conne$ + " 16800") THEN
                                           Net16% = Net16% + 1
                                           PrevRecord$ = ""
                                           EXIT DO
                                        END IF
                                        IF INSTR(19, PrevRecord$, Conne$ + " 14400") THEN
                                            Net14% = Net14% + 1
                                            PrevRecord$ = ""
                                            EXIT DO
                                        END IF
                                        IF INSTR(19, PrevRecord$, Conne$ + " 12000") THEN
                                            Net120% = Net120% + 1
                                            PrevRecord$ = ""
                                            EXIT DO
                                        END IF
                                        IF INSTR(19, PrevRecord$, Conne$ + " 9600") THEN
                                            Net96% = Net96% + 1
                                            PrevRecord$ = ""
                                            EXIT DO
                                        END IF
                                        IF INSTR(19, PrevRecord$, Conne$ + " 7200") THEN
                                            Net72% = Net72% + 1
                                            PrevRecord$ = ""
                                            EXIT DO
                                        END IF
                                        IF INSTR(19, PrevRecord$, Conne$ + " 4800") THEN
                                            Net48% = Net48% + 1
                                            PrevRecord$ = ""
                                            EXIT DO
                                        END IF
                                        IF INSTR(19, PrevRecord$, Conne$ + " 2400") THEN
                                            Net24% = Net24% + 1
                                            PrevRecord$ = ""
                                            EXIT DO
                                        END IF
                                        IF INSTR(19, PrevRecord$, Conne$ + " 1200") THEN
                                            Net12% = Net12% + 1
                                            PrevRecord$ = ""
                                            EXIT DO
                                        END IF
                                        IF INSTR(19, PrevRecord$, Conne$ + " ") THEN
                                            NetOther% = NetOther% + 1
                                            PrevRecord$ = ""
                                            EXIT DO
                                        END IF
                                        PrevRecord$ = ""
                                        EXIT DO
                                    END IF
                                END IF
                            END IF
                        END IF

                      'BINK Transfer cancelled
                      '-----------------------
                        IF INSTR(19, Record$, "BINK Transfer cancelled") THEN
                            Offset& = 0
                            EXIT DO
                        END IF
                      'Synchronizing to Offset
                      '-----------------------
                        IF INSTR(19, Record$, SyncO$) THEN
                            P% = QInstrB(-1, Record$, " ")
                            Offset& = VAL(MID$(Record$, P%))
                            EXIT DO
                        END IF

                      'CPS stats on incoming/outgoing mail/files ("BINK CPS:")
                      '-------------------------------------------------------
                        IF INSTR(19, Record$, CPSst$) THEN
                            CPSRecord$ = Record$
                            EXIT DO
                        END IF

                      'Sent mail/files - Outgoing
                      '--------------------------
                        IF INSTR(19, Record$, SentS$) AND CPSRecord$ > "" THEN
                            IF ItsMail%(Record$) THEN
                                MailRec% = True
                                CurPos% = 24
                                Temp$ = ParseString$(CurPos%, CPSRecord$, " ")
                                CPSRate$ = ParseString$(CurPos%, CPSRecord$, " ")
                                ByteOut$ = ParseString$(CurPos% + 1, CPSRecord$, " ")
                                ByteOut& = VAL(ByteOut$)
                                CPSOut% = VAL(CPSRate$)
                                IF CPSOut% > 0 THEN
                                    TimeOut& = ByteOut& / CPSOut%
                                ELSE TimeOut% = 0
                                END IF
                                MByteOut1 = MByteOut1 + ByteOut&

                                IF MailDetail% THEN
                                    PRINT #MDtl%, MNode1; Comma;
                                    PRINT #MDtl%, MID$(Record$, 10, 8); Comma; ByteOut&; Comma;
                                    PRINT #MDtl%, CPSOut%; Comma; 0; Comma; 0
                                END IF
                                IF Offset& THEN
                                    MByteOut1 = MByteOut1 + Offset&
                                    Offset& = 0
                                END IF
                                MTimeOut1 = MTimeOut1 + TimeOut&
                                EXIT DO
                            ELSEIF NOT ItsMail%(Record$) THEN
                                CurPos% = 24
                                Temp$ = ParseString$(CurPos%, CPSRecord$, " ")
                                CPSRate$ = ParseString$(CurPos%, CPSRecord$, " ")
                                ByteCount$ = ParseString$(CurPos% + 1, CPSRecord$, " ")
                                FileCPS = VAL(CPSRate$)
                                FileByteOut = VAL(ByteCount$)
                                IF Offset& THEN
                                    FileByteOut = FileByteOut + Offset&
                                    Offset& = 0
                                END IF
                                P% = QInstrB(-1, Record$, "\")
                                IF P% THEN
                                    FileNm = MID$(Record$, P% + 1)
                                ELSEIF QInstrB(-1, Record$, ".RSP") THEN
                                    P% = QInstrB(-1, Record$, " ")
                                    IF P% THEN
                                        FileNm = MID$(Record$, P% + 1) + ReqFile$
                                    END IF
                                END IF

                                GOSUB WriteFTmpRec
                                GOSUB InitFTV
                                EXIT DO
                            END IF
                        END IF

                      'Received mail/files - Incoming
                      '--------------------------
                        IF INSTR(19, Record$, RecvS$) AND CPSRecord$ > "" OR INSTR(19, Record$, RecS1$) AND CPSRecord$ > "" THEN
                            IF ItsMail%(Record$) THEN
                                MailRec% = True
                                CurPos% = 24
                                Temp$ = ParseString$(CurPos%, CPSRecord$, " ")
                                CPSRate$ = ParseString$(CurPos%, CPSRecord$, " ")
                                ByteIn$ = ParseString$(CurPos% + 1, CPSRecord$, " ")
                                ByteIn& = VAL(ByteIn$)
                                CPSIn% = VAL(CPSRate$)
                                IF CPSIn% > 0 THEN
                                    TimeIn& = ByteIn& / CPSIn%
                                ELSE
                                    TimeIn& = 0
                                END IF
                                MByteIn1 = MByteIn1 + ByteIn&
                                IF MailDetail% THEN
                                    PRINT #MDtl%, MNode1; Comma;
                                    PRINT #MDtl%, MID$(Record$, 10, 8); Comma; 0; Comma; 0; Comma;
                                    PRINT #MDtl%, ByteIn&; Comma; CPSIn%
                                END IF

                                IF Offset& THEN
                                    MByteIn1 = MByteIn1 + Offset&
                                    Offset& = 0
                                END IF
                                MTimeIn1 = MTimeIn1 + TimeIn&
                                EXIT DO
                            ELSEIF NOT ItsMail%(Record$) THEN
                                CurPos% = 24
                                Temp$ = ParseString$(CurPos%, CPSRecord$, " ")
                                CPSRate$ = ParseString$(CurPos%, CPSRecord$, " ")
                                ByteCount$ = ParseString$(CurPos% + 1, CPSRecord$, " ")
                                FileCPS = VAL(CPSRate$)
                                FileByteIn = VAL(ByteCount$)
                                IF Offset& THEN
                                    IF QInstrB(-1, Record$, ".req") THEN
                                      'do nothing
                                    ELSE
                                        FileByteIn = FileByteIn + Offset&
                                        Offset& = 0
                                    END IF
                                END IF
                                P% = QInstrB(-1, Record$, "\")
                                IF P% THEN
                                    FileNm = MID$(Record$, P% + 1)
                                END IF
                                GOSUB WriteFTmpRec
                                GOSUB InitFTV
                                EXIT DO
                            END IF
                        END IF

                      'Lost Carrier
                      '------------
                        IF INSTR(19, Record$, LstCr$) THEN
                            IF ProcNode% THEN
                                GOSUB WriteMTmpRec
                                GOSUB InitFV
                                EXIT DO
                            ELSEIF MCallsIn1 THEN
                                GOSUB WriteMTmpRec
                                GOSUB InitFV
                                EXIT DO
                            END IF

                        END IF

                      'Timeout
                      '-------
                        IF INSTR(19, Record$, TiOut$) THEN
                            IF MCallsIn1 THEN
                                TOutNode$ = MNode1
                                GOSUB WriteMTmpRec
                                GOSUB InitFV
                                EXIT DO
                            END IF
                        END IF

                      'No Send - Remote Hung Up
                      '------------------------
                        IF INSTR(19, Record$, NoSnd$) THEN
                            GOSUB WriteMTmpRec
                            GOSUB InitFV
                            EXIT DO
                        END IF

 ' 15 Mar 06:52:32 BINK Received: 0/0 Sent: 0/0 Total: 0/0 CPS: 0
 ' ---------------------------------------------------------------
                       IF INSTR(17, Record$, "BINK Received: 0/0 Sent: 0/0 Total: 0/0 CPS: 0") THEN
                           GOSUB WriteMTmpRec
                           GOSUB InitFV
                           EXIT DO
                       END IF

                      'End of WaZOO Session
                      '--------------------
                        IF INSTR(Record$, EWazo$) THEN
                            IF RTRIM$(MNode1) = "Unknown" THEN EXIT DO
                            GOSUB WriteMTmpRec
                            GOSUB InitFV
                            EXIT DO
                        END IF

                      'End of EMSI Session
                      '--------------------
                        IF INSTR(Record$, EEMSI$) THEN
                            IF RTRIM$(MNode1) = "Unknown" THEN EXIT DO
                            GOSUB WriteMTmpRec
                            GOSUB InitFV
                            EXIT DO
                        END IF

                      'End of FTS-0001 Session
                      '--------------------
                        IF INSTR(Record$, EFTSt$) THEN
                            IF RTRIM$(MNode1) = "Unknown" THEN EXIT DO
                            GOSUB WriteMTmpRec
                            GOSUB InitFV
                            EXIT DO
                        END IF


                      'Maximus BBS Files in/out
                      '------------------------
                    ELSEIF DispMaxSTats% AND MID$(Record$, 19, 4) = "MAX " THEN
                        CALL MaxStats(Record$)
                    END IF
                LOOP
            LOOP
            CLOSE Handel%
        LOOP
    LOOP
  'Dummy Record to mark the end of file
    PRINT #MTmp%, ""; Comma; 0; Comma; 0; Comma; 0;
    PRINT #MTmp%, Comma; 0; Comma; 0; Comma; 0; Comma; 0

    CLOSE Handel%, Fcst%, MTmp%, FTmp%, MDtl%, Fax%, MaxH%

  '************************************
  '* Start BKLARpt.txt - output report
  '************************************
    Rpt% = FREEFILE

    OPEN BKLARptFile$ FOR OUTPUT AS Rpt%

    IF BBS% THEN
        PRINT #Rpt%, ClrScreen$
        PRINT #Rpt%, MorePrompt$
        PRINT #Rpt%, WHTE$
    END IF

    PRINT #Rpt%,
    IF LastLog% > 0 THEN
        PRINT #Rpt%, Rpt$(44);  '* Multiple Logs
    ELSE
        PRINT #Rpt%, Logfile$(0);
    END IF
    PRINT #Rpt%, TAB(61 - LEN(BinklaVersion$)); "BinkLA Version "; BinklaVersion$
    IF INSTR(SysName$, "Not Defined") THEN
        PRINT #Rpt%,
    ELSE
        P% = INSTR(SysName$, "@")
        IF P% THEN
            SysName$ = MID$(SysName$, 3, P% - 3)
            PRINT #Rpt,
            PRINT #Rpt, TAB(38 - LEN(SysName$) \ 2); SysName$
        END IF
    END IF
    LOCATE 7
    PRINT       'SysName$

    Temp$ = "Binkley "

    Temp$ = Temp$ + RptTi$
    PRINT #Rpt%, TAB(38 - LEN(Temp$) \ 2); Temp$
    PRINT #Rpt%, TAB(38 - ((LEN(StrLg$) * 2) + (LEN(HrsTo$)) + (LEN(Hours$) + 3)) \ 2);
    PRINT #Rpt%, StrLg$; " "; HrsTo$; " "; EndLg$; " "; Hours$;

    IF BBS% THEN
        PRINT #Rpt, GREN$
    ELSE
        PRINT #Rpt, CRLF$;
    END IF

    FOR X% = 1 TO 6
        PRINT #Rpt%, Rpt$(X%)
    NEXT

  'Default to internal sort of temp files
    IF IntSrt% THEN
        IF RptPtI% THEN
            IF MTmpCount% THEN
              ' $DYNAMIC
                REDIM Idx&(1 TO MTmpCount%)
                REDIM Seeks&(1 TO MTmpCount%)
                CurSeek& = 1
                MTmp% = FREEFILE
                OPEN "BklamTmp.$$$" FOR INPUT AS MTmp%
                LOCATE 13: COLOR GREEN
                PRINT SPC(Ln%); "Sorting I..."
                FOR X% = 1 TO MTmpCount%
                    LINE INPUT #MTmp%, Record$
                    Seeks&(X%) = CurSeek&
                    CurSeek& = CurSeek& + LEN(Record$) + 2
                    NetNode$ = ParseString$(1, Record$, ",")
                    NetNode$ = RTRIM$(NetNode$)
                    Idx&(X%) = ComputeCRC&(NetNode$)
                NEXT
                CLOSE MTmp%
              'Sort the Index
                CALL SORT(Idx&(), Seeks&(), MTmpCount%)
                MTmp% = FREEFILE
                OPEN "BklamTmp.$$$" FOR INPUT AS MTmp%
                CRCTmp% = FREEFILE
                OPEN "BklamTmp.$$S" FOR OUTPUT AS CRCTmp%
                FOR X% = 1 TO MTmpCount%
                    SEEK #MTmp%, Seeks&(X%)
                    LINE INPUT #MTmp%, Record$
                    PRINT #CRCTmp%, Record$
                NEXT
                PRINT #CRCTmp%, ""; Comma; 0; Comma; 0; Comma; 0;
                PRINT #CRCTmp%, Comma; 0; Comma; 0; Comma; 0; Comma; 0
                CLOSE MTmp%, CRCTmp%
                ERASE Seeks&, Idx&
            END IF
            MTmp% = FREEFILE
            RptIRecCtr% = 0
            OPEN "Bklarpt.$$$" FOR OUTPUT AS #MTmp%
        END IF
    END IF

    IF IntSrt% THEN
        IF RptPtII% THEN
            LOCATE 13: COLOR GREEN
            PRINT SPC(Ln%); "Sorting II..."
            Count% = LineCount%("BklaFTmp.$$$", SPACE$(4096))
            FTmp% = FREEFILE
            OPEN "BklaFTmp.$$$" FOR INPUT AS #FTmp%
            REDIM Rec$(1 TO Count%)
            FOR X% = 1 TO Count%
                LINE INPUT #FTmp%, Rec$(X%)
            NEXT
            CLOSE FTmp%
            CALL SortStr(BYVAL VARPTR(Rec$(1)), Count%, 0)
            FTmp% = FREEFILE
            OPEN "BklaFTmp.$$S" FOR OUTPUT AS #FTmp%
            FOR X% = 1 TO Count%
                PRINT #FTmp%, Rec$(X%)
            NEXT
            CLOSE FTmp%
            ERASE Rec$
        END IF
    END IF

    IF NOT IntSrt% THEN
      '**************************
      '* External Sort of the data files
      '**************************
      '   SortProgram$ = "QSORT"
        IF RptPtI% THEN
            SortFlag% = True
            LOCATE 13: COLOR GREEN
            PRINT SPC(Ln%); "Sorting I..."
Sorting:
            SHELL SortProgram$ + " < BklamTmp.$$$ > BklamTmp.$$S "
        END IF
        IF RptPtII% THEN
            LOCATE 13
            PRINT SPC(Ln%); "Sorting II.."
            SHELL SortProgram$ + " < BklaFTmp.$$$ > BklaFTmp.$$S "
        END IF

        CALL ClearScr(14, 1, 23, 79, -1, -1)
    END IF

    IF RptPtI% THEN

      '**************************************************************
      'Merge Records from BklamTmp.$$S for output report BklaRpt.txt
      '**************************************************************

        STmp% = FREEFILE
        OPEN "BklamTmp.$$S" FOR INPUT AS STmp%
        IF LOF(STmp%) = 0 THEN
            BEEP
            DOSError$ = ErrorCode$(4)
            CALL ErrorMessage(DOSError$)
            LOCATE 17, 13
            COLOR YELLOW
            PRINT "Sort file BKLAMTmp.$$S is Nul (Zero length). Deleting file."
            CLOSE STmp%: KILL "BKLAMTmp.$$S"
            IF Exist%("BKLAMTMP.$$$") THEN KILL "BKLAMTMP.$$$"
            IF Exist%("BKLAFTMP.$$$") THEN KILL "BKLAFTMP.$$$"
            IF Exist%("BKLACTMP.$$$") THEN KILL "BKLACTMP.$$$"
            IF Exist%("BKLAFTMP.$$S") THEN KILL "BKLAFTMP.$$S"
            IF Exist%("BKLAMDTL.$$$") THEN KILL "BKLAMDTL.$$$"
            IF Exist%("BKLAFAX.$$$") THEN KILL "BKLAFAX.$$$"
            IF Exist("bklamax.$$$") THEN KILL "bklamax.$$$"
            LOCATE 18, 17
            COLOR 10, 0
            PRINT "You may have run out of disk space or sort memory."
            IF SortProgram$ = "SORT" THEN
                COLOR CYAN + BRIGHT
                LOCATE 20, 2
                PRINT "SORT program. Failed!"
                CALL SetLevel(1)
                END
            END IF
            CALL SetLevel(1)
            END
        END IF
        IF MkDataFile% THEN
            DatF% = FREEFILE    'Data file from
            OPEN BklaDatF$ FOR OUTPUT AS DatF%  'Part I Report
        END IF

        INPUT #STmp%, MNode1, MCallsOut1, MConnect1, MCallsIn1, MByteOut1
        INPUT #STmp%, MByteIn1, MTimeOut1, MTimeIn1

        INPUT #STmp%, MNode2, MCallsOut2, MConnect2, MCallsIn2, MByteout2
        INPUT #STmp%, MByteIn2, MTimeOut2, MTimeIn2
        DO
            DO
                IF EOF(STmp%) THEN
                    EXIT DO
                END IF
                IF MNode1 = MNode2 THEN
                  'Combine Records
                    MCallsOut1 = MCallsOut1 + MCallsOut2
                    MConnect1 = MConnect1 + MConnect2
                    MCallsIn1 = MCallsIn1 + MCallsIn2
                    MByteOut1 = MByteOut1 + MByteout2
                    MByteIn1 = MByteIn1 + MByteIn2
                    MTimeOut1 = MTimeOut1 + MTimeOut2
                    MTimeIn1 = MTimeIn1 + MTimeIn2

                  'Get the next record
                    INPUT #STmp%, MNode2, MCallsOut2, MConnect2, MCallsIn2, MByteout2
                    INPUT #STmp%, MByteIn2, MTimeOut2, MTimeIn2
                END IF
            LOOP UNTIL MNode1 <> MNode2

            IF MNode1 = MNode2$ THEN
              'Combine Records
                MCallsOut1 = MCallsOut1 + MCallsOut2
                MConnect1 = MConnect1 + MConnect2
                MCallsIn1 = MCallsIn1 + MCallsIn2
                MByteOut1 = MByteOut1 + MByteout2
                MByteIn1 = MByteIn1 + MByteIn2
                MTimeOut1 = MTimeOut1 + MTimeOut2
                MTimeIn1 = MTimeIn1 + MTimeIn2

                GOSUB WriteRpt
            ELSE
                GOSUB WriteRpt
            END IF

            MNode1 = MNode2
            MCallsOut1 = MCallsOut2
            MConnect1 = MConnect2
            MCallsIn1 = MCallsIn2
            MByteOut1 = MByteout2
            MByteIn1 = MByteIn2
            MTimeOut1 = MTimeOut2
            MTimeIn1 = MTimeIn2
            IF EOF(STmp%) THEN EXIT DO
            INPUT #STmp%, MNode2, MCallsOut2, MConnect2, MCallsIn2, MByteout2
            INPUT #STmp%, MByteIn2, MTimeOut2, MTimeIn2
        LOOP UNTIL MNode1 = ""
    ELSE

      'No records to process for the report
      '------------------------------------
        PRINT #Rpt%, Bar$;
        PRINT #Rpt%, TAB(38 - LEN(Rpt$(24)) \ 2); Rpt$(24);
        PRINT #Rpt%, TAB(76); Bar$
        PRINT #Rpt%, Rpt$(8)
    END IF

    IF IntSrt% THEN
        IF RptPtI% THEN
            CLOSE MTmp%
            MTmp% = FREEFILE
            REDIM Rec$(1 TO RptIRecCtr%)
            OPEN "BklaRpt.$$$" FOR INPUT AS #MTmp%
            FOR X% = 1 TO RptIRecCtr%
                LINE INPUT #MTmp%, Rec$(X%)
            NEXT
            CLOSE #MTmp%
            CALL SortStr(BYVAL VARPTR(Rec$(1)), RptIRecCtr%, 0)
            FOR X% = 1 TO RptIRecCtr%
                Posn% = 1
                MNode1 = ParseString$(Posn%, Rec$(X%), ",")
                Temp$ = ParseString$(Posn%, Rec$(X%), ",")
                MCallsOut1 = VAL(Temp$)
                Temp$ = ParseString$(Posn%, Rec$(X%), ",")
                MConnect1 = VAL(Temp$)
                Temp$ = ParseString$(Posn%, Rec$(X%), ",")
                MCallsIn1 = VAL(Temp$)
                Temp$ = ParseString$(Posn%, Rec$(X%), ",")
                MByteOut1 = VAL(Temp$)
                Temp$ = ParseString$(Posn%, Rec$(X%), ",")
                MByteIn1 = VAL(Temp$)
                Temp$ = ParseString$(Posn%, Rec$(X%), ",")
                MTimeOut1 = VAL(Temp$)
                Temp$ = ParseString$(Posn%, Rec$(X%), ",")
                MTimeIn1 = VAL(Temp$)
                Temp$ = ParseString$(Posn%, Rec$(X%), ",")
                MByteOutIn1& = VAL(Temp$)
                Temp$ = ParseString$(Posn%, Rec$(X%), ",")
                MTimeOutIn1% = VAL(Temp$)
                Temp$ = ParseString$(Posn%, Rec$(X%), ",")
                MAvgCPS1% = VAL(Temp$)
                Temp$ = ParseString$(Posn%, Rec$(X%), ",")
                MtimeMin1! = VAL(Temp$)
                NoTot% = True
                IF MkDataFile% THEN
                    IF BobDavis% THEN
                        P% = INSTR(MNode1, ":")
                        IF P% THEN
                            Zone$ = LEFT$(MNode1, P% - 1)
                            Temp$ = MID$(MNode1, P% + 1)
                        ELSE
                            Zone$ = "99"
                            Temp$ = MNode1
                        END IF
                        P% = INSTR(Temp$, "/")
                        IF P% THEN
                            Net$ = LEFT$(Temp$, P% - 1)
                            Node$ = RTRIM$(MID$(Temp$, P% + 1))
                        ELSE
                            Net$ = "9999"
                            Node$ = "999"
                        END IF
                        PRINT #DatF%, Zone$; Comma; Net$; Comma; Node$; Comma;
                    ELSE
                        PRINT #DatF%, MNode1; Comma;
                    END IF
                    PRINT #DatF%, MCallsOut1; Comma; MConnect1; Comma; MCallsIn1; Comma;
                    PRINT #DatF%, MByteOut1; Comma; MByteIn1; Comma; MTimeOut1; Comma;
                    PRINT #DatF%, MTimeIn1; Comma; MByteOutIn1&; Comma; MTimeOutIn1%; Comma;
                    PRINT #DatF%, MAvgCPS1%; Comma;
                    PRINT #DatF%, USING "####.###"; MtimeMin1!
                END IF
                GOSUB BkLARptOut
            NEXT
            ERASE Rec$
        END IF
    END IF
  '************************************
  'Totals for BKLARpt.txt output Part I
  '************************************
    IF RptPtI% THEN
        PRINT #Rpt%, Rpt$(7)

        TotMAvgCPS& = (TotMByteOut1& + TotMByteIn1&)
        IF TotMAvgCPS& > 0 AND TotTimeOutIn& > 0 THEN
            TotMAvgCPS& = (TotMByteOut1& + TotMByteIn1&) \ TotTimeOutIn&
            MTotTimeMin! = TotTimeOutIn& / 60
        END IF
        PRINT #Rpt%, Bar$; " TOTALS"; TAB(17);
        PRINT #Rpt, USING "####"; TotCallsOut1%;
        PRINT #Rpt, TAB(25);
        PRINT #Rpt, USING "####"; TotConnect1%;
        PRINT #Rpt, TAB(33);
        PRINT #Rpt, USING "###"; TotCallsIn1%;
        PRINT #Rpt, TAB(37);
        PRINT #Rpt, USING "###,###,###"; TotMByteOut1&;
        PRINT #Rpt, TAB(51);
        PRINT #Rpt, USING "###,###,###"; TotMByteIn1&;
        PRINT #Rpt, TAB(65);
        PRINT #Rpt, USING "#####"; TotMAvgCPS&;
        PRINT #Rpt, TAB(70);
        PRINT #Rpt, USING "####.#"; MTotTimeMin!;
        PRINT #Rpt, Bar$

        PRINT #Rpt%, Rpt$(8)
    END IF
    PRINT #Rpt,

  'Mail Detail Report if MailDetail% = True  -MD switch
  '----------------------------------------------------
    IF RptPtI% THEN
        IF MailDetail% THEN
            FOR X% = 45 TO 50
                PRINT #Rpt%, Rpt$(X%)
            NEXT
            MDtl% = FREEFILE
            OPEN "BKLAMDtl.$$$" FOR INPUT AS MDtl%
            DO UNTIL EOF(MDtl%)
                INPUT #MDtl%, MNode1, TimeTrans$, MByteOut1, CPSOut%, MByteIn1, CPSIn%
                IF ExNet% THEN
                    FOR X% = 1 TO Last%
                        IF INSTR(MNode1, ExcludNet$(X%)) THEN
                            ChopNet% = True
                            EXIT FOR
                        END IF
                    NEXT
                END IF
                IF NOT ChopNet% THEN
                    PRINT #Rpt%, Bar$; MNode1; TAB(18); TimeTrans$; SPACE$(4);
                    PRINT #Rpt%, USING "###,###,###"; MByteOut1;
                    PRINT #Rpt%, SPACE$(4);
                    PRINT #Rpt%, USING "#####"; CPSOut%;
                    PRINT #Rpt%, SPACE$(6);
                    PRINT #Rpt%, USING "###,###,###"; MByteIn1;
                    PRINT #Rpt%, SPACE$(3);
                    PRINT #Rpt%, USING "#####"; CPSIn%;
                    PRINT #Rpt%, TAB(76); Bar$
                END IF
                ChopNet% = False
            LOOP
          'No records to process for the report
          '------------------------------------
            IF LOF(MDtl%) = 0 THEN
                PRINT #Rpt%, Bar$;
                PRINT #Rpt%, TAB(38 - LEN(Rpt$(24)) \ 2); Rpt$(24);
                PRINT #Rpt%, TAB(76); Bar$
                PRINT #Rpt%, Rpt$(8)
                PRINT #Rpt%,
            ELSE
                PRINT #Rpt%, Rpt$(8)
                PRINT #Rpt%,
            END IF
            CLOSE MDtl%
        END IF
    END IF

  'Heading for BKLARpt.Txt output Part II
  '--------------------------------------

    IF BBS% THEN PRINT #Rpt%, YELLO$; CHR$(27); "[1A"

    FOR X% = 9 TO 14
        PRINT #Rpt%, Rpt$(X%)
    NEXT
    CALL PrtCtrDisp(PrtRec%, Ln%)

  '*************************************************************
  ' Part II of BKLARpt.txt - detail lines - file out/in listing
  '*************************************************************

    IF RptPtII% THEN
        Ctr% = 0
        TmpF% = FREEFILE
        OPEN "BKLAFTmp.$$S" FOR INPUT AS #TmpF%
        DO UNTIL EOF(TmpF%)
            INPUT #TmpF%, MNode1, FileNm, FileByteOut
            INPUT #TmpF%, FileByteIn, FileCPS
            Ctr% = Ctr% + 1
            IF FileCPS > 0 THEN
                FTranMin! = ((FileByteOut + FileByteIn) / FileCPS) / 60
                FTranSec& = (FileByteOut + FileByteIn) \ FileCPS
                TotFTranSec& = TotFTranSec& + FTranSec&
            ELSE
                FTranMin! = 0
            END IF
            TotFByteOut& = TotFByteOut& + FileByteOut
            TotFByteIn& = TotFByteIn& + FileByteIn
            TotFTranMin! = TotFTranMin! + FTranMin!

            PRINT #Rpt%, Bar$; MNode1; TAB(21); UCASE$(FileNm); TAB(37);
            PRINT #Rpt%, USING "###,###,###"; FileByteOut;
            PRINT #Rpt%, TAB(51);
            PRINT #Rpt%, USING "###,###,###"; FileByteIn;
            PRINT #Rpt%, TAB(65);
            PRINT #Rpt%, USING "#####"; FileCPS;
            PRINT #Rpt%, TAB(71);
            PRINT #Rpt%, USING "###.#"; FTranMin!;
            PRINT #Rpt%, Bar$

            PrtRec% = PrtRec% + 1
            CALL PrtCtrDisp(PrtRec%, Ln%)
        LOOP

        PRINT #Rpt%, Rpt$(7)


      '************************************
      '* Totals for BKLARpt.txt - Part II
      '************************************

        IF TotFTranSec& > 0 AND (TotFByteOut& + TotFByteIn&) > 0 THEN
            FileCPSAvg% = (TotFByteOut& + TotFByteIn&) \ TotFTranSec&
        END IF

        PRINT #Rpt%, Bar$; " TOTALS"; TAB(25); Ctr%;
        PRINT #Rpt%, TAB(37);
        PRINT #Rpt%, USING "###,###,###"; TotFByteOut&;
        PRINT #Rpt%, TAB(51);
        PRINT #Rpt%, USING "###,###,###"; TotFByteIn&;
        PRINT #Rpt%, TAB(65);
        PRINT #Rpt%, USING "#####"; FileCPSAvg%;
        PRINT #Rpt%, TAB(70);
        PRINT #Rpt%, USING "####.#"; TotFTranMin!;
        PRINT #Rpt%, Bar$
        PRINT #Rpt%, Rpt$(8)

        PrtRec% = PrtRec% + 1
        CALL PrtCtrDisp(PrtRec%, Ln%)

    ELSE        'No records to process for Part II report
        PRINT #Rpt%, Bar$;
        PRINT #Rpt%, TAB(38 - LEN(Rpt$(24)) \ 2); Rpt$(24);
        PRINT #Rpt%, TAB(76); Bar$
        PRINT #Rpt%, Rpt$(8)
    END IF
  '***********************************
  'Maximus BBS Incoming/outgoing files
  '***********************************
    IF DispMaxSTats% THEN
        MaxH% = FREEFILE
        OPEN "bklamax.$$$" FOR INPUT AS #MaxH%
        PRINT #Rpt%,
        DO UNTIL EOF(MaxH%)
            LINE INPUT #MaxH%, Record$
            PRINT #Rpt%, Record$
        LOOP
        IF MaxFileCount% > 0 THEN
            PRINT #Rpt%, Rpt$(7)
            PRINT #Rpt%, Bar$; " TOTALS"; TAB(25); MaxFileCount%;
            PRINT #Rpt%, TAB(37);
            PRINT #Rpt%, USING "###,###,###"; MaxOutFTot&;
            PRINT #Rpt%, TAB(51);
            PRINT #Rpt%, USING "###,###,###"; MaxInFTot&;
            IF MaxInFTot& + MaxOutFTot& > 0 THEN
                IF MaxSecTot% > 0 THEN
                    MaxAvgCPS% = (MaxInFTot& + MaxOutFTot&) / MaxSecTot%
                    ELSE MaxAvgCPS% = 0
                END IF
            END IF
            TotMaxFTranMin! = MaxSecTot% / 60
            PRINT #Rpt%, TAB(64);
            PRINT #Rpt%, USING "#####"; MaxAvgCPS%;
            PRINT #Rpt%, TAB(70);
            PRINT #Rpt%, USING "####.#"; TotMaxFTranMin!;
            PRINT #Rpt%, Bar$
            PRINT #Rpt%, Rpt$(8)
            IF MissingFileSize& THEN
                PRINT #Rpt, SPACE$(18); "*** Missing file info in Maximus logfile."
            END IF
        ELSE
            PRINT #Rpt%, Bar$;
            PRINT #Rpt%, TAB(38 - LEN(Rpt$(24)) \ 2); Rpt$(24);
            PRINT #Rpt%, TAB(76); Bar$
            PRINT #Rpt%, Rpt$(8)
        END IF
    END IF
  '***************************
  'Part III Incoming Fax Files
  '***************************
  IF FaxRec% THEN
    PRINT #Rpt,
    FOR X% = 57 TO 61
        PRINT #Rpt%, Rpt$(X%)
    NEXT
    IF FaxRec% THEN
        Fax% = FREEFILE
        OPEN "BKLAFax.$$$" FOR INPUT AS #Fax%
        DO UNTIL EOF(Fax%)
            INPUT #Fax, FaxWith$, FaxFileName$, FaxBytes$
            FaxBytes& = QPValL(FaxBytes$)
            PRINT #Rpt%, Bar$; FaxWith$;
            PRINT #Rpt%, TAB(43); FaxFileName$;
            PRINT #Rpt%, TAB(60);
            PRINT #Rpt, USING "###,###,###"; FaxBytes&;
            TotFaxBytes& = TotFaxBytes& + FaxBytes&
            PRINT #Rpt, TAB(76); Bar$
        LOOP
        CLOSE Fax%
        PRINT #Rpt%, Rpt$(8)
 '  ELSE
 '      PRINT #Rpt%, Bar$;
 '      PRINT #Rpt%, TAB(38 - LEN(Rpt$(24)) \ 2); Rpt$(24);
 '      PRINT #Rpt%, TAB(76); Bar$
 '      PRINT #Rpt%, Rpt$(8)
 '
   END IF
  END IF

  '************************************************
  ' Part III Session Cost output from BKLACTmp.$$$
  '************************************************

    IF BBS% THEN PRINT #Rpt%, CYANB$; CHR$(27); "[1A"

    IF RptPtIII% THEN
        CstF% = FREEFILE
        OPEN "BKLACTmp.$$$" FOR INPUT AS #CstF%
        PRINT #Rpt%,
        DO UNTIL EOF(CstF%)
            LINE INPUT #CstF%, Record$
            PRINT #Rpt, Record$

            PrtRec% = PrtRec% + 1
            CALL PrtCtrDisp(PrtRec%, Ln%)

        LOOP
        PRINT #Rpt%, Rpt$(8)
        PRINT #Rpt,
    ELSE
        PRINT #Rpt,
        FOR X% = 15 TO 20
            PRINT #Rpt%, Rpt$(X%)
        NEXT
        PRINT #Rpt%, Bar$;
        PRINT #Rpt%, TAB(38 - LEN(Rpt$(24)) \ 2); Rpt$(24);
        PRINT #Rpt%, TAB(76); Bar$
        PRINT #Rpt%, Rpt$(8)
        PRINT #Rpt,
    END IF

  ' *****************************
  ' Part IV Summary report output
  '******************************

    IF BBS% THEN PRINT #Rpt%, REDC$; CHR$(27); "[1A"

    FOR X% = 21 TO 23
        PRINT #Rpt%, Rpt$(X%)
    NEXT

  ' FOR X% = 79 TO 81
  '     PRINT #Rpt%, Rpt$(X%)
  ' NEXT
    IF DispMaxSTats% THEN
        PRINT #Rpt, Rpt$(79);
'       'BBS Out/In Bytes
        PRINT #Rpt, SPACE$(1); Rpt$(76);
        PRINT #Rpt, USING "###,###,###"; (MaxInFTot& + MaxOutFTot&);
        PRINT #Rpt, TAB(76); Bar$
    ELSE PRINT #Rpt, Rpt$(79); TAB(76); Bar$
    END IF
    PRINT #Rpt, Rpt$(80)
    PRINT #Rpt, Rpt$(81)


  'BBS Callers at 33600
    PRINT #Rpt, Bar$; SPACE$(1); Rpt$(77);
    PRINT #Rpt, USING "####"; BBS33%;
    PRINT #Rpt, Bar$;
    PRINT #Rpt, USING "####"; Net33%;
    PRINT #Rpt, Bar$;
    PRINT #Rpt, USING "####"; NetOut33%;
'   PRINT #Rpt, TAB(33); Bar$;
'   PRINT #Rpt, TAB(76); Bar$
    PRINT #Rpt, Rpt$(82)



  'BBS Callers at 31200
    PRINT #Rpt, Bar$; SPACE$(10); Rpt$(78);
    PRINT #Rpt, USING "####"; BBS31%;
    PRINT #Rpt, Bar$;
    PRINT #Rpt, USING "####"; Net31%;
    PRINT #Rpt, Bar$;
    PRINT #Rpt, USING "####"; NetOut31%;
    PRINT #Rpt, TAB(33); Rpt$(25)

  'BBS Callers at 28800
    PRINT #Rpt, Bar$; SPACE$(10); Rpt$(53);
    PRINT #Rpt, USING "####"; BBS28%;
    PRINT #Rpt, Bar$;
    PRINT #Rpt, USING "####"; Net28%;
    PRINT #Rpt, Bar$;
    PRINT #Rpt, USING "####"; NetOut28%;
    PRINT #Rpt, TAB(33); Rpt$(25)
  ' PRINT #Rpt, SPACE$(1); Rpt$(56)

  'BBS Callers at 26400
    PRINT #Rpt, Bar$; SPACE$(10); Rpt$(62);
    PRINT #Rpt, USING "####"; BBS264%;
    PRINT #Rpt, Bar$;
    PRINT #Rpt, USING "####"; Net264%;
    PRINT #Rpt, Bar$;
    PRINT #Rpt, USING "####"; NetOut264%;
  'Message Bytes Transferred    =
    PRINT #Rpt, Bar$; SPACE$(1); Rpt$(28);
    PRINT #Rpt, USING "###,###,###"; TotMByteOut1& + TotMByteIn1&;
    PRINT #Rpt, TAB(76); Bar$

  'BBS Callers at 24000
    PRINT #Rpt, Bar$; SPACE$(10); Rpt$(63);
    PRINT #Rpt, USING "####"; BBS240%;
    PRINT #Rpt, Bar$;
    PRINT #Rpt, USING "####"; Net240%;
    PRINT #Rpt, Bar$;
    PRINT #Rpt, USING "####"; NetOut240%;
    'File Bytes Transferred       =";
    PRINT #Rpt, Bar$; SPACE$(1); Rpt$(30);
    PRINT #Rpt, USING "###,###,###"; TotFByteOut& + TotFByteIn&;
    PRINT #Rpt, TAB(76); Bar$


  'BBS Callers at 21600
    PRINT #Rpt, Bar$; SPACE$(10); Rpt$(54);
    PRINT #Rpt, USING "####"; BBS21%;
    PRINT #Rpt, Bar$;
    PRINT #Rpt, USING "####"; Net21%;
    PRINT #Rpt, Bar$;
    PRINT #Rpt, USING "####"; NetOut21%;
  'Total Fax File Bytes
    PRINT #Rpt, Bar$; SPACE$(1); Rpt$(74);
    PRINT #Rpt, USING "###,###,###"; TotFaxBytes&;
    PRINT #Rpt, TAB(76); Bar$

  'BBS Callers at 19200
    PRINT #Rpt, Bar$; SPACE$(10); Rpt$(55);
    PRINT #Rpt, USING "####"; BBS19%;
    PRINT #Rpt, Bar$;
    PRINT #Rpt, USING "####"; Net19%;
    PRINT #Rpt, Bar$;
    PRINT #Rpt, USING "####"; NetOut19%;
  'Total Bytes Transferred
    PRINT #Rpt, Bar$; SPACE$(1); Rpt$(32);
    PRINT #Rpt, USING "###,###,###"; (TotFByteOut& + TotFByteIn&) + (TotMByteOut1& + TotMByteIn1&) + TotFaxBytes&;
    PRINT #Rpt, TAB(76); Bar$


  'BBS Callers at 16800   =
    PRINT #Rpt, Bar$; SPACE$(10); Rpt$(51);
    PRINT #Rpt, USING "####"; BBS16%;
    PRINT #Rpt, Bar$;
    PRINT #Rpt, USING "####"; Net16%;
    PRINT #Rpt, Bar$;
    PRINT #Rpt, USING "####"; NetOut16%;
    PRINT #Rpt, Rpt$(25)

  '14400
    PRINT #Rpt, Bar$; SPACE$(10); Rpt$(27);
    PRINT #Rpt, USING "####"; BBS14%;
    PRINT #Rpt, Bar$;
    PRINT #Rpt, USING "####"; Net14%;
    PRINT #Rpt, Bar$;
    PRINT #Rpt, USING "####"; NetOut14%;
    PRINT #Rpt, Rpt$(25)

  'BBS Callers at 12000
    PRINT #Rpt, Bar$; SPACE$(10); Rpt$(64);
    PRINT #Rpt, USING "####"; BBS120%;
    PRINT #Rpt, Bar$;
    PRINT #Rpt, USING "####"; Net120%;
    PRINT #Rpt, Bar$;
    PRINT #Rpt, USING "####"; NetOut120%;
  'Message Connect Time         =
    PRINT #Rpt, TAB(33); Bar$; SPACE$(1); Rpt$(35); SPACE$(6);
    IF MTotTimeMin! > 0 THEN
        MTotTimeHr! = MTotTimeMin! / 60
    END IF
    PRINT #Rpt, USING "###.#"; MTotTimeHr!;
    PRINT #Rpt, Bar$

  '9600   =
    PRINT #Rpt, Bar$; SPACE$(11); Rpt$(29);
    PRINT #Rpt, USING "####"; BBS96%;
    PRINT #Rpt, Bar$;
    PRINT #Rpt, USING "####"; Net96%;
    PRINT #Rpt, Bar$;
    PRINT #Rpt, USING "####"; NetOut96%;
  'File Transfer Connect Time   =
    PRINT #Rpt, Bar$; SPACE$(1); Rpt$(37); SPACE$(6);
    IF TotFTranMin! > 0 THEN
        TotFTranHr! = TotFTranMin! / 60
    END IF
    PRINT #Rpt, USING "###.#"; TotFTranHr!;
    PRINT #Rpt, Bar$

  'BBS Callers at 7200
    PRINT #Rpt, Bar$; SPACE$(11); Rpt$(65);
    PRINT #Rpt, USING "####"; BBS72%;
    PRINT #Rpt, Bar$;
    PRINT #Rpt, USING "####"; Net72%;
    PRINT #Rpt, Bar$;
    PRINT #Rpt, USING "####"; NetOut72%;
  'TOTAL Connect Time (Hours)   =
    PRINT #Rpt, Bar$; SPACE$(1); Rpt$(38); SPACE$(6);
    PRINT #Rpt, USING "###.#"; MTotTimeHr! + TotFTranHr!;
    PRINT #Rpt, Bar$

  'BBS Callers at 4800
    PRINT #Rpt, Bar$; SPACE$(11); Rpt$(66);
    PRINT #Rpt, USING "####"; BBS48%;
    PRINT #Rpt, Bar$;
    PRINT #Rpt, USING "####"; Net48%;
    PRINT #Rpt, Bar$;
    PRINT #Rpt, USING "####"; NetOut48%;
  'TOTAL Network Session Fee    =
    PRINT #Rpt, Bar$; SPACE$(1); Rpt$(40); SPACE$(6);
    PRINT #Rpt, USING "#####"; TotSessCost%;
    PRINT #Rpt, TAB(76); Bar$

  '2400   =
    PRINT #Rpt, Bar$; SPACE$(11); Rpt$(31);
    PRINT #Rpt, USING "####"; BBS24%;
    PRINT #Rpt, Bar$;
    PRINT #Rpt, USING "####"; Net24%;
    PRINT #Rpt, Bar$;
    PRINT #Rpt, USING "####"; NetOut24%;
    PRINT #Rpt, Rpt$(25)

  '1200   =
    PRINT #Rpt, Bar$; SPACE$(11); Rpt$(33);
    PRINT #Rpt, USING "####"; BBS12%;
    PRINT #Rpt, Bar$;
    PRINT #Rpt, USING "####"; Net12%;
    PRINT #Rpt, Bar$;
    PRINT #Rpt, USING "####"; NetOut12%;
    PRINT #Rpt, Rpt$(25)

  'Other  =
    PRINT #Rpt, Bar$; SPACE$(11); Rpt$(34);
    PRINT #Rpt, USING "####"; BBSOther%;
    PRINT #Rpt, Bar$;
    PRINT #Rpt, USING "####"; NetOther%;
    PRINT #Rpt, Bar$;
    PRINT #Rpt, USING "####"; NetOutOthr%;
  'TOTAL Incoming FAX Calls
    PRINT #Rpt, Bar$; SPACE$(1); Rpt$(75); SPACE$(7);
    PRINT #Rpt, USING "####"; FaxCall%;
    PRINT #Rpt, TAB(76); Bar$
  'Nuisance Callers       =
    PRINT #Rpt, Rpt$(41); SPACE$(7);
    PRINT #Rpt, USING "####"; NuisanceCall%;
    PRINT #Rpt, TAB(76); Bar$

  'Password Error Calls   =
  ' IF DispMaxSTats% THEN
  '     PRINT #Rpt, Rpt$(67);
  ' ELSE PRINT #Rpt, Bar$; SPACE$(31); Bar$;
  ' END IF
  ' PRINT #Rpt, SPACE$(1); Rpt$(39); SPACE$(7);
  'TOTAL BBS Callers      =
    PRINT #Rpt, Bar$; SPACE$(1); Rpt$(36);
    PRINT #Rpt, USING "####"; BBS33% + BBS31% + BBS28% + BBS264% + BBS240% + BBS21% + BBS19% + BBS16% + BBS14% + BBS120% + BBS96% + BBS72% + BBS48% + BBS24% + BBS12% + BBSOther%;
    PRINT #Rpt, " ";
    PRINT #Rpt, USING "####"; Net33% + Net31% + Net28% + Net264% + Net240% + Net21% + Net19% + Net16% + Net14% + Net120% + Net96% + Net72% + Net48% + Net24% + Net12% + NetOther%;
    PRINT #Rpt, " ";
    PRINT #Rpt, USING "####"; NetOut33% + NetOut31% + NetOut28% + NetOut264% + NetOut240% + NetOut21% + NetOut19% + NetOut16% + NetOut14% + NetOut120% + NetOut96% + NetOut72% + NetOut48% + NetOut24% + NetOut12% + NetOutOthr%;
    PRINT #Rpt, Rpt$(39); SPACE$(7);
    PRINT #Rpt, USING "####"; PasswordErr%;
    PRINT #Rpt, TAB(76); Bar$

  'Unsuccessful Connect Attempts=
    PRINT #Rpt, Rpt$(42); SPACE$(6);

'   IF DispMaxSTats% THEN
'     'BBS Out/In Bytes
'       PRINT #Rpt, Bar$; SPACE$(1); Rpt$(76);
'       PRINT #Rpt, USING "###,###,###"; (MaxInFTot& + MaxOutFTot&);
'       PRINT #Rpt, TAB(33); Bar$; SPACE$(1); Rpt$(42); SPACE$(6);
'   ELSE PRINT #Rpt, Bar$, TAB(33); Bar$; SPACE$(1); Rpt$(42); SPACE$(6);
'   END IF

    PRINT #Rpt, USING "#####"; (TotCallsOut1% + TotCallsIn1%) - TotConnect1%;
    PRINT #Rpt, Bar$
    PRINT #Rpt, Rpt$(26)
    IF LastLog% > 0 THEN
        PRINT #Rpt, Rpt$(43)    'Processed logs:
        PRINT #Rpt, STRING$(LEN(Rpt$(43)), "-")
        FOR X% = 0 TO LastLog%
            PRINT #Rpt, Logfile$(X%)
        NEXT
    END IF
    IF MkDataFile% THEN
        PRINT #Rpt,
        PRINT #Rpt, TAB(38 - (LEN(CreDF$) + 11) \ 2); CreDF$; " "; BklaDatF$
    END IF
    CLOSE
    LOCATE 16
    PRINT SPC(Ln%); "Finished Output: ";
    COLOR CYAN + BRIGHT
    PRINT BKLARptFile$
    COLOR 7, 0

    IF DelTempFiles% THEN
        KILL "BKLAMTmp.$$$"
        KILL "BKLAFTmp.$$$"
        KILL "BKLACTmp.$$$"
        KILL "BKLAFax.$$$"
        IF RptPtI% THEN
            KILL "BKLAMTmp.$$S"
            IF Exist%("BKLAMDTL.$$$") THEN KILL "BKLAMDTL.$$$"
        END IF
        IF RptPtII% THEN
            KILL "BKLAFTmp.$$S"
        END IF
    END IF
    IF Exist%("Bklarpt.$$$") THEN KILL "Bklarpt.$$$"
    IF Exist("bklamax.$$$") THEN KILL "bklamax.$$$"
    IF DispRpt% THEN
        GOSUB ListFile
    END IF
    END

  '**********************
  ' Program error traps
  '**********************
ErrHandler:
  'Out of String Space
    IF ERR = 14 THEN
        PRINT #Rpt, "                 *** Program ran out of string space."
        CLEAR
        GOSUB KillFilesOnError
        PRINT "Out of String Space"
        PRINT "Exiting to DOS with ErrorLevel set to 14."
        CALL SetLevel(14)
        END
    END IF

    IF SortFlag% AND ERR = 53 AND SortProgram$ <> "SORT" THEN
        SortProgram$ = "SORT"
        RESUME Sorting
    END IF
    PRINT
    BEEP
    Message$ = ErrorMsg$(ERR)
    CALL ErrorMessage(Message$)
    GOSUB KillFilesOnError
    CALL SetLevel(1)
    END

  ' *************************
  ' * Sub-routines
  ' *************************

  'Kill Temp files if program aborts on an error
  '---------------------------------------------
KillFilesOnError:
    CLOSE
    IF Exist%("BKLAMTmp.$$S") THEN KILL "BKLAMTmp.$$S"
    IF Exist%("BKLAMTMP.$$$") THEN KILL "BKLAMTMP.$$$"
    IF Exist%("BKLAFTMP.$$$") THEN KILL "BKLAFTMP.$$$"
    IF Exist%("BKLACTMP.$$$") THEN KILL "BKLACTMP.$$$"
    IF Exist%("BKLAFTMP.$$S") THEN KILL "BKLAFTMP.$$S"
    IF Exist%("BKLAMDTL.$$$") THEN KILL "BKLAMDTL.$$$"
    IF Exist%("BKLARPT.$$$") THEN KILL "BKLARPT.$$$"
    IF Exist%("BKLAFax.$$$") THEN KILL "BKLAFax.$$$"
    IF Exist("bklamax.$$$") THEN KILL "bklamax.$$$"
    RETURN
  'Write Temp Fax File BKLAFAX.$$$
  '-------------------------------
WriteFaxTmp:
    PRINT #Fax%, FaxWith$; Comma; FaxFileName$; Comma; STR$(FaxBytes&)
    RETURN

  'Write BKLAMTmp.$$$ mail record
  '------------------------------
WriteMTmpRec:
    IF INSTR(MNode1, "Unknown") AND TOutNode$ > "" THEN
        MNode1 = TOutNode$
    END IF
    IF ExNet% THEN
        FOR X% = 1 TO Last%
            IF INSTR(MNode1, ExcludNet$(X%)) THEN
                ChopNet% = True
                EXIT FOR
            END IF
        NEXT
    END IF
    IF ChopNet% THEN
        ChopNet% = False
        MailRec% = False
        ProcNode% = False
        RETURN
    END IF

    RptPtI% = True
    MTmpCount% = MTmpCount% + 1
    PRINT #MTmp%, MNode1; Comma; MCallsOut1; Comma;
    PRINT #MTmp%, MConnect1; Comma; MCallsIn1; Comma;
    PRINT #MTmp%, MByteOut1; Comma; MByteIn1; Comma;
    PRINT #MTmp%, MTimeOut1;
    PRINT #MTmp%, Comma;
    PRINT #MTmp%, MTimeIn1
    MailRec% = False
    ProcNode% = False

   'Count Outgoing Calls by LinkRate
   '--------------------------------
    IF MCallsOut1 = 1 AND MConnect1 = 1 THEN
       SELECT CASE LinkRate&
           CASE IS = 33600
               NetOut33% = NetOut33% + 1
           CASE IS = 31200
               NetOut31% = NetOut31% + 1
           CASE IS = 28800
               NetOut28% = NetOut28% + 1
           CASE IS = 26400
               NetOut264% = NetOut264% + 1
           CASE IS = 24000
               NetOut240% = NetOut240% + 1
           CASE IS = 21600
               NetOut21% = NetOut21% + 1
           CASE IS = 19200
               NetOut19% = NetOut19% + 1
           CASE IS = 16800
               NetOut16% = NetOut16% + 1
           CASE IS = 14400
               NetOut14% = NetOut14% + 1
           CASE IS = 12000
               NetOut120% = NetOut120% + 1
           CASE IS = 9600
               NetOut96% = NetOut96% + 1
           CASE IS = 7200
               NetOut72% = NetOut72% + 1
           CASE IS = 4800
               NetOut48% = NetOut48% + 1
           CASE IS = 2400
               NetOut24% = NetOut24% + 1
           CASE IS = 1200
               NetOut12% = NetOut12% + 1
           CASE IS < 1200
               NetOutOthr% = NetOutOthr% + 1
       END SELECT
    END IF

    RETURN

  'Write BKLAFTmp.$$$ file transfer record
  '---------------------------------------
WriteFTmpRec:
    IF INSTR(MNode1, "Unknown") AND TOutNode$ > "" THEN
        MNode1 = TOutNode$
    END IF

    FileNm = UCASE$(FileNm)
    IF ExNet% THEN
        FOR X% = 1 TO Last%
            IF INSTR(MNode1, ExcludNet$(X%)) THEN
                ChopNet% = True
                EXIT FOR
            END IF
        NEXT
    END IF
    IF ChopNet% THEN
        ChopNet% = False
        RETURN
    END IF

    IF ExcludeFiles% THEN
        FOR X% = 1 TO LastF%
            IF INSTR(FileNm, ExcludExt$(X%)) THEN
                ChopExt% = True
                EXIT FOR
            END IF
        NEXT
    END IF

    IF ChopExt% THEN
        ChopExt% = False
        RETURN
    END IF

    RptPtII% = True
    PRINT #FTmp%, MNode1; Comma; LEFT$(FileNm, 12); Comma; FileByteOut; Comma;
    PRINT #FTmp%, FileByteIn; Comma; FileCPS
    IF INSTR(FileNm, ".RSP") THEN
        PRINT #FTmp%, MNode1; Comma; ReqFile$; Comma; 0; Comma;
        PRINT #FTmp%, 0; Comma; 0
    END IF
    Offset& = 0
    RETURN

WriteRpt:
  'Write BKLARpt.Txt detail lines
  'A Nul record slipped in
    IF MCallsOut1 + MConnect1 + MCallsIn1 + MByteOut1 + MByteIn1 + MTimeOut1 + MTimeIn1 = 0 THEN
        RETURN
    END IF

    MByteOutIn1& = MByteOut1 + MByteIn1
    MTimeOutIn1% = MTimeOut1 + MTimeIn1

    IF MByteOutIn1& > 0 AND MTimeOutIn1% > 0 THEN
        MAvgCPS1% = MByteOutIn1& \ MTimeOutIn1%
        MtimeMin1! = MTimeOutIn1% / 60
    END IF

  'Data file from Part I of the report - BKLADat.nnn
    IF NOT IntSrt% THEN
        IF MkDataFile% THEN
            IF BobDavis% THEN
                P% = INSTR(MNode1, ":")
                IF P% THEN
                    Zone$ = LEFT$(MNode1, P% - 1)
                    Temp$ = MID$(MNode1, P% + 1)
                ELSE
                    Zone$ = "99"
                    Temp$ = MNode1
                END IF
                P% = INSTR(Temp$, "/")
                IF P% THEN
                    Net$ = LEFT$(Temp$, P% - 1)
                    Node$ = RTRIM$(MID$(Temp$, P% + 1))
                ELSE
                    Net$ = "9999"
                    Node$ = "999"
                END IF
                PRINT #DatF%, Zone$; Comma; Net$; Comma; Node$; Comma;
            ELSE
                PRINT #DatF%, MNode1; Comma;
            END IF
            PRINT #DatF%, MCallsOut1; Comma; MConnect1; Comma;
            PRINT #DatF%, MCallsOut1; Comma; MConnect1; Comma; MCallsIn1; Comma;
            PRINT #DatF%, MByteOut1; Comma; MByteIn1; Comma; MTimeOut1; Comma;
            PRINT #DatF%, MTimeIn1; Comma; MByteOutIn1&; Comma; MTimeOutIn1%; Comma;
            PRINT #DatF%, MAvgCPS1%; Comma;
            PRINT #DatF%, USING "####.###"; MtimeMin1!
        END IF
    END IF

    IF IntSrt% THEN
        RptIRecCtr% = RptIRecCtr% + 1
        PRINT #MTmp%, MNode1; Comma; MCallsOut1; Comma; MConnect1; Comma; MCallsIn1; Comma;
        PRINT #MTmp%, MByteOut1; Comma; MByteIn1; Comma; MTimeOut1; Comma;
        PRINT #MTmp%, MTimeIn1; Comma; MByteOutIn1&; Comma; MTimeOutIn1%; Comma;
        PRINT #MTmp%, MAvgCPS1%; Comma; MtimeMin1!
        PrtRec% = PrtRec% + 1
        CALL PrtCtrDisp(PrtRec%, Ln%)
    END IF

  'Output to BKLARpt.txt of Part I data
  'collected from BklaMTmp.$$S
    IF NOT IntSrt% THEN
BkLARptOut:
        PRINT #Rpt, Bar$; MNode1; TAB(18);
        PRINT #Rpt, USING "###"; MCallsOut1;
        PRINT #Rpt, TAB(26);
        PRINT #Rpt, USING "###"; MConnect1;
        PRINT #Rpt, TAB(33);
        PRINT #Rpt, USING "###"; MCallsIn1;
        PRINT #Rpt, TAB(37);
        PRINT #Rpt, USING "###,###,###"; MByteOut1;
        PRINT #Rpt, TAB(51);
        PRINT #Rpt, USING "###,###,###"; MByteIn1;
        PRINT #Rpt, TAB(65);
        PRINT #Rpt, USING "#####"; MAvgCPS1%;
        PRINT #Rpt, TAB(71);
        PRINT #Rpt, USING "###.#"; MtimeMin1!;
        PRINT #Rpt, Bar$

        PrtRec% = PrtRec% + 1
        CALL PrtCtrDisp(PrtRec%, Ln%)
    END IF
  'Totals
    IF NoTot% THEN
      'Do nothing
    ELSE
        TotCallsOut1% = TotCallsOut1% + MCallsOut1
        TotConnect1% = TotConnect1% + MConnect1
        TotCallsIn1% = TotCallsIn1% + MCallsIn1
        TotMByteOut1& = TotMByteOut1& + MByteOut1
        TotMByteIn1& = TotMByteIn1& + MByteIn1
        TotTimeOutIn& = TotTimeOutIn& + MTimeOutIn1%

        MByteOutIn1& = 0
        MTimeOutIn1% = 0
        MAvgCPS1% = 0
        MtimeMin1! = 0
        RETURN
    END IF

InitFV:
    MNode1 = "Unknown       "
    MCallsOut1 = 0
    MConnect1 = 0
    MCallsIn1 = 0
    MByteOut1 = 0
    MByteIn1 = 0
    MTimeOut1 = 0
    MTimeIn1 = 0
    RETURN

InitFTV:
    FileNm = "Unknown    "
    FileByteOut = 0
    FileByteIn = 0
    FileCPS = 0
    ByteCount$ = ""
    CPSRate$ = ""
    RETURN

ListFile:
  ' CLEAR
    TYPE FVInfo
        Colr        AS INTEGER  'Text color (white on black default)
        ULRow       AS INTEGER  'these four describe the window's corners
        ULCol       AS INTEGER
        LRRow       AS INTEGER
        LRCol       AS INTEGER
        HorizOffset AS INTEGER  'left margin within the window (see below)
        LoPtr       AS INTEGER  'used internally -- do not change!
        FileHandle  AS INTEGER  'internal (the DOS file handle if you care)
        EndOfFile   AS INTEGER  'used internally -- do not change!
        LineNumber  AS LONG     'line number of top line displayed, READ ONLY
        TabStop     AS INTEGER  'Tab stop setting (see below)
        FileSeek    AS LONG     'force read anywhere in the file (see below)
        FileOffset  AS LONG     'used internally -- do not change!
    END TYPE

    DIM FVI0 AS FVInfo          'create the TYPE variable
    REDIM Array(1 TO 16384)     'set up the MANDATORY 32K buffer

    FVI0.Colr = 10              'select a display color
  ' FVI0.Colr = 7               'select a display color
    FVI0.ULRow = 2              'define the window corners
    FVI0.ULCol = 1
    FVI0.LRRow = 24
    FVI0.LRCol = 80
    FVI0.TabStop = 8

    FileName$ = BKLARptFile$
    Ln% = 76 - (LEN(Copyright1$) + LEN(BinklaVersion$))

    CLS
    Ky = 0      'no keystrokes pending
    Action = 1  'tell FileView to assume full control
    DO
        LOCATE 1, 1
        PRINT SPACE$(Ln% \ 2); Copyright1$; BinklaVersion$; SPACE$(Ln% \ 2)
        LOCATE 25, 1
        COLOR 0, 7
        PRINT "Line:"; LEFT$(STR$(FVI0.LineNumber) + SPACE$(3), 4);
        PRINT "File:"; LEFT$(FileName$ + SPACE$(15), 15);
        PRINT "QUIT: ESC or X  MOVE: "; CHR$(24); CHR$(25); CHR$(27);
        PRINT CHR$(26); " PgUp PgDn Home End";

        FileView FileName$, Ky, Action, FVI0, Array(1)
        IF Ky = 27 OR Ky = 88 OR Ky = 120 THEN
            EXIT DO
        END IF
    LOOP
    COLOR 7, 0
    PRINT
    LOCATE 25, 1
    CALL ClearEOL(0)
    CLOSE
    RETURN

REM $STATIC
DEFSNG A-Z
    FUNCTION ComputeCRC& (X$) STATIC
      ' ComputeCRC - Copyright (C) 1989, Donn Bly, 1:236/7.0
      '
      ' Standard Donn Bly Licencing Agreement:
      '  This code may be used for anything that you want, except for profit.  If
      '  you want to profit from my work you had better talk to me first.
      '
        STATIC InputByte AS INTEGER, CRCWord AS LONG, C%, FeedBackBit AS INTEGER
      '
      ' CRC Calculation Polynomial = X^16+X^15+X^2+X^0
      '
      ' X$ is the block on which to compute the CRC
      '
        CRCWord = 0
        FOR C% = 1 TO LEN(X$)
            InputByte = ASC(MID$(X$, C%, 1))
            FeedBackBit = ((CRCWord AND 32768) = 32768) XOR ((InputByte AND 128) = 128)
            CRCWord = ((CRCWord AND 32767&) * 2&)
            IF FeedBackBit THEN CRCWord = CRCWord XOR &H8005&
            FeedBackBit = ((CRCWord AND 32768) = 32768) XOR ((InputByte AND 64) = 64)
            CRCWord = ((CRCWord AND 32767&) * 2&)
            IF FeedBackBit THEN CRCWord = CRCWord XOR &H8005&
            FeedBackBit = ((CRCWord AND 32768) = 32768) XOR ((InputByte AND 32) = 32)
            CRCWord = ((CRCWord AND 32767&) * 2&)
            IF FeedBackBit THEN CRCWord = CRCWord XOR &H8005&
            FeedBackBit = ((CRCWord AND 32768) = 32768) XOR ((InputByte AND 16) = 16)
            CRCWord = ((CRCWord AND 32767&) * 2&)
            IF FeedBackBit THEN CRCWord = CRCWord XOR &H8005&
            FeedBackBit = ((CRCWord AND 32768) = 32768) XOR ((InputByte AND 8) = 8)
            CRCWord = ((CRCWord AND 32767&) * 2&)
            IF FeedBackBit THEN CRCWord = CRCWord XOR &H8005&
            FeedBackBit = ((CRCWord AND 32768) = 32768) XOR ((InputByte AND 4) = 4)
            CRCWord = ((CRCWord AND 32767&) * 2&)
            IF FeedBackBit THEN CRCWord = CRCWord XOR &H8005&
            FeedBackBit = ((CRCWord AND 32768) = 32768) XOR ((InputByte AND 2) = 2)
            CRCWord = ((CRCWord AND 32767&) * 2&)
            IF FeedBackBit THEN CRCWord = CRCWord XOR &H8005&
            FeedBackBit = ((CRCWord AND 32768) = 32768) XOR ((InputByte AND 1) = 1)
            CRCWord = ((CRCWord AND 32767&) * 2&)
            IF FeedBackBit THEN CRCWord = CRCWord XOR &H8005&
        NEXT C%
        ComputeCRC& = CRCWord
    END FUNCTION

DEFINT A-Z
    SUB ErrorMessage (Message$) STATIC

      ' Trim off spaces on each end of message
        Message$ = LTRIM$(RTRIM$(Message$))

      ' Make message length an odd number
        IF LEN(Message$) MOD 2 = 0 THEN
            Message$ = Message$ + " "
        END IF

      ' Minimum length of message is 9 characters
        DO WHILE LEN(Message$) < 9
            Message$ = " " + Message$ + " "
        LOOP

      ' Maximum length of message is 75
        Message$ = LEFT$(Message$, 75)

      ' Initialization of display
        SCREEN 0
        WIDTH 80
        CLS
        CALL Copyright
        COLOR GREEN + BRIGHT, BLACK
        LOCATE 8, 10
        PRINT "Darn.  I think we just blew it!"

      ' Calculate screen locations
        lm% = LEN(Message$)
        Col% = 38 - lm% \ 2

      ' Create the error box
        COLOR RED + BRIGHT, RED
        LOCATE 12, Col%
        PRINT CHR$(201); STRING$(lm% + 2, 205); CHR$(187)
        LOCATE 13, Col%
        PRINT CHR$(186); SPACE$(lm% + 2); CHR$(186)
        LOCATE 14, Col%
        PRINT CHR$(186); SPACE$(lm% + 2); CHR$(186)
        LOCATE 15, Col%
        PRINT CHR$(200); STRING$(lm% + 2, 205); CHR$(188)

      ' The title
        COLOR CYAN + BRIGHT, RED
        LOCATE 13, 36
        PRINT "* ERROR *";

      ' The message$
        COLOR YELLOW, RED
        LOCATE 14, Col% + 2
        PRINT Message$;

        COLOR WHITE, BLACK

    END SUB

    SUB InputLine (IOCHAN, BUFSIZE, STATUS, TEXT$) STATIC

      '[]=============================================================[]
      '[]        Inputs a line of text from the specified file        []
      '[]=============================================================[]

        STATIC TOTBYTES&        ' Total #bytes in file
        STATIC Bytes&           ' #Bytes read so far
        STATIC SEEKPOS&         ' Seek position in file
        STATIC SPOS             ' Start of line in buffer

      ' Initialize if this is the first call

        IF STATUS = 1 THEN
            STATUS = 0
            TOTBYTES& = LOF(IOCHAN)
            Bytes& = 0
            SEEKPOS& = 1
            Buffer$ = STRING$(BUFSIZE, 0)
            SPOS = 1
        END IF

        EPOS = INSTR(SPOS, Buffer$, CRLF$)
        IF EPOS <> 0 THEN
          '
          ' Easy - have a full line
          '
            TEXT$ = MID$(Buffer$, SPOS, EPOS - SPOS)
        ELSE
          ' Partial line - read the next block
          '  and assemble the full line
          '
            IF LEFT$(Buffer$, 1) = CHR$(0) THEN
                TEXT$ = ""
            ELSE
                TEXT$ = MID$(Buffer$, SPOS, BUFSIZE - SPOS + 1)
            END IF
            IF (SEEKPOS& + BUFSIZE) > TOTBYTES& THEN
                BUFSIZE = TOTBYTES& - SEEKPOS& + 1
                Buffer$ = STRING$(BUFSIZE, 0)
            END IF
            GET #IOCHAN, SEEKPOS&, Buffer$
            Bytes& = Bytes& + BUFSIZE
            SEEKPOS& = SEEKPOS& + BUFSIZE
            IF Bytes& = TOTBYTES& THEN
              '
              ' Last block needs ending CRLF
              '
                IF RIGHT$(Buffer$, 2) <> CRLF$ THEN
                    Buffer$ = Buffer$ + CRLF$
                    BUFSIZE = BUFSIZE + 2
                END IF
            END IF
            IF RIGHT$(TEXT$, 1) = CR$ THEN
              '
              ' Special case - CR at end of previous block
              '
                TEXT$ = LEFT$(TEXT$, LEN(TEXT$) - 1)
                EPOS = 0
            ELSE
                EPOS = INSTR(1, Buffer$, CRLF$)
                TEXT$ = TEXT$ + MID$(Buffer$, 1, EPOS - 1)
            END IF
        END IF

      ' Point to start of next line

        SPOS = EPOS + 2

      ' All done? If so set status and deallocate buffer

        IF (Bytes& = TOTBYTES& AND EPOS = (BUFSIZE - 1)) THEN
            Buffer$ = ""        ' This doesn't ERASE
            STATUS = -1
        END IF

    END SUB

    FUNCTION ItsMail% (Work$)

      'Determine by the extension on the filename is it's
      'Mail or a file of some other flavour.

        P% = QInstrB%(-1, Work$, ".")
        IF P% THEN
            Extension$ = (MID$(Work$, P% + 1, 2))
            SELECT CASE UCASE$(Extension$)
            CASE IS = "MO", "TU", "WE", "TH", "FR", "SA", "SU", "OU", "PK", "CU", "HU", "DU"
                ItsMail% = True
            CASE ELSE
                ItsMail% = False
            END SELECT
        END IF
    END FUNCTION

