/* ********************************** */
/*                                    */
/* Binkley - Adept Outbound Converter */
/*                 by BK              */
/* ********************************** */

/* NOTE:

This rexx script will convert following files:

	*.HLO  = Hold flavor (PKTs and/or file attaches) -> H.*
	*.FLO  = File Attach -> N.*
	*.CLO  = File Attach CRASH flavor -> C.*
	*.REQ  = File Request or Update Request -> R.*

Files listed below are Netmails. They will be renamed and directly zipped into A.* files
whiles corresponding flavor files are created

*.CUT  = Netmail crash flag -> A.* & C.*
*.OUT  = Netmail attach or request flag -> A.* & N.*
*.HUT  = Netmail hold flag -> A.* & H.*

My setup:
I ve setup FASTECHO 1.45 and 1.46. Every node configuration is as normal as you need, but 
DO NOT archieve mails for any node! SET ".PKT" !!!!!!...!!!

You also need a small batch like this:


fastech2 scan         -> scan for outbound mail
fastech2 pack -p      -> pack outbound netmail
bink2adept.cmd        -> mhh .. play quake? .. sorry no netx/ipx included


If you want to make any changes .. feel free .. but lemme know what and why!


Just change the pathes to match your setup!
*/


/* SETUP */

adept_out="c:\adept\mailer\outbound_mail\"          /* Adept Outbound Path */
bink_out="c:\adept\mailer\outbound_mail\bink\"      /* Binkley styled Outbound Path */
default_domain="FIDONET"                            /* default domain */
default_ZONE=2                                      /* your default zone number */
default_point=0                                     /* default point number */

/* ******* */

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

tmp=syscls()
temp=0
path_bink=translate(filespec("P", bink_out))

hold=adept_out||"*.HLO"         /* HOLD flavors */
crash=adept_out||"*.CLO"        /* ATTACH & CRASH */
attach=adept_out||"*.FLO"       /* ATTACH normal */
request=adept_out||"*.REQ"      /* REQUEST & UPDATE REQUEST */

OUT_NM=adept_out||"*.OUT"       /* NetMail */
HLD_NM=adept_out||"*.HUT"       /* HOLD NetMail */
CR_NM=adept_out||"*.CUT"        /* CRASH NetMail without flavor */

call SysFileTree hold, "hold_array.", "FS"
call SysFileTree crash, "crash_array.", "FS"
call SysFileTree attach, "attach_array.", "FS"
call SysFileTree request, "request_array.", "FS"

call SysFileTree OUT_NM, "out_nm_array.", "FS"
call SysFileTree HLD_NM, "hld_NM_array.", "FS"
call SysFileTree cr_nm, "cr_nm_array.", "FS"



/* HOLD PKT */

if hold_array.0 > 0 then do
	do i=1 to hold_array.0
		hold_name.i=strip(subword(hold_array.i, 5),"B")
		domain_hold.i=default_domain                   /* set fido defaults */
		zone_hold.i=default_zone
		point_hold.i=default_point
		path=translate(filespec("P", hold_name.i))

		if path\=path_bink then do                     /* if true either point or other domain */
			path=strip(path, "T", "\")
			last=lastpos("\", path)
			last1=lastpos("\", path, last-1)
			new_zone=substr(path, last1+1, (last-last1-1))
			last2=lastpos(".", new_zone)            /* DOMAIN.ZONE dir? */
			if last2\=0 then do
				new_end=substr(new_zone, last2+1)
				zone_hold.i=x2d(new_end)        /* get domain and zone */
				domain_hold.i=substr(new_zone, 1, last2-1)
			end			
			new_dir=substr(path, last+1)
			last=lastpos(".", new_dir)
			new_end=substr(new_dir, last+1)

			if new_end = "PNT" then do              /* Point -> get net/node.point */
			   net_hold.i=x2d(substr(new_dir,1,4))
			   node_hold.i=x2d(substr(new_dir,5,4))
			   point_hold.i=x2d(substr(filespec( "N", hold_name.i),5,4))
			end
			else do
				zone_hold.i=x2d(new_end)         /* Node -> get net/node.point */
				domain_hold.i=substr(new_dir, 1, last-1)
				net_hold.i=x2d(substr(filespec( "N", hold_name.i),1,4))
				node_hold.i=x2d(substr(filespec( "N", hold_name.i),5,4))
			end
		end
		else do
			net=FILESPEC("N", hold_name.i)
			net=strip(substr(net,1,4),"B")
 			node=FILESPEC("N", hold_name.i)
			node=strip(substr(node,5,4),"B")
			net_hold.i=x2d(net)
			node_hold.i=x2d(node)
		end
		hold_out.i="A."||zone_hold.i||"."||net_hold.i||"."||node_hold.i||"."||point_hold.i||"."||domain_hold.i
		hold_flavor.i="H."||zone_hold.i||"."||net_hold.i||"."||node_hold.i||"."||point_hold.i||"."||domain_hold.i
		say "   ***Creating Outbound "||filespec("N", hold_name.i)||" for "||hold_out.i||" HOLD flavor"
		say ""
	end

	do i=1 to hold_array.0
		file=hold_name.i

		rc_open = STREAM( (file) , "C" , "OPEN" )
		do while lines(file)
			line=linein(file)
			last=lastpos(".", line)
			endung=translate(substr(line, last+1))
			filesearch=adept_out||hold_flavor.i
			call SysFileTree filesearch, "flavor.", "FS"
			if endung="PKT" then do
				'ZIP.EXE -m -j 'adept_out||hold_out.i line
				if flavor.0=0 then do
					say "   *** Creating H-flavor"
					say ""
					rc_open = STREAM( (filesearch) , "C" , "OPEN" )
					rc_open = STREAM( (filesearch) , "C" , "CLOSE" )
				end
			end
			else do
				if flavor.0=0 then do
					say "   *** Creating H-flavor for file attach"
					say ""
					rc_open = STREAM( (filesearch) , "C" , "OPEN" )
					ok=lineout(filesearch, line)
					rc_open = STREAM( (filesearch) , "C" , "CLOSE" )
				end
				else do
					rc_open = STREAM( (filesearch) , "C" , "OPEN" )
					rc_seek = STREAM( (filesearch) , "C" , "SEEK <0" )
					ok=lineout(filesearch, line)
					rc_open = STREAM( (filesearch) , "C" , "CLOSE" )

				end
			end

		end
		rc_open = STREAM( (file) , "C" , "CLOSE" )
		call Sysfiledelete(file)
	end
end

/* *.HUT */

if HLD_NM_array.0 > 0 then do
	do i=1 to hld_nm_array.0
		hld_nm_name.i=strip(subword(hld_nm_array.i, 5),"B")
		domain_hold.i=default_domain
		zone_hold.i=default_zone
		point_hold.i=default_point
		path=translate(filespec("P", hld_nm_name.i))
		if path\=path_bink then do
			path=strip(path, "T", "\")
			last=lastpos("\", path)
			last1=lastpos("\", path, last-1)
			new_zone=substr(path, last1+1, (last-last1-1))
			last2=lastpos(".", new_zone)
			if last2\=0 then do
				new_end=substr(new_zone, last2+1)
				zone_hold.i=x2d(new_end)
				domain_hold.i=substr(new_zone, 1, last2-1)
			end			
			new_dir=substr(path, last+1)
			last=lastpos(".", new_dir)
			new_end=substr(new_dir, last+1)

			if new_end = "PNT" then do
			   net_hold.i=x2d(substr(new_dir,1,4))
			   node_hold.i=x2d(substr(new_dir,5,4))
			   point_hold.i=x2d(substr(filespec( "N", hld_nm_name.i),5,4))
			end
			else do
				zone_hold.i=x2d(new_end)
				domain_hold.i=substr(new_dir, 1, last-1)
				net_hold.i=x2d(substr(filespec( "N", hld_nm_name.i),1,4))
				node_hold.i=x2d(substr(filespec( "N", hld_nm_name.i),5,4))
			end
		end
		else do
			net=FILESPEC("N", hld_nm_name.i)
			net=strip(substr(net,1,4),"B")
 			node=FILESPEC("N", hld_nm_name.i)
			node=strip(substr(node,5,4),"B")
			net_hold.i=x2d(net)
			node_hold.i=x2d(node)
		end
		hld_nm_out.i="A."||zone_hold.i||"."||net_hold.i||"."||node_hold.i||"."||point_hold.i||"."||domain_hold.i
		hld_nm_flavor.i="H."||zone_hold.i||"."||net_hold.i||"."||node_hold.i||"."||point_hold.i||"."||domain_hold.i
		say "   ***Creating Outbound "||filespec("N", hld_nm_name.i)||" for "||hld_nm_out.i||" HOLD flavor"
		say ""
	end

	do i=1 to hld_nm_array.0
		file=hld_nm_name.i
		filesearch=adept_out||hld_nm_flavor.i
		call SysFileTree filesearch, "flavor.", "FS"
		new_name=pkt_name()
		'@ren 'hld_nm_name.i new_name
		'@ZIP.EXE -m -j 'adept_out||hld_nm_out.i path||'\'||new_name
		if flavor.0=0 then do
			say "   *** Creating H-flavor"
			say ""
			rc_open = STREAM( (filesearch) , "C" , "OPEN" )
			rc_close = STREAM( (filesearch) , "C" , "CLOSE" )
		end
	end
end


/* *.OUT */

if OUT_NM_array.0 > 0 then do
	do i=1 to OUT_NM_array.0
		OUT_NM_name.i=strip(subword(OUT_NM_array.i, 5),"B")
		domain_hold.i=default_domain
		zone_hold.i=default_zone
		point_hold.i=default_point
		path=translate(filespec("P", OUT_NM_name.i))
		if path\=path_bink then do
			path=strip(path, "T", "\")
			last=lastpos("\", path)
			last1=lastpos("\", path, last-1)
			new_zone=substr(path, last1+1, (last-last1-1))
			last2=lastpos(".", new_zone)
			if last2\=0 then do
				new_end=substr(new_zone, last2+1)
				zone_hold.i=x2d(new_end)
				domain_hold.i=substr(new_zone, 1, last2-1)
			end			
			new_dir=substr(path, last+1)
			last=lastpos(".", new_dir)
			new_end=substr(new_dir, last+1)

			if new_end = "PNT" then do
			   net_hold.i=x2d(substr(new_dir,1,4))
			   node_hold.i=x2d(substr(new_dir,5,4))
			   point_hold.i=x2d(substr(filespec( "N", OUT_NM_name.i),5,4))
			end
			else do
				zone_hold.i=x2d(new_end)
				domain_hold.i=substr(new_dir, 1, last-1)
				net_hold.i=x2d(substr(filespec( "N", OUT_NM_name.i),1,4))
				node_hold.i=x2d(substr(filespec( "N", OUT_NM_name.i),5,4))
			end
		end
		else do
			net=FILESPEC("N", OUT_NM_name.i)
			net=strip(substr(net,1,4),"B")
 			node=FILESPEC("N", OUT_NM_name.i)
			node=strip(substr(node,5,4),"B")
			net_hold.i=x2d(net)
			node_hold.i=x2d(node)
		end
		OUT_NM_out.i="A."||zone_hold.i||"."||net_hold.i||"."||node_hold.i||"."||point_hold.i||"."||domain_hold.i
		OUT_NM_flavor.i="H."||zone_hold.i||"."||net_hold.i||"."||node_hold.i||"."||point_hold.i||"."||domain_hold.i
		say "   ***Creating Outbound "||filespec("N", OUT_NM_name.i)||" for "||OUT_NM_out.i||" HOLD flavor"
		say ""
	end

	do i=1 to OUT_NM_array.0
		file=OUT_NM_name.i
		filesearch=adept_out||OUT_NM_flavor.i
		call SysFileTree filesearch, "flavor.", "FS"
		new_name=pkt_name()
		'@ren 'out_nm_name.i new_name
		'@ZIP.EXE -m -j 'adept_out||out_nm_out.i path||'\'||new_name
		if flavor.0=0 then do
			say "   *** Creating H-flavor"
			say ""
			rc_open = STREAM( (filesearch) , "C" , "OPEN" )
			rc_close = STREAM( (filesearch) , "C" , "CLOSE" )
		end
	end
end


/* CRASH PKT */

if crash_array.0 > 0 then do
	do i=1 to crash_array.0
		crash_name.i=strip(subword(crash_array.i, 5),"B")
		domain_hold.i=default_domain
		zone_hold.i=default_zone
		point_hold.i=default_point
		path=translate(filespec("P", crash_name.i))
		if path\=path_bink then do
			path=strip(path, "T", "\")
			last=lastpos("\", path)
			last1=lastpos("\", path, last-1)
			new_zone=substr(path, last1+1, (last-last1-1))
			last2=lastpos(".", new_zone)
			if last2\=0 then do
				new_end=substr(new_zone, last2+1)
				zone_hold.i=x2d(new_end)
				domain_hold.i=substr(new_zone, 1, last2-1)
			end			
			new_dir=substr(path, last+1)
			last=lastpos(".", new_dir)
			new_end=substr(new_dir, last+1)

			if new_end = "PNT" then do
			   net_hold.i=x2d(substr(new_dir,1,4))
			   node_hold.i=x2d(substr(new_dir,5,4))
			   point_hold.i=x2d(substr(filespec( "N", crash_name.i),5,4))
			end
			else do
				zone_hold.i=x2d(new_end)
				domain_hold.i=substr(new_dir, 1, last-1)
				net_hold.i=x2d(substr(filespec( "N", crash_name.i),1,4))
				node_hold.i=x2d(substr(filespec( "N", crash_name.i),5,4))
			end
		end
		else do
			net=FILESPEC("N", crash_name.i)
			net=strip(substr(net,1,4),"B")
 			node=FILESPEC("N", crash_name.i)
			node=strip(substr(node,5,4),"B")
			net_hold.i=x2d(net)
			node_hold.i=x2d(node)
		end
		crash_out.i="A."||zone_hold.i||"."||net_hold.i||"."||node_hold.i||"."||point_hold.i||"."||domain_hold.i
		crash_flavor.i="C."||zone_hold.i||"."||net_hold.i||"."||node_hold.i||"."||point_hold.i||"."||domain_hold.i
		say "   ***Creating Outbound "||filespec("N", crash_name.i)||" for "||crash_out.i||" CRASH flavor"
		say ""
	end

	do i=1 to crash_array.0
		file=crash_name.i

		rc_open = STREAM( (file) , "C" , "OPEN" )
		do while lines(file)
			line=linein(file)
			last=lastpos(".", line)
			endung=translate(substr(line, last+1))
			filesearch=adept_out||crash_flavor.i
			call SysFileTree filesearch, "flavor.", "FS"
			if endung="PKT" then do
				'ZIP.EXE -m -j 'adept_out||crash_out.i line
				if flavor.0=0 then do
					say "   *** Creating C-flavor"
					say ""
					rc_open = STREAM( (filesearch) , "C" , "OPEN" )
					rc_open = STREAM( (filesearch) , "C" , "CLOSE" )
				end
			end
			else do
				if flavor.0=0 then do
					say "   *** Creating C-flavor for file attach"
					say ""
					rc_open = STREAM( (filesearch) , "C" , "OPEN" )
					ok=lineout(filesearch, line)
					rc_open = STREAM( (filesearch) , "C" , "CLOSE" )
				end
				else do
					rc_open = STREAM( (filesearch) , "C" , "OPEN" )
					rc_seek = STREAM( (filesearch) , "C" , "SEEK <0" )
					ok=lineout(filesearch, line)
					rc_open = STREAM( (filesearch) , "C" , "CLOSE" )

				end
			end
		end
		rc_open = STREAM( (file) , "C" , "CLOSE" )
		call Sysfiledelete(file)
	end
end


/* *.CUT */

if CR_NM_array.0 > 0 then do
	do i=1 to CR_NM_array.0
		CR_NM_name.i=strip(subword(CR_NM_array.i, 5),"B")
		domain_hold.i=default_domain
		zone_hold.i=default_zone
		point_hold.i=default_point
		path=translate(filespec("P", CR_NM_name.i))
		if path\=path_bink then do
			path=strip(path, "T", "\")
			last=lastpos("\", path)
			last1=lastpos("\", path, last-1)
			new_zone=substr(path, last1+1, (last-last1-1))
			last2=lastpos(".", new_zone)
			if last2\=0 then do
				new_end=substr(new_zone, last2+1)
				zone_hold.i=x2d(new_end)
				domain_hold.i=substr(new_zone, 1, last2-1)
			end			
			new_dir=substr(path, last+1)
			last=lastpos(".", new_dir)
			new_end=substr(new_dir, last+1)

			if new_end = "PNT" then do
			   net_hold.i=x2d(substr(new_dir,1,4))
			   node_hold.i=x2d(substr(new_dir,5,4))
			   point_hold.i=x2d(substr(filespec( "N", CR_NM_name.i),5,4))
			end
			else do
				zone_hold.i=x2d(new_end)
				domain_hold.i=substr(new_dir, 1, last-1)
				net_hold.i=x2d(substr(filespec( "N", CR_NM_name.i),1,4))
				node_hold.i=x2d(substr(filespec( "N", CR_NM_name.i),5,4))
			end
		end
		else do
			net=FILESPEC("N", CR_NM_name.i)
			net=strip(substr(net,1,4),"B")
 			node=FILESPEC("N", CR_NM_name.i)
			node=strip(substr(node,5,4),"B")
			net_hold.i=x2d(net)
			node_hold.i=x2d(node)
		end
		CR_NM_out.i="A."||zone_hold.i||"."||net_hold.i||"."||node_hold.i||"."||point_hold.i||"."||domain_hold.i
		CR_NM_flavor.i="C."||zone_hold.i||"."||net_hold.i||"."||node_hold.i||"."||point_hold.i||"."||domain_hold.i
		say "   ***Creating Outbound "||filespec("N", CR_NM_name.i)||" for "||CR_NM_out.i||" CRASH flavor"
		say ""
	end

	do i=1 to CR_NM_array.0
		file=CR_NM_name.i
		filesearch=adept_out||CR_NM_flavor.i
		call SysFileTree filesearch, "flavor.", "FS"

		new_name=pkt_name()
		'@ren 'cr_nm_name.i new_name
		'@ZIP.EXE -m -j 'adept_out||cr_nm_out.i path||'\'||new_name
		if flavor.0=0 then do
			say "   *** Creating C-flavor"
			say ""
			rc_open = STREAM( (filesearch) , "C" , "OPEN" )
			rc_close = STREAM( (filesearch) , "C" , "CLOSE" )
		end
	end
end




/* FLO ATTACH */

if attach_array.0 > 0 then do
	do i=1 to attach_array.0
		attach_name.i=strip(subword(attach_array.i, 5),"B")
		domain_hold.i=default_domain
		zone_hold.i=default_zone
		point_hold.i=default_point
		path=translate(filespec("P", attach_name.i))
		if path\=path_bink then do
			path=strip(path, "T", "\")
			last=lastpos("\", path)
			last1=lastpos("\", path, last-1)
			new_zone=substr(path, last1+1, (last-last1-1))
			last2=lastpos(".", new_zone)
			if last2\=0 then do
				new_end=substr(new_zone, last2+1)
				zone_hold.i=x2d(new_end)
				domain_hold.i=substr(new_zone, 1, last2-1)
			end			
			new_dir=substr(path, last+1)
			last=lastpos(".", new_dir)
			new_end=substr(new_dir, last+1)

			if new_end = "PNT" then do
			   net_hold.i=x2d(substr(new_dir,1,4))
			   node_hold.i=x2d(substr(new_dir,5,4))
			   point_hold.i=x2d(substr(filespec( "N", attach_name.i),5,4))
			end
			else do
				zone_hold.i=x2d(new_end)
				domain_hold.i=substr(new_dir, 1, last-1)
				net_hold.i=x2d(substr(filespec( "N", attach_name.i),1,4))
				node_hold.i=x2d(substr(filespec( "N", attach_name.i),5,4))
			end
		end
		else do
			net=FILESPEC("N", attach_name.i)
			net=strip(substr(net,1,4),"B")
 			node=FILESPEC("N", attach_name.i)
			node=strip(substr(node,5,4),"B")
			net_hold.i=x2d(net)
			node_hold.i=x2d(node)
		end
		attach_out.i="A."||zone_hold.i||"."||net_hold.i||"."||node_hold.i||"."||point_hold.i||"."||domain_hold.i
		attach_flavor.i="N."||zone_hold.i||"."||net_hold.i||"."||node_hold.i||"."||point_hold.i||"."||domain_hold.i
		say "   ***Creating Outbound "||filespec("N", attach_name.i)||" for "||attach_out.i||" HOLD flavor"
		say ""
	end

	do i=1 to attach_array.0
		file=attach_name.i

		rc_open = STREAM( (file) , "C" , "OPEN" )
		do while lines(file)
			line=linein(file)
			last=lastpos(".", line)
			endung=translate(substr(line, last+1))
			filesearch=adept_out||attach_flavor.i
			call SysFileTree filesearch, "flavor.", "FS"
			say "   *** Creating H-flavor for file attach"
			say ""
			if endung="PKT" then do
				'ZIP.EXE -m -j 'adept_out||attach_out.i line
				if flavor.0=0 then do
					rc_open = STREAM( (filesearch) , "C" , "OPEN" )
					rc_open = STREAM( (filesearch) , "C" , "CLOSE" )
				end
			end
			else do
				if flavor.0=0 then do
					rc_open = STREAM( (filesearch) , "C" , "OPEN" )
					ok=lineout(filesearch, line)
					rc_open = STREAM( (filesearch) , "C" , "CLOSE" )
				end
				else do
					rc_open = STREAM( (filesearch) , "C" , "OPEN" )
					rc_seek = STREAM( (filesearch) , "C" , "SEEK <0" )
					ok=lineout(filesearch, line)
					rc_open = STREAM( (filesearch) , "C" , "CLOSE" )

				end
			end
		end
		rc_open = STREAM( (file) , "C" , "CLOSE" )
		call Sysfiledelete(file)
	end
end


/* REQUESTS */

if request_array.0 > 0 then do
	do i=1 to request_array.0
		request_name.i=strip(subword(request_array.i, 5),"B")
		domain_hold.i=default_domain
		zone_hold.i=default_zone
		point_hold.i=default_point
		path=translate(filespec("P", request_name.i))
		if path\=path_bink then do
			path=strip(path, "T", "\")
			last=lastpos("\", path)
			last1=lastpos("\", path, last-1)
			new_zone=substr(path, last1+1, (last-last1-1))
			last2=lastpos(".", new_zone)
			if last2\=0 then do
				new_end=substr(new_zone, last2+1)
				zone_hold.i=x2d(new_end)
				domain_hold.i=substr(new_zone, 1, last2-1)
			end			
			new_dir=substr(path, last+1)
			last=lastpos(".", new_dir)
			new_end=substr(new_dir, last+1)

			if new_end = "PNT" then do
			   net_hold.i=x2d(substr(new_dir,1,4))
			   node_hold.i=x2d(substr(new_dir,5,4))
			   point_hold.i=x2d(substr(filespec( "N", request_name.i),5,4))
			end
			else do
				zone_hold.i=x2d(new_end)
				domain_hold.i=substr(new_dir, 1, last-1)
				net_hold.i=x2d(substr(filespec( "N", request_name.i),1,4))
				node_hold.i=x2d(substr(filespec( "N", request_name.i),5,4))
			end
		end
		else do
			net=FILESPEC("N", request_name.i)
			net=strip(substr(net,1,4),"B")
 			node=FILESPEC("N", request_name.i)
			node=strip(substr(node,5,4),"B")
			net_hold.i=x2d(net)
			node_hold.i=x2d(node)
		end
		request_flavor.i="R."||zone_hold.i||"."||net_hold.i||"."||node_hold.i||"."||point_hold.i||"."||domain_hold.i
		say "   ***Creating Outbound "||filespec("N", request_name.i)||" for "||request_out.i||" REQUEST flavor"
		say ""
	end

	do i=1 to request_array.0
		file=request_name.i

		rc_open = STREAM( (file) , "C" , "OPEN" )
		do while lines(file)
			line=linein(file)
			last=lastpos(".", line)
			endung=translate(substr(line, last+1))
			filesearch=adept_out||request_flavor.i
			call SysFileTree filesearch, "flavor.", "FS"
			say "   *** Creating R-flavor for file request"
			say ""
				if flavor.0=0 then do
					rc_open = STREAM( (filesearch) , "C" , "OPEN" )
					ok=lineout(filesearch, line)
					rc_open = STREAM( (filesearch) , "C" , "CLOSE" )
				end
				else do
					rc_open = STREAM( (filesearch) , "C" , "OPEN" )
					rc_seek = STREAM( (filesearch) , "C" , "SEEK <0" )
					ok=lineout(filesearch, line)
					rc_open = STREAM( (filesearch) , "C" , "CLOSE" )

				end
		end
		rc_open = STREAM( (file) , "C" , "CLOSE" )
		call Sysfiledelete(file)
	end
end


say ""
say ""
say center("   *****************************",70)
say center("   * Binkley - Adept Converter *",70)
say center("   *                           *",70)
say center("   *     --==BREAKDOWN==--     *",70)
say center("   *                           *",70)
say center("   *****************************",70)
say center("                          BK'97 ",70)
say ""

say "   *** "||hold_array.0||" HLO file(s) found"
say "   *** "||crash_array.0||" CLO file(s) found"
say "   *** "||request_array.0||" REQ file(s)" 
say "   *** "||attach_array.0||" FLO file(s) found"

hold=out_nm_array.0+hld_nm_array.0
say "   *** "||hold||" NetMail(s) and "||cr_nm_array.0||" CRASH NetMail(s) found"
say ""
say "   *** DONE!"

exit

pkt_name:

	tage=0
	zeit=0
	new_name=""

/* FTS-0009: [MSGID]
   The serial number may be any eight
   character hexadecimal number,  as long as it is unique - no two
   messages from a given system may have the same serial number
   within a three years.  The manner in which this serial number is
   generated is left to the implementor.

   NOTE:
   I ve no idea how to make unique for 3 years. i ve decided to make them unique
   for one year - any other test i made would need more than 8 characters.
   Once i can find out the way gatekeeper will name PKTs i will replace this function.
*/
	tage=d2x(date("D"))
	zeit=(time("S"))
	zeit=zeit+temp
	zeit=d2x(zeit)
	new_name=tage||zeit
	laenge=length(new_name)
	do a=laenge to 7
		new_name='0'||new_name
	end
	temp=temp+1
	new_name=new_name||'.PKT'
return new_name

