unit Bildemo1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, BIL, DdeMan;

type
  TForm1 = class(TForm)
    ButtonInstall: TButton;
    ButtonExit: TButton;
    EditInstallTo: TEdit;
    EditInstallFrom: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    DdeClientConv1: TDdeClientConv;
    procedure ButtonInstallClick(Sender: TObject);
    procedure ButtonExitClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.ButtonInstallClick(Sender: TObject);
Var
   TListParams: TStringList;
   sProgram: String;
   bRet:     boolean;
   cIDAPI:   string;
begin
 
    { Set directory to a directory supplied in a Edit Box }
    SetInstallToDir( EditInstallTo.Text );

    { Set directory to a directory supplied in a Edit Box }
    SetInstallFromDir( EditInstallFrom.Text );

    { Get Program Directory }
    sProgram := sGetProgDir;

    if MessageDlg( 'This Program is about to do the following:' + chr(13) + chr(10) +
                '  Create directory ' + sProgram + chr(13) + chr(10) +
                '  Decompress ' + EditInstallFrom.Text + '\DEMO.TX_' + chr(13) + chr(10) +
                '     to ' + sProgram + '\DEMO.TXT' + chr(13) + chr(10) +
                '  Add an Alias to your IDAPI.CFG ' + chr(13) + chr(10) +
                '  Create/Modify ' + sProgram + '\BILDEMO.INI' + chr(13) + chr(10) +
                '  Create Program Group and Item'
                ,mtInformation, [mbOk,mbCancel],0 ) = mrOK then
    begin

       if MessageDlg( 'Warning: This Program is about to Edit your IDAPI.INI' + chr(13) + chr(10) +
                      '         If you have not backed up this file' + chr(13) + chr(10) +
                      '         cancel now and back it up'
                      ,mtInformation, [mbOk,mbCancel],0 ) = mrOK then
       begin               

         { Create Program directory }
         bRet := bCreateDirectory( sProgram );

         { Decompress DEMO.TX_ to DEMO.TXT in the program directory }
         bRet := bInstallFile('DEMO.TX_', 'DEMO.TXT', fiSameDateTimeIgnore, 'P' );

         { Backup IDAIP.CFG }
         cIDAPI := sReadProfile( sGetWinDir + '\WIN.INI',
                                 'IDAPI', 'CONFIGFILE01', '');
         sBackUpByNumber( cIDAPI );

         if length( cIDAPI ) > 1 then
            begin
            { Create a Alias for Interbase }
            TListParams:= TStringList.create;
            TListParams.Add( 'DB INFO');
            TListParams.Add( 'TYPE=INTRBASE' );
            TListParams.Add( 'PATH=' );
            TListParams.Add( 'DB OPEN' );
            TListParams.Add( 'USER NAME=' );
            TListParams.Add( 'ODBC DSN=' );
            TListParams.Add( 'OPEN MODE=READ/WRITE' );
            TListParams.Add( 'SCHEMA CACHE SIZE=8' );
            TListParams.Add( 'SQLQRYMODE=' );
            TListParams.Add( 'LANGDRIVER=' );
            TListParams.Add( 'SQLPASSTHRU MODE=' );
            bRet := bBDEAddAlias('BILDEMO',TListParams);
            TListParams.Clear;
            end;
         { Create/Update BILDEMO.INI }
         bRet := bWriteProfile( sProgram+'\BILDEMO.INI', 'BILGROUP','BILITEM','VALUE');

         { Create the program Group/Item
          The first parameter is a TDdeClientConv this is create by 
          clicking on the System tab on the visual controls,
          then clicking on the DdeClientConv }
         bRet := bAdd2ProgMan( DdeClientConv1, 'BILDemo', 'BILDEMO Executable', EditInstallFrom.Text + '\BILDEMO.EXE');
      end;
   end;
end;
procedure TForm1.ButtonExitClick(Sender: TObject);
begin
     Halt;
end;

procedure TForm1.FormCreate(Sender: TObject);
var
   sPath: string;
begin
    sPath := sGetPath(Application.ExeName);
    EditInstallTo.Text := sPath + '\TO';
    EditInstallFrom.Text := sPath;

end;

end.
 