/*lint -cmsc

    Standard Library Definitions -- Microsoft C Version

    This file contains declarations of standard library functions
    for use with PC-Lint.  When provided to PC-Lint along with
    other modules, the functions declared here are considered
    defined with the properties given.  Of course, later redefinitions
    may occur.

    This file may not be complete.  Your compiler may contain
    many other functions not declared here.
    You may modify or augment this file so that it more
    closely conforms to the library provided with your compiler.

    The include file "stdio.h" is provided with your compiler.

 */
/*lint -format=%(%f(%l)\s:\s%)%t\s%n:\s%m
       error format expected by Microsoft editor
       Note that %c can also be used to specify column */
/*lint -w(0,0)  This specifies an infinite width line.  PC-lint will
       not break lines at the normal 80-character boudary. This is
       done because the editor strips off the file-name line-number */
/*lint -e46 bit-fields are not required to be int or unsigned */

/*lint -library  library flag -- Don't get upset if these externals
              are not referenced or defined */


#include "stdio.h"

/*lint -dMSDOS  this preprocessor symbol is pre-defined */
typedef void *UNIV;     /* universal pointer */
/* typedef char *STRING;   string */
typedef const char *CSTRING;   /* constant string */

#define VOID void       /* compiler-independent void */
typedef FILE *STREAM;   /* a universal file designator */


/*lint +fvr
  The following functions exhibit variable return modes.
  That is, they may equally-usefully be called for a value
  as called just for their effects.
 */


int     close();
int     creat();
int     fclose();
int     fflush();
int     _flsbuf();
int     fprintf();
int     fputc();
int     fputs();
int     fscanf();
int     fseek();
/* for some versions of C it is
   necessary to change the following declaration to:
int     fwrite();
 */
size_t  fwrite();
long    lseek();
UNIV    memcpy();
UNIV    memmove();
UNIV    memset();
int     printf();
int     puts();
int     scanf();
int     sprintf();
int     sscanf();
/* STRING  strcat();
STRING  strcpy();
STRING  strncat();
STRING  strncpy(); */
int     unlink();
int     write();


/*lint -fvr  End of routines that exhibit varying return mode */


VOID    main(int, char**);  /* since main is not otherwise referenced */

/*  At this point we wish to include prototypes for all functions
    you are likely to use.  The easiest way to do this is to use
    the prototypes that come with your compiler.

    Some of the less-frequently-used include files have been commented
    out to save processing time.  Also, for some compilers, there
    can be an overlap in that some functions are included in more
    than one header file.  Please include the omitted include files
    if you need them.  Failure to include an appropriate header will
    result in a Warning 526, ... "not defined" for any called function
    whose prototype is contained in the header.
 */


/* #include "types.h" */
/* #include "assert.h" */
/* #include "direct.h" */
/* #include "conio.h" */
#include "ctype.h"
/* #include "dos.h" */
/* #include "errno.h" */
/* #include "fcntl.h" */
/* #include "float.h" */
/* #include "graph.h" */
/* #include "io.h" */
/* #include "limits.h" */
/* #include "malloc.h" */
/* #include "math.h" */
/* #include "memory.h" */
/* #include "process.h" */
/* #include "setjmp.h" */
/* #include "search.h" */
/* #include "stdarg.h" */
/* #include "stat.h" */
/* #include "signal.h" */
/* #include "share.h" */
/* #include "stddef.h" */
#include "stdlib.h"
#include "string.h"
/* #include "time.h" */
/* #include "varargs.h" */



/*lint -restore Restore error messages to original state.
       This option is only necessary if flags of the form
       -e... appear in this file. */

