------------------------------------------------------------------
README.C

What follows is my log of the development of BG.EXE. It was written
for Borland C 3.1 running under DOS.

Feel free to copy and modify the sources on the condition that you
always acknowledge the original author of the sources, Owen F.Ransen.

These sources cannot be used for commercial purposes without 
permission.

-------------------------------------------------------------------

THINGS STILL TO DO:

1) If Goodness == Best then you should make a random selection between the 2.
2) You should make the starting more realistic.
3) You MUST check the max moves possible, and not make one with less.
4) You should sort out a good text placement scheme.
5) You should ho hi-lo switch stuff.

8th August 1991

Things going quite well but problem sometimes reentering from the bar,
sometimes he doesn't even though he can, and in fact SHOULD. Trying to
get over this by having a Moves_Made field in Best_Move, and using that
as a high priority selector, but still does not always work.

                   -----++++***!!#!!***++++-----

I think I have got the problem, it seems to be in Select_Best_Ndice_Move().
I reckon I do not handle the situation where only a single move can be made
correctly.

There are two branches in that function

    if (Still dice to test and not won)
        for every move which can be made
           Select_Best_Ndice_Move with the next dice
    else
        end of recursion, evaluate the move.

The problem is that in the first branch, if no moves can be made I do not
call Select_Best_Ndice_Move, and so I never evaluate the one piece move!
What is happening is that I am not evaluating the leaves of the tree which
use less than the maximum number of pieces. So in the first branch, if no
moves have been made (there remains a piece stuck somewhere) I should
recurse anyway.

    if (Still dice to test and not won)
        for (every move which can be made)
           Select_Best_Ndice_Move with the next dice
        if (no moves made)
           Select_Best_Ndice_Move with the next dice to force end
           of recursion and evaluation of the move
    else
        end of recursion, evaluate the move.

                   -----++++***!!#!!***++++-----

Now a new problem has arisen: When bearing off I do not check that there
are no pieces above me if the move would take me home.

                   -----++++***!!#!!***++++-----

Still a problem somewhere, near the end of the first game black is losing,
throws a 5,4 and can move (with one piece) 5 then 4 from point1. But he
only moves the 4...

                   -----++++***!!#!!***++++-----

9th August 1991

I goddit wrong again. To get over a previous problem I had forced
the recursion down branches it should not naturally go. The idea was that
it would end up in the non recursing branch sooner or later. And that
works except that Moves_Done was also forced, and the selection between
moves was always made according to Goodness, since Moves_Done was always
the same (having been forced down branches).

Now things are much more natural and neat. As soon as I get to a branch
where no more moves can be made I evaluate the move, and store it in
Best if it is better than the previous best. Like this if only (for example)
three moves can be made, the recursion stops at the third level and
evaluation takes place with 'Moves_Done' correctly reflecting the number
of dice used. See Select_Best_Ndice_Move () in BG_MOVES.C for the
C function. Today it seems to work ok.

                   -----++++***!!#!!***++++-----

17th September 1991

Even the 9th August improvements were not entirely correct, though now I
hope they are. I think things could be made neater by throwing away Moves_Made,
since this number is implicit in the dice you are using. Or not? Ah.

Now I have written bits of code for drawing semicircles from any two points
and in any direction. This will be required because I have seen that just
showing piece in new positions it is hard to see where they come from. You
need to see the path(s) they have taken too.

Text handling is better now. There is Side_Text function and a Help_Text
function, both of which work woth both compilers, MSC was the more difficult
to get going.

Now I have to record the path taken by the pieces of the best move, so that
I can display the move with semicircles.

                   -----++++***!!#!!***++++-----

18th September 1991, and now I have to record the moves made, not just the
new layout. I think I will do this with

typedef struct {
    Layout_t New_Layout ;     /* The new layout after the transition */
    char     N_Moves ;        /* 0..4 moves to get to new layout */
    char     Old_Points [4] ; /* Where the piece was */
    char     Dice_Values[4] ; /* How many places moved */
    char     Old_High [4] ;   /* The level of the old position of the piece */
} Transition_t ;

Transitions will be passed into BG_MOVE.C functions where I used to pass
New Layouts. Old_High is required so that we know where the semicircle
which describes the move will start from. New_High we can get implicityly
from the rest of the structure.

                   -----++++***!!#!!***++++-----

7th October 1991, from what I can see we are always one grid space out in
the y-calc for drawing the transits...

8th October 1991. The above bug solved, I forgot that ROWS on a point start
from 0, and the 1st point is on row 0, the 2nd point is on row 1 etc. I simply
had to subtract 1 from the N_Pieces to calculate rows.

3 bugs still to solve with the display of motion:
    1) Sometimes the semi-circles are far to big in the y direction, even
       going off the screen.
    2) Movement to the bar is incorrect, it looks like I should reverse the
       rows.
    3) Bearing off movement is incorrect.
    4) Movement from the bar back into the game is incorrect. It should be
       a straight line too.
    5) Get_Piece_Center only works when there is no 'squashing' to be done.

                   -----++++***!!#!!***++++-----

10th October 1991, I have got rid of bug 1 by making the paths only slightly
curved, a weighted average of the semicircle and the straight line paths.

                   -----++++***!!#!!***++++-----

11th October 1991. I made the program smaller and got rid of the bearing off
bug by making HOME the same as any other point except that a triangle
is not drawn on it.

16th October 1991. Writing the statistics in real time.

18th October 1991. Starting to add multilanguage support in BG_MESG.C
Language support is working. Now I have to think about how to adjust
weights, switching types of screen and so on...

19th October 1991. Ported latest changes to MIX-C. Found a bug in
Int_Rand_Range which can go out of range sometimes. Made it recurse
in those circumstances, seems to work.

22nd October 1991. Now have a weighting menu which seems to work, though
I should check that all weighting functions return a number between 0..100.

24th October 1991. Added the setup menu and titles. Replaced Random_Score
with Exiting_Score, and made Safety_Score more sensible, returning 100% if
there is absolutely no danger.

There is an occasional error with an unitialised Transit... aaah

26th October 1991.

Why does the last 10% of a release take up 90% of the effort.
A word on Aspect Ratios. In the Dis_Cfg_t Aspect_V and Aspect_H are
provided so that you can work out a vertical size to be the same on the
screen as a horizontal size given in pixels. For example:
    12 horizontal pixels is the length in centimeters as
    ((12 * Aspect_V) / Aspect_H) vertical pixels.

                   -----++++***!!#!!***++++-----

4th November 1991. I found that occasional bug. It was a set of local
variables which were very occassionally, in special situations, not
initialised. HINT: Initialise variables which are not OBVIOUSLY initialised
in the function.

The logo drawer is struggling into life...

There are still a few problems with the graphics, for example the SETUP
menu overwrites the logo area. Maybe if I just moved that menu up or
down a few text rows...

                   -----++++***!!#!!***++++-----

8th November 1991

Tidying up a few things prior to a first pre alpha alpha release. The logo
is better placed now, there is space in the main menu for S.W.S. information
and help, though these have not yet been implemented.

                   -----++++***!!#!!***++++-----

21st November 1991. A pre-alpha release given to Sergio. Suggestions and
things to do:
    1) When assessing security of a piece consider its advancement into
       the game.
    2) Give partial totals (per game) as well as global totals.
    3) Select the highest resolution available, but allow override too.
    4) Look at the risk of being eaten when assessing the security of
       a piece.

                   -----++++***!!#!!***++++-----

30th November 1991, lets the user change the graphics mode (to a certain
extent) by reading the command line. We have also got better filling of
ellipses, gave problems previously with Power-C and VGA mode...

                   -----++++***!!#!!***++++-----

28th December 1991. Now I have the Safety_Score a bity more sensible, counting
only the first four pieces uncovered, since no one can eat more than that
many pieces in one go!

                   -----++++***!!#!!***++++-----

21st January 1992, a long rest, but now starting with a vengance on getting
the user to play against the computer...
23rd January 1992, Get_User_Point written ok, tested ok. See BG_GRAF2.C
24th January 1992, incredible but TRUE, you are BLACK and can play against
                   the computer....

4th February 1992, added PRIMES weighting, and F9 lets you escape writing
and error message into the permanently recording BG?.REC file. This is so
that if you spot an error you can record it in the file.

7th February 1992, a terrible terrible bug discovered in BG_MOVE.C. I was
doing a logically wrong thing, the first part of Choose_Move should be
    if (Moves_Done < Best_Score->Moves_Made) {
        Copy = FALSE

but instead it was
    if (Moves_Done > Best_Score->Moves_Made) {
        Copy = TRUE

What an error!

                   -----++++***!!#!!***++++-----

13th February 1992, Correcting two bugs, one is that I leave the dice list
intact during his throw even if I have not been able to move, the other is
that at the end game I ignore the weightings and do simple "get me off the
board" selections.

                   -----++++***!!#!!***++++-----

14th February 1992, I am having a lot of trouble with the trailing score,
now I gone back to the count of the last piece.

15th Feb 92, There was a bug when the user is taking his pieces of the board,
the computer wanted that you do Max_Moves before letting you win, tho of
course if you win there is no need to use all the dice available!

ANOTHER bug found. This time to do with the special cases when exiting.
If I am exiting but have no pieces taken off the board then the
Exiting_Score was 0, which is not very clever since then this:

    if (!Overlap(Me,Him)) {
        /* The choice of move is rather simple */
        if (!Bearing_Off(Me)) {
            return (Trailing_Score (Me,Him)) ; /* Move closer to inner table */
        } else {
            return (Exiting_Score (Me,Him)) ; /* Take pieces off inner table */
        }
    }

does not work well in some special cases. So I have changed the calculation
of exiting score to be the number of pieces at home if they are not zero,
else it is the trailing score. Evaluate_Move was returning zero even though
we were in the last quadrant, and this had to compete with leaving a single
piece outside the last quadrant, which has a non zero score and hence this
last worst position was chosen as the best...


a good setup...
    {Runners_Score,    {"RUNNERS",      "RUNNER"},       {0,50} },
    {Prime_Score,      {"PRIMES",       "PRIMES"},       {0,50} },
    {Safety_Score,     {"SAFETY",       "SICUREZZA"},    {0,50} },
    {Aggression_Score, {"AGGRESIVENESS","AGGRESSIVITA"}, {0,30} },
    {Wall_Score,       {"WALL",         "MURO"},         {0,50} },
    {Agro_Coward_Score,{"HITTING SAFELY","COLPO SICURO"},{0,50} }

29th Feb 1992, still having problems exiting well, but with the above
settings the computer plays reasonably well. Now there is also the
title page.

9th March 1992, Vers 1.05:
    1) Starts up with question about which video display you are using,
       I had to add CGA for Liusa's bookshop.
    2) 'Weights' removed from the top level menu.
    3) 'Help()' function removed.
    4) If mode selected is not CGA then points drawn in red and green,
       else points always drawn in white.
    5) Paths drawn in black or white, I no longer attempt XOR.
    6) Recording the moves (always) in ready to use C-source type text,
       in files like BG0.REC, BG1.REC etc.

                   -----++++***!!#!!***++++-----

10th March 1992,Trying to improve the user interface when one of the
players is totally blocked. The dice will not be thrown and a message
will be given to expain why.

		   -----++++***!!#!!***++++-----

14th March 1992.
1) A bug corrected, I was breaking out of the main playing loop when I
   should have been continuing! Now I do not use either 'break' or
   'continue', but 'if'.
2) Enzo complained about the amount of time he had to wait when the player
   had thrown a double and the computer was searching for the best move.
   In fact I only needed to search for the most legal move, i.e. the move
   that shifted the most pieces. Now I have added a search type which tells
   the computer to stop as soon as he can if he is searching for legality
   and not bestness.

		   -----++++***!!#!!***++++-----

23rd March 1992 find me trying to port the program to BORLAND.C. And here
is the result so far...

		   -----++++***!!#!!***++++-----

24th March 1992, getting there, tho problems with rectangle sizes, I
either erase too much or too little, I need to find out exactly what
the graphics functions do...

		   -----++++***!!#!!***++++-----

4th April 1992, abandoned keeping compatibility with all three compilers,
I will use only BORLAND from now on. One of the main reasons for this
is that you can draw lines in XOR mode, which is very useful for showing
the traces of the computers movements on the board.

		   -----++++***!!#!!***++++-----

5th April 1992, I have added three more simple score evaluators, and they
make an incredible difference. It is much harder to beat the little b***rs
now!

		   -----++++***!!#!!***++++-----

11th April 1992. This should be the final release apart from the
text of the title page and maybe the decoding. The weights are as
follows with this release, and PIERO is the best player, I beat him
only 3-2, where as I have not lost a single match against all the
other three players.
static W_Func_t W_F_Table [N_WEIGHTS] = {
    /* Function,        English,        Italian            B/W weights */
    {Runners_Score,    {"RUNNERS",      "RUNNER"},       {0,60} },
    {Prime_Score,      {"PRIMES",       "PRIMES"},       {0,50} },
    {Safety_Score,     {"SAFETY",       "SICUREZZA"},    {0,50} },
    {Aggression_Score, {"AGGRESIVENESS","AGGRESSIVITA"}, {0,60} },
    {Wall_Score,       {"WALL",         "MURO"},         {0,50} },
    {Agro_Coward_Score,{"HITTING SAFELY","COLPO SICURO"},{0,50} },
    {Inner_Sec_Score,  {"INNER SAFETY", "COLPO SICURO"}, {0,50} },
    {Outer_Sec_Score,  {"OUTER SAFETY", "COLPO SICURO"}, {0,50} },
    {Trail_Sec_Score,  {"TRAIL SAFETY", "COLPO SICURO"}, {0,50} }
} ;

static long Opponents [N_OPPS][N_WEIGHTS] =
/*run  pri  safe  aggro wall agrwal inner outer trail */
{{60,   30,   50,   60,   50,   50,   60,   20,   10},     /* PIERO */
 {30,   90,   40,   75,   60,   80,   50,   50,   10},     /* PINUCCIA */
 {90,   50,   60,   40,   50,   80,   50,   30,   15},     /* ALBERTO */
 {99,   99,   20,   30,   30,   50,   50,   50,    0}} ;   /* LUISA */


		   -----++++***!!#!!***++++-----

15th April 1992.
What I said above about the abilities of the players is not
entirely TRUE, yesterday SERGIO beat me 5-4. There is a new thing
now in that the human can choose what colour he is. I am about to
start working seriously on genetic selection of the players, so this
is a set of sources in case of disaster...

		   -----++++***!!#!!***++++-----

Serious bug found in BG_EVAL.C, I was passing OPPONENT(Human) instead
of OPPONENT(*Human)!

		   -----++++***!!#!!***++++-----

25th April 1992, Version 1.0, and I'll send it to Pete in the U.S.A. to
distribute to friends. Genetics works. A touch more protection. No mention
of LIBRERIA ATALA, since they are not exactly moving fast... I have to
write a README.1ST to explain how to use the game.

		   -----++++***!!#!!***++++-----

27th April 1992, Took the EXE to work to see what it did on other
computers. It crashed. Says that
        ERROR "In Show_Move, Old_Point + Moves > HOME_I."
Well buggar me. It doesn't crash on my machine...

		   -----++++***!!#!!***++++-----

30th April 1992. Well, as far as I can tell it seems to be when you
run it from floppy disk on an EISA machine, and maybe the mouse is not
installed... I simply cannot find the problem here. Strategies:
    1) Put mouse test at start of program, DONE.
    2) Make a LINT file and lint the sources, NOT DONE YET.
    3) Put more checks on array boundaries and so on in the sources,
       DOING.
    4) Add an option "qt" which allows you to run the program without
       protection, but which exits before a game is complete. This
       will let you check things quickly on alien machines. DOING
This is version 1.02.
		   -----++++***!!#!!***++++-----

AAAAAAAAARRRRRRRRGGGGGGGGGHHHHHHH It could have been an unitialised ptr
which LINT told me about. Good old LINT. I'll test it on Monday
morning...
		   -----++++***!!#!!***++++-----

2nd May 1992, general tidy up and more linting...
3rd May 1992, added the file BG_STDOP.C, which forces std opening moves...

		   -----++++***!!#!!***++++-----

10th May 1992, simple things still to do:
    1) Take out SWS from main menu.
    2) Let the user throw the dice.
    3) See what F9 does when not debugging.

		   -----++++***!!#!!***++++-----

15th May 1992, some things to improve the game (+ those above!):
    1) A new weight for occupation of the key points.
    2) A new weight for unsafe eating when he has uncovered points
       in his home territory
    3) Improve the performance of runners when they are in a column
       of 3 or more.

		   -----++++***!!#!!***++++-----

19th May 1992, changed the mouths of the faces a little bit to make the
teeth a bit more obviously teeth, mouths wider, and with less teeth.

		   -----++++***!!#!!***++++-----

22nd May 1992, discovered a bug, tho don't know how long it has been there,
I had left EGA_TEST defined, so some releases will never work with CGA.
Now I am working on version 1.04, which has the option that the user can
throw the dice manually.

It seems to work, though I have added an ugly global var called F10_Hit
which is set if the user hits F10 while inputing the dice. I think this
may be the tidiest way of doing things, an exception which proves the rule,
and I should use that var more often, where currently I return User_Char
and so on.

I have also, finally, taken out that useless S.W.S. menu option.

		   -----++++***!!#!!***++++-----

30th May 1992. Now we have colour display of board, pieces and dice,
with the mono option on the command line to force a black and white
only display. The text still talks about black and white, though it
should talk about red and white.

I have changed the points system to calculate SIMPLE, GAMMON and BACKGAMMON
winning games. The computer does not play very well now. Now there is
a readout of points won instead of games won.

		   -----++++***!!#!!***++++-----

31st May 1992, version 1.07, an Italian release for Libreria Atala, but I
forgot to change the default language from English to Italian. Oh well.
Luisa has got the disk now...

		   -----++++***!!#!!***++++-----

5th June 1992. I've godda cod id de dose and so am staying away from
work and ACAD12 drivers. This release is 1.08 and has dumping of
evaluation scores at the end and a message at the end of each game
which says who won and how many points he got. Not yet thouroughly
tested or linted, but it seems to work...

		   -----++++***!!#!!***++++-----

28th June 1992. Vers 1.11, to be sent to Jamie and Fred, along with
photos of the trip in England. In this release you can ESCAPE from
the setup menmu without the changes taking effect. Also made a single
file to decide if this is a ENGLISH_REL or an ITALIAN_REL. With the
former the default language is English and the first screen is dedicated
to me, with the latter the default language is Italian, and I share
the first screen with LIBRERIA ATALA.

		   -----++++***!!#!!***++++-----

7th January 1993. I am getting the human side of doubling going. Needs
    1) A place on the screen to click for the doubling.
    2) A display of the current stakes.
    3) The printout changed at the end of the game.

		   -----++++***!!#!!***++++-----

14th January 1993.
Still working on doubling. There is a bug that drawing into the
bar point destroys the doubling cube area.

Draw_Double_Cube needs to erase all three areas where the cube can be and
redraw it where it has to go.

Human side of doubling done. Still have to:
    1) Get computer to accept or reject.
    2) Get computer to double or not.
    3) Get human to accept or not.

		   -----++++***!!#!!***++++-----

22nd January 1993.

Now the human can double, the computer doubles too.
    1) The human cannot yet reject.
    2) The graphics get messed up.
    3) The computer behaviour is not very intelligent.

                   -----++++***!!#!!***++++-----

30th January 1993, doubling is probably ok as far as I can go in this
program, ora BASTA!

23rd January 1993.

Now the human can double, and reject, and the graphics is ok but
not yet multilingual.

		   -----++++***!!#!!***++++-----

What is missing still?
    1) Intelligent computer doubling, accepting and rejecting.
    2) Playing to a final score.
    3) NOCUBE rule.

Tho this is probably releasable!

		   -----++++***!!#!!***++++----

31st December 1993.

I think I've lost a version along the way. Anyway this version does not
reject the double if it is proposed early on in the game.

BUGFIX: In BG_STDOP.C the standard opening move for 5,1 was incorrect,
        the move with 5 was not made.

		   -----++++***!!#!!***++++----

16th January 1994.

This release of sources is just before I start gathering statistics for the
Neural Network Backgammon Brain.

		   -----++++***!!#!!***++++----

28th April 1994.

I have integrated in the neural network, and it seems to work, but it
does not play very well. I need to do the following things:
    0) Make Wakeup() read the limits of the input and output vectors.
    1) Introduce a 5th player which is the neural network.
    2) Check that the answers I get here are the same as the ones I get
       when running the neural network without the back-gammon
       program around it.
    3) Make some other neural networks with the same data but with
       more and less neurons.
    4) Introduce the two new players and do a tournament again to see
       who is really the best player.

29th April 1994.

I am replacing statistical Pete (player number 3) with brainy Brian so that
I can run a tournament to see if the NN player beats the others.

		   -----++++***!!#!!***++++----

14th May 1994.

I have managed to get BRIAN to run against the user and also against three
other comptetitors in a tournament, but he plays very badly, I have to admit.
