/*
 *
 * Functions for the mouse TSR to BG.EXE
 * 29th February 1992
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <dos.h>
#include "bg.h"
#include "mousy.h"

/***************************************************************************/

void Mouse (short far* m1, short far* m2, short far* m3,
            short far* m4, short far* m5)
/*
PURPOSE: To call the mouse interrupt procedure with the parameters given.
NOTES:   This has been adapted from a Turbo Pascal routine in a very
         old Microsoft Mouse manual.
*/
{
   union  REGS  Cpu_Reg ;
   struct SREGS Seg_Reg ;

   if ((*m1) >= 0) {
       Cpu_Reg.x.ax = (uint)(*m1) ;
       Cpu_Reg.x.bx = (uint)(*m2) ;
       Cpu_Reg.x.cx = (uint)(*m3) ;

       if (((*m1) == SET_G_CURS_BLOCK) ||
	   ((*m1) == SET_INTERRUPT)    ||
	   ((*m1) == SWAP_INTS)        ||
	   ((*m1) == SAVE_MOUSE_STATE) ||
	   ((*m1) == REST_MOUSE_STATE)    ) {
	   Cpu_Reg.x.dx = ((unsigned long)m4) & 0xFFFF ;
	   Seg_Reg.es   = ((unsigned long)m4) >> 16 ;

       } else if ((*m1) == CONDITIONAL_OFF) {
	   Cpu_Reg.x.cx = (uint)(*m2) ;
	   Cpu_Reg.x.dx = (uint)(*m3) ;
	   Cpu_Reg.x.si = (uint)(*m4) ;
	   Cpu_Reg.x.di = (uint)(*m5) ;

       } else {
	   Cpu_Reg.x.dx = (uint)(*m4) ;
       }

       (void)int86x (MS_MOUSE_INT_NUM,&Cpu_Reg,&Cpu_Reg,&Seg_Reg) ;

       if ((*m1) == SWAP_INTS) {
	   (*m2) = Seg_Reg.es ;
       }

       (*m1)  = Cpu_Reg.x.ax ;
       (*m2)  = Cpu_Reg.x.bx ;
       (*m3)  = Cpu_Reg.x.cx ;
       (*m4)  = Cpu_Reg.x.dx ;
    }
}

/***************************************************************************/

void Check_Mouse (void)
/*
PURPOSE: To exit if the mouse driver is not installed.
NOTES:   1) Copied from a very old Microsoft Mouse Manual.
*/
{
    union  REGS  inregs,outregs ;
    struct SREGS segregs ;
    long         address ;
    uchar        first_byte ;

    inregs.x.ax = 0x3533 ;
    (void)intdosx (&inregs,&outregs,&segregs) ;
    address = (((long)segregs.es)<<16) + (long)outregs.x.bx ;
    first_byte = (uchar)(*(long far *)address) ;
    if ((address == 0) || (first_byte == 0xCF)) {
        printf ("\nMouse driver not installed") ;
        exit (1) ;
    }
}

/***************************************************************************/

int Init_Mouse (void)
/*
PURPOSE: To init the mouse, returning non-zero if we are successful
*/
{
    short m1,m2,m3,m4,m5 ;

    m1 = RESET_AND_STAT ;  /* Initialise the mouse */
    Mouse (&m1,&m2,&m3,&m4,&m5) ;

    if (m1 == 0) {
        return (FALSE) ;
    } else {
        return (TRUE) ;
    }
}

/***************************************************************************/

void Set_Mouse_Pos (short x, short y)
/*
PURPOSE: To put the mouse at the given position.
*/
{
    short m1,m2,m3,m4,m5 ;
    m1 = SET_MOUSE_POS ;
    m3 = x ;    /* at the centre of the screen */
    m4 = y ;
    Mouse (&m1,&m2,&m3,&m4,&m5) ;
}

/***************************************************************************/

void Set_Mouse_Limits (short x0, short y0, short x1, short y1)
/*
PURPOSE: To set a limit on the range of the mouse.
*/
{
    short m1,m2,m3,m4,m5 ;

    m1 = SET_X_MIN_MAX ;
    m3 = x0 ;     /* minimum x */
    m4 = x1 ;     /* maximum x */
    Mouse (&m1,&m2,&m3,&m4,&m5) ;

    m1 = SET_Y_MIN_MAX ;
    m3 = y0 ;     /* minimum y */
    m4 = y1 ;     /* maximum y */
    Mouse (&m1,&m2,&m3,&m4,&m5) ;
}

/***************************************************************************/

#define SHP_LEN 32

static short Std_Shape [SHP_LEN] = {
                    0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,
                    0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,
                    0xff80,0xff00,0xc600,0xc600,0xc300,0xf180,0xf8c0,0xcc60,
                    0x8630,0x0318,0x0018c,0x00c6,0x0063,0x0036,0x001e,0x0008} ;

static short In_Shape [SHP_LEN] = {
                    0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,
                    0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,
                     0x180, 0x180, 0x180, 0x7e0, 0x3c0,0x1188,0x1818,0xfc3f,
                    0xfc3f,0x1818,0x1188, 0x3c0, 0x7e0, 0x180, 0x180,0x180} ;

static short Out_Shape [SHP_LEN] = {
                    0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,
                    0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,
                    0x0180,0x03c0,0x07e0,0x0180,0x0180,0x2184,0x6006,0xfc3f,
                    0xfc3f,0x6006,0x2184, 0x180, 0x180, 0x7e0, 0x3c0,0x180} ;

static short Quest_Shape [SHP_LEN] = {
                    0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,
                    0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,
                    0x03c0,0x07e0,0x0e70,0x0c30,0x0c30,0x0070,0x00e0,0x01c0,
                    0x0180,0x0180,0x0180,0x0180,0x0000,0x0000,0x0180,0x0180} ;

short The_Shape [SHP_LEN] ;

void Set_Cursor_Shape (short Code, short Hot_X, short Hot_Y)
/*
PURPOSE: To set the cursor shape, which is an array of 32 shorts. The first
16 shorts tell us if the cursor is part of the cursor or screen, the
last 16 shorts tell us how the pixel contributes to the colour of the
cursor.
*/
{
    short m1,m2,m3,m5 ;

    switch (Code) {
        case IN_ARROW_SHP :
            memcpy (The_Shape,In_Shape,SHP_LEN*sizeof(short)) ;
            break ;
        case OUT_ARROW_SHP :
            memcpy (The_Shape,Out_Shape,SHP_LEN*sizeof(short)) ;
            break ;
        case QUESTION_SHP :
            memcpy (The_Shape,Quest_Shape,SHP_LEN*sizeof(short)) ;
            break ;
        default :
            memcpy (The_Shape,Std_Shape,SHP_LEN*sizeof(short)) ;
            break ;
    }

    m1 = SET_G_CURS_BLOCK ;
    m2 = Hot_X ;
    m3 = Hot_Y ;
    Mouse (&m1,&m2,&m3,(short far*)The_Shape,&m5) ;
}

/***************************************************************************/

void Show_Mouse_Cursor (void)
{
    short m1,m2,m3,m4,m5 ;
    m1 =  SHOW_CURSOR ;
    Mouse (&m1,&m2,&m3,&m4,&m5) ;
}

/***************************************************************************/

void Hide_Mouse_Cursor (void)
{
    short m1,m2,m3,m4,m5 ;
    m1 = HIDE_CURSOR ;
    Mouse (&m1,&m2,&m3,&m4,&m5) ;
}

/***************************************************************************/

short Get_Mouse_Or_Key (short* Mx, short* My)

/*
PURPOSE: To wait for input from the user, either as a keyboard hit
         or as a mouse button hit.
NOTES: 1) If a key had been hit then we return
	       FUN_BIT or KEY_BIT with the key code in lower eight bytes.
       2) If the mouse button has been pressed then we return
	       LEFT_BIT or RIGHT_BIT and Mx and My are set to the position.
*/
{
    char  Key_0 ;
    short Input_Code ;
    short m1,m2,m3,m4,m5 ;

    Input_Code = 0 ;
    do {
        m1 = GET_STAT_AND_POS ;
        Mouse (&m1,&m2,&m3,&m4,&m5) ;
        if (m2 == LEFT_BUT) {
            Input_Code = LEFT_BIT ;
	} else if (m2 == RIGHT_BUT) {
            Input_Code = RIGHT_BIT ;
        } else if (kbhit()) {
            Key_0 = (char)getch () ;
            if (Key_0 == FUN_PREFIX) {
                Input_Code = FUN_BIT | getch () ;
            } else {
                Input_Code = KEY_BIT | Key_0 ;
            }
        }

    } while (Input_Code == 0) ;

    (*Mx) = m3 ;
    (*My) = m4 ;

    if (Input_Code & (LEFT_BIT | RIGHT_BIT)) {
        /* Wait for user to release mouse button */
        do {
            m1 = GET_STAT_AND_POS ;
            Mouse (&m1,&m2,&m3,&m4,&m5) ;
        } while ((m2 == LEFT_BUT) || (m2 == RIGHT_BUT)) ;
    }

    return (Input_Code) ;
}

/***************************************************************************/

void Start_Up_Mouse (void)

{
    extern Screen_Const_t Grafs ;

    Check_Mouse () ;
    if (!Init_Mouse ()) {
        Error_Exit ("Mouse not found") ;
    }
    Set_Mouse_Pos (Grafs.Board_X+(Grafs.Board_Wide/2),
                   Grafs.Board_Y+(Grafs.Board_High/2)) ;
    Set_Mouse_Limits (Grafs.Board_X+2,Grafs.Board_Y+2,
                      Grafs.Board_X+Grafs.Board_Wide-4,
                      Grafs.Board_Y+Grafs.Board_High-4) ;
    Set_Cursor_Shape (NORMAL_SHP,0,0) ;
}

/***************************************************************************/

