/*
 * ENCODER.C, encodes plain text so that it can be hidden in the
 * data part of my exe programs, e.g. BG.EXE.
 *
 * This version 8th June 1992
 */


#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include <malloc.h>
#include <string.h>

typedef unsigned char uchar ;
typedef unsigned short ushort ;

#include "DEC.H"   /* Contains shifts and masks for encode-decode */

#define TRUE  1
#define FALSE 0
#define MAX_CHARS 10000
#define NUL (uchar)0

/************************************************************************/

uchar* Read_In_File (uchar* In_Name) ;
int    Convert_Buffer (ushort* Cod_Buf, uchar* Str_Buf) ;
void   Write_Cod (ushort* Cod_Buf, uchar* Out_Name) ;

/***************************************************************************/

void main (int argc, uchar* argv[])
{
    uchar* Str_Buf ;
    ushort* Cod_Buf ;
    ushort Cod_Buf_Len ;

    if (argc != 3) {
        printf ("\nUSAGE:\nencoder infile outfile\n\n (add any extensions you need)\n") ;
        exit (1) ;
    }

    Str_Buf = Read_In_File (argv[1]) ;

    if (Str_Buf != NULL) {
        printf ("\nStr_Buf has %d + 1 chars",strlen (Str_Buf)) ;
        Cod_Buf_Len = (strlen (Str_Buf) + 1) * 2 ; /* uchars --> ushorts */
        printf ("\nWhich means %d bytes when used as shorts",Cod_Buf_Len) ;
        Cod_Buf_Len = Cod_Buf_Len + (3*sizeof(ushort)) ;
                      /* count + chksum + 0xFFFF at end */
        printf ("\nAdding checksum, count and terminator = %d ",Cod_Buf_Len) ;
        Cod_Buf = malloc (Cod_Buf_Len) ;
        if (Cod_Buf != NULL) {
            printf ("\nAbout to convert the buffer...") ;
            if (Convert_Buffer (Cod_Buf,Str_Buf)) {
                printf ("done\nAbout to to file the buffer...") ;
                Write_Cod (Cod_Buf,argv[2]) ;
            } else {
                printf ("\nError converting buffer") ;
            }
            free (Cod_Buf) ;
        } else {
            printf ("\nCould not malloc (%d bytes)",Cod_Buf_Len) ;
            exit (1) ;
        }
        free (Str_Buf) ;
    }
}

/***************************************************************************/

uchar* Read_In_File (uchar* In_Name)
/*
PURPOSE: To read in all the uchars from the file into a mallocced buffer.
*/
{
    uchar* Buffer ;
    FILE* In ;
    ushort i,Reading ;

    Buffer = malloc (MAX_CHARS+1) ;
    if (Buffer == NULL) {
        printf ("\nCould not malloc to read %s.",In_Name) ;
        return (NULL) ;
    }

    In = fopen (In_Name,"rt") ;
    if (In == NULL) {
        printf ("\nCould not open %s to read.",In_Name) ;
        free (Buffer) ;
        return (NULL) ;
    }

    i = 0 ;
    Reading = TRUE ;
    do {
        Buffer[i] = fgetc (In) ;
        if (i == MAX_CHARS) {
            Reading = FALSE ;
            printf ("\nWarning, file too long, truncated") ;
        } else if (feof(In)) {
            Reading = FALSE ;
        } else {
            i++ ;
        }
    } while (Reading) ;

    Buffer[i] = NUL ;  /* Zero terminate the string */

    fclose (In) ;

    printf ("\nRead %d uchars from %s",i,In_Name) ;

    return (Buffer) ;
}

/***************************************************************************/

int Convert_Buffer (ushort* Cod_Buf, uchar* Str_Buf)
/*
PURPOSE: To code up the Str_Buf, putting the coded version in Cod_Buf.
FORMAT:  0th ushort is length of decoded string
         1st ushort is check sum of decoded string
         2nd ushort is first uchar coded up...
         nth ushort is (n-2)th uchar coded up
         last ushort is 0xFFFF
*/
{
    ushort cc,sc,Chk_Sum ;

    cc = 0 ;  /* The first uchar is... */
    sc = 2 ;  /* ...the 3rd ushort. */
    Chk_Sum = 0 ;

    while (Str_Buf[cc] != NUL) {
        Chk_Sum = Chk_Sum + (ushort)Str_Buf[cc] ;
        if (Str_Buf[cc] > 127) {
            Cod_Buf[sc] = ((ushort)Str_Buf[cc] << SPECIAL_SHIFT) | SPECIAL_TAG ;
            Cod_Buf[sc] = Cod_Buf[sc] | (rand() & SPECIAL_RND_MSK) ;
        } else {
            Cod_Buf[sc] = ((ushort)Str_Buf[cc] << NORMAL_SHIFT) | NORMAL_TAG ;
            Cod_Buf[sc] = Cod_Buf[sc] | (rand() & NORMAL_RND_MSK) ;
        }
        cc++ ;
        sc++ ;
    }
    Cod_Buf [sc]    = SHORT_END ;
    Cod_Buf [CHK_I] = Chk_Sum ;
    Cod_Buf [LEN_I] = cc ;

    return (TRUE) ;
}

/***************************************************************************/

void Write_Cod (ushort* Cod_Buf, uchar* Out_Name)
{
    FILE* Out ;
    ushort i ;

    Out = fopen (Out_Name,"wt") ;
    if (Out == NULL) {
        printf ("\nCould not open %s to write",Out_Name) ;
        return ;
    }

    i = 0 ;

    /* Write the checksum and length */
    fprintf (Out,"\n#define %s_CHECK_SUM  0x%X\n",Out_Name,Cod_Buf[CHK_I]) ;
    fprintf (Out,"\n#define %s_LENGTH     %d\n",Out_Name,Cod_Buf[LEN_I]) ;

    i = FIRST_CHAR_I ;
    fprintf (Out,"\nushort %s[] = {\n    ",Out_Name) ;

    printf ("\n") ;

    while (Cod_Buf[i] != SHORT_END) {
        if (!(i%16)) {
            printf ("\r %5d chars written",i) ;
        }
        fprintf (Out,"0x%.4X, ",Cod_Buf[i]) ;
        i++ ;
        if (!((i-FIRST_CHAR_I) % 8)) {
            fprintf (Out,"\n    ") ;
        }
        if (i > MAX_CHARS) {
            printf ("\nWARNING: buffer overflow!") ;
            break ;
        }
    }

    fprintf (Out,"0x%.4X};\n",Cod_Buf[i]) ;
    fclose (Out) ;
    printf ("\n") ;

}

/***************************************************************************/
