/*
 *
 *                     B  G  _  U  S  E  R  1 .  C
 * BG.EXE user interaction file, this version 28th April 1994.
 *
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <conio.h>
#include <time.h>
#include "lang.h"
#include "bg.h"

/***************************************************************************/

extern short Lang ;
extern Disp_Cfg_t Disp_Cfg ;

/***************************************************************************/


/* String menu type. A list of fields, each field having n options. eg:
    SPEED:    full   MEDIUM   slow   pausing
    LANGUAGE: italian ENGLISH
    OPPONENT: GIORGIO pinuccia, alberto, luisa
*/

String_Menu_t Setup_Menu [N_SETUP_FIELDS] = {
    {{"LANGUAGE","LINGUA"},
     {{"ENGLISH","ITALIAN"},
      {"INGLESE","ITALIANO"}},
     0,2,12},
    {{"SPEED","VELOCITA'"},
     {{"PAUSING","SLOW","MED","FAST"},
      {"PAUSA","LENTO","MEDIO","VELOCE"}},
     0,4,9},
    {{"YOUR ARE","TU SEI"},
     {{"RED","WHITE"},
      {"ROSSO","BIANCO"}},
     0,2,8},
    {{"OPPONENT","AVVERSARIO"},
     {{"SERGIO","ENZO  ","OWEN  ","BRIAN  "}, /* Spaces required when...  */
      {"SERGIO","ENZO  ","OWEN  ","BRIAN  "}},/* ...doing genetics.       */
     0,4,12},
    {{"POINTS","PUNTI"},
     {{"3","5","7","9"},
      {"3","5","7","9"}},
     0,4,3},
    {{"DICE","DADI"},
     {{"AUTO","MANUAL"},
      {"AUTO","MANUALE"}},
     0,2,9},
} ;

/***************************************************************************/

void Setup (Speed_t* Speed, Player_t* Human, short* Opp_I)
/*
PURPOSE: To allow the user to change variuos things.
*/
{
    ushort Field ;
    extern Disp_Cfg_t Disp_Cfg ;
    extern Throw_t    Throw ; /* Automatic or manual */
    extern int        Target_Score ;
    int     Com ;
    #define S_X     ((SETUP_COL*Disp_Cfg.Char_Wide) - (MARGIN/2))
    #define S_Y     ((S_TITLE_ROW*Disp_Cfg.Char_High) - (MARGIN/2))
    #define S_WIDE  ((SETUP_COLS_WIDE*Disp_Cfg.Char_Wide) + MARGIN)
    #define S_HIGH  (((N_SETUP_FIELDS+1)*Disp_Cfg.Char_High) + MARGIN)

    Fill_Rect (S_X,S_Y,S_WIDE,S_HIGH,BLACK) ;
    Draw_Rect (S_X-1,S_Y-1,S_WIDE+2,S_HIGH+2,WHITE) ;

    Setup_Menu [LANG_FIELD].Selector  = (char)Lang ;
    Setup_Menu [COL_FIELD].Selector   = (char)(*Human) ;
    Setup_Menu [SPEED_FIELD].Selector = (char)(*Speed) ;
    Setup_Menu [OPP_FIELD].Selector   = (char)(*Opp_I) ;
    Setup_Menu [THROW_FIELD].Selector = (char)Throw ;

    Print_Message (MENU_HELP_MSG) ;
    Print_Message (SETUP_MSG) ;
    /* Redraw all fields */
    for (Field = 0 ; Field < N_SETUP_FIELDS ; Field++) {
        Draw_Field (Field,&Setup_Menu[Field],GREY) ;
    }

    Field = 0 ;
    do {
        Draw_Field (Field,&Setup_Menu[Field],WHITE) ; /* Hilite */
        Com = Get_Key () ;
        Draw_Field (Field,&Setup_Menu[Field],GREY) ; /* De hilite */
        switch (Com) {
            case UP_KEY :
                if (Field > 0) {
                    Field-- ;
                } else {
                    Field = N_SETUP_FIELDS - 1 ;
                }
                break ;
            case DN_KEY :
                if (Field < (N_SETUP_FIELDS-1)) {
                    Field++ ;
                } else {
                    Field = 0 ;
                }
                break ;
            case RT_KEY :
                if (Setup_Menu[Field].Selector < (Setup_Menu[Field].N_Options-1)) {
                    Setup_Menu[Field].Selector++ ;
                } else {
                    Setup_Menu[Field].Selector = 0 ;
                }
                break ;
            case LF_KEY :
                if (Setup_Menu[Field].Selector > 0) {
                    Setup_Menu[Field].Selector-- ;
                } else {
                    Setup_Menu[Field].Selector = Setup_Menu[Field].N_Options-1 ;
                }
                break ;
        }
    } while ((Com != ENTER_KEY) && (Com != ESC_KEY)) ;

    if (Com == ENTER_KEY) {
        /* The changes take effect only with the enter key */
        Lang         = Setup_Menu [LANG_FIELD].Selector ;
        (*Speed)     = (Speed_t)  Setup_Menu [SPEED_FIELD].Selector ;
        (*Human)     = (Player_t) Setup_Menu [COL_FIELD].Selector ;
        (*Opp_I)     = (short)    Setup_Menu [OPP_FIELD].Selector ;
        Throw        = (Throw_t)  Setup_Menu [THROW_FIELD].Selector ;
        switch (Setup_Menu [TARG_FIELD].Selector) {
            case 0 : Target_Score = 3 ; break ;
            case 1 : Target_Score = 5 ; break ;
            case 2 : Target_Score = 7 ; break ;
            case 3 : Target_Score = 9 ; break ;
            default :
                Error_Exit ("Bad selector for Target_Score") ;
                break ;
        }
    }
    Fill_Rect (S_X-1,S_Y-1,S_WIDE+2,S_HIGH+2,BLACK) ;
}

/**************************************************************************/

void Draw_Field (ushort Field, String_Menu_t* Item, ushort Colour)
/*
PURPOSE: To draw the menu item in the requested colour.
NOTES  : Since we can use the 1 bpp CGA mode we change the CASE of
         the field according to the Colour, so that a change
         can be seen in single colour displays...
*/
{
    #define LS_CHARS 32
    ushort i,Col ;
    char Temp [LS_CHARS] ;

    i = 0 ;
    (void)strcpy (Temp,Item->Name[Lang]) ;
    if (Colour != WHITE) {
        (void)strlwr (Temp) ;
    } else {
        (void)strupr (Temp) ;
    }

    Graf_Text (SETUP_ROW+Field,SETUP_COL,Temp,Colour) ;

    for (i = 0 ; i < Item->N_Options ; i++) {
        (void)strcpy (Temp,Item->Options[Lang][i]) ;
        if (i == Item->Selector) {
            Col = WHITE ;
            (void)strupr (Temp) ;
        } else {
            Col = GREY ;
            (void)strlwr (Temp) ;
        }
        Graf_Text (SETUP_ROW+Field,FIELD_COL+(i*Item->O_Width),Temp,Col) ;
    }
}

/**************************************************************************/

boolean Top_Level_Interact (Speed_t* Speed, Player_t* Human, short* Opponent)
/*
PURPOSE: To let the user play, exit, or change settings. Normally this
         is called at the very start of the program and when the user
         wants to change things between games. We return TRUE if we
         are to continue playing.
*/
{
    int Com ;

    do {
        Top_Level_Menu (TRUE) ;
        Com = Get_Key () ;
        switch (Com) {
            case SETUP_KEY :
                Top_Level_Menu (FALSE) ;
                Setup (Speed,Human,Opponent) ;
                break ;
        }
    } while ((Com != PLAY_KEY) && (Com != ESC_KEY)) ;

    Top_Level_Menu (FALSE) ;

    Setup_Weights (*Opponent,OPPONENT(*Human)) ;
    Clear_Logo_Area () ;

    return (Com == PLAY_KEY) ;
}

/**************************************************************************/

void Top_Level_Menu (boolean Draw)
/*
PURPOSE: To draw the top level menu, or erase it.
*/
{
    #define T_X     ((MAIN_MENU_COL*Disp_Cfg.Char_Wide) - (MARGIN/2))
    #define T_Y     ((MAIN_MENU_ROW*Disp_Cfg.Char_High) - (MARGIN/2))
    #define T_WIDE  ((MAIN_COLS_WIDE*Disp_Cfg.Char_Wide) + MARGIN)
    #define T_HIGH  ((MAIN_MENU_ROWS*Disp_Cfg.Char_High) + MARGIN)
    extern  Disp_Cfg_t Disp_Cfg ;
    ushort  m ;

    if (!Draw) {
        Fill_Rect (T_X-1,T_Y-1,T_WIDE+2,T_HIGH+2,BLACK) ;
        return ;
    }
    Clear_Help_Line () ; /* No help, it's all in top level menu */
    Fill_Rect (T_X,T_Y,T_WIDE,T_HIGH,BLACK) ;
    Draw_Rect (T_X-1,T_Y-1,T_WIDE+2,T_HIGH+2,WHITE) ;

    for (m = FIRST_MAIN_MSG ; m <= LAST_MAIN_MSG ; m++) {
        Print_Message (m) ;
    }
}

/**************************************************************************/

int Get_Key (void)
/*
PURPOSE: To do a getch, and to return also a single code for function keys.
*/
{
    int Ch ;

    Ch = getch();
    if (Ch == FUN_PREFIX) {
        return (getch()) ;
    } else {
        return (Ch) ;
    }
}

/**************************************************************************/

boolean First_Interaction (Speed_t* Speed, Player_t* Human, short* Opponent)
/*
PURPOSE: To draw the title page and get the first choices of the user.
*/
{
    extern Screen_Const_t Grafs ;
    boolean Playing ;

    Title_Page () ;

    Playing  = Top_Level_Interact (Speed,Human,Opponent) ;
    if (Playing) {
        Clear_Screen () ;
    }
    return (Playing) ;
}

/*************************************************************************/

ushort Get_Check_Sum (uchar* String)
/*
PURPOSE: Returns the checksum of a string.
*/
{
    ushort sum,i ;
    sum = 0 ;
    i   = 0 ;
    while (String[i] != NUL) {
        sum = sum + (ushort)String[i] ;
        i++ ;
    }
    return (sum) ;
}

/*************************************************************************/

#include "DEC.H"

/*************************************************************************/

void Demask (char* String)
/*
PURPOSE: To strip the mask bit off a string
*/
{
    #define UNMASK 0x7F
    short i ;
    i = 0 ;
    while (String[i] != NUL) {
        String [i] = String[i] & UNMASK ;
        i++ ;
    }
}

/*************************************************************************/

#if DRODBAR
#define TITLE_CHKSUM  0x7DAE

ushort Title [1772] = {
    0x993A, 0x99A2, 0x99A6, 0x99A2, 0x99A8, 0x99AD, 0x99BB, 0x99AF, 
    0x99A4, 0x99B6, 0x99AC, 0x99BE, 0x99B3, 0x99BF, 0x99BC, 0x99B0,
    0x99A4, 0x99A1, 0x99BF, 0x99B7, 0x99AF, 0x99B1, 0x99B6, 0x99A1,
    0x99AE, 0x99B5, 0x99AC, 0x99AB, 0x99BB, 0x99A8, 0x99B1, 0x99A3, 
    0x99AB, 0x99A9, 0x99B6, 0x99BE, 0x99AB, 0x99AB, 0x99A9, 0x99BC, 
    0x99B9, 0x99B8, 0x99B2, 0x99B8, 0x99A4, 0x99A7, 0x99AE, 0x99B4,
    0x99A7, 0x99BF, 0x99AB, 0x99A4, 0x99A3, 0x99AC, 0x99A4, 0x99BA,
    0x99BB, 0x99A2, 0x99BE, 0x99B1, 0x99B5, 0x99AF, 0x99A2, 0x99BD, 
    0x99AE, 0x99A6, 0x99BD, 0x99B3, 0x99BE, 0x99A9, 0x99B5, 0x99B5, 
    0x99AD, 0x99B6, 0x99AD, 0x9761, 0x4054, 0x9754, 0x4104, 0x4102,
    0x4100, 0x4100, 0x4102, 0x4106, 0x4103, 0x4103, 0x4104, 0x4102, 
    0x4104, 0x4107, 0x4100, 0x4103, 0x4101, 0x4101, 0x4103, 0x4105, 
    0x4103, 0x4210, 0x4102, 0x4101, 0x4101, 0x420F, 0x4107, 0x4103, 
    0x4100, 0x421F, 0x4105, 0x4101, 0x4102, 0x4259, 0x4106, 0x4102, 
    0x4106, 0x423A, 0x4104, 0x4106, 0x4107, 0x420F, 0x4106, 0x4102, 
    0x4100, 0x426B, 0x4104, 0x4107, 0x4107, 0x426E, 0x4104, 0x4104,
    0x4100, 0x4278, 0x4107, 0x4100, 0x4105, 0x4276, 0x4107, 0x4104, 
    0x4103, 0x4104, 0x4102, 0x4100, 0x4107, 0x4104, 0x4104, 0x4104,
    0x4101, 0x4105, 0x4101, 0x4103, 0x4100, 0x4100, 0x4101, 0x4103, 
    0x9747, 0x4056, 0x9758, 0x4107, 0x4100, 0x4106, 0x4105, 0x4100,
    0x4107, 0x4105, 0x4102, 0x4100, 0x4101, 0x4106, 0x4104, 0x4101, 
    0x4105, 0x4105, 0x4104, 0x4106, 0x4102, 0x4106, 0x4106, 0x4101, 
    0x4141, 0x431B, 0x4148, 0x4104, 0x418D, 0x41CD, 0x41CF, 0x419B,
    0x4102, 0x4102, 0x427D, 0x4101, 0x4173, 0x4107, 0x4236, 0x4102,
    0x4177, 0x4100, 0x4294, 0x4101, 0x420D, 0x4106, 0x4277, 0x4103, 
    0x429E, 0x4101, 0x422A, 0x4103, 0x4273, 0x4106, 0x4103, 0x4107, 
    0x4107, 0x4101, 0x4103, 0x4103, 0x4107, 0x4106, 0x4106, 0x4104, 
    0x4100, 0x4105, 0x4103, 0x4107, 0x4100, 0x4104, 0x4106, 0x4102, 
    0x4101, 0x4101, 0x4105, 0x4104, 0x4102, 0x974F, 0x4050, 0x9990,
    0x99AE, 0x99B0, 0x99B6, 0x99B8, 0x99B2, 0x99A5, 0x99AD, 0x99BF, 
    0x99BA, 0x99A2, 0x99A8, 0x99A7, 0x99A4, 0x99BC, 0x99BF, 0x99AC, 
    0x99B1, 0x99B7, 0x99B2, 0x99B8, 0x99A0, 0x99AB, 0x99A6, 0x99A9, 
    0x99AB, 0x99B7, 0x99A4, 0x99BF, 0x99A6, 0x99A9, 0x99AF, 0x99AA,
    0x99B6, 0x99AB, 0x99A6, 0x99B3, 0x99B0, 0x99B2, 0x99BA, 0x99AA, 
    0x99B3, 0x99A3, 0x99B0, 0x99B0, 0x99A7, 0x99A7, 0x99B9, 0x99A5, 
    0x99B6, 0x99B1, 0x99B1, 0x99B4, 0x99A9, 0x99AD, 0x99B6, 0x99BD,
    0x99A7, 0x99AA, 0x99AB, 0x99A3, 0x99AC, 0x99AB, 0x99AC, 0x99B8, 
    0x99A6, 0x99AA, 0x99B3, 0x99A5, 0x99B4, 0x99AE, 0x99AB, 0x99BE, 
    0x99A1, 0x99AF, 0x9733, 0x4055, 0x975D, 0x4106, 0x42A6, 0x4346, 
    0x434D, 0x439A, 0x4101, 0x434B, 0x439E, 0x4101, 0x431E, 0x4340, 
    0x430D, 0x4394, 0x4348, 0x43A1, 0x43C9, 0x4105, 0x43BF, 0x430A, 
    0x4394, 0x432D, 0x4164, 0x4107, 0x4386, 0x4360, 0x432F, 0x430D,
    0x439C, 0x432C, 0x4100, 0x4320, 0x4378, 0x4372, 0x430D, 0x43A6, 
    0x4328, 0x4103, 0x418A, 0x41AD, 0x4104, 0x42AF, 0x429E, 0x4100, 
    0x4224, 0x437A, 0x4364, 0x4367, 0x430F, 0x4390, 0x439F, 0x4107, 
    0x437A, 0x4392, 0x4103, 0x418F, 0x4187, 0x4101, 0x42A8, 0x425D,
    0x4104, 0x4282, 0x4379, 0x43A8, 0x4377, 0x4323, 0x439D, 0x4107, 
    0x437F, 0x4394, 0x4104, 0x43A2, 0x4345, 0x4329, 0x4105, 0x975F, 
    0x4054, 0x9747, 0x4107, 0x432F, 0x438D, 0x43AC, 0x434D, 0x43B1,
    0x430F, 0x4364, 0x432E, 0x4377, 0x43A6, 0x4101, 0x43A4, 0x4378, 
    0x4102, 0x4102, 0x4104, 0x420E, 0x426A, 0x4270, 0x422F, 0x4298, 
    0x42A1, 0x42CC, 0x4107, 0x424A, 0x4270, 0x42A5, 0x422C, 0x4293, 
    0x4275, 0x4208, 0x42A0, 0x4248, 0x427C, 0x4270, 0x4209, 0x4267, 
    0x4103, 0x4101, 0x437E, 0x4396, 0x4103, 0x4107, 0x423C, 0x4295,
    0x422D, 0x422C, 0x4272, 0x4280, 0x4229, 0x4209, 0x421B, 0x4229,
    0x4176, 0x4104, 0x4242, 0x432D, 0x4366, 0x4383, 0x4103, 0x43A6, 
    0x4340, 0x4328, 0x4101, 0x43B1, 0x434A, 0x431D, 0x43A3, 0x4349, 
    0x436F, 0x4399, 0x4103, 0x4103, 0x974F, 0x4054, 0x9740, 0x4103, 
    0x437D, 0x4337, 0x4103, 0x43A7, 0x437D, 0x4397, 0x43A0, 0x43AA,
    0x4396, 0x432B, 0x4107, 0x430B, 0x4375, 0x4324, 0x4102, 0x4387,
    0x437C, 0x4365, 0x4360, 0x43AC, 0x43A1, 0x434A, 0x437A, 0x4377, 
    0x4162, 0x4105, 0x430D, 0x4370, 0x4321, 0x4107, 0x4340, 0x432C,
    0x4363, 0x4384, 0x4107, 0x43A3, 0x437E, 0x4102, 0x4380, 0x4393, 
    0x432A, 0x43B2, 0x432C, 0x4375, 0x43A7, 0x4100, 0x4331, 0x43AE, 
    0x43A1, 0x43AF, 0x4396, 0x4328, 0x4101, 0x4308, 0x4310, 0x43A9, 
    0x439D, 0x432D, 0x439B, 0x4104, 0x4379, 0x4331, 0x4104, 0x4387, 
    0x437E, 0x43BA, 0x432D, 0x4395, 0x4102, 0x4311, 0x43C9, 0x4104, 
    0x4101, 0x9751, 0x4052, 0x9741, 0x4104, 0x4106, 0x4100, 0x4103,
    0x4100, 0x4107, 0x43A3, 0x4345, 0x4329, 0x4107, 0x432B, 0x43C0, 
    0x43A6, 0x4390, 0x432F, 0x436F, 0x432F, 0x4101, 0x4363, 0x432C, 
    0x4336, 0x43A2, 0x4167, 0x4103, 0x43A3, 0x4345, 0x432C, 0x4106, 
    0x432B, 0x43C7, 0x43A1, 0x4390, 0x432A, 0x436E, 0x432E, 0x4106,
    0x4397, 0x434D, 0x433F, 0x4343, 0x43A1, 0x4106, 0x430C, 0x4372, 
    0x4327, 0x4107, 0x43A7, 0x4341, 0x432C, 0x4100, 0x432E, 0x43C3, 
    0x43A3, 0x4394, 0x432B, 0x436E, 0x4328, 0x4105, 0x4319, 0x432F,
    0x4371, 0x43A4, 0x4328, 0x4393, 0x4173, 0x4101, 0x4104, 0x4107, 
    0x4101, 0x4100, 0x4101, 0x4102, 0x4101, 0x4106, 0x974B, 0x4050, 
    0x998F, 0x99A2, 0x99A4, 0x99B2, 0x99B7, 0x99A6, 0x99A5, 0x99B4,
    0x99BE, 0x99AF, 0x99B2, 0x99AF, 0x99BA, 0x99AA, 0x99B8, 0x99B8, 
    0x99A2, 0x99B2, 0x99B1, 0x99B0, 0x99AF, 0x99B7, 0x99BA, 0x99AE, 
    0x99B3, 0x99B1, 0x99B3, 0x99AA, 0x99B9, 0x99A6, 0x99B7, 0x99AB,
    0x99BF, 0x99B8, 0x99BE, 0x99B2, 0x99B1, 0x99B2, 0x99B0, 0x99A7, 
    0x99A6, 0x99B3, 0x99AB, 0x99A5, 0x99BF, 0x99BB, 0x99B8, 0x99A2, 
    0x99BE, 0x99B6, 0x99AA, 0x99A1, 0x99A4, 0x99A8, 0x99B8, 0x99BB, 
    0x99AF, 0x99B8, 0x99BB, 0x99AB, 0x99B2, 0x99BE, 0x99AA, 0x99B9,
    0x99B6, 0x99B1, 0x99B4, 0x99A9, 0x99B1, 0x99AC, 0x99BF, 0x99A5, 
    0x99A4, 0x99A1, 0x99A0, 0x9727, 0x4052, 0x9742, 0x4103, 0x4103, 
    0x4106, 0x4103, 0x421C, 0x4105, 0x42AC, 0x4103, 0x429D, 0x4106,
    0x42A4, 0x4103, 0x427A, 0x4105, 0x426C, 0x4100, 0x4102, 0x4103, 
    0x4244, 0x4106, 0x4208, 0x4107, 0x4297, 0x4105, 0x4221, 0x4104,
    0x42BF, 0x4101, 0x420F, 0x4107, 0x4290, 0x4104, 0x422F, 0x4105, 
    0x4101, 0x4106, 0x4137, 0x4104, 0x4107, 0x4100, 0x429B, 0x4100, 
    0x427B, 0x4105, 0x4230, 0x4100, 0x42A5, 0x4102, 0x42B8, 0x4102, 
    0x420A, 0x4107, 0x4290, 0x4105, 0x422B, 0x4105, 0x4100, 0x4105,
    0x4227, 0x4102, 0x422A, 0x4104, 0x429B, 0x4103, 0x424D, 0x4106, 
    0x423F, 0x4102, 0x4272, 0x4105, 0x4103, 0x4100, 0x4100, 0x4107,
    0x974A, 0x4054, 0x975C, 0x4105, 0x4107, 0x4104, 0x4104, 0x4105, 
    0x4107, 0x4103, 0x4105, 0x4101, 0x4106, 0x4104, 0x4102, 0x4101,
    0x4104, 0x4105, 0x4107, 0x4106, 0x4102, 0x4107, 0x4105, 0x4100, 
    0x4100, 0x4105, 0x4107, 0x4102, 0x4102, 0x4103, 0x4105, 0x4105, 
    0x4104, 0x4101, 0x4100, 0x4102, 0x4101, 0x4107, 0x4106, 0x4103,
    0x4103, 0x4103, 0x4107, 0x4104, 0x4107, 0x4100, 0x4100, 0x4106, 
    0x4107, 0x4101, 0x4106, 0x4105, 0x4105, 0x4107, 0x4106, 0x4102, 
    0x4105, 0x4107, 0x4104, 0x4102, 0x4103, 0x4100, 0x4102, 0x4100, 
    0x4106, 0x4103, 0x4102, 0x4100, 0x4104, 0x4103, 0x4105, 0x4106, 
    0x4106, 0x4106, 0x4106, 0x4107, 0x4106, 0x9754, 0x4051, 0x9756, 
    0x4107, 0x4107, 0x4101, 0x4100, 0x4105, 0x4104, 0x4102, 0x4104,
    0x4105, 0x4101, 0x4152, 0x4105, 0x420F, 0x43A8, 0x43A6, 0x437A,
    0x431A, 0x430A, 0x4323, 0x4100, 0x418F, 0x4187, 0x4163, 0x418D, 
    0x4189, 0x4165, 0x4189, 0x4190, 0x4164, 0x4106, 0x420F, 0x4227, 
    0x429D, 0x4167, 0x4107, 0x420A, 0x43A9, 0x43A5, 0x437F, 0x4265,
    0x4249, 0x429B, 0x4281, 0x4103, 0x4224, 0x432A, 0x43B3, 0x4329, 
    0x4367, 0x4378, 0x4383, 0x4368, 0x432A, 0x4373, 0x43A6, 0x4170, 
    0x4103, 0x4107, 0x4101, 0x4101, 0x4100, 0x4106, 0x4100, 0x4103,
    0x4107, 0x4100, 0x4107, 0x4100, 0x4101, 0x4103, 0x4106, 0x4107, 
    0x4100, 0x4104, 0x9751, 0x4054, 0x9745, 0x4107, 0x4107, 0x4107, 
    0x4105, 0x4103, 0x4102, 0x4102, 0x4105, 0x4101, 0x4107, 0x4157, 
    0x4105, 0x42BD, 0x434F, 0x4370, 0x4322, 0x437E, 0x43BE, 0x4398, 
    0x4107, 0x419B, 0x4102, 0x4233, 0x4396, 0x437E, 0x4377, 0x43A1, 
    0x416A, 0x422D, 0x4371, 0x4320, 0x4107, 0x4226, 0x432B, 0x43B3,
    0x432D, 0x4363, 0x437F, 0x4385, 0x4369, 0x432E, 0x4376, 0x43A2, 
    0x4175, 0x4107, 0x4100, 0x4107, 0x4103, 0x4103, 0x4107, 0x4100, 
    0x4105, 0x4107, 0x4100, 0x4103, 0x4107, 0x4105, 0x4102, 0x4103, 
    0x4107, 0x4105, 0x4103, 0x4100, 0x4104, 0x4100, 0x4107, 0x4104,
    0x4106, 0x4101, 0x4103, 0x4100, 0x4105, 0x4105, 0x4102, 0x9759, 
    0x4056, 0x9754, 0x4107, 0x4105, 0x4102, 0x4100, 0x4103, 0x4102,
    0x4107, 0x4105, 0x4100, 0x4100, 0x4154, 0x4101, 0x41C6, 0x4105,
    0x4310, 0x434D, 0x43A5, 0x4162, 0x4103, 0x418D, 0x41B3, 0x4104, 
    0x4310, 0x434D, 0x43A6, 0x4165, 0x4102, 0x419C, 0x4195, 0x4104, 
    0x4215, 0x434D, 0x43A3, 0x4102, 0x422F, 0x436A, 0x4314, 0x432E, 
    0x4327, 0x4324, 0x432C, 0x4323, 0x4105, 0x4219, 0x437C, 0x4370, 
    0x43A4, 0x4395, 0x4378, 0x4367, 0x4364, 0x432C, 0x4396, 0x439A,
    0x4174, 0x4106, 0x4100, 0x4103, 0x4106, 0x4103, 0x4105, 0x4103,
    0x4104, 0x4101, 0x4103, 0x4106, 0x4102, 0x4104, 0x4100, 0x4104, 
    0x4104, 0x4105, 0x4102, 0x4102, 0x9743, 0x4056, 0x9745, 0x4102, 
    0x4103, 0x4104, 0x4104, 0x4100, 0x4100, 0x4105, 0x4101, 0x4106, 
    0x4101, 0x4154, 0x4101, 0x424A, 0x4373, 0x439B, 0x43A3, 0x4396,
    0x43AA, 0x4369, 0x4328, 0x4371, 0x43A4, 0x430C, 0x43A1, 0x434C, 
    0x437F, 0x4377, 0x4103, 0x430E, 0x4375, 0x4327, 0x4106, 0x424C, 
    0x4376, 0x4322, 0x43A8, 0x439B, 0x43A6, 0x4392, 0x434D, 0x4308,
    0x4367, 0x4101, 0x4269, 0x434A, 0x4319, 0x4394, 0x437F, 0x431E, 
    0x437F, 0x4374, 0x43A2, 0x4393, 0x437C, 0x4362, 0x4365, 0x432E, 
    0x4397, 0x439B, 0x4177, 0x4100, 0x4104, 0x4105, 0x4102, 0x4106, 
    0x4104, 0x4101, 0x4106, 0x4102, 0x4106, 0x4100, 0x4107, 0x4100,
    0x4106, 0x9752, 0x4057, 0x975B, 0x4106, 0x4105, 0x4100, 0x4101, 
    0x4103, 0x4103, 0x4101, 0x4104, 0x4103, 0x4107, 0x4154, 0x4102,
    0x4194, 0x4221, 0x4106, 0x430F, 0x4377, 0x4327, 0x4100, 0x4199, 
    0x4225, 0x4106, 0x421C, 0x437B, 0x4369, 0x4382, 0x43AA, 0x43A7, 
    0x432F, 0x4392, 0x4104, 0x423D, 0x4394, 0x430F, 0x4380, 0x4341, 
    0x434F, 0x431D, 0x439D, 0x4174, 0x4100, 0x4103, 0x4100, 0x4100,
    0x4107, 0x4100, 0x4100, 0x4102, 0x4106, 0x4106, 0x4107, 0x4103, 
    0x4102, 0x4104, 0x4103, 0x4100, 0x4106, 0x4106, 0x4105, 0x4103, 
    0x4101, 0x4107, 0x4100, 0x4101, 0x4102, 0x4101, 0x4105, 0x4104,
    0x4103, 0x4104, 0x4105, 0x4103, 0x4103, 0x4105, 0x9758, 0x4051, 
    0x974E, 0x4101, 0x4104, 0x4103, 0x4101, 0x4102, 0x4100, 0x4106, 
    0x4102, 0x4100, 0x4103, 0x4150, 0x4105, 0x421C, 0x437F, 0x436D, 
    0x4385, 0x43A9, 0x43A3, 0x432D, 0x4391, 0x439C, 0x4100, 0x430C, 
    0x4375, 0x4325, 0x4102, 0x4219, 0x437C, 0x4366, 0x437B, 0x43AB, 
    0x4394, 0x4173, 0x4103, 0x4101, 0x4101, 0x4102, 0x4103, 0x4101,
    0x4105, 0x4105, 0x4103, 0x4103, 0x4107, 0x4105, 0x4101, 0x4105, 
    0x4102, 0x4101, 0x4104, 0x4102, 0x4100, 0x4107, 0x4101, 0x4107, 
    0x4107, 0x4102, 0x4104, 0x4107, 0x4104, 0x4105, 0x4102, 0x4107,
    0x4106, 0x4107, 0x4105, 0x4104, 0x4105, 0x4107, 0x4100, 0x4103,
    0x4103, 0x4101, 0x4105, 0x9740, 0x4052, 0x9749, 0x4103, 0x4104, 
    0x4100, 0x4107, 0x4105, 0x4100, 0x4107, 0x4103, 0x4100, 0x4107, 
    0x4150, 0x4103, 0x4293, 0x430B, 0x43CA, 0x4103, 0x42A5, 0x4396,
    0x430E, 0x431C, 0x434A, 0x4374, 0x433D, 0x4100, 0x430F, 0x4376, 
    0x4325, 0x4104, 0x4287, 0x4341, 0x4379, 0x43A7, 0x437D, 0x4390,
    0x432F, 0x430A, 0x4364, 0x4348, 0x439F, 0x4368, 0x4174, 0x4103, 
    0x4101, 0x4107, 0x4107, 0x4106, 0x4106, 0x4107, 0x4104, 0x4106, 
    0x4103, 0x4103, 0x4102, 0x4101, 0x4102, 0x4106, 0x4107, 0x4101, 
    0x4102, 0x4107, 0x4102, 0x4105, 0x4101, 0x4100, 0x4107, 0x4103,
    0x4100, 0x4103, 0x4102, 0x4100, 0x4106, 0x4105, 0x4107, 0x4103, 
    0x9749, 0x4057, 0x9740, 0x4101, 0x4101, 0x4102, 0x4106, 0x4101, 
    0x4105, 0x4104, 0x4104, 0x4103, 0x4103, 0x4150, 0x4101, 0x42A4, 
    0x4393, 0x430A, 0x4376, 0x439C, 0x4384, 0x43AB, 0x43A0, 0x432C,
    0x4392, 0x4399, 0x4107, 0x430A, 0x4377, 0x4323, 0x4107, 0x4287, 
    0x4308, 0x4393, 0x430D, 0x4363, 0x4362, 0x432C, 0x4364, 0x4106, 
    0x4285, 0x4396, 0x4379, 0x431A, 0x4328, 0x439F, 0x439D, 0x434E,
    0x4376, 0x433C, 0x4173, 0x4107, 0x4101, 0x4101, 0x4102, 0x4102,
    0x4105, 0x4105, 0x4103, 0x4105, 0x4107, 0x4101, 0x4105, 0x4106, 
    0x4106, 0x4102, 0x4107, 0x4103, 0x4101, 0x4104, 0x4107, 0x4104, 
    0x4102, 0x4101, 0x4102, 0x4106, 0x4102, 0x974B, 0x4053, 0x9741, 
    0x4106, 0x4106, 0x4100, 0x4104, 0x4101, 0x4101, 0x4103, 0x4107, 
    0x4102, 0x4106, 0x4105, 0x4100, 0x4100, 0x4100, 0x4100, 0x4102,
    0x4104, 0x4104, 0x4106, 0x4103, 0x4107, 0x4103, 0x4105, 0x4105,
    0x4104, 0x4107, 0x4104, 0x4107, 0x4100, 0x4103, 0x4103, 0x4104, 
    0x4100, 0x4107, 0x4107, 0x4104, 0x4102, 0x4104, 0x4103, 0x4102, 
    0x4100, 0x4105, 0x4106, 0x4105, 0x4101, 0x4107, 0x4102, 0x4103,
    0x4101, 0x4102, 0x4102, 0x4102, 0x4103, 0x4100, 0x4106, 0x4100, 
    0x4104, 0x4105, 0x4102, 0x4105, 0x4102, 0x4107, 0x4104, 0x4100, 
    0x4106, 0x4100, 0x4106, 0x4107, 0x4106, 0x4102, 0x4104, 0x4103,
    0x4107, 0x4102, 0x9747, 0x4053, 0x998A, 0x99AF, 0x99A1, 0x99AF, 
    0x99BD, 0x99B4, 0x99B2, 0x99B8, 0x99AD, 0x99AC, 0x99BC, 0x99A5, 
    0x99A9, 0x99AE, 0x99B3, 0x99A9, 0x99A9, 0x99B1, 0x99B8, 0x99B3, 
    0x99A7, 0x99B9, 0x99B6, 0x99BE, 0x99BD, 0x99A2, 0x99BD, 0x99BA, 
    0x99A0, 0x99AC, 0x99BD, 0x99BA, 0x99BC, 0x99A8, 0x99A7, 0x99BF, 
    0x99B1, 0x99A1, 0x99A0, 0x99A4, 0x99AD, 0x99AE, 0x99A5, 0x99AC,
    0x99AB, 0x99B8, 0x99A6, 0x99A9, 0x99AB, 0x99A6, 0x99BD, 0x99AE, 
    0x99B3, 0x99B1, 0x99AF, 0x99B7, 0x99A5, 0x99A4, 0x99A5, 0x99B7, 
    0x99A2, 0x99B4, 0x99AB, 0x99A2, 0x99BE, 0x99A1, 0x99AA, 0x99BB, 
    0x99A4, 0x99AA, 0x99A2, 0x99A0, 0x99AC, 0x99B7, 0x99AB, 0x9735,
    0x4053, 0x9743, 0x4104, 0x4107, 0x427B, 0x4171, 0x4234, 0x4171,
    0x4293, 0x4308, 0x4370, 0x439B, 0x4328, 0x4372, 0x4165, 0x4102,
    0x4265, 0x4329, 0x4338, 0x4373, 0x4308, 0x4372, 0x437A, 0x4163,
    0x4106, 0x4147, 0x4269, 0x424B, 0x4149, 0x4167, 0x4104, 0x4248, 
    0x42A0, 0x4208, 0x4265, 0x42C9, 0x4106, 0x4100, 0x4105, 0x4105, 
    0x4106, 0x4100, 0x4103, 0x4103, 0x4106, 0x4101, 0x4105, 0x4103, 
    0x4101, 0x4104, 0x4103, 0x4105, 0x4103, 0x4104, 0x4101, 0x4100, 
    0x4100, 0x4106, 0x4105, 0x4235, 0x430D, 0x43C5, 0x41D0, 0x4105, 
    0x4182, 0x419F, 0x4199, 0x4189, 0x4106, 0x41A3, 0x4187, 0x41A0,
    0x419C, 0x418E, 0x41C6, 0x4106, 0x975D, 0x4054, 0x990D, 0x99A2, 
    0x99BF, 0x99BC, 0x99AD, 0x99A0, 0x99B6, 0x99BF, 0x99B6, 0x99A8,
    0x99A9, 0x99BA, 0x99B5, 0x99BF, 0x99AF, 0x99A9, 0x99B1, 0x99AC, 
    0x99A9, 0x99BF, 0x99BF, 0x99AD, 0x99A2, 0x99AB, 0x99A3, 0x99BC,
    0x99A5, 0x99AD, 0x99AA, 0x99BB, 0x99BF, 0x99B9, 0x99A4, 0x99A7,
    0x99B6, 0x99AA, 0x99A6, 0x99BC, 0x99A9, 0x99AA, 0x99A0, 0x99A5, 
    0x99A9, 0x99A1, 0x99BB, 0x99A7, 0x99B7, 0x99BD, 0x99B6, 0x99AE,
    0x99BE, 0x99A0, 0x99A1, 0x99B7, 0x99B2, 0x99B0, 0x99BA, 0x99BF,
    0x99AA, 0x99BA, 0x99A7, 0x99AC, 0x99BC, 0x99A8, 0x99B4, 0x99BB,
    0x99B7, 0x99A5, 0x99AE, 0x99A9, 0x99A5, 0x99AE, 0x99A0, 0x99A5,
    0x99A1, 0x979C, 0x4055, 0xFFFF};
#else

#define TITLE_CHKSUM  0x51B7

#define TITLE_LENGTH    1772

ushort Title [TITLE_LENGTH] = {
    0x993A, 0x99A2, 0x99A6, 0x99A2, 0x99A8, 0x99AD, 0x99BB, 0x99AF, 
    0x99A4, 0x99B6, 0x99AC, 0x99BE, 0x99B3, 0x99BF, 0x99BC, 0x99B0, 
    0x99A4, 0x99A1, 0x99BF, 0x99B7, 0x99AF, 0x99B1, 0x99B6, 0x99A1, 
    0x99AE, 0x99B5, 0x99AC, 0x99AB, 0x99BB, 0x99A8, 0x99B1, 0x99A3, 
    0x99AB, 0x99A9, 0x99B6, 0x99BE, 0x99AB, 0x99AB, 0x99A9, 0x99BC, 
    0x99B9, 0x99B8, 0x99B2, 0x99B8, 0x99A4, 0x99A7, 0x99AE, 0x99B4, 
    0x99A7, 0x99BF, 0x99AB, 0x99A4, 0x99A3, 0x99AC, 0x99A4, 0x99BA, 
    0x99BB, 0x99A2, 0x99BE, 0x99B1, 0x99B5, 0x99AF, 0x99A2, 0x99BD, 
    0x99AE, 0x99A6, 0x99BD, 0x99B3, 0x99BE, 0x99A9, 0x99B5, 0x99B5, 
    0x99AD, 0x99B6, 0x99AD, 0x9761, 0x4054, 0x9754, 0x4104, 0x4102, 
    0x4100, 0x4100, 0x4102, 0x4106, 0x4103, 0x4103, 0x4104, 0x4102, 
    0x4104, 0x4107, 0x4100, 0x4103, 0x4101, 0x4101, 0x4103, 0x4105, 
    0x4103, 0x4210, 0x4102, 0x4101, 0x4101, 0x420F, 0x4107, 0x4103, 
    0x4100, 0x421F, 0x4105, 0x4101, 0x4102, 0x4259, 0x4106, 0x4102, 
    0x4106, 0x423A, 0x4104, 0x4106, 0x4107, 0x420F, 0x4106, 0x4102, 
    0x4100, 0x426B, 0x4104, 0x4107, 0x4107, 0x426E, 0x4104, 0x4104, 
    0x4100, 0x4278, 0x4107, 0x4100, 0x4105, 0x4276, 0x4107, 0x4104, 
    0x4103, 0x4104, 0x4102, 0x4100, 0x4107, 0x4104, 0x4104, 0x4104, 
    0x4101, 0x4105, 0x4101, 0x4103, 0x4100, 0x4100, 0x4101, 0x4103, 
    0x9747, 0x4056, 0x9758, 0x4107, 0x4100, 0x4106, 0x4105, 0x4100, 
    0x4107, 0x4105, 0x4102, 0x4100, 0x4101, 0x4106, 0x4104, 0x4101, 
    0x4105, 0x4105, 0x4104, 0x4106, 0x4102, 0x4106, 0x4106, 0x4101, 
    0x4101, 0x4103, 0x4100, 0x4104, 0x4105, 0x4105, 0x4107, 0x4103, 
    0x4102, 0x4102, 0x4105, 0x4101, 0x4103, 0x4107, 0x4106, 0x4102, 
    0x4107, 0x4100, 0x4104, 0x4101, 0x4105, 0x4106, 0x4107, 0x4103, 
    0x4106, 0x4101, 0x4102, 0x4103, 0x4103, 0x4106, 0x4103, 0x4107, 
    0x4107, 0x4101, 0x4103, 0x4103, 0x4107, 0x4106, 0x4106, 0x4104, 
    0x4100, 0x4105, 0x4103, 0x4107, 0x4100, 0x4104, 0x4106, 0x4102, 
    0x4101, 0x4101, 0x4105, 0x4104, 0x4102, 0x974F, 0x4050, 0x9750, 
    0x4106, 0x4100, 0x4106, 0x4100, 0x4102, 0x4105, 0x4105, 0x4107, 
    0x4102, 0x4102, 0x4100, 0x4107, 0x4104, 0x4104, 0x4107, 0x4104, 
    0x4101, 0x4107, 0x4102, 0x4100, 0x4100, 0x4143, 0x431E, 0x4149, 
    0x4103, 0x418F, 0x41CC, 0x41CF, 0x41A6, 0x4101, 0x4107, 0x421A, 
    0x4106, 0x42AB, 0x4106, 0x429B, 0x4100, 0x42A2, 0x4102, 0x427A, 
    0x4103, 0x426B, 0x4100, 0x4208, 0x4107, 0x42A7, 0x4101, 0x424D, 
    0x4106, 0x42C1, 0x4101, 0x4104, 0x4101, 0x4105, 0x4106, 0x4105, 
    0x4107, 0x4102, 0x4103, 0x4103, 0x4104, 0x4103, 0x4104, 0x4100, 
    0x4106, 0x4102, 0x4103, 0x4105, 0x4104, 0x4106, 0x4103, 0x4106, 
    0x4101, 0x4107, 0x9753, 0x4055, 0x975D, 0x4106, 0x4106, 0x4106, 
    0x4105, 0x4102, 0x4101, 0x4103, 0x4106, 0x4101, 0x4106, 0x4100, 
    0x4105, 0x4104, 0x4100, 0x4101, 0x4101, 0x4105, 0x4107, 0x4102, 
    0x4104, 0x4105, 0x4104, 0x4107, 0x4106, 0x4100, 0x4107, 0x4105, 
    0x4104, 0x4104, 0x4100, 0x4100, 0x4100, 0x4102, 0x4105, 0x4106, 
    0x4100, 0x4103, 0x4102, 0x4105, 0x4104, 0x4107, 0x4106, 0x4100, 
    0x4104, 0x4102, 0x4104, 0x4107, 0x4107, 0x4100, 0x4107, 0x4107, 
    0x4102, 0x4102, 0x4103, 0x4107, 0x4107, 0x4101, 0x4100, 0x4105, 
    0x4104, 0x4102, 0x4101, 0x4100, 0x4107, 0x4103, 0x4105, 0x4107, 
    0x4107, 0x4104, 0x4104, 0x4102, 0x4105, 0x4101, 0x4105, 0x975F, 
    0x4054, 0x9987, 0x99A7, 0x99A7, 0x99BD, 0x99B4, 0x99B5, 0x99A9, 
    0x99AF, 0x99AC, 0x99B6, 0x99B7, 0x99B6, 0x99A9, 0x99A4, 0x99A8, 
    0x99BA, 0x99BA, 0x99AC, 0x99A6, 0x99AA, 0x99B0, 0x99A7, 0x99B8, 
    0x99B9, 0x99A4, 0x99B7, 0x99B2, 0x99B8, 0x99AD, 0x99A4, 0x99BB, 
    0x99B5, 0x99A0, 0x99B8, 0x99A0, 0x99B4, 0x99A8, 0x99B9, 0x99B7, 
    0x99AB, 0x99A9, 0x99A6, 0x99B6, 0x99A3, 0x99AF, 0x99B4, 0x99B5, 
    0x99AD, 0x99BC, 0x99AA, 0x99A0, 0x99A1, 0x99B1, 0x99BB, 0x99A1, 
    0x99BE, 0x99BC, 0x99A2, 0x99AD, 0x99BE, 0x99A3, 0x99A3, 0x99AE, 
    0x99B8, 0x99B0, 0x99A1, 0x99B1, 0x99BA, 0x99BD, 0x99BB, 0x99B1, 
    0x99A7, 0x99A1, 0x99AB, 0x99A3, 0x972F, 0x4054, 0x9740, 0x4103, 
    0x4105, 0x4107, 0x4103, 0x421F, 0x4105, 0x42AF, 0x4100, 0x429A, 
    0x4106, 0x42A3, 0x4107, 0x427B, 0x4105, 0x426C, 0x4102, 0x4107, 
    0x4104, 0x4245, 0x4100, 0x420C, 0x4101, 0x4292, 0x4102, 0x4227, 
    0x4102, 0x42BD, 0x4105, 0x4208, 0x4101, 0x4297, 0x4100, 0x422C, 
    0x4103, 0x4104, 0x4107, 0x4133, 0x4106, 0x4102, 0x4100, 0x429B, 
    0x4102, 0x427A, 0x4104, 0x4235, 0x4107, 0x42A0, 0x4101, 0x42BE, 
    0x4101, 0x420F, 0x4106, 0x4290, 0x4101, 0x4228, 0x4100, 0x4101, 
    0x4105, 0x4225, 0x4103, 0x422C, 0x4101, 0x4299, 0x4104, 0x424F, 
    0x4106, 0x423A, 0x4105, 0x4275, 0x4102, 0x4101, 0x4101, 0x4104, 
    0x4101, 0x9751, 0x4052, 0x9741, 0x4104, 0x4106, 0x4100, 0x4103, 
    0x4100, 0x4107, 0x4103, 0x4105, 0x4101, 0x4107, 0x4103, 0x4100, 
    0x4106, 0x4100, 0x4107, 0x4107, 0x4107, 0x4101, 0x4103, 0x4104, 
    0x4106, 0x4102, 0x4107, 0x4103, 0x4103, 0x4105, 0x4104, 0x4106, 
    0x4103, 0x4107, 0x4101, 0x4100, 0x4102, 0x4106, 0x4106, 0x4106, 
    0x4107, 0x4105, 0x4107, 0x4103, 0x4101, 0x4106, 0x4104, 0x4102, 
    0x4107, 0x4107, 0x4107, 0x4101, 0x4104, 0x4100, 0x4106, 0x4103, 
    0x4103, 0x4104, 0x4103, 0x4106, 0x4100, 0x4105, 0x4101, 0x4107, 
    0x4101, 0x4104, 0x4100, 0x4103, 0x4103, 0x4101, 0x4104, 0x4107, 
    0x4101, 0x4100, 0x4101, 0x4102, 0x4101, 0x4106, 0x974B, 0x4050, 
    0x974F, 0x4102, 0x4154, 0x4102, 0x429F, 0x43B6, 0x434D, 0x4364, 
    0x43AE, 0x4387, 0x4382, 0x437F, 0x4102, 0x432A, 0x4100, 0x4380, 
    0x432A, 0x4392, 0x4399, 0x4378, 0x4377, 0x430F, 0x4362, 0x434E, 
    0x43D3, 0x43D1, 0x430B, 0x43D2, 0x4349, 0x437E, 0x4377, 0x432B, 
    0x4107, 0x4208, 0x43AE, 0x43A2, 0x4379, 0x421A, 0x4208, 0x4227, 
    0x4106, 0x418B, 0x4183, 0x4165, 0x418F, 0x418B, 0x4160, 0x418A, 
    0x4196, 0x4106, 0x4142, 0x4209, 0x4224, 0x4298, 0x4160, 0x420B, 
    0x43AF, 0x43A0, 0x437B, 0x4263, 0x424A, 0x429E, 0x4282, 0x4161, 
    0x426E, 0x4371, 0x43AC, 0x4161, 0x4221, 0x421C, 0x4267, 0x414D, 
    0x4174, 0x4101, 0x4100, 0x9747, 0x4052, 0x9742, 0x4103, 0x4153, 
    0x4106, 0x429B, 0x43B4, 0x434D, 0x4364, 0x43AB, 0x4385, 0x4386, 
    0x437C, 0x4103, 0x432A, 0x4105, 0x4384, 0x4328, 0x4392, 0x439B, 
    0x437C, 0x4376, 0x4308, 0x4367, 0x434F, 0x43D5, 0x43D1, 0x430C, 
    0x43D7, 0x4349, 0x437F, 0x4377, 0x4328, 0x4104, 0x4227, 0x427D, 
    0x4299, 0x4166, 0x4107, 0x42BC, 0x434F, 0x4370, 0x4323, 0x4378, 
    0x43BB, 0x439D, 0x4100, 0x4198, 0x4175, 0x42C2, 0x4160, 0x4102, 
    0x4272, 0x42A7, 0x4100, 0x4105, 0x4103, 0x4105, 0x4100, 0x4105, 
    0x4107, 0x4102, 0x4102, 0x4104, 0x4103, 0x4103, 0x4105, 0x4106, 
    0x4107, 0x4102, 0x4102, 0x4105, 0x4103, 0x4100, 0x4100, 0x4107, 
    0x974A, 0x4054, 0x975C, 0x4105, 0x4107, 0x4104, 0x4104, 0x4105, 
    0x4147, 0x421B, 0x4165, 0x4101, 0x421E, 0x415C, 0x415A, 0x4161, 
    0x4104, 0x4215, 0x430F, 0x439E, 0x434A, 0x431F, 0x4165, 0x4100, 
    0x4230, 0x437D, 0x4397, 0x43A2, 0x4342, 0x4163, 0x4105, 0x420D, 
    0x439C, 0x4399, 0x4328, 0x436A, 0x4311, 0x4367, 0x432E, 0x4393, 
    0x4163, 0x4103, 0x4287, 0x430C, 0x439F, 0x4318, 0x4308, 0x4366, 
    0x4167, 0x4101, 0x427E, 0x431D, 0x431D, 0x430F, 0x436E, 0x416A, 
    0x4195, 0x4167, 0x4104, 0x426A, 0x437B, 0x4320, 0x43AA, 0x4360, 
    0x430E, 0x416B, 0x4192, 0x4160, 0x4104, 0x4263, 0x424D, 0x429E, 
    0x4286, 0x414E, 0x4176, 0x4107, 0x4106, 0x9754, 0x4051, 0x9756, 
    0x4107, 0x4157, 0x4101, 0x4298, 0x43B5, 0x434C, 0x4362, 0x43AC, 
    0x4385, 0x4381, 0x437A, 0x4105, 0x4337, 0x4348, 0x4396, 0x436A, 
    0x43BA, 0x430A, 0x4393, 0x4328, 0x4167, 0x4107, 0x4383, 0x4395, 
    0x4379, 0x431D, 0x4329, 0x4398, 0x439C, 0x437E, 0x4397, 0x434F, 
    0x4105, 0x430F, 0x4107, 0x41C2, 0x4101, 0x4315, 0x434F, 0x43A5, 
    0x4161, 0x4103, 0x4189, 0x41B3, 0x4104, 0x4312, 0x434B, 0x43A1, 
    0x4167, 0x4100, 0x419B, 0x4190, 0x4102, 0x4213, 0x434E, 0x43A0, 
    0x4173, 0x4107, 0x4101, 0x4101, 0x4100, 0x4106, 0x4100, 0x4103, 
    0x4107, 0x4100, 0x4107, 0x4100, 0x4101, 0x4103, 0x4106, 0x4107, 
    0x4100, 0x4104, 0x9751, 0x4054, 0x9745, 0x4107, 0x4157, 0x4107, 
    0x429D, 0x43B3, 0x434A, 0x4362, 0x43AD, 0x4381, 0x4387, 0x437F, 
    0x4105, 0x4345, 0x430F, 0x4390, 0x4322, 0x43BE, 0x430E, 0x4390, 
    0x432F, 0x4163, 0x4102, 0x424B, 0x4276, 0x42A6, 0x422F, 0x4261, 
    0x4162, 0x4105, 0x4269, 0x4248, 0x421F, 0x4296, 0x427B, 0x421B, 
    0x4245, 0x424B, 0x4287, 0x4165, 0x4101, 0x4246, 0x424E, 0x42A2, 
    0x420D, 0x421F, 0x4240, 0x424F, 0x4163, 0x4103, 0x42A7, 0x4228, 
    0x42C5, 0x420F, 0x4298, 0x4163, 0x4107, 0x424D, 0x4272, 0x426B, 
    0x427F, 0x429D, 0x4173, 0x4170, 0x4174, 0x4100, 0x4107, 0x4104, 
    0x4106, 0x4101, 0x4103, 0x4100, 0x4105, 0x4105, 0x4102, 0x9759, 
    0x4056, 0x9754, 0x4107, 0x4155, 0x4102, 0x4238, 0x4393, 0x430A, 
    0x4337, 0x434D, 0x4318, 0x4308, 0x4104, 0x4329, 0x4106, 0x436D, 
    0x4308, 0x4375, 0x43AD, 0x430A, 0x4363, 0x434D, 0x439B, 0x43A4, 
    0x4348, 0x431D, 0x430E, 0x4105, 0x43A2, 0x432C, 0x431D, 0x4374, 
    0x434D, 0x431D, 0x430B, 0x4102, 0x4387, 0x432A, 0x4394, 0x4106, 
    0x430F, 0x4384, 0x4384, 0x4363, 0x434D, 0x4319, 0x430C, 0x43D0, 
    0x434C, 0x437D, 0x4370, 0x432F, 0x4104, 0x4344, 0x430E, 0x4392, 
    0x4324, 0x43BE, 0x4308, 0x4393, 0x432E, 0x4103, 0x432D, 0x4103, 
    0x439C, 0x4379, 0x4333, 0x43A6, 0x43BA, 0x430C, 0x4390, 0x432C, 
    0x4174, 0x4105, 0x4102, 0x4102, 0x9743, 0x4056, 0x9745, 0x4102, 
    0x4153, 0x4104, 0x421C, 0x4378, 0x4390, 0x439D, 0x4349, 0x4106, 
    0x4321, 0x434C, 0x4101, 0x4332, 0x437B, 0x4393, 0x436B, 0x430E, 
    0x43D2, 0x4349, 0x4378, 0x4371, 0x432C, 0x4104, 0x4279, 0x4274, 
    0x416F, 0x429F, 0x424B, 0x42A6, 0x422D, 0x4107, 0x4226, 0x427C, 
    0x429E, 0x4162, 0x4100, 0x42BB, 0x434E, 0x4372, 0x4325, 0x4378, 
    0x43BF, 0x4399, 0x4101, 0x432A, 0x4101, 0x421C, 0x420F, 0x4226, 
    0x4177, 0x4104, 0x4102, 0x4103, 0x4104, 0x4102, 0x4105, 0x4106, 
    0x4107, 0x4103, 0x4107, 0x4100, 0x4104, 0x4105, 0x4102, 0x4106, 
    0x4104, 0x4101, 0x4106, 0x4102, 0x4106, 0x4100, 0x4107, 0x4100, 
    0x4106, 0x9752, 0x4057, 0x975B, 0x4106, 0x4155, 0x4100, 0x4219, 
    0x437B, 0x4373, 0x4399, 0x43AC, 0x4363, 0x432F, 0x4374, 0x43D2, 
    0x430C, 0x4161, 0x4106, 0x430F, 0x4377, 0x430F, 0x4360, 0x4349, 
    0x439D, 0x434E, 0x4104, 0x4323, 0x4349, 0x4102, 0x439A, 0x437F, 
    0x4367, 0x43AA, 0x43D4, 0x434D, 0x437C, 0x4377, 0x4348, 0x4101, 
    0x4347, 0x430D, 0x4395, 0x4324, 0x43B8, 0x430B, 0x4390, 0x4328, 
    0x4107, 0x4328, 0x4100, 0x439A, 0x437E, 0x4336, 0x43A7, 0x43BB, 
    0x430A, 0x4394, 0x432B, 0x4170, 0x4106, 0x4106, 0x4105, 0x4103, 
    0x4101, 0x4107, 0x4100, 0x4101, 0x4102, 0x4101, 0x4105, 0x4104, 
    0x4103, 0x4104, 0x4105, 0x4103, 0x4103, 0x4105, 0x9758, 0x4051, 
    0x974E, 0x4101, 0x4154, 0x4103, 0x4269, 0x43AA, 0x4360, 0x43A6, 
    0x434A, 0x4368, 0x432B, 0x4320, 0x434D, 0x430C, 0x4107, 0x432D, 
    0x4105, 0x4391, 0x432B, 0x4375, 0x4321, 0x432C, 0x4390, 0x434C, 
    0x4375, 0x433D, 0x4102, 0x4381, 0x432C, 0x4396, 0x4103, 0x420B, 
    0x4394, 0x431B, 0x4343, 0x4349, 0x43A1, 0x432A, 0x43A3, 0x43A1, 
    0x43AD, 0x4395, 0x430B, 0x4103, 0x432F, 0x4105, 0x4269, 0x432D, 
    0x431A, 0x4319, 0x430C, 0x4372, 0x4348, 0x431F, 0x4309, 0x4177, 
    0x4107, 0x4102, 0x4104, 0x4107, 0x4104, 0x4105, 0x4102, 0x4107, 
    0x4106, 0x4107, 0x4105, 0x4104, 0x4105, 0x4107, 0x4100, 0x4103, 
    0x4103, 0x4101, 0x4105, 0x9740, 0x4052, 0x9749, 0x4103, 0x4154, 
    0x4100, 0x424F, 0x4375, 0x4398, 0x43A7, 0x430B, 0x4360, 0x4367, 
    0x4308, 0x43D3, 0x434B, 0x437B, 0x4372, 0x432B, 0x4105, 0x4346, 
    0x430E, 0x4394, 0x4322, 0x43BC, 0x430D, 0x4390, 0x432F, 0x4106, 
    0x432D, 0x4104, 0x439F, 0x4379, 0x4331, 0x43A7, 0x43BD, 0x4308, 
    0x4397, 0x432A, 0x4174, 0x4100, 0x4107, 0x4100, 0x4104, 0x4103, 
    0x4101, 0x4107, 0x4107, 0x4106, 0x4106, 0x4107, 0x4104, 0x4106, 
    0x4103, 0x4103, 0x4102, 0x4101, 0x4102, 0x4106, 0x4107, 0x4101, 
    0x4102, 0x4107, 0x4102, 0x4105, 0x4101, 0x4100, 0x4107, 0x4103, 
    0x4100, 0x4103, 0x4102, 0x4100, 0x4106, 0x4105, 0x4107, 0x4103, 
    0x9749, 0x4057, 0x9740, 0x4101, 0x4151, 0x4102, 0x4286, 0x4391, 
    0x437D, 0x433C, 0x4394, 0x430B, 0x436B, 0x4368, 0x4309, 0x43D4, 
    0x434B, 0x437A, 0x4376, 0x432C, 0x4104, 0x4363, 0x4378, 0x433C, 
    0x434A, 0x4319, 0x430F, 0x4102, 0x439F, 0x432B, 0x438F, 0x43AF, 
    0x4328, 0x4373, 0x43D5, 0x434B, 0x430A, 0x4364, 0x432C, 0x4106, 
    0x432D, 0x4106, 0x4281, 0x4172, 0x4260, 0x4177, 0x421D, 0x4176, 
    0x4106, 0x4104, 0x4103, 0x4107, 0x4101, 0x4101, 0x4102, 0x4102, 
    0x4105, 0x4105, 0x4103, 0x4105, 0x4107, 0x4101, 0x4105, 0x4106, 
    0x4106, 0x4102, 0x4107, 0x4103, 0x4101, 0x4104, 0x4107, 0x4104, 
    0x4102, 0x4101, 0x4102, 0x4106, 0x4102, 0x974B, 0x4053, 0x9741, 
    0x4106, 0x4106, 0x4100, 0x4104, 0x4101, 0x4101, 0x4103, 0x4107, 
    0x4102, 0x4106, 0x4105, 0x4100, 0x4100, 0x4100, 0x4100, 0x4102, 
    0x4104, 0x4104, 0x4106, 0x4103, 0x4107, 0x4103, 0x4105, 0x4105, 
    0x4104, 0x4107, 0x4104, 0x4107, 0x4100, 0x4103, 0x4103, 0x4104, 
    0x4100, 0x4107, 0x4107, 0x4104, 0x4102, 0x4104, 0x4103, 0x4102, 
    0x4100, 0x4105, 0x4106, 0x4105, 0x4101, 0x4107, 0x4102, 0x4103, 
    0x4101, 0x4102, 0x4102, 0x4102, 0x4103, 0x4100, 0x4106, 0x4100, 
    0x4104, 0x4105, 0x4102, 0x4105, 0x4102, 0x4107, 0x4104, 0x4100, 
    0x4106, 0x4100, 0x4106, 0x4107, 0x4106, 0x4102, 0x4104, 0x4103, 
    0x4107, 0x4102, 0x9747, 0x4053, 0x998A, 0x99AF, 0x99A1, 0x99AF, 
    0x99BD, 0x99B4, 0x99B2, 0x99B8, 0x99AD, 0x99AC, 0x99BC, 0x99A5, 
    0x99A9, 0x99AE, 0x99B3, 0x99A9, 0x99A9, 0x99B1, 0x99B8, 0x99B3, 
    0x99A7, 0x99B9, 0x99B6, 0x99BE, 0x99BD, 0x99A2, 0x99BD, 0x99BA, 
    0x99A0, 0x99AC, 0x99BD, 0x99BA, 0x99BC, 0x99A8, 0x99A7, 0x99BF, 
    0x99B1, 0x99A1, 0x99A0, 0x99A4, 0x99AD, 0x99AE, 0x99A5, 0x99AC, 
    0x99AB, 0x99B8, 0x99A6, 0x99A9, 0x99AB, 0x99A6, 0x99BD, 0x99AE, 
    0x99B3, 0x99B1, 0x99AF, 0x99B7, 0x99A5, 0x99A4, 0x99A5, 0x99B7, 
    0x99A2, 0x99B4, 0x99AB, 0x99A2, 0x99BE, 0x99A1, 0x99AA, 0x99BB, 
    0x99A4, 0x99AA, 0x99A2, 0x99A0, 0x99AC, 0x99B7, 0x99AB, 0x9735, 
    0x4053, 0x9743, 0x4104, 0x4107, 0x421B, 0x42A9, 0x429C, 0x42A1, 
    0x427B, 0x4268, 0x4208, 0x42A3, 0x4248, 0x42C2, 0x4165, 0x4102, 
    0x4265, 0x4329, 0x4338, 0x4373, 0x4308, 0x4372, 0x437A, 0x4163, 
    0x4106, 0x4147, 0x4269, 0x424B, 0x4149, 0x4167, 0x4104, 0x4248, 
    0x42A0, 0x4208, 0x4265, 0x42C9, 0x4106, 0x4100, 0x4105, 0x4105, 
    0x4106, 0x42A0, 0x432B, 0x4363, 0x41D6, 0x4101, 0x4185, 0x419B, 
    0x4199, 0x418C, 0x4103, 0x41A5, 0x4183, 0x4184, 0x41C1, 0x41A8, 
    0x41B0, 0x4166, 0x4105, 0x4235, 0x430D, 0x43C5, 0x41D0, 0x4105, 
    0x4182, 0x419F, 0x4199, 0x4189, 0x4106, 0x41A3, 0x4187, 0x41A0, 
    0x419C, 0x418E, 0x41C6, 0x4106, 0x975D, 0x4054, 0x990D, 0x99A2, 
    0x99BF, 0x99BC, 0x99AD, 0x99A0, 0x99B6, 0x99BF, 0x99B6, 0x99A8, 
    0x99A9, 0x99BA, 0x99B5, 0x99BF, 0x99AF, 0x99A9, 0x99B1, 0x99AC, 
    0x99A9, 0x99BF, 0x99BF, 0x99AD, 0x99A2, 0x99AB, 0x99A3, 0x99BC, 
    0x99A5, 0x99AD, 0x99AA, 0x99BB, 0x99BF, 0x99B9, 0x99A4, 0x99A7, 
    0x99B6, 0x99AA, 0x99A6, 0x99BC, 0x99A9, 0x99AA, 0x99A0, 0x99A5, 
    0x99A9, 0x99A1, 0x99BB, 0x99A7, 0x99B7, 0x99BD, 0x99B6, 0x99AE,
    0x99BE, 0x99A0, 0x99A1, 0x99B7, 0x99B2, 0x99B0, 0x99BA, 0x99BF,
    0x99AA, 0x99BA, 0x99A7, 0x99AC, 0x99BC, 0x99A8, 0x99B4, 0x99BB,
    0x99B7, 0x99A5, 0x99AE, 0x99A9, 0x99A5, 0x99AE, 0x99A0, 0x99A5,
    0x99A1, 0x979C, 0x4055, 0xFFFF};
#endif

/*************************************************************************/

void Decode_And_Show_Titles (void)

{
    uchar* Str ;

    Str = (uchar*)Title ;
    Decode (Str,Title,TITLE_CHKSUM) ;
    Show_Titles () ;
}

/*************************************************************************/

void Show_Titles (void)

{
    clrscr () ; gotoxy (0,0) ;
    printf ((char*)Title) ;
}

/*************************************************************************/

void Decode (uchar* String, ushort* Shorts, ushort Checksum)
/*
PURPOSE: To decode the string, storing it inplace where the shorts
         used to be. We also make sure that the decoded string has
         the same checksum as the one passed to us. If the checksum
         is different then we exit immediately.
*/
{
    short s,c ;
    ushort Check ;

    Check = 0 ;
    s = 0 ;
    c = 0 ;
    while (Shorts[s] != 0xFFFF) {
        if (Shorts[s] & NORMAL_TAG) {
            String[c] = (Shorts[s] >> NORMAL_SHIFT) & 0xFF ;
        } else if (Shorts[s] & SPECIAL_TAG) {
            String[c] = (Shorts[s] >> SPECIAL_SHIFT) & 0xFF ;
        } else {
            exit (1) ;
        }
        Check = Check + (ushort)String[c] ;
        s++ ;
        c++ ;
    }
    String[c] = NUL ;
    if (Check != Checksum) {
        exit (1) ;
    }
}

/*************************************************************************/
