/*
 *    B G _ S T D O P . C  -- this file deals with standard opening moves.
 *
 *     O.F.Ransen, 25th March 1995
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <conio.h>
#include "bg.h"

/*************************************************************************/

#define N_STD_OPENINGS 16
#define NO_MOVE_INDEX   0

/*************************************************************************/
/* There is a list of standard opening moves. The index in the look
up table points to a transit to copy. Doubles never occur in opening
moves of course, as shown by the leading diagonal (NO_MOVE_INDEX).

                       1st Dice =    1  2  3  4  5  6     2nd Dice */
static short Std_Lut [6][6]     = {{ 0, 1, 2, 3, 4, 5},    /* 1 */
                                   { 1, 0, 6, 7, 8, 9},    /* 2 */
                                   { 2, 6, 0,10,11,12},    /* 3 */
                                   { 3, 7,10, 0,13,14},    /* 4 */
                                   { 4, 8,11,13, 0,15},    /* 5 */
                                   { 5, 9,12,14,15, 0,}};  /* 6 */

static Transit_t Std_Trans [N_STD_OPENINGS] = {
     /* 00 = all doubles, used to init opponents no motion transit */
     {{0, 2,0,0,0,0,0, 0,0,0,0,0,5, 0,0,0,0,3,0, 5,0,0,0,0,0, 0},
       0,
      { 0, 0, 0, 0},
      { 0, 0, 0, 0},
      { 0, 0, 0, 0},
      { 0, 0, 0, 0}},

     /* 01 = 2,1 */
     {{0, 1,1,0,0,0,0, 0,0,0,0,0,4, 0,1,0,0,3,0, 5,0,0,0,0,0, 0},
       2,             /* N_Moves */
      {12, 1,0,0},    /* Starting points */
      { 2, 1,0,0},    /* N places moved */
      { 4, 1,0,0},    /* Starting height (0..5) */
      { 0, 0,0,0}},   /* Ending height   (0..5) */

     /* 02 = 3,1 */
     {{0, 2,0,0,0,0,0, 0,0,0,0,0,5, 0,0,0,0,2,0, 4,2,0,0,0,0, 0},
       2,             /* N_Moves */
      {17,19,0,0},    /* Starting points */
      { 3, 1,0,0},    /* N places moved */
      { 2, 4,0,0},    /* Starting height (0..5) */
      { 0, 1,0,0}},   /* Ending height   (0..5) */

     /* 03 = 4,1, using TD-Gammons move */
     {{0, 1,1,0,0,0,0, 0,0,0,0,0,4, 0,0,0,1,3,0, 5,0,0,0,0,0, 0},
       2,             /* N_Moves */
      {12, 1,0,0},    /* Starting points */
      { 4, 1,0,0},    /* N places moved */
      { 4, 1,0,0},    /* Starting height (0..5) */
      { 0, 0,0,0}},   /* Ending height   (0..5) */

     /* 04 = 5,1 */
     {{0, 1,1,0,0,0,0, 0,0,0,0,0,4, 0,0,0,0,4,0, 5,0,0,0,0,0, 0},
       2,           /* N_Moves */
      {1,12,0,0},    /* Starting points */
      {1, 5,0,0},    /* N places moved */
      {1, 4,0,0},    /* Starting height (0..5) */
      {0, 3,0,0}},   /* Ending height   (0..5) */

     /* 05 = 6,1 */
     {{0, 2,0,0,0,0,0, 0,0,0,0,0,4, 0,0,0,0,2,2, 5,0,0,0,0,0, 0},
       2,
      {12,17,0,0},
      { 6, 1,0,0},
      { 4, 2,0,0},
      { 0, 1,0,0}},

     /* 06 = 2,3 */
     {{0, 2,0,0,0,0,0, 0,0,0,0,0,3, 0,1,1,0,3,0, 5,0,0,0,0,0, 0},
       2,
      {12,12, 0, 0},
      { 3, 2, 0, 0},
      { 4, 3, 0, 0},
      { 0, 0, 0, 0}},

     /* 07 = 2,4 */
     {{0, 2,0,0,0,0,0, 0,0,0,0,0,5, 0,0,0,0,2,0, 4,0,2,0,0,0, 0},
       2,
      {17,19, 0, 0},
      { 4, 2, 0, 0},
      { 2, 4, 0, 0},
      { 0, 1, 0, 0}},

     /* 08 = 5,2 */
     {{0, 2,0,0,0,0,0, 0,0,0,0,0,3, 0,1,0,0,4,0, 5,0,0,0,0,0, 0},
       2,           /* N_Moves */
      {12,12,0,0},    /* Starting points */
      { 5, 2,0,0},    /* N places moved */
      { 4, 3,0,0},    /* Starting height (0..5) */
      { 3, 0,0,0}},   /* Ending height   (0..5) */

     /* 09 = 6,2 */
     {{0, 1,0,0,0,0,0, 1,0,0,0,0,4, 0,1,0,0,3,0, 5,0,0,0,0,0, 0},
       2,           /* N_Moves */
      {1,12,0,0},    /* Starting points */
      {6, 2,0,0},    /* N places moved */
      {1, 4,0,0},    /* Starting height (0..5) */
      {0, 0,0,0}},   /* Ending height   (0..5) */

     /* 10 = 3,4 */
     {{0, 2,0,0,0,0,0, 0,0,0,0,0,3, 0,0,1,1,3,0, 5,0,0,0,0,0, 0},
       2,               /* N_Moves */
      {12,12, 0, 0},    /* Starting points */
      { 3, 4, 0, 0},    /* N places moved */
      { 4, 3, 0, 0},    /* Starting height (0..5) */
      { 0, 0, 0, 0}},   /* Ending height   (0..5) */

     /* 11 = 5,3 */
     {{0, 2,0,0,0,0,0, 0,0,0,0,0,3, 0,0,1,0,4,0, 5,0,0,0,0,0, 0},
       2,
      {12,12, 0, 0},
      { 5, 3, 0, 0},
      { 4, 3, 0, 0},
      { 3, 0, 0, 0}},

     /* 12 = 6,3 */
     {{0, 1,0,0,0,0,0, 0,0,0,1,0,5, 0,0,0,0,3,0, 5,0,0,0,0,0, 0},
       2,           /* N_Moves */
      {1,7,0,0},    /* Starting points */
      {6,3,0,0},    /* N places moved */
      {1,0,0,0},    /* Starting height (0..5) */
      {0,0,0,0}},   /* Ending height   (0..5) */

     /* 13 = 5,4 */
     {{0, 2,0,0,0,0,0, 0,0,0,0,0,3, 0,0,0,1,4,0, 5,0,0,0,0,0, 0},
       2,           /* N_Moves */
      {12,12,0,0},    /* Starting points */
      { 5, 4,0,0},    /* N places moved */
      { 4, 3,0,0},    /* Starting height (0..5) */
      { 3, 0,0,0}},   /* Ending height   (0..5) */

     /* 14 = 6,4 */
     {{0, 1,0,0,0,0,0, 0,0,0,0,1,5, 0,0,0,0,3,0, 5,0,0,0,0,0, 0},
       2,              /* N_Moves */
      { 1, 7, 0, 0},   /* Starting points */
      { 6, 4, 0, 0},   /* N places moved */
      { 1, 0, 0, 0},   /* Starting height (0..5) */
      { 0, 0, 0, 0}},  /* Ending height   (0..5) */

     /* 15 = 6,5 */
     {{0, 1,0,0,0,0,0, 0,0,0,0,0,6, 0,0,0,0,3,0, 5,0,0,0,0,0, 0},
       2,           /* N_Moves */
      {1,7,0,0},    /* Starting points */
      {6,5,0,0},    /* N places moved */
      {1,0,0,0},    /* Starting height (0..5) */
      {0,5,0,0}}};  /* Ending height   (0..5) */

/**************************************************************************/

extern const Layout_t Initial_Layout ;

boolean Standard_Opening (Dice_t*    Dice,
                          Transit_t* My_Old_Tr,  Transit_t* His_Old_Tr,
                          Transit_t* My_Best_Tr, Transit_t* His_Best_Tr)
/*
PURPOSE: To return TRUE if we are at the first move of the game and to
copy in a standard move into the best transits.
*/
{
    short Transit_Index ;

    if (memcmp (My_Old_Tr->Layout,Initial_Layout,sizeof(Layout_t)) == SAME_STRING) {
        if (memcmp (His_Old_Tr->Layout,Initial_Layout,sizeof(Layout_t)) == SAME_STRING) {

            Transit_Index = Std_Lut [Dice->Values[0]-1][Dice->Values[1]-1] ;
            if ((Transit_Index <= 0) || (Transit_Index >= N_STD_OPENINGS)) {
                Error_Exit ("Bad Transit_Index") ;
            }
            memcpy (My_Best_Tr,&Std_Trans[Transit_Index],sizeof(Transit_t)) ;
            memcpy (His_Best_Tr,&Std_Trans[NO_MOVE_INDEX],sizeof(Transit_t)) ;

            Check_Layout (My_Best_Tr->Layout, "Checking My Std Op") ;
            Check_Layout (His_Best_Tr->Layout,"Checking His Std Op") ;

            return (TRUE) ;
        }
    }
    return (FALSE) ;
}

/**************************************************************************/
