/*
 *                        B G _ M E S G . C
 * This module handles multi language message printing.
 * O.F.Ransen:    18th October 1991
 * This version:  30th January 1993
 */

#include <stdlib.h>
#include <stdio.h>
#include <stdlib.h>   /* For rand function */
#include <conio.h>
#include <string.h>
#include <dos.h>      /* For 'sound' and 'delay' */
#include "lang.h"
#include "bg.h"

/****************************************************************************/

#define HELP_AREA    1   /* A single line at the bottom of the screen  */
#define SIDE_AREA    2   /* Block of text on right of screen */
#define GRAF_AREA    3   /* Anywhere on the screen in graphics mode */
#define TEXT_AREA    4   /* Anywhere on the screen in text mode */
#define CFRAME_AREA  5   /* A central frame area */

extern Disp_Cfg_t Disp_Cfg ;

#if ITALIAN_REL
short Lang = ITA_LANG ;
#elif ENGLISH_REL
short Lang = ENG_LANG ;
#else
Force an error
#endif

Mesg_t Messages[N_MESGS] = {
    /* 01234567890 */
    {{"STATISTICS ","STATISTICHE"},       /* STAT_MSG */
      SIDE_AREA, 1,2,0,PUSH},

    {{"RED    WHITE","ROSSO BIANCO"},     /* ID_MSG */
      SIDE_AREA, ID_ROW,0,0,PUSH},

    {{"  TOTALS   ","  TOTALI   "},          /* TOTAL_MSG */
      SIDE_AREA, TOTALM_ROW,0,0,PUSH},

    {{" DOUBLES   ","   DOPPI   "},          /* DOUBLE_MSG */
      SIDE_AREA, DOUBM_ROW,0,0,PUSH},

    {{"  POINTS   ","   PUNTI   "},          /* POINTS_MSG */
      SIDE_AREA, POINTSM_ROW,0,0,PUSH},

    {{"F10=MAIN MENU","F10=MENU PRINCIPALE"}, /* HELP_MSG */
      HELP_AREA,0,0,0,PUSH},

    {{"LEFT MOUSE BUTTON (F10=MAIN MENU...)",  /* HIT_MOUSE_MSG */
      "BOTTONE SINISTRA (F10=MENU PRINCIPALE...)"},
      HELP_AREA,0,0,0,PUSH},

    {{"SETUP",                               /* SETUP_MSG */
      "SETUP"},
      GRAF_AREA,S_TITLE_ROW,SETUP_COL,0,PUSH},

    /* These are main menu titles... */

    {{"F3    = SETUP",  "F3    = SETUP"},
     GRAF_AREA,MAIN_MENU_ROW,MAIN_MENU_COL,0,PUSH},

    {{"ENTER = PLAY",  "INVIO = GIOCA"},
     GRAF_AREA,MAIN_MENU_ROW+1,MAIN_MENU_COL,0,PUSH},

    {{"ESC   = EXIT",   "ESC   = USCIRE"},
     GRAF_AREA,MAIN_MENU_ROW+2,MAIN_MENU_COL,0,PUSH},

    {{"USE CURSOR KEYS, ENTER TO ACCEPT, ESC TO ABANDON",
      "USARE TASTI CURSORI , INVIO , ESC"},
       HELP_AREA,0,0,0,PUSH},

    /* These are the playing instructions... */

    {{"YOU CANNOT MOVE FROM THIS POINT",  /* CANT_START_MSG */
      "NON POI COMINCARE DA QUA"},
      HELP_AREA,0,0,300,PUSH},

    {{"YOU CANNOT MOVE TO THIS POINT",    /* CANT_END_MSG */
      "NON POI FINIRE QUA"},
       HELP_AREA,0,0,333,PUSH},

    {{"SELECT START POINT (ESC=REDO F10=END)",       /* SEL_STA_MSG */
      "SELEZIONARE PUNTO DI PARTENZA (ESC=RIFARE, F10=USCIRE)"},
       HELP_AREA,0,0,0,PUSH},

    {{"SELECT END POINT (ESC=REDO F10=END)",                 /* SEL_END_MSG */
      "SELEZIONARE PUNTO DI ARRIVO (ESC=RIFARE, F10=USCIRE)"},
       HELP_AREA,0,0,0,PUSH},

    {{"CLICK AGAIN TO GO, ESC=RETRY, F10=QUIT",  /* CLK_GO_MSG */
      "CLICK PER CONFERMARE, ESC=RIFARE, F10=USCIRE"},
       HELP_AREA,0,0,0,PUSH},

    {{"RED CANNOT MOVE...",  /* B_NOGO_MSG */
      "ROSSO E\' BLOCCATO..."},
       HELP_AREA,0,0,0,PUSH},

    {{"WHITE CANNOT MOVE...",  /* W_NOGO_MSG */
      "BIANCO E\' BLOCCATO"},
       HELP_AREA,0,0,0,PUSH},

    {{"ESC TO EXIT...",        /* CTLC_MSG */
      "ESC PER USCIRE..."},
       HELP_AREA,0,0,0,PUSH},

    {{"INPUT INITIAL DICE (1...6, ENTER=ACCEPT, BACKSPACE=CHANGE)",  /* INIT_DICE_MSG */
      "INSERIRE PRIMI DADI (1...6, INVIO=ACCETTARE, CANCELLA=CAMBIARE)"},
       HELP_AREA,0,0,0,PUSH},

    /* 0123456789012345678901234567890123456789012345678901234567890123 */

    {{"INPUT DICE (1...6, ENTER=ACCEPT, BACKSPACE=CHANGE, ESC=CLEAR)",  /* THROW_DICE_MSG */
      "INSERIRE DADI (1..6, INVIO=ACCETTARE, CANC=CAMBIARE)"},
       HELP_AREA,0,0,0,PUSH},

    {{"HIT A KEY TO CONTINUE",  /* HAKTOC_MSG */
      "PREMERE QUALSIASI TASTO"},
       TEXT_AREA,0,0,0,PUSH},

    {{"CLICK ON CENTRAL D TO DOUBLE ANYWHERE ELSE TO THROW",  /* DBL_MSG */
      "CLICKARE (SUL D CENTRALE PER RADDOPPIARE)"},
       HELP_AREA,0,0,0,PUSH},

    {{"DOUBLING BEYOND 32 NOT ALLOWED",  /* DBL_LIM_MSG */
      "NON SI PUO RADDOPIARE OLTRE 32"},
       HELP_AREA,0,0,0,PUSH},

    {{"CLICK ON CENTRAL D TO ACCEPT DOUBLE",   /* ACC_DBL_MSG */
      "CLICKARE SUL D CENTRALE PER ACCETTARE"},
       HELP_AREA,12,0,0,PUSH},

    {{"COMPUTER REJECTS DOUBLE",   /* COM_REJ_MSG */
      "IL COMPUTER NON ACCETTA IL RADDOPPIO"},
       CFRAME_AREA,12,0,0,PUSH},

    {{"COMPUTER ACCEPTS DOUBLE",   /* COM_ACC_MSG */
      "IL COMPUTER ACCETTA IL RADDOPPIO"},
       CFRAME_AREA,12,0,0,PUSH},

    {{"COMPUTER DOUBLES, DO YOU ACCEPT?",   /* YOU_ACC_MSG */
      "IL COMPUTER RADDOPPIA, ACCETTI?"},
       CFRAME_AREA,12,0,0} ,

    {{"WHITE DOUBLES...",   /* WHT_PROP_DBL_MSG */
      "BIANCO RADDOPPIA..."},
       CFRAME_AREA,11,0,0,PUSH},

    {{"RED DOUBLES...",   /* BLK_PROP_DBL_MSG */
      "ROSSO RADDOPPIA..."},
       CFRAME_AREA,11,0,0,PUSH},

    {{"WHITE REJECTS DOUBLE",   /* WHT_REJ_DBL_MSG */
      "BIANCO NON ACCETTA IL RADDOPPIO"},
       CFRAME_AREA,13,0,0,PUSH},

    {{"RED REJECTS DOUBLE",   /* BLK_REJ_DBL_MSG */
      "ROSSO NON ACCETTA IL RADDOPPIO"},
       CFRAME_AREA,13,0,0,PUSH},

    {{"WHITE ACCEPTS DOUBLE",   /* WHT_ACC_DBL_MSG */
      "BIANCO ACCETTA IL RADDOPPIO"},
       CFRAME_AREA,13,0,0,PUSH},

    {{"RED ACCEPTS DOUBLE",   /* BLK_ACC_DBL_MSG */
      "ROSSO ACCETTA IL RADDOPPIO"},
       CFRAME_AREA,13,0,0,PUSH},

    {{"NO DOUBLING IN NEXT MATCH",   /* NO_CUBE_MSG */
      "CUBO DI RADDOPPIO CONGELATO"},
       CFRAME_AREA,14,0,0,PUSH},

    {{"-       -",   /* PLAY_TO_MSG */
      "-       -"},
      SIDE_AREA, TARGETM_ROW,0,0,PUSH},

    {{"THE COMPUTER HAS WON",   /* COM_WINS_SET_MSG */
      "IL COMPUTER HA VINTO"},
       CFRAME_AREA,9,0,0,PUSH},

    {{"YOU HAVE WON",   /* YOU_WIN_SET_MSG */
      "TU HAI VINTO"},
       CFRAME_AREA,9,0,0,OVERWRITE}
} ;


/****************************************************************************/

void Print_Message (ushort m)
/*
PURPOSE: To print a message in the correct language in the correct area
         at the correct position.
*/
{
    if (m >= N_MESGS) {
        Error_Exit ("Bad m in Print_Message") ;
    }
    if (Messages[m].Sound != 0) { /* There is a sound */
        sound (Messages[m].Sound) ;
        delay (333) ;
    }
    switch (Messages[m].Area) {
        case HELP_AREA:
	    Clear_Help_Line () ;
	    Help_Text (Messages[m].Col,Messages[m].Message[Lang],WHITE) ;
	    break ;
        case SIDE_AREA:
            Side_Text (Messages[m].Row,Messages[m].Col,
                       Messages[m].Message[Lang],WHITE) ;
            break ;
        case GRAF_AREA:
            Graf_Text (Messages[m].Row,Messages[m].Col,
                       Messages[m].Message[Lang],GREY) ;
            break ;
        case TEXT_AREA :
            printf (Messages[m].Message[Lang]) ;
            break ;
        case CFRAME_AREA :
            Framed_Center_String (Messages[m].Message[Lang],
                                  Messages[m].Row,Messages[m].Op) ;
            if (Messages[m].Op == PUSH) {
                Seconds_Delay (2) ;
                Erase_Framed_String () ;
            }
            break ;
        default:
            Error_Exit ("Bad Area in Print_Message") ;
            break ;
    }
    nosound () ;
}

/****************************************************************************/

static char Human_Name[N_LANGS][SIDE_COLS] = {"YOU","TU"} ;

static char Colour_Strings [N_LANGS][2][8] =
     {{"RED","WHITE"},
      {"ROSSO","BIANCO"}} ;

extern String_Menu_t Setup_Menu [N_SETUP_FIELDS] ;

void Print_Players (short Opponent, Player_t Human)
/*
PURPOSE: To print the name of the opponent we are playing against.
Human will be either BLACK_PLAYER or WHITE_PLAYER, Opponent will be
one of the computer opponents.
*/
{
    char Temp [SIDE_COLS] ;
    short c ;

    for (c = 0 ; c < SIDE_COLS ; c++) {
        Side_Text (OPP_ROW,c," ",WHITE) ;
    }

    if (Human == BLACK_PLAYER) {
        (void)strcpy (Temp,Human_Name[Lang]) ;
        (void)strcat (Temp,"  ") ;
        (void)strcat (Temp,Setup_Menu[OPP_FIELD].Options[Lang][Opponent]) ;
    } else {
        (void)strcpy (Temp,Setup_Menu[OPP_FIELD].Options[Lang][Opponent]) ;
        (void)strcat (Temp,"  ") ;
        (void)strcat (Temp,Human_Name[Lang]) ;
    }
    Side_Text (OPP_ROW,0,Temp,WHITE) ;
}

/****************************************************************************/

void Print_Opponents (short Black, Player_t White)
/*
PURPOSE: To print the name of the opponent we are playing against.
Human will be either BLACK_PLAYER or WHITE_PLAYER, Opponent will be
one of the computer opponents.
*/
{
    char Temp [SIDE_COLS+1] ;
    short c ;

    for (c = 0 ; c < SIDE_COLS ; c++) {
        Side_Text (OPP_ROW,c," ",WHITE) ;
    }

    (void)strcpy (Temp,Setup_Menu[OPP_FIELD].Options[Lang][Black]) ;
    (void)strcat (Temp," ") ;
    (void)strcat (Temp,Setup_Menu[OPP_FIELD].Options[Lang][White]) ;

    Side_Text (OPP_ROW,0,Temp,WHITE) ;
}

/****************************************************************************/

void Print_Tournament (short T_Num, short Pos[N_OPPS])
/*
PURPOSE: To print the tournament number and present classification
of the players.
*/
{
    #define T_NUM_ROW (Disp_Cfg.Text_Rows-SIDE_ROWS-N_OPPS-2)
    #define T_COL     (Disp_Cfg.Text_Cols-SIDE_COLS)
    char Str [SIDE_COLS+1] ;
    short o ;

    /* Print the tournament number */
    sprintf (Str,"T: %2d",T_Num) ;
    Graf_Text (T_NUM_ROW,T_COL,Str,WHITE) ;

    /* Print the players in order of classification */
    for (o = 0 ; o < N_OPPS ; o++) {
        Graf_Text (T_NUM_ROW+1+Pos[o],T_COL,
                   Setup_Menu[OPP_FIELD].Options[Lang][o],WHITE) ;
    }
}

/****************************************************************************/

static char Win_Types [N_LANGS][4][60] =
  {{"NO_WIN",
    " WINS A SINGLE GAME (1 x %d = %d POINTS)",
    " WINS A GAMMON (2 x %d = %d POINTS)",
    " WINS A BACKGAMMON (3 x %d = %d POINTS)"},
   {"NO_WIN",
    " VINCE 1 x %d = %d PUNTI (SEMPLICE)",
    " VINCE 2 x %d = %d PUNTI (GAMMON)",
    " VINCE 3 x %d = %d PUNTI (BACKGAMMON)"}} ;


void Show_Winner (Player_t Winner, Player_t Human, short Points)
/*
PURPOSE: To draw a string in the middle of the screen saying who
         won how many points.
*/
{
    char Win_Str [64] ;
    char Dummy [64] ;
    extern int Double_Value ;

    (void)strcpy (Win_Str,Colour_Strings[Lang][Winner]);  /* RED */

    (void)sprintf (Dummy,Win_Types[Lang][Points],Double_Value,Double_Value*Points) ;

    if (Human != NULL_PLAYER) {
        (void)strcat (Win_Str,Dummy) ;  /* RED WINS...*/
        Framed_Center_String (Win_Str,12,PUSH) ;
        Seconds_Delay (3) ;
        Erase_Framed_String () ;
    }
}

/****************************************************************************/
