/*
 *                     B  G  _  G  R  A  F  3  .  C
 *         A graphics module for the backgammon playing program BG.C.
 *                   This version  23rd January 1993
 *
 */

#include "comp.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <malloc.h>
#include "bg.h"

/*************************************************************************/

extern Disp_Cfg_t Disp_Cfg ; /* Imported from BG_GRAF1.C */
extern Screen_Const_t Grafs ;

/*************************************************************************/
#define PMASK 0x80
/*lint -e569   */
char Bg_String [] = {' ' | PMASK,'B',' ' | PMASK,' ' | PMASK,'A' | PMASK,' ' | PMASK,' ' | PMASK,'C' | PMASK,' ' | PMASK,' ' | PMASK,'K' | PMASK,' ' | PMASK,' ' | PMASK,'G' | PMASK,' ' | PMASK,' ' | PMASK,'A' | PMASK,' ' | PMASK,' ' | PMASK,'M' | PMASK,' ' | PMASK,' ' | PMASK,'M' | PMASK,' ' | PMASK,' ' | PMASK,'O' | PMASK,' ' | PMASK,' ' | PMASK,'N' | PMASK,' ',NUL} ;
char Sws_String [] = {' ' | PMASK,'b','y' | PMASK,' ' | PMASK,'C' | PMASK,'U','S' | PMASK,'T','O' | PMASK,'M' | PMASK,'A' | PMASK,'T' | PMASK,'I' | PMASK,'X' | PMASK,' ',NUL} ;
/*lint +e569   */
void Title_Page (void)
/*
PURPOSE: To draw the title page of BG.EXE.
*/
{
    Demask (Bg_String) ;
    Demask (Sws_String) ;
    Framed_Center_String (Bg_String,TITLE_BG_ROW,OVERWRITE) ;
    Framed_Center_String (Sws_String,TITLE_SWS_ROW,OVERWRITE) ;
    Framed_Center_String (VER_STR,TITLE_VER_ROW,OVERWRITE) ;
    Init_Faces () ;
}

/*************************************************************************/

typedef struct {
    void*  Ptr ;
    int    Size ;
    short  x0,y0,x1,y1 ;
} Pushed_Image_t ;

static Pushed_Image_t P_Image ;
static boolean Pushed = FALSE ;

/*************************************************************************/

void Framed_Center_String (char* String, short Row, FCS_Op_t Operation)
/*
PURPOSE: To draw the string in the center of the screen at Row.
         The background rectangle is set to black.
         The string is 'framed'.
NOTES:   1) If Operation is OVERWRITE then we do not save what was below
         the string rectangle.
         2) If Operation is PUSH then we save what was below, ready to
         be popped by Erase_Center_String
*/
{
    short x,y,N_Chars,Wide,High,Col ;


    N_Chars = strlen (String) ;
    Col     = (Disp_Cfg.Text_Cols/2) - (N_Chars/2) ;

    x    = (Col * Disp_Cfg.Char_Wide) - MARGIN ;
    y    = (Row * Disp_Cfg.Char_High) - MARGIN ;
    Wide = (N_Chars * Disp_Cfg.Char_Wide) + (2*MARGIN) ;
    High = Disp_Cfg.Char_High + (2*MARGIN) ;

    if (Operation == PUSH) {
        if (Pushed == TRUE) {
            Error_Exit ("Pushing when already pushed") ;
        }
        P_Image.x0 = x ;
        P_Image.y0 = y ;
        P_Image.x1 = x + Wide + 1 ;
        P_Image.y1 = y + High + 1 ;
        P_Image.Size = imagesize (P_Image.x0,P_Image.y0,P_Image.x1,P_Image.y1) ;
        P_Image.Ptr  = malloc ((size_t)P_Image.Size) ;
        if (P_Image.Ptr == NULL) {
            Error_Exit ("Cannot malloc for pushed image") ;
        }
        getimage (P_Image.x0,P_Image.y0,P_Image.x1,P_Image.y1,P_Image.Ptr) ;
        Pushed = TRUE ;
    }

    Fill_Rect (x,y,Wide,High,BLACK) ;
    Graf_Text (Row,Col,String,WHITE) ;

    Draw_Rect (x,y,Wide,High,WHITE) ;
    Draw_Line (x,y+High,x+Wide-1,y+High,WHITE) ; /* Underline bottom line */
}

/*************************************************************************/

void Erase_Framed_String (void)
/*
PURPOSE: To restore the area of the screen erased by the last
         Framed_Center_String operation.
*/
{
    if (!Pushed) {
        Error_Exit ("Trying to pop an unpushed image") ;
    }

    putimage (P_Image.x0,P_Image.y0,P_Image.Ptr,COPY_PUT) ;

    free (P_Image.Ptr) ;

    Pushed = FALSE ;
}

/*************************************************************************/

void Clear_Screen (void)
/*
PURPOSE: To clear the whole graphics screen.
*/
{
    Fill_Rect (0,0,Disp_Cfg.X_Pixels,Disp_Cfg.Y_Pixels,BLACK) ;
}

/*************************************************************************/
#if DRODBAR
void Draw_Prob_Diag (char Disp[6][6])
/*
PURPOSE: To draw in the Logo_Area the probability diagram passed.
*/
{
    short w,h,x,y,c,d0,d1 ;

    /* Clear the logo away
    Fill_Rect (Grafs.Logo_X,Grafs.Logo_Y,
               Grafs.Logo_Wide,Grafs.Logo.High,BLACK) ; */

    Draw_Rect (Grafs.Logo_X,Grafs.Logo_Y,
               Grafs.Logo_Wide,Grafs.Logo_High,WHITE) ;

    w = (Grafs.Logo_Wide / 6) ;
    h = (Grafs.Logo_High / 6) ;

    for (d0 = 0 ; d0 < 6 ; d0++) {
        x = Grafs.Logo_X + (w*d0) ;
        for (d1 = 0 ; d1 < 6 ; d1++) {
            y = Grafs.Logo_Y + (h*d1) ;
            if (Disp[d0][d1]) {
                c = WHITE ;
            } else {
                c = BLACK ;
            }
            Fill_Rect (x,y,w,h,c) ;
        }
    }
}
#endif
/*************************************************************************/

void Draw_Pline (short N_Points, short Line[][2], short Col)
/*
PURPOSE: To draw a polyline, not closed.
*/
{
    short i ;
    for (i = 0 ; i < (N_Points-1) ; i++) {
	Draw_Line (Line[i][0],Line[i][1],
		   Line[i+1][0],Line[i+1][1],Col) ;
    }
}

/***************************************************************************/

void Draw_Pgon (short N_Points, short Line[][2], short Col)
/*
PURPOSE: To draw a closed polyline, i.e. a polygon.
*/
{
    Draw_Pline (N_Points,Line,Col) ;
    Draw_Line (Line[0][0],Line[0][1],
               Line[N_Points-1][0],Line[N_Points-1][1],Col) ;
}

/***************************************************************************/

void Draw_Double_Button (void)
/*
PURPOSE: To draw the square at the center of the bar which is
         used as DOUBLE button.
*/
{
    short x,y ;

    /* Draw the rectangle */
    Draw_Rect (Grafs.Double_X+2,Grafs.Double_Y+2,Grafs.Unit_Wide,Grafs.Unit_High,WHITE) ;

    /* Draw the 'D' char inside the rectangle */
    x = Grafs.Double_X + 2 + (Grafs.Unit_Wide/2) - (Disp_Cfg.Char_Wide/2) ;
    y = Grafs.Double_Y + 2 + (Grafs.Unit_High/2) - (Disp_Cfg.Char_High/2) ;
    Text_At_Pixel (x,y,"D",WHITE) ;
}

/***************************************************************************/

void Draw_Double_Cube (Player_t Possesor, short Number)
/*
PURPOSE: To draw the doubling cube at the end of the BAR next to the
         player who has possession.
*/
{
    char Buffer[4] ;
    short x,y,Num_Wide,Cube_Row,Clear_Row ;

    if (Possesor == WHITE_PLAYER) {
        Cube_Row  = 0 ;
        Clear_Row = 11 ;
    } else if (Possesor == BLACK_PLAYER) {
        Cube_Row  = 11 ;
        Clear_Row = 0 ;
    } else {
        return ;
    }

    /* Clear the old cube... */
    Get_Grid_Corner (&x,&y,BAR_COL,Clear_Row) ;
    /* Draw the rectangle */
    Fill_Rect (x+2,y+2,Grafs.Unit_Wide,Grafs.Unit_High,BLACK) ;


    /* Draw the new cube... */
    Get_Grid_Corner (&x,&y,BAR_COL,Cube_Row) ;

    /* Draw the rectangle */
    Draw_Rect (x+2,y+2,Grafs.Unit_Wide,Grafs.Unit_High,WHITE) ;

    /* Draw the number char inside the rectangle */
    sprintf (Buffer,"%d",Number) ;
    if (Number > 8) {
        Num_Wide = Disp_Cfg.Char_Wide*2 ;
    } else {
        Num_Wide = Disp_Cfg.Char_Wide ;
    }
    x = x + 2 + (Grafs.Unit_Wide/2) - (Num_Wide/2) ;
    y = y + 2 + (Grafs.Unit_High/2) - (Disp_Cfg.Char_High/2) ;
    Text_At_Pixel (x,y,Buffer,WHITE) ;
}

/***************************************************************************/
