/*
 *
 *                     B  G  _  F  A  C  E  .  C
 * BG.EXE face drawing file, this version 2nd May 1992.
 *
 */

#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include "bg.h"

/***************************************************************************/

extern Disp_Cfg_t Disp_Cfg ;
extern Screen_Const_t Grafs ;

/***************************************************************************/
#define MAX_E_RAD   12          /* Maximum eye radius  */
#define MIN_E_RAD    2          /* Minimum eye radius  */
#define N_FO_PNTS    8          /* Face Outline Points */
#define N_NO_PNTS    4          /* Nose Outline Points */
#define M_PNTS      11          /* Mouth points        */
#define N_TEETH  (M_PNTS-1)
#define MAX_SMILE_OFFSET    12   /* % of whole face */
#define MAX_TOOTH_SIZE      20   /* % of whole face */

/* The face is drawn on an imaginary grid of 100x100, with 0,0 at top left */
typedef struct Face {
    short Eye_X,  Eye_Y ;   /* X=offset from center, pixel coords */
    short Ex_Rad, Ey_Rad ;  /* % sizes always */
    short Mouth_Y,M_Wide ;
    short S_Val,  T_Val ;     /* Smile and Tooth values */
    short Outline [N_FO_PNTS][2] ;
              /* Polyline for outline of face, will be closed */
    short Nose_Line [N_NO_PNTS][2] ;
              /* Polyline for outline of nose, may be closed or left open */
} Face_t ;

static Face_t Faces[N_OPPS] = {
    {20,40,              /* Eye x, Eye y */
      5,4,
     60,40,              /* Mouth y, wide, */
     0,0,
     {{20,5},{10,30},{20,70},{40,90},{60,90},{80,70},{90,30},{80,5}},
     {{40,50},{40,50},{50,45},{60,50}}},

    {15,35,               /* Eye x, Eye y */
      5,4,
     70,35,               /* Mouth y, wide */
     0,0,
     {{30,10},{10,30},{10,70},{40,90},{60,90},{90,70},{90,30},{70,10}},
     {{40,50},{40,50},{50,55},{60,50}}},

    {10,20,               /* Alberto */
      5,4,
     70,30,              /* Mouth_Y, Mouth_Wide */
     0,0,
     {{30,5},{10,20},{20,80},{50,93},{50,93},{80,80},{90,20},{70,5}},
     {{50,30},{40,60},{50,65},{60,50}}},

    {20,30,
      5,4,
     70,40,
     0,0,
     {{40,10},{10,20},{20,80},{50,90},{50,90},{80,80},{90,20},{60,10}},
     {{50,30},{50,30},{40,50},{60,50}}}  };


/***************************************************************************/

void Init_Faces (void)
/*
PURPOSE: To change some of the face fields to pixel fields so we
         don't have to recalculate them every time
*/
{
    short f,p,Dummy ;

    for (f = 0 ; f < N_OPPS ; f++) {
        Faces[f].Eye_X  = ((Grafs.Logo_Wide * Faces[f].Eye_X)/100) ;
        Faces[f].M_Wide = ((Grafs.Logo_Wide * Faces[f].M_Wide)/100) ;
        Pixel_Transform (&Dummy,&Faces[f].Eye_Y) ;
        Pixel_Transform (&Dummy,&Faces[f].Mouth_Y) ;
        /* Transform face outline points */
        for (p = 0 ; p < N_FO_PNTS ; p++) {
            Pixel_Transform (&Faces[f].Outline[p][0],&Faces[f].Outline[p][1]) ;
        }
        /* Transform nose line points */
        for (p = 0 ; p < N_NO_PNTS ; p++) {
            Pixel_Transform (&Faces[f].Nose_Line[p][0],&Faces[f].Nose_Line[p][1]) ;
        }
    }
}

/***************************************************************************/

void Pixel_Transform (short* x, short* y)
/*
PURPOSE: To transform the x and y from the 100x100 grid to the actual
         pixel coords in the logo area.
*/
{
    (*x) = ((Grafs.Logo_Wide * (*x))/100) + Grafs.Logo_X ;
    (*y) = ((Grafs.Logo_High * (*y))/100) + Grafs.Logo_Y ;
}

/***************************************************************************/

void Draw_Eyes (short N_Vals, short o)
/*
PURPOSE: To draw the eyes of the opponent after he has seen the dice.
*/
{
    short Abs_X_Rad,Abs_Y_Rad ;

    /* Erase the old eyes */
    Abs_X_Rad = (Faces[o].Ex_Rad * Grafs.Logo_Wide)/100 ;
    Abs_Y_Rad = (Faces[o].Ey_Rad * Grafs.Logo_High)/100 ;

    /* Erase the old eyes */
    Draw_Ellipse (Grafs.Logo_Center+Faces[o].Eye_X,Faces[o].Eye_Y,Abs_X_Rad,Abs_Y_Rad,BLACK) ;
    Draw_Ellipse (Grafs.Logo_Center-Faces[o].Eye_X,Faces[o].Eye_Y,Abs_X_Rad,Abs_Y_Rad,BLACK) ;

    if (N_Vals == 4) {
        Faces[o].Ex_Rad+=2 ;
        Faces[o].Ey_Rad+=2 ;
    } else {
        Faces[o].Ex_Rad-=1 ;
        Faces[o].Ey_Rad-=1 ;
    }

    if (Faces[o].Ex_Rad < MIN_E_RAD) {
        Faces[o].Ex_Rad = MIN_E_RAD ;
    } else if (Faces[o].Ex_Rad > MAX_E_RAD) {
        Faces[o].Ex_Rad = MAX_E_RAD ;
    }
    if (Faces[o].Ey_Rad < MIN_E_RAD) {
        Faces[o].Ey_Rad = MIN_E_RAD ;
    } else if (Faces[o].Ey_Rad > MAX_E_RAD) {
        Faces[o].Ey_Rad = MAX_E_RAD ;
    }

    Abs_X_Rad = (Faces[o].Ex_Rad * Grafs.Logo_Wide)/100 ;
    Abs_Y_Rad = (Faces[o].Ey_Rad * Grafs.Logo_High)/100 ;
    Draw_Ellipse (Grafs.Logo_Center+Faces[o].Eye_X,Faces[o].Eye_Y,Abs_X_Rad,Abs_Y_Rad,WHITE) ;
    Draw_Ellipse (Grafs.Logo_Center-Faces[o].Eye_X,Faces[o].Eye_Y,Abs_X_Rad,Abs_Y_Rad,WHITE) ;

    Draw_Point (Grafs.Logo_Center+Faces[o].Eye_X,Faces[o].Eye_Y,WHITE) ;
    Draw_Point (Grafs.Logo_Center-Faces[o].Eye_X,Faces[o].Eye_Y,WHITE) ;
}

/***************************************************************************/

void Draw_Face_Outline (short o, short Col)
/*
PURPOSE: To draw the outline of the oth face, assuming it has already
been transformed into the logo area. The nose is drawn too. The face
outline is closed, the nose can be closed or open.
*/
{
    Draw_Pgon (N_FO_PNTS,Faces[o].Outline,Col) ;
    Draw_Pline (N_NO_PNTS,Faces[o].Nose_Line,Col) ;
}

/***************************************************************************/

void Redraw_Mouth (short o, short S_Val, short T_Val)
/*
S_Val must be between -100 and +100 (inclusive).
T_Val must be between 0 qnd 100 (inclusive)
MAX_SMILE_OFFSET is a positive % number. 100% means smile covers whole.
face.
*/
{
    Draw_Mouth (o,Faces[o].S_Val,Faces[o].T_Val,BLACK) ; /* Erase old mouth */
    Faces[o].S_Val = S_Val ;  /* Store new...  */
    Faces[o].T_Val = T_Val ;  /* ...values.    */
    Draw_Mouth (o,Faces[o].S_Val,Faces[o].T_Val,WHITE) ; /* Draw new mouth */
}

/***************************************************************************/

void Draw_Mouth (short o, short S_Val, short T_Val, short Colour)
/*
PURPOSE: To draw a smiling or unsmiling mouth, with or without sharp
         protruding teeth.
*/
{
    short  Mouth [M_PNTS][2] ;
    short  Teeth [N_TEETH][2] ;
    short  t,p ;
    double Dsval ;

    if ((S_Val > 100) || (S_Val < (-100))) {
        Error_Exit ("Bad S_Val") ;
    }

    Dsval = ((double)S_Val/100.0)*(double)MAX_SMILE_OFFSET/100.0 ;
    /* Dsval is now a fraction of a face */

    for (p = 0 ; p < M_PNTS ; p++) {
        Mouth[p][0] = Grafs.Logo_Center - (Faces[o].M_Wide/2) + ((Faces[o].M_Wide*p)/(M_PNTS-1)) ;
        Mouth[p][1] = Faces[o].Mouth_Y ;
    }

    for (p = 0 ; p < M_PNTS ; p++) {
        double Doff ;
        Doff = -Dsval*cos ((double)p*TWO_PI/(double)(M_PNTS-1)) ;
        /* Doff is as a fraction of a face */

        Mouth[p][1] = Mouth[p][1] + (short)(Doff*(double)Grafs.Logo_High) ;
    }

    Draw_Pline (M_PNTS,Mouth,Colour) ;

    if (T_Val > 0) {
        double T_Offset ;
        T_Offset = (T_Val*(MAX_TOOTH_SIZE/100.0)*Grafs.Logo_High)/100.0 ;
        for (t = 0 ; t < N_TEETH ; t++) {
            /* Here we init the position of the points of the teeth */
            Teeth[t][0] = (Mouth[t][0] + Mouth[t+1][0]) / 2 ;
            Teeth[t][1] = (Mouth[t][1] + Mouth[t+1][1]) / 2 + (short)T_Offset ;
        }
        for (t = 0 ; t < N_TEETH ; t++) {
            Draw_Line (Mouth[t][0],Mouth[t][1],
                       Teeth[t][0],Teeth[t][1],Colour) ;
            Draw_Line (Mouth[t+1][0],Mouth[t+1][1],
                       Teeth[t][0],Teeth[t][1],Colour) ;
        }
    }
}

/***************************************************************************/
#if DRODBAR
void Redraw_Eyebrows (short o, short Eb_Val)
{
}

/***************************************************************************/

void Draw_Eyebrows (short o, short Eb_Val, short Colour)
{
}
#endif
/***************************************************************************/

void Draw_Face (Layout_t Me, Layout_t Him, short o)
/*
A decent range seems to be between -50 and +50
*/
{
    short Pips ;

    Pips = Pip_Count_Diff (Me,Him) ;
    if (Pips > 50) {
        Pips = 50 ;
    } else if (Pips < (-50)) {
        Pips = (-50) ;
    }
    Redraw_Mouth (o,Pips,(short)Aggression_Score(Me,Him)) ;
    Draw_Face_Outline (o, WHITE) ;
}

/***************************************************************************/

void Show_Opponents_Face (Layout_t Layouts[2], Player_t Hum, short O_Index)
/*
PURPOSE: To show the opponents joy or anger as he contemplates his
          position.
*/
{
    if (Hum == BLACK_PLAYER) {
        Draw_Face (Layouts[WHITE_PLAYER], Layouts[BLACK_PLAYER], O_Index) ;
    } else {
        Draw_Face (Layouts[BLACK_PLAYER], Layouts[WHITE_PLAYER], O_Index) ;
    }
}

/***************************************************************************/
